"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NagSuppressions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const nag_suppression_helper_1 = require("./utils/nag-suppression-helper");
/**
 * Helper class with methods to add cdk-nag suppressions to cdk resources
 */
class NagSuppressions {
    /**
     * Apply cdk-nag suppressions to a Stack and optionally nested stacks
     * @param stack The Stack to apply the suppression to
     * @param suppressions A list of suppressions to apply to the stack
     * @param applyToNestedStacks Apply the suppressions to children stacks (default:false)
     */
    static addStackSuppressions(stack, suppressions, applyToNestedStacks = false) {
        const stacks = applyToNestedStacks
            ? stack.node.findAll().filter((x) => x instanceof monocdk_1.Stack)
            : [stack];
        stacks.forEach((s) => {
            var _b, _c;
            nag_suppression_helper_1.NagSuppressionHelper.assertSuppressionsAreValid(s.node.id, suppressions);
            let metadata = (_c = (_b = s.templateOptions.metadata) === null || _b === void 0 ? void 0 : _b.cdk_nag) !== null && _c !== void 0 ? _c : {};
            metadata = nag_suppression_helper_1.NagSuppressionHelper.addRulesToMetadata(metadata, suppressions);
            if (!s.templateOptions.metadata) {
                s.templateOptions.metadata = {};
            }
            s.templateOptions.metadata.cdk_nag = metadata;
        });
    }
    /**
     * Add cdk-nag suppressions to a CfnResource and optionally its children
     * @param construct The IConstruct to apply the suppression to
     * @param suppressions A list of suppressions to apply to the resource
     * @param applyToChildren Apply the suppressions to children CfnResources  (default:false)
     */
    static addResourceSuppressions(construct, suppressions, applyToChildren = false) {
        nag_suppression_helper_1.NagSuppressionHelper.assertSuppressionsAreValid(construct.node.id, suppressions);
        const constructs = applyToChildren ? construct.node.findAll() : [construct];
        for (const child of constructs) {
            const possibleL1 = child.node.defaultChild
                ? child.node.defaultChild
                : child;
            if (possibleL1 instanceof monocdk_1.CfnResource) {
                const resource = possibleL1;
                let metadata = resource.getMetadata('cdk_nag');
                metadata = nag_suppression_helper_1.NagSuppressionHelper.addRulesToMetadata(metadata, suppressions);
                resource.addMetadata('cdk_nag', metadata);
            }
        }
    }
    /**
     * Add cdk-nag suppressions to a CfnResource and optionally its children via its path
     * @param stack The Stack the construct belongs to
     * @param path The path to the construct in the provided stack
     * @param suppressions A list of suppressions to apply to the resource
     * @param applyToChildren Apply the suppressions to children CfnResources  (default:false)
     */
    static addResourceSuppressionsByPath(stack, path, suppressions, applyToChildren = false) {
        for (const child of stack.node.findAll()) {
            const fixedPath = path.replace(/^\//, '');
            if (child.node.path === fixedPath ||
                child.node.path + '/Resource' === fixedPath) {
                NagSuppressions.addResourceSuppressions(child, suppressions, applyToChildren);
            }
        }
    }
}
exports.NagSuppressions = NagSuppressions;
_a = JSII_RTTI_SYMBOL_1;
NagSuppressions[_a] = { fqn: "monocdk-nag.NagSuppressions", version: "1.12.35" };
//# sourceMappingURL=data:application/json;base64,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