from http import HTTPStatus
from typing import Any, Dict, List, Optional

import httpx

from ... import errors
from ...client import Client
from ...models.get_generated_label_names_response_200_item import GetGeneratedLabelNamesResponse200Item
from ...types import UNSET, Response


def _get_kwargs(
    project_name: str,
    *,
    client: Client,
    config_name: str,
) -> Dict[str, Any]:
    url = "{}/projects/{projectName}/models/_generated_label_names".format(client.base_url, projectName=project_name)

    headers: Dict[str, str] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    params: Dict[str, Any] = {}
    params["configName"] = config_name

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    return {
        "method": "get",
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
        "params": params,
    }


def _parse_response(
    *, client: Client, response: httpx.Response
) -> Optional[List["GetGeneratedLabelNamesResponse200Item"]]:
    if response.status_code == HTTPStatus.OK:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = GetGeneratedLabelNamesResponse200Item.from_dict(response_200_item_data)

            response_200.append(response_200_item)

        return response_200
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(f"Unexpected status code: {response.status_code}")
    else:
        return None


def _build_response(
    *, client: Client, response: httpx.Response
) -> Response[List["GetGeneratedLabelNamesResponse200Item"]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    project_name: str,
    *,
    client: Client,
    config_name: str,
) -> Response[List["GetGeneratedLabelNamesResponse200Item"]]:
    """Returns the list of label names generated by the latest model of the configuration

    Args:
        project_name (str):
        config_name (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[List['GetGeneratedLabelNamesResponse200Item']]
    """

    kwargs = _get_kwargs(
        project_name=project_name,
        client=client,
        config_name=config_name,
    )

    response = httpx.request(
        verify=client.verify_ssl,
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    project_name: str,
    *,
    client: Client,
    config_name: str,
) -> Optional[List["GetGeneratedLabelNamesResponse200Item"]]:
    """Returns the list of label names generated by the latest model of the configuration

    Args:
        project_name (str):
        config_name (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[List['GetGeneratedLabelNamesResponse200Item']]
    """

    return sync_detailed(
        project_name=project_name,
        client=client,
        config_name=config_name,
    ).parsed


async def asyncio_detailed(
    project_name: str,
    *,
    client: Client,
    config_name: str,
) -> Response[List["GetGeneratedLabelNamesResponse200Item"]]:
    """Returns the list of label names generated by the latest model of the configuration

    Args:
        project_name (str):
        config_name (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[List['GetGeneratedLabelNamesResponse200Item']]
    """

    kwargs = _get_kwargs(
        project_name=project_name,
        client=client,
        config_name=config_name,
    )

    async with httpx.AsyncClient(verify=client.verify_ssl) as _client:
        response = await _client.request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    project_name: str,
    *,
    client: Client,
    config_name: str,
) -> Optional[List["GetGeneratedLabelNamesResponse200Item"]]:
    """Returns the list of label names generated by the latest model of the configuration

    Args:
        project_name (str):
        config_name (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[List['GetGeneratedLabelNamesResponse200Item']]
    """

    return (
        await asyncio_detailed(
            project_name=project_name,
            client=client,
            config_name=config_name,
        )
    ).parsed
