(function(){window.Djblets=window.Djblets||{};Djblets.Config={};"use strict";Djblets.Config.ListItems=Backbone.Collection.extend({initialize:function initialize(models,options){this.options=options},fetch:function fetch(options){this.trigger("fetching");Backbone.Collection.prototype.fetch.call(this,options)}});"use strict";Djblets.Config.ListItem=Backbone.Model.extend({defaults:{text:null,editURL:null,showRemove:false,canRemove:true,loading:false,removeLabel:gettext("Remove"),itemState:null},itemStateTexts:{disabled:gettext("Disabled"),enabled:gettext("Enabled"),error:gettext("Error")},initialize:function initialize(){var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};this.actions=options.actions||[];if(this.get("showRemove")){this.actions.push({id:"delete",label:this.get("removeLabel"),danger:true,enabled:this.get("canRemove")})}},setActions:function setActions(actions){this.actions=actions;this.trigger("actionsChanged")}});Djblets.Config.List=Backbone.Model.extend();"use strict";Djblets.Config.ListItemView=Backbone.View.extend({tagName:"li",className:"djblets-c-config-forms-list__item",iconBaseClassName:"djblets-icon",itemStateClasses:{disabled:"-is-disabled",enabled:"-is-enabled",error:"-has-error"},actionHandlers:{},template:_.template('<% if (editURL) { %>\n<a href="<%- editURL %>"><%- text %></a>\n<% } else { %>\n<%- text %>\n<% } %>'),initialize:function initialize(){this.listenTo(this.model,"actionsChanged",this.render);this.listenTo(this.model,"request",this.showSpinner);this.listenTo(this.model,"sync",this.hideSpinner);this.listenTo(this.model,"destroy",this.remove);this.$spinnerParent=null;this.$spinner=null},render:function render(){var model=this.model;this.$el.empty().append(this.template(_.defaults(model.attributes,this.getRenderContext())));this._$itemState=this.$(".djblets-c-config-forms-list__item-state");this.listenTo(model,"change:itemState",this._onItemStateChanged);this._onItemStateChanged();this.addActions(this.getActionsParent());return this},getRenderContext:function getRenderContext(){return{}},remove:function remove(){var _this=this;this.$el.fadeOut("normal",function(){return Backbone.View.prototype.remove.call(_this)})},getActionsParent:function getActionsParent(){return this.$el},showSpinner:function showSpinner(){if(this.$spinner){return}this.$el.attr("aria-busy","true");this.$spinner=$("<span>").addClass("djblets-o-spinner").attr("aria-hidden","true").prependTo(this.$spinnerParent).hide().css("visibility","visible").fadeIn()},hideSpinner:function hideSpinner(){var _this2=this;if(!this.$spinner){return}this.$spinner.fadeOut("slow",function(){_this2.$spinner.remove();_this2.$spinner=null});this.$el.removeAttr("aria-busy")},addActions:function addActions($parentEl){var _this3=this;var $actions=$("<span>").addClass("djblets-c-config-forms-list__item-actions");this.model.actions.forEach(function(action){var $action=_this3._buildActionEl(action).appendTo($actions);if(action.children){if(action.label){$action.append(" &#9662;")}$action.click(function(){return _.defer(function(){return _this3._showActionDropdown(action,$action)})})}});this.$spinnerParent=$actions;$actions.prependTo($parentEl)},_showActionDropdown:function _showActionDropdown(action,$action){var _this4=this;var actionPos=$action.position();var $menu=$("<div/>").css({minWidth:$action.outerWidth(),position:"absolute"}).addClass("djblets-c-config-forms-popup-menu").click(function(e){return e.stopPropagation()});var $items=$("<ul/>").addClass("djblets-c-config-forms-popup-menu__items").appendTo($menu);var actionLeft=actionPos.left+$action.getExtents("m","l");action.children.forEach(function(childAction){return $("<li/>").addClass("djblets-c-config-forms-popup-menu__item "+("config-forms-list-action-row-"+childAction.id)).append(_this4._buildActionEl(childAction)).appendTo($items)});this.trigger("actionMenuPopUp",{action:action,$action:$action,$menu:$menu});$menu.appendTo($action.parent());var winWidth=$(window).width();var paneWidth=$menu.width();$menu.move($action.offset().left+paneWidth>winWidth?actionLeft+$action.innerWidth()-paneWidth:actionLeft,actionPos.top+$action.outerHeight(),"absolute");$(document).one("click",function(){_this4.trigger("actionMenuPopDown",{action:action,$action:$action,$menu:$menu});$menu.remove()})},_buildActionEl:function _buildActionEl(action){var _this5=this;var enabled=action.enabled!==false;var actionHandlerName=enabled?this.actionHandlers[action.id]:null;var isCheckbox=action.type==="checkbox";var isRadio=action.type==="radio";var $action=void 0;var $result=void 0;if(isCheckbox||isRadio){var inputID=_.uniqueId("action_"+action.type);$action=$("<input/>").attr({name:action.name,type:action.type,id:inputID});var $label=$("<label>").attr("for",inputID).text(action.label);if(action.id){$label.addClass("config-forms-list-action-label-"+action.id)}$result=$("<span/>").append($action).append($label);if(action.propName){if(isCheckbox){$action.bindProperty("checked",this.model,action.propName)}else if(isRadio){$action.bindProperty("checked",this.model,action.propName,{radioValue:action.radioValue})}}if(action.enabledPropName){$action.bindProperty("disabled",this.model,action.enabledPropName,{inverse:action.enabledPropInverse!==true})}if(actionHandlerName){var actionHandler=_.debounce(_.bind(this[actionHandlerName],this),50,true);$action.change(actionHandler);if(isRadio&&action.dispatchOnClick){$action.click(actionHandler)}}}else{if(action.url){$action=$('<a class="btn" role="button">').attr("href",action.url)}else{$action=$('<button type="button">')}$result=$action;if(action.label){$action.text(action.label)}if(action.ariaLabel){$action.attr("aria-label",action.ariaLabel)}if(action.iconName){$action.prepend($("<span>").addClass(this.iconBaseClassName).addClass(this.iconBaseClassName+"-"+action.iconName))}if(actionHandlerName){$action.click(function(evt){evt.preventDefault();evt.stopPropagation();_this5._onActionButtonClicked(evt,actionHandlerName,$action)})}}$action.addClass("djblets-c-config-forms-list__item-action");if(action.id){$action.addClass("config-forms-list-action-"+action.id)}if(action.danger){$action.addClass("-is-danger")}if(action.primary){$action.addClass("-is-primary")}if(!enabled){$action.prop("disabled",true)}return $result},_onItemStateChanged:function _onItemStateChanged(){var model=this.model;var oldItemState=model.previous("itemState");var itemState=model.get("itemState");if(oldItemState){this.$el.removeClass(this.itemStateClasses[oldItemState])}if(itemState){this.$el.addClass(this.itemStateClasses[itemState]);this._$itemState.text(model.itemStateTexts[itemState])}},_onActionButtonClicked:function _onActionButtonClicked(evt,actionHandlerName,$action){var promise=this[actionHandlerName].call(this,evt);if(promise&&typeof promise.then==="function"){$action.prop("disabled",true);var childrenHTML=$action.html();$action.empty();var $spinner=$('<span class="djblets-o-spinner">').appendTo($action);promise.finally(function(){$spinner.remove();$action.html(childrenHTML);$action.prop("disabled",false)})}}});"use strict";Djblets.Config.ListView=Backbone.View.extend({tagName:"ul",className:"djblets-c-config-forms-list",defaultItemView:Djblets.Config.ListItemView,initialize:function initialize(){var _this=this;var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var collection=this.model.collection;this.ItemView=options.ItemView||this.defaultItemView;this.views=[];this.animateItems=!!options.animateItems;this.once("rendered",function(){_this.listenTo(collection,"add",_this._addItem);_this.listenTo(collection,"remove",_this._removeItem);_this.listenTo(collection,"reset",_this._renderItems)})},getBody:function getBody(){return this.$el},render:function render(){this.$listBody=this.getBody();this._renderItems();this.trigger("rendered");return this},_addItem:function _addItem(item,collection){var options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};var animateItem=options.animate!==false;var view=new this.ItemView({model:item});view.render();if(this.animateItems&&animateItem){view.$el.fadeIn()}this.$listBody.append(view.$el);this.views.push(view)},_removeItem:function _removeItem(item,collection){var options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};var animateItem=options.animate!==false;var view=_.find(this.views,function(view){return view.model===item});if(view){this.views=_.without(this.views,view);if(this.animateItems&&animateItem){view.$el.fadeOut(function(){view.remove()})}else{view.remove()}}},_renderItems:function _renderItems(){var _this2=this;this.views.forEach(function(view){view.remove()});this.views=[];this.$listBody.empty();this.model.collection.each(function(item){_this2._addItem(item,item.collection,{animate:false})})}});"use strict";Djblets.Config.PagesView=Backbone.View.extend({initialize:function initialize(){this.router=new Backbone.Router({routes:{":pageID":"page"}});this.listenTo(this.router,"route:page",this._onPageChanged);this._$activeNav=null;this._$activePage=null;this._preserveMessages=true},render:function render(){this._$pageNavs=this.$(".djblets-c-config-forms-page-nav__item");this._$pages=this.$(".djblets-c-config-forms-subpage");this._$activeNav=this._$pageNavs.eq(0).addClass("-is-active");this._$activePage=this._$pages.eq(0).addClass("-is-active");Backbone.history.start({root:window.location.pathname});return this},_onPageChanged:function _onPageChanged(pageID){this._$activeNav.removeClass("-is-active");this._$activePage.removeClass("-is-active");this._$activePage=$("#page_"+pageID);if(this._$activePage.length===0){this.router.navigate(this._$pageNavs.find("a").attr("href").substr(1),{trigger:true,replace:true})}else{this._$activeNav=this._$pageNavs.filter(':has(a[href="#'+pageID+'"])').addClass("-is-active");this._$activePage.addClass("-is-active");if(!this._preserveMessages){$("#messages").remove()}this._preserveMessages=false}}});"use strict";Djblets.Config.TableItemView=Djblets.Config.ListItemView.extend({tagName:"tr",template:_.template('<td>\n<% if (editURL) { %>\n<a href="<%- editURL %>"><%- text %></a>\n<% } else { %>\n<%- text %>\n<% } %>\n</td>'),getActionsParent:function getActionsParent(){return this.$("td:last")}});"use strict";Djblets.Config.TableView=Djblets.Config.ListView.extend({tagName:"table",defaultItemView:Djblets.Config.TableItemView,render:function render(){var $body=this.getBody();if($body.length===0){this.$el.append("<tbody>")}return Djblets.Config.ListView.prototype.render.call(this)},getBody:function getBody(){return this.$("tbody")}})}).call(this);
