"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AfterCreate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * @stability stable
 */
class AfterCreate extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const provider = aws_cdk_lib_1.CustomResourceProvider.getOrCreateProvider(this, 'AWSCDK.TriggerCustomResourceProvider', {
            runtime: aws_cdk_lib_1.CustomResourceProviderRuntime.NODEJS_14_X,
            codeDirectory: path_1.join(__dirname, '..', 'lambda'),
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: ['lambda:InvokeFunction'],
                    Resource: ['*'],
                },
            ],
        });
        const resource = new aws_cdk_lib_1.CustomResource(this, 'Resource', {
            resourceType: 'Custom::Trigger',
            serviceToken: provider.serviceToken,
            properties: {
                // we use 'currentVersion' because a new version is created every time the
                // handler changes (either code or configuration). this will have the effect
                // that the trigger will be executed every time the handler is changed.
                HandlerArn: props.handler.currentVersion.functionArn,
            },
        });
        // add a dependency between our resource and the resources we want to invoke
        // after.
        resource.node.addDependency(...(_b = props.resources) !== null && _b !== void 0 ? _b : []);
    }
}
exports.AfterCreate = AfterCreate;
_a = JSII_RTTI_SYMBOL_1;
AfterCreate[_a] = { fqn: "cdk-triggers.AfterCreate", version: "0.1.18" };
//# sourceMappingURL=data:application/json;base64,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