# coding: utf-8

"""
    validateapi

    The validation APIs help you validate data. Check if an E-mail address is real. Check if a domain is real. Check up on an IP address, and even where it is located. All this and much more is available in the validation API.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class FullEmailValidationResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'valid_address': 'bool',
        'mail_server_used_for_validation': 'str',
        'valid_syntax': 'bool',
        'valid_domain': 'bool',
        'valid_smtp': 'bool',
        'is_catchall_domain': 'bool',
        'domain': 'str',
        'is_free_email_provider': 'bool',
        'is_disposable': 'bool'
    }

    attribute_map = {
        'valid_address': 'ValidAddress',
        'mail_server_used_for_validation': 'MailServerUsedForValidation',
        'valid_syntax': 'Valid_Syntax',
        'valid_domain': 'Valid_Domain',
        'valid_smtp': 'Valid_SMTP',
        'is_catchall_domain': 'IsCatchallDomain',
        'domain': 'Domain',
        'is_free_email_provider': 'IsFreeEmailProvider',
        'is_disposable': 'IsDisposable'
    }

    def __init__(self, valid_address=None, mail_server_used_for_validation=None, valid_syntax=None, valid_domain=None, valid_smtp=None, is_catchall_domain=None, domain=None, is_free_email_provider=None, is_disposable=None):  # noqa: E501
        """FullEmailValidationResponse - a model defined in Swagger"""  # noqa: E501

        self._valid_address = None
        self._mail_server_used_for_validation = None
        self._valid_syntax = None
        self._valid_domain = None
        self._valid_smtp = None
        self._is_catchall_domain = None
        self._domain = None
        self._is_free_email_provider = None
        self._is_disposable = None
        self.discriminator = None

        if valid_address is not None:
            self.valid_address = valid_address
        if mail_server_used_for_validation is not None:
            self.mail_server_used_for_validation = mail_server_used_for_validation
        if valid_syntax is not None:
            self.valid_syntax = valid_syntax
        if valid_domain is not None:
            self.valid_domain = valid_domain
        if valid_smtp is not None:
            self.valid_smtp = valid_smtp
        if is_catchall_domain is not None:
            self.is_catchall_domain = is_catchall_domain
        if domain is not None:
            self.domain = domain
        if is_free_email_provider is not None:
            self.is_free_email_provider = is_free_email_provider
        if is_disposable is not None:
            self.is_disposable = is_disposable

    @property
    def valid_address(self):
        """Gets the valid_address of this FullEmailValidationResponse.  # noqa: E501

        True if the email address is valid overall, false otherwise  # noqa: E501

        :return: The valid_address of this FullEmailValidationResponse.  # noqa: E501
        :rtype: bool
        """
        return self._valid_address

    @valid_address.setter
    def valid_address(self, valid_address):
        """Sets the valid_address of this FullEmailValidationResponse.

        True if the email address is valid overall, false otherwise  # noqa: E501

        :param valid_address: The valid_address of this FullEmailValidationResponse.  # noqa: E501
        :type: bool
        """

        self._valid_address = valid_address

    @property
    def mail_server_used_for_validation(self):
        """Gets the mail_server_used_for_validation of this FullEmailValidationResponse.  # noqa: E501

        Email server connected to for verification  # noqa: E501

        :return: The mail_server_used_for_validation of this FullEmailValidationResponse.  # noqa: E501
        :rtype: str
        """
        return self._mail_server_used_for_validation

    @mail_server_used_for_validation.setter
    def mail_server_used_for_validation(self, mail_server_used_for_validation):
        """Sets the mail_server_used_for_validation of this FullEmailValidationResponse.

        Email server connected to for verification  # noqa: E501

        :param mail_server_used_for_validation: The mail_server_used_for_validation of this FullEmailValidationResponse.  # noqa: E501
        :type: str
        """

        self._mail_server_used_for_validation = mail_server_used_for_validation

    @property
    def valid_syntax(self):
        """Gets the valid_syntax of this FullEmailValidationResponse.  # noqa: E501

        True if the syntax of the email address is valid, false otherwise.  This is one component of ValidAddress, but not the only one.  # noqa: E501

        :return: The valid_syntax of this FullEmailValidationResponse.  # noqa: E501
        :rtype: bool
        """
        return self._valid_syntax

    @valid_syntax.setter
    def valid_syntax(self, valid_syntax):
        """Sets the valid_syntax of this FullEmailValidationResponse.

        True if the syntax of the email address is valid, false otherwise.  This is one component of ValidAddress, but not the only one.  # noqa: E501

        :param valid_syntax: The valid_syntax of this FullEmailValidationResponse.  # noqa: E501
        :type: bool
        """

        self._valid_syntax = valid_syntax

    @property
    def valid_domain(self):
        """Gets the valid_domain of this FullEmailValidationResponse.  # noqa: E501

        True if the domain name of the email address is valid, false otherwise.  This is one component of ValidAddress, but not the only one.  # noqa: E501

        :return: The valid_domain of this FullEmailValidationResponse.  # noqa: E501
        :rtype: bool
        """
        return self._valid_domain

    @valid_domain.setter
    def valid_domain(self, valid_domain):
        """Sets the valid_domain of this FullEmailValidationResponse.

        True if the domain name of the email address is valid, false otherwise.  This is one component of ValidAddress, but not the only one.  # noqa: E501

        :param valid_domain: The valid_domain of this FullEmailValidationResponse.  # noqa: E501
        :type: bool
        """

        self._valid_domain = valid_domain

    @property
    def valid_smtp(self):
        """Gets the valid_smtp of this FullEmailValidationResponse.  # noqa: E501

        True if the email address was verified by the remote server, false otherwise.  This is one component of ValidAddress, but not the only one.  # noqa: E501

        :return: The valid_smtp of this FullEmailValidationResponse.  # noqa: E501
        :rtype: bool
        """
        return self._valid_smtp

    @valid_smtp.setter
    def valid_smtp(self, valid_smtp):
        """Sets the valid_smtp of this FullEmailValidationResponse.

        True if the email address was verified by the remote server, false otherwise.  This is one component of ValidAddress, but not the only one.  # noqa: E501

        :param valid_smtp: The valid_smtp of this FullEmailValidationResponse.  # noqa: E501
        :type: bool
        """

        self._valid_smtp = valid_smtp

    @property
    def is_catchall_domain(self):
        """Gets the is_catchall_domain of this FullEmailValidationResponse.  # noqa: E501

        True if the domain is a catch-all domain name, false otherwise.  Catch-all domain names, while rare, always accept inbound email to ensure they do not lose any potentially useful emails.  Catch-all domain names can occassionally be configured to first accept and store all inbound email, but then later send a bounce email back to the sender after a delayed period of time.  # noqa: E501

        :return: The is_catchall_domain of this FullEmailValidationResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_catchall_domain

    @is_catchall_domain.setter
    def is_catchall_domain(self, is_catchall_domain):
        """Sets the is_catchall_domain of this FullEmailValidationResponse.

        True if the domain is a catch-all domain name, false otherwise.  Catch-all domain names, while rare, always accept inbound email to ensure they do not lose any potentially useful emails.  Catch-all domain names can occassionally be configured to first accept and store all inbound email, but then later send a bounce email back to the sender after a delayed period of time.  # noqa: E501

        :param is_catchall_domain: The is_catchall_domain of this FullEmailValidationResponse.  # noqa: E501
        :type: bool
        """

        self._is_catchall_domain = is_catchall_domain

    @property
    def domain(self):
        """Gets the domain of this FullEmailValidationResponse.  # noqa: E501

        Domain name of the email address  # noqa: E501

        :return: The domain of this FullEmailValidationResponse.  # noqa: E501
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """Sets the domain of this FullEmailValidationResponse.

        Domain name of the email address  # noqa: E501

        :param domain: The domain of this FullEmailValidationResponse.  # noqa: E501
        :type: str
        """

        self._domain = domain

    @property
    def is_free_email_provider(self):
        """Gets the is_free_email_provider of this FullEmailValidationResponse.  # noqa: E501

        True if the email domain name is a free provider (typically a free to sign up web email provider for consumers / personal use), false otherwise.  # noqa: E501

        :return: The is_free_email_provider of this FullEmailValidationResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_free_email_provider

    @is_free_email_provider.setter
    def is_free_email_provider(self, is_free_email_provider):
        """Sets the is_free_email_provider of this FullEmailValidationResponse.

        True if the email domain name is a free provider (typically a free to sign up web email provider for consumers / personal use), false otherwise.  # noqa: E501

        :param is_free_email_provider: The is_free_email_provider of this FullEmailValidationResponse.  # noqa: E501
        :type: bool
        """

        self._is_free_email_provider = is_free_email_provider

    @property
    def is_disposable(self):
        """Gets the is_disposable of this FullEmailValidationResponse.  # noqa: E501

        True if the email address is a disposable email address, false otherwise; these disposable providers are not typically used to receive email and so will have a low likelihood of opening mail sent there.  # noqa: E501

        :return: The is_disposable of this FullEmailValidationResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_disposable

    @is_disposable.setter
    def is_disposable(self, is_disposable):
        """Sets the is_disposable of this FullEmailValidationResponse.

        True if the email address is a disposable email address, false otherwise; these disposable providers are not typically used to receive email and so will have a low likelihood of opening mail sent there.  # noqa: E501

        :param is_disposable: The is_disposable of this FullEmailValidationResponse.  # noqa: E501
        :type: bool
        """

        self._is_disposable = is_disposable

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FullEmailValidationResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FullEmailValidationResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
