from pathlib import Path
from datetime import datetime

from yaml import safe_load, safe_dump

from ocrd_models import OcrdConfig
from ocrd_utils import XDG_CONFIG_HOME, VERSION
from ocrd_validators import OcrdConfigValidator
from ocrd_models.ocrd_config import DEFAULT_CONFIG

def load_config_file():
    """
    Load the configuration file
    """
    fpath = Path(XDG_CONFIG_HOME, 'ocrd', 'config.yml')
    if not fpath.parent.exists():
        fpath.parent.mkdir()
    obj = DEFAULT_CONFIG
    if not fpath.exists():
        with open(str(fpath), 'w', encoding='utf-8') as f_out:
            f_out.write("# Generated by OCR-D/core %s on %s\n" % (VERSION, datetime.now()))
            f_out.write(safe_dump(obj))
    with open(str(fpath), 'r', encoding='utf-8') as f_in:
        obj = {**obj, **safe_load(f_in.read())}
        report = OcrdConfigValidator.validate(obj)
        if not report.is_valid:
            raise ValueError("The configuration is invalid: %s" % report.errors)
        return OcrdConfig(obj)
