<a id="mypy-boto3-mturk"></a>

# mypy-boto3-mturk

[![PyPI - mypy-boto3-mturk](https://img.shields.io/pypi/v/mypy-boto3-mturk.svg?color=blue)](https://pypi.org/project/mypy-boto3-mturk)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-mturk.svg?color=blue)](https://pypi.org/project/mypy-boto3-mturk)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-mturk?color=blue)](https://pypistats.org/packages/mypy-boto3-mturk)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.MTurk 1.19.6](https://boto3.amazonaws.com/v1/documentation/api/1.19.6/reference/services/mturk.html#MTurk)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-mturk docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mturk/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-mturk](#mypy-boto3-mturk)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `MTurk` service.

```bash
python -m pip install boto3-stubs[mturk]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[mturk]` in your environment:
  `python -m pip install 'boto3-stubs[mturk]'`

Both type checking and auto-complete should work for `MTurk` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[mturk]` in your environment:
  `python -m pip install 'boto3-stubs[mturk]'`

Both type checking and auto-complete should work for `MTurk` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[mturk]` in your environment:
  `python -m pip install 'boto3-stubs[mturk]'`
- Run `mypy` as usual

Type checking should work for `MTurk` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[mturk]` in your environment:
  `python -m pip install 'boto3-stubs[mturk]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `MTurk` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`MTurkClient` provides annotations for `boto3.client("mturk")`.

```python
import boto3

from mypy_boto3_mturk import MTurkClient

client: MTurkClient = boto3.client("mturk")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MTurkClient = session.client("mturk")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_mturk.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_mturk import MTurkClient
from mypy_boto3_mturk.paginator import (
    ListAssignmentsForHITPaginator,
    ListBonusPaymentsPaginator,
    ListHITsPaginator,
    ListHITsForQualificationTypePaginator,
    ListQualificationRequestsPaginator,
    ListQualificationTypesPaginator,
    ListReviewableHITsPaginator,
    ListWorkerBlocksPaginator,
    ListWorkersWithQualificationTypePaginator,
)

client: MTurkClient = boto3.client("mturk")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_assignments_for_hit_paginator: ListAssignmentsForHITPaginator = client.get_paginator("list_assignments_for_hit")
list_bonus_payments_paginator: ListBonusPaymentsPaginator = client.get_paginator("list_bonus_payments")
list_hits_paginator: ListHITsPaginator = client.get_paginator("list_hits")
list_hits_for_qualification_type_paginator: ListHITsForQualificationTypePaginator = client.get_paginator("list_hits_for_qualification_type")
list_qualification_requests_paginator: ListQualificationRequestsPaginator = client.get_paginator("list_qualification_requests")
list_qualification_types_paginator: ListQualificationTypesPaginator = client.get_paginator("list_qualification_types")
list_reviewable_hits_paginator: ListReviewableHITsPaginator = client.get_paginator("list_reviewable_hits")
list_worker_blocks_paginator: ListWorkerBlocksPaginator = client.get_paginator("list_worker_blocks")
list_workers_with_qualification_type_paginator: ListWorkersWithQualificationTypePaginator = client.get_paginator("list_workers_with_qualification_type")
```

<a id="literals"></a>

### Literals

`mypy_boto3_mturk.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_mturk.literals import (
    AssignmentStatusType,
    ComparatorType,
    EventTypeType,
    HITAccessActionsType,
    HITReviewStatusType,
    HITStatusType,
    ListAssignmentsForHITPaginatorName,
    ListBonusPaymentsPaginatorName,
    ListHITsForQualificationTypePaginatorName,
    ListHITsPaginatorName,
    ListQualificationRequestsPaginatorName,
    ListQualificationTypesPaginatorName,
    ListReviewableHITsPaginatorName,
    ListWorkerBlocksPaginatorName,
    ListWorkersWithQualificationTypePaginatorName,
    NotificationTransportType,
    NotifyWorkersFailureCodeType,
    QualificationStatusType,
    QualificationTypeStatusType,
    ReviewActionStatusType,
    ReviewPolicyLevelType,
    ReviewableHITStatusType,
    ServiceName,
    PaginatorName,
)

def check_value(value: AssignmentStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_mturk.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_mturk.type_defs import (
    AcceptQualificationRequestRequestRequestTypeDef,
    ApproveAssignmentRequestRequestTypeDef,
    AssignmentTypeDef,
    AssociateQualificationWithWorkerRequestRequestTypeDef,
    BonusPaymentTypeDef,
    CreateAdditionalAssignmentsForHITRequestRequestTypeDef,
    CreateHITRequestRequestTypeDef,
    CreateHITResponseTypeDef,
    CreateHITTypeRequestRequestTypeDef,
    CreateHITTypeResponseTypeDef,
    CreateHITWithHITTypeRequestRequestTypeDef,
    CreateHITWithHITTypeResponseTypeDef,
    CreateQualificationTypeRequestRequestTypeDef,
    CreateQualificationTypeResponseTypeDef,
    CreateWorkerBlockRequestRequestTypeDef,
    DeleteHITRequestRequestTypeDef,
    DeleteQualificationTypeRequestRequestTypeDef,
    DeleteWorkerBlockRequestRequestTypeDef,
    DisassociateQualificationFromWorkerRequestRequestTypeDef,
    GetAccountBalanceResponseTypeDef,
    GetAssignmentRequestRequestTypeDef,
    GetAssignmentResponseTypeDef,
    GetFileUploadURLRequestRequestTypeDef,
    GetFileUploadURLResponseTypeDef,
    GetHITRequestRequestTypeDef,
    GetHITResponseTypeDef,
    GetQualificationScoreRequestRequestTypeDef,
    GetQualificationScoreResponseTypeDef,
    GetQualificationTypeRequestRequestTypeDef,
    GetQualificationTypeResponseTypeDef,
    HITLayoutParameterTypeDef,
    HITTypeDef,
    ListAssignmentsForHITRequestRequestTypeDef,
    ListAssignmentsForHITResponseTypeDef,
    ListBonusPaymentsRequestRequestTypeDef,
    ListBonusPaymentsResponseTypeDef,
    ListHITsForQualificationTypeRequestRequestTypeDef,
    ListHITsForQualificationTypeResponseTypeDef,
    ListHITsRequestRequestTypeDef,
    ListHITsResponseTypeDef,
    ListQualificationRequestsRequestRequestTypeDef,
    ListQualificationRequestsResponseTypeDef,
    ListQualificationTypesRequestRequestTypeDef,
    ListQualificationTypesResponseTypeDef,
    ListReviewPolicyResultsForHITRequestRequestTypeDef,
    ListReviewPolicyResultsForHITResponseTypeDef,
    ListReviewableHITsRequestRequestTypeDef,
    ListReviewableHITsResponseTypeDef,
    ListWorkerBlocksRequestRequestTypeDef,
    ListWorkerBlocksResponseTypeDef,
    ListWorkersWithQualificationTypeRequestRequestTypeDef,
    ListWorkersWithQualificationTypeResponseTypeDef,
    LocaleTypeDef,
    NotificationSpecificationTypeDef,
    NotifyWorkersFailureStatusTypeDef,
    NotifyWorkersRequestRequestTypeDef,
    NotifyWorkersResponseTypeDef,
    PaginatorConfigTypeDef,
    ParameterMapEntryTypeDef,
    PolicyParameterTypeDef,
    QualificationRequestTypeDef,
    QualificationRequirementTypeDef,
    QualificationTypeDef,
    QualificationTypeTypeDef,
    RejectAssignmentRequestRequestTypeDef,
    RejectQualificationRequestRequestRequestTypeDef,
    ResponseMetadataTypeDef,
    ReviewActionDetailTypeDef,
    ReviewPolicyTypeDef,
    ReviewReportTypeDef,
    ReviewResultDetailTypeDef,
    SendBonusRequestRequestTypeDef,
    SendTestEventNotificationRequestRequestTypeDef,
    UpdateExpirationForHITRequestRequestTypeDef,
    UpdateHITReviewStatusRequestRequestTypeDef,
    UpdateHITTypeOfHITRequestRequestTypeDef,
    UpdateNotificationSettingsRequestRequestTypeDef,
    UpdateQualificationTypeRequestRequestTypeDef,
    UpdateQualificationTypeResponseTypeDef,
    WorkerBlockTypeDef,
)

def get_structure() -> AcceptQualificationRequestRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-mturk` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-mturk docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mturk/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
