"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const constructs_1 = require("constructs");
/**
 * Network settings for the manager and runners.
 *
 * All EC2 instances should belong to the same subnet, availability zone and vpc.
 *
 * @stability stable
 */
class Network extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.vpc = (_b = props === null || props === void 0 ? void 0 : props.vpc) !== null && _b !== void 0 ? _b : new aws_ec2_1.Vpc(scope, `Vpc`, {
            maxAzs: 1,
        });
        this.subnet = this.findSubnet(this.vpc, props === null || props === void 0 ? void 0 : props.subnetSelection);
        this.availabilityZone = this.subnet.availabilityZone;
        if (!this.hasPrivateSubnet(this.vpc)) {
            aws_cdk_lib_1.Annotations.of(this).addWarning(`No private network found in ${this.vpc.vpcId}, using public addresses.`);
        }
    }
    hasPrivateSubnet(vpc) {
        return !!vpc.privateSubnets.length;
    }
    /**
     * Returns the first private or public subnet. Optionally filters by AZ.
     *
     * @exception Throws an error if no private or public is found.
     */
    findSubnet(vpc, subnetSelection) {
        const selectedSubnets = vpc.selectSubnets(subnetSelection || {
            subnetType: this.hasPrivateSubnet(vpc) ? aws_ec2_1.SubnetType.PRIVATE_WITH_NAT : aws_ec2_1.SubnetType.PUBLIC,
            availabilityZones: vpc.availabilityZones,
        });
        const subnet = selectedSubnets.subnets.find(() => true);
        if (!subnet) {
            throw new Error(`Neither a private nor a public subnet is found in ${vpc.vpcId}`);
        }
        return subnet;
    }
}
exports.Network = Network;
_a = JSII_RTTI_SYMBOL_1;
Network[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Network", version: "0.0.162" };
//# sourceMappingURL=data:application/json;base64,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