"""release 0.1.5

Revision ID: 4907800d9126
Revises: 41a413504720
Create Date: 2022-09-07 15:19:07.998433

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "4907800d9126"
down_revision = "41a413504720"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "pipeline",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "artifact_to_pipeline",
        sa.Column("pipeline_id", sa.Integer(), nullable=True),
        sa.Column("artifact_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["artifact_id"],
            ["artifact.id"],
        ),
        sa.ForeignKeyConstraint(
            ["pipeline_id"],
            ["pipeline.id"],
        ),
    )
    op.create_table(
        "dependency",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("pipeline_id", sa.Integer(), nullable=False),
        sa.Column("post_artifact_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pipeline_id"],
            ["pipeline.id"],
        ),
        sa.ForeignKeyConstraint(
            ["post_artifact_id"],
            ["artifact.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "dependency_to_artifact_table",
        sa.Column("dependency_id", sa.Integer(), nullable=True),
        sa.Column("artifact_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["artifact_id"],
            ["artifact.id"],
        ),
        sa.ForeignKeyConstraint(
            ["dependency_id"],
            ["dependency.id"],
        ),
    )
    op.add_column(
        "artifact",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
    )
    op.create_unique_constraint(
        "_unique_artifact_name_and_version", "artifact", ["name", "version"]
    )
    op.create_unique_constraint(
        "_unique_artifact_name_for_a_node_id_and_exec_id",
        "artifact",
        ["name", "node_id", "execution_id", "version"],
    )
    op.add_column(
        "node", sa.Column("control_dependency", sa.String(), nullable=True)
    )
    op.create_foreign_key(
        "_control_dependency_node_id",
        "node",
        "node",
        ["control_dependency"],
        ["id"],
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        "_control_dependency_node_id", "node", type_="foreignkey"
    )
    op.drop_column("node", "control_dependency")
    op.drop_constraint(
        "_unique_artifact_name_for_a_node_id_and_exec_id",
        "artifact",
        type_="unique",
    )
    op.drop_constraint(
        "_unique_artifact_name_and_version", "artifact", type_="unique"
    )
    op.drop_column("artifact", "id")
    op.drop_table("dependency_to_artifact_table")
    op.drop_table("if_node")
    op.drop_table("else_node")
    op.drop_table("dependency")
    op.drop_table("artifact_to_pipeline")
    op.drop_table("pipeline")
    # ### end Alembic commands ###
