"""mlflow_integration

Revision ID: 07d0db31e15f
Revises: 4907800d9126
Create Date: 2022-11-03 16:26:37.217174

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "07d0db31e15f"
down_revision = "4907800d9126"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "mlflow_artifact_storage",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("artifact_id", sa.Integer(), nullable=False),
        sa.Column("backend", sa.String(), nullable=False),
        sa.Column("tracking_uri", sa.String(), nullable=False),
        sa.Column("registry_uri", sa.String(), nullable=True),
        sa.Column("model_uri", sa.String(), nullable=False),
        sa.Column("model_flavor", sa.String(), nullable=False),
        sa.Column("delete_time", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["artifact_id"],
            ["artifact.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("mlflow_artifact_storage")
    # ### end Alembic commands ###
