# -*- coding: utf-8 -*-
"""Code that represents a shell command."""
from __future__ import annotations

from aiida.orm import InstalledCode

__all__ = ('ShellCode',)


class ShellCode(InstalledCode):
    """Code that represents a shell command.

    This code type is automatically generated by the :func:`~aiida_shell.engine.launch.launch_shell_job` function and is
    a subclass of :class:`~aiida.orm.nodes.data.code.installed.InstalledCode`. It can therefore be used for any other
    calculation job as well.
    """

    def __init__(self, *args, default_calc_job_plugin: str = 'core.shell', **kwargs) -> None:
        """Construct a new instance."""
        self.validate_default_calc_job_plugin(default_calc_job_plugin)
        super().__init__(*args, default_calc_job_plugin=default_calc_job_plugin, **kwargs)

    @staticmethod
    def validate_default_calc_job_plugin(default_calc_job_plugin: str) -> None:
        """Validate the default calculation job plugin.

        The ``ShellCode`` should only be used with the ``core.shell`` calculation job entry point.

        :raises ValueError: If ``default_calc_job_plugin`` is not ``core.shell``.
        """
        if default_calc_job_plugin != 'core.shell':
            raise ValueError(f'`default_calc_job_plugin` has to be `core.shell`, but got: {default_calc_job_plugin}')

    @classmethod
    def _get_cli_options(cls) -> dict:
        """Return the CLI options that would allow to create an instance of this class."""
        options = super()._get_cli_options()
        options['default_calc_job_plugin']['default'] = 'core.shell'
        return options
