# generated by datamodel-codegen:
#   filename:  type/changeEvent.json
#   timestamp: 2023-03-30T09:54:39+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional

from pydantic import BaseModel, Extra, Field

from . import basic, entityHistory


class EventType(Enum):
    entityCreated = 'entityCreated'
    entityUpdated = 'entityUpdated'
    entitySoftDeleted = 'entitySoftDeleted'
    entityDeleted = 'entityDeleted'


class EntityTypes(Enum):
    All = 'All'
    Chart = 'Chart'
    Dashboard = 'Dashboard'
    Database = 'Database'
    Database_Schema = 'Database Schema'
    Glossary = 'Glossary'
    Glossary_Term = 'Glossary Term'
    Location = 'Location'
    Metrics = 'Metrics'
    Ml_Model = 'Ml Model'
    Pipeline = 'Pipeline'
    Report = 'Report'
    Table = 'Table'
    Topic = 'Topic'
    Test_Case = 'Test Case'


class FieldTypes(Enum):
    All = 'All'
    Display_Name = 'Display Name'
    Description = 'Description'
    Owner = 'Owner'
    Location = 'Location'
    Tags = 'Tags'
    Usage_Summary = 'Usage Summary'
    Followers = 'Followers'
    Sample_Data = 'Sample Data'
    Synonyms = 'Synonyms'
    Glossary = 'Glossary'
    Test_Case_Result_Success = 'Test Case Result Success'
    Test_Case_Result_Failed = 'Test Case Result Failed'
    Test_Case_Result_Aborted = 'Test Case Result Aborted'


class Filters(BaseModel):
    class Config:
        extra = Extra.forbid

    eventType: EventType = Field(..., description='Event type that is being requested.')
    include: Optional[List[str]] = Field(
        ['all'], description='Field which are allowed to pass', unique_items=True
    )
    exclude: Optional[List[str]] = Field(
        [], description='Field which are not allowed to pass', unique_items=True
    )


class EventFilter(BaseModel):
    class Config:
        extra = Extra.forbid

    entityType: str = Field(
        ...,
        description='Entity type for filter , example : topic , table, dashboard, mlmodel , etc',
    )
    filters: Optional[List[Filters]] = Field(
        None, description='List of operations supported by the resource.'
    )


class ChangeEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    eventType: EventType
    entityType: str = Field(
        ...,
        description='Entity type that changed. Use the schema of this entity to process the entity attribute.',
    )
    entityId: basic.Uuid = Field(
        ..., description='Identifier of entity that was modified by the operation.'
    )
    entityFullyQualifiedName: Optional[str] = Field(
        None,
        description='Fully Qualified Name of entity that was modified by the operation.',
    )
    previousVersion: Optional[entityHistory.EntityVersion] = Field(
        None,
        description='Version of the entity before this change. Note that not all changes result in entity version change. When entity version is not changed, `previousVersion` is same as `currentVersion`.',
    )
    currentVersion: Optional[entityHistory.EntityVersion] = Field(
        None,
        description='Current version of the entity after this change. Note that not all changes result in entity version change. When entity version is not changed, `previousVersion` is same as `currentVersion`.',
    )
    userName: Optional[str] = Field(
        None, description='Name of the user whose activity resulted in the change.'
    )
    timestamp: basic.Timestamp = Field(
        ...,
        description='Timestamp when the change was made in Unix epoch time milliseconds.',
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None,
        description='For `eventType` `entityUpdated` this field captures details about what fields were added/updated/deleted. For `eventType` `entityCreated` or `entityDeleted` this field is null.',
    )
    entity: Optional[Any] = Field(
        None,
        description='For `eventType` `entityCreated`, this field captures JSON coded string of the entity using the schema corresponding to `entityType`.',
    )
