# generated by datamodel-codegen:
#   filename:  settings/settings.json
#   timestamp: 2023-03-30T09:54:39+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from ..configuration import (
    authenticationConfiguration,
    authorizerConfiguration,
    elasticSearchConfiguration,
    eventHandlerConfiguration,
    fernetConfiguration,
    jwtTokenConfiguration,
    pipelineServiceClientConfiguration,
    taskNotificationConfiguration,
)


class SettingType(Enum):
    authorizerConfiguration = 'authorizerConfiguration'
    authenticationConfiguration = 'authenticationConfiguration'
    jwtTokenConfiguration = 'jwtTokenConfiguration'
    elasticsearch = 'elasticsearch'
    eventHandlerConfiguration = 'eventHandlerConfiguration'
    airflowConfiguration = 'airflowConfiguration'
    fernetConfiguration = 'fernetConfiguration'
    slackEventPublishers = 'slackEventPublishers'
    secretsManagerConfiguration = 'secretsManagerConfiguration'
    sandboxModeEnabled = 'sandboxModeEnabled'
    slackChat = 'slackChat'
    taskNotificationConfiguration = 'taskNotificationConfiguration'
    testResultNotificationConfiguration = 'testResultNotificationConfiguration'


class Settings(BaseModel):
    class Config:
        extra = Extra.forbid

    config_type: SettingType = Field(
        ..., description='Unique identifier that identifies an entity instance.'
    )
    config_value: Optional[
        Union[
            pipelineServiceClientConfiguration.PipelineServiceClientConfiguration,
            authenticationConfiguration.AuthenticationConfiguration,
            authorizerConfiguration.AuthorizerConfiguration,
            elasticSearchConfiguration.ElasticSearchConfiguration,
            eventHandlerConfiguration.EventHandlerConfiguration,
            fernetConfiguration.FernetConfiguration,
            jwtTokenConfiguration.JWTTokenConfiguration,
            taskNotificationConfiguration.TaskNotificationConfiguration,
        ]
    ] = None
