# generated by datamodel-codegen:
#   filename:  metadataIngestion/objectstore/containerMetadataConfig.json
#   timestamp: 2023-03-30T09:54:39+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field


class MetadataEntry(BaseModel):
    dataPath: str = Field(
        ...,
        description='The path where the data resides in the container, excluding the bucket name',
        title='Data path',
    )
    structureFormat: Optional[str] = Field(
        None,
        description="What's the schema format for the container, eg. avro, parquet, csv.",
        title='Schema format',
    )
    isPartitioned: Optional[bool] = Field(
        False,
        description="Flag indicating whether the container's data is partitioned",
        title='Is Partitioned',
    )
    partitionColumn: Optional[str] = Field(
        None,
        description="What is the partition column in case the container's data is partitioned",
        title='Partition Column',
    )


class ObjectStoreContainerConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    entries: List[MetadataEntry] = Field(
        ...,
        description='List of metadata entries for the bucket containing information about where data resides and its structure',
    )
