# generated by datamodel-codegen:
#   filename:  entity/utils/supersetApiConnection.json
#   timestamp: 2023-03-30T09:54:39+00:00

from __future__ import annotations

from enum import Enum

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr


class ApiProvider(Enum):
    db = 'db'
    ldap = 'ldap'


class SupersetAPIConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    provider: ApiProvider = Field(
        ...,
        description="Authentication provider for the Superset service. For basic user/password authentication, the default value `db` can be used. This parameter is used internally to connect to Superset's REST API.",
        title='Provider',
    )
    username: str = Field(..., description='Username for Superset.', title='Username')
    password: CustomSecretStr = Field(
        ..., description='Password for Superset.', title='Password'
    )
