# generated by datamodel-codegen:
#   filename:  entity/teams/role.json
#   timestamp: 2023-03-30T09:54:39+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference


class RoleName(BaseModel):
    __root__: basic.EntityName = Field(..., description='A unique name for the role.')


class Role(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid
    name: RoleName
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    displayName: Optional[str] = Field(
        None, description="Name used for display purposes. Example 'Data Consumer'."
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the role.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    allowDelete: Optional[bool] = Field(
        None, description="Some system roles can't be deleted"
    )
    allowEdit: Optional[bool] = Field(
        None, description="Some system roles can't be edited"
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    policies: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Policies that is attached to this role.'
    )
    users: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Users that have this role assigned to them.'
    )
    teams: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Teams that have this role assigned to them.'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    disabled: Optional[bool] = Field(
        None,
        description="System policy can't be deleted. Use this flag to disable them.",
    )
