# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/databricksPipelineConnection.json
#   timestamp: 2023-03-30T09:54:39+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class DatabricksType(Enum):
    DatabricksPipeline = 'DatabricksPipeline'


class DatabricksPipelineConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DatabricksType] = Field(
        DatabricksType.DatabricksPipeline,
        description='Service Type',
        title='Service Type',
    )
    hostPort: str = Field(
        ...,
        description='Host and port of the Databricks service.',
        title='Host and Port',
    )
    token: CustomSecretStr = Field(
        ..., description='Generated Token to connect to Databricks.', title='Token'
    )
    httpPath: Optional[str] = Field(
        None, description='Databricks compute resources URL.', title='Http Path'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
