# generated by datamodel-codegen:
#   filename:  entity/data/query.json
#   timestamp: 2023-03-30T09:54:39+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference, tagLabel, votes


class Query(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier of the query.'
    )
    name: basic.EntityName = Field(
        ..., description='Name of a entity to which the query belong'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='Fully qualified name of a query.'
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this Query. It could be title or label.',
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of a query.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the query.')
    href: Optional[basic.Href] = Field(None, description='Link to this Query resource.')
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Query.'
    )
    duration: Optional[float] = Field(
        None, description='How long did the query took to run in seconds.'
    )
    users: Optional[List[entityReference.EntityReference]] = Field(
        None, description='List of users who ran this query.'
    )
    followers: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Followers of this Query.'
    )
    votes: Optional[votes.Votes] = None
    query: basic.SqlQuery = Field(..., description='SQL Query definition.')
    checksum: Optional[str] = Field(
        None, description='Checksum to avoid registering duplicate queries.'
    )
    queryDate: Optional[basic.Timestamp] = Field(
        None, description='Date on which the query ran.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this SQL query.'
    )
    queryUsedIn: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Entities that are using this query'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
