# generated by datamodel-codegen:
#   filename:  entity/classification/tag.json
#   timestamp: 2023-03-30T09:54:39+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field, constr

from ...type import basic, entityHistory, entityReference


class TagName(BaseModel):
    __root__: constr(regex=r'^(?u)[\w\'\- .&]+$', min_length=2, max_length=64) = Field(
        ..., description='Name of the tag.'
    )


class Tag(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier of this entity instance.'
    )
    name: TagName = Field(..., description='Name of the tag.')
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this tag.'
    )
    fullyQualifiedName: Optional[str] = Field(
        None, description='Unique name of the tag of format `Classification.tag1.tag2`.'
    )
    description: basic.Markdown = Field(..., description='Description of the tag.')
    classification: Optional[entityReference.EntityReference] = Field(
        None, description='Reference to the classification that this tag is part of.'
    )
    parent: Optional[entityReference.EntityReference] = Field(
        None,
        description='Reference to the parent tag. When null, the term is at the root of the Classification.',
    )
    children: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Children tags under this tag.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to the tag.'
    )
    usageCount: Optional[int] = Field(
        None, description='Count of how many times this tag and children tags are used.'
    )
    deprecated: Optional[bool] = Field(False, description='If the tag is deprecated.')
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    disabled: Optional[bool] = Field(
        None, description="System tags can't be deleted. Use this flag to disable them."
    )
    mutuallyExclusive: Optional[bool] = Field(
        'false',
        description='Children tags under this group are mutually exclusive. When mutually exclusive is `true` the tags from this group are used to **classify** an entity. An entity can only be in one class - example, it can only be either `tier1` or `tier2` and not both. When mutually exclusive is `false`, the tags from this group are used to **categorize** an entity. An entity can be in multiple categories simultaneously - example a customer can be `newCustomer` and `atRisk` simultaneously.',
    )
