# generated by datamodel-codegen:
#   filename:  api/data/createDashboard.json
#   timestamp: 2023-03-30T09:54:39+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityReference, tagLabel


class CreateDashboardRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(
        ..., description='Name that identifies this dashboard.'
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this Dashboard. It could be title or label from the source services',
    )
    description: Optional[basic.Markdown] = Field(
        None,
        description='Description of the database instance. What it has and how to use it.',
    )
    dashboardUrl: Optional[str] = Field(
        None, description='Dashboard URL suffix from its service.'
    )
    charts: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None,
        description='List of fully qualified name of charts included in this Dashboard.',
    )
    dataModels: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None,
        description='List of fully qualified name of data models included in this Dashboard.',
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this dashboard'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this dashboard'
    )
    service: basic.FullyQualifiedEntityName = Field(
        ...,
        description='Link to the dashboard service fully qualified name where this dashboard is hosted in',
    )
    extension: Optional[basic.EntityExtension] = Field(
        None,
        description='Entity extension data with custom attributes added to the entity.',
    )
