# generated by datamodel-codegen:
#   filename:  api/automations/createWorkflow.json
#   timestamp: 2023-03-30T09:54:39+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field

from ...entity.automations import testServiceConnection, workflow
from ...entity.services.connections import testConnectionResult
from ...type import basic, entityReference


class CreateWorkflowRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(..., description='Name of the workflow.')
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this workflow definition.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the test connection def.'
    )
    workflowType: workflow.WorkflowType = Field(
        ..., description='Type of the workflow.'
    )
    request: testServiceConnection.TestServiceConnectionRequest = Field(
        ..., description='Request body for a specific workflow type'
    )
    status: Optional[workflow.WorkflowStatus] = Field(
        workflow.WorkflowStatus.Pending, description='Workflow computation status.'
    )
    response: Optional[testConnectionResult.TestConnectionResult] = Field(
        None, description='Response to the request.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this workflow.'
    )
