
Based on [react-d3-graph](https://www.npmjs.com/package/react-d3-graph)


## Install

`pip install streamlit-agraph`

## Use
```python
import streamlit
from streamlit_agraph import agraph

nodes = []
edges = []
nodes.append( Node(id="Spiderman", size=400, svg="http://marvel-force-chart.surge.sh/marvel_force_chart_img/top_spiderman.png") ) # ,
nodes.append( Node(id="Captain_Marvel", size=400, svg="http://marvel-force-chart.surge.sh/marvel_force_chart_img/top_captainmarvel.png"))
edges.append( Edge(source="Captain_Marvel", target="Spiderman", type="CURVE_SMOOTH"))

return_value = agraph(nodes=nodes,
                      edges=edges, 
                      nodeHighlightBehavior="true",
                      node_color="blue", node_size=1000,
                      highlightStrokeColor="blue",
                      highlightColor="lightblue" )
```

![](https://github.com/ChrisChross/streamlit-agraph/blob/master/imgs/example.png)

