import transformers


DOCUMENTATION_TEMPLATE = """# {model_name}

_This README.md is autogenerated by Model Zoo_

### Predictions

- Install the Python client library `modelzoo-client`

```bash
pip install modelzoo-client
```

- Make a prediction

```python
import modelzoo.transformers

input = "These violent delights have violent ends"
prediction = modelzoo.transformers.generate("{model_name}",input)
```
"""


def generate_default_transformers_docs(
    model_name: str, pipeline: transformers.Pipeline
) -> str:
    return DOCUMENTATION_TEMPLATE.format(model_name=model_name)
