#  Copyright (C) 2020 Servly AI.
#  See the LICENCE file distributed with this work for additional
#  information regarding copyright ownership.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

DOCUMENTATION_TEMPLATE = """# {model_name}

_This README.md is autogenerated by Model Zoo_

### Predictions

- Install the Python client library `modelzoo-client`

```bash
pip install modelzoo-client
```

- Make a prediction

```python
import numpy as np
import modelzoo.torch

prediction = modelzoo.torch.predict("{model_name}", {{"input_1": np.random.randn(...)}})
```
"""


def generate_default_pytorch_docs(model_name: str) -> str:
    return DOCUMENTATION_TEMPLATE.format(model_name=model_name)
