<div align="center">

[![Botstrap Logo](https://raw.githubusercontent.com/nuztalgia/botstrap/main/docs/images/logo-192.png)](https://botstrap.readthedocs.io)

# Botstrap

[![Development Status](https://img.shields.io/pypi/status/botstrap)](https://pypi.org/project/botstrap/)
[![Latest Version](https://img.shields.io/pypi/v/botstrap?label=latest%20version)](https://pypi.org/project/botstrap/)
[![Supported Python Versions](https://img.shields.io/pypi/pyversions/botstrap)](https://pypi.org/project/botstrap/)
<br>
[![Tests](https://github.com/nuztalgia/botstrap/actions/workflows/tests.yml/badge.svg)](https://github.com/nuztalgia/botstrap/actions/workflows/tests.yml)
[![Docs](https://img.shields.io/readthedocs/botstrap?logo=read-the-docs&logoColor=9fa6ae&label=Docs&labelColor=313a43)](https://readthedocs.org/projects/botstrap)
[![CodeQL](https://github.com/nuztalgia/botstrap/actions/workflows/codeql.yml/badge.svg)](https://github.com/nuztalgia/botstrap/actions/workflows/codeql.yml)
<br>
[![Codacy](https://img.shields.io/codacy/grade/6864639715f04899b62d3a4460eba83e?logo=codacy)](https://app.codacy.com/gh/nuztalgia/botstrap)
[![Codecov](https://img.shields.io/codecov/c/github/nuztalgia/botstrap?logo=codecov&logoColor=fff)](https://app.codecov.io/github/nuztalgia/botstrap)
[![Libraries.io](https://img.shields.io/librariesio/github/nuztalgia/botstrap?logo=librariesdotio&logoColor=ddd&logoWidth=12&label=deps)](https://libraries.io/github/nuztalgia/botstrap)

An easy-to-use utility toolbelt for Discord bots written in Python.<br>
[**Read the docs »**](https://botstrap.readthedocs.io)

</div>

## Overview

Do you store your Discord bot token in
[plaintext](https://en.wikipedia.org/wiki/Plaintext)? Don't get caught with your pants
down. Strap in!

**Botstrap** is a ~~Python library~~ suit of power armor that perfectly fits your
Discord bot. It offers:

- 🔐 **Secure encryption** and password protection to keep your bot tokens safe
- 🤹 A straightforward way to **manage multiple tokens** and/or bot configurations
- 🌈 An intuitive, colorful, and customizable **command-line interface** for your bot
- 🤝 Out-of-the-box **compatibility** with all of the most popular Python
  [Discord libraries](https://discord.com/developers/docs/topics/community-resources#libraries)
- ... and more to come!

## Installation

Python **3.10** or higher is required. It's also generally a good idea to upgrade pip
(`python -m pip install -U pip`).

```sh
pip install -U botstrap
```

For additional/alternative installation instructions, see the
[documentation](https://botstrap.readthedocs.io/en/latest/getting-started/).

## Quickstart

Coming soon! In the meantime, check out the very detailed
[API Reference](https://botstrap.readthedocs.io/en/latest/api/).
