"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KafkaVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Kafka cluster version
 */
class KafkaVersion {
    /**
     *
     * @param version cluster version number
     */
    constructor(version) {
        this.version = version;
    }
    /**
     * Custom cluster version
     * @param version custom version number
     */
    static of(version) {
        return new KafkaVersion(version);
    }
}
exports.KafkaVersion = KafkaVersion;
_a = JSII_RTTI_SYMBOL_1;
KafkaVersion[_a] = { fqn: "@aws-cdk/aws-msk-alpha.KafkaVersion", version: "2.69.0-alpha.0" };
/**
 * Kafka version 1.1.1
 */
KafkaVersion.V1_1_1 = KafkaVersion.of('1.1.1');
/**
 * Kafka version 2.2.1
 */
KafkaVersion.V2_2_1 = KafkaVersion.of('2.2.1');
/**
 * Kafka version 2.3.1
 */
KafkaVersion.V2_3_1 = KafkaVersion.of('2.3.1');
/**
 * Kafka version 2.4.1
 */
KafkaVersion.V2_4_1_1 = KafkaVersion.of('2.4.1.1');
/**
 * Kafka version 2.5.1
 */
KafkaVersion.V2_5_1 = KafkaVersion.of('2.5.1');
/**
 * Kafka version 2.6.0
 */
KafkaVersion.V2_6_0 = KafkaVersion.of('2.6.0');
/**
 * Kafka version 2.6.1
 */
KafkaVersion.V2_6_1 = KafkaVersion.of('2.6.1');
/**
 * Kafka version 2.6.2
 */
KafkaVersion.V2_6_2 = KafkaVersion.of('2.6.2');
/**
 * Kafka version 2.6.3
 */
KafkaVersion.V2_6_3 = KafkaVersion.of('2.6.3');
/**
 * Kafka version 2.7.0
 */
KafkaVersion.V2_7_0 = KafkaVersion.of('2.7.0');
/**
 * Kafka version 2.7.1
 */
KafkaVersion.V2_7_1 = KafkaVersion.of('2.7.1');
/**
 * Kafka version 2.7.2
 */
KafkaVersion.V2_7_2 = KafkaVersion.of('2.7.2');
/**
 * Kafka version 2.8.0
 */
KafkaVersion.V2_8_0 = KafkaVersion.of('2.8.0');
/**
 * Kafka version 2.8.1
 */
KafkaVersion.V2_8_1 = KafkaVersion.of('2.8.1');
/**
 * Kafka version 3.1.1
 */
KafkaVersion.V3_1_1 = KafkaVersion.of('3.1.1');
/**
 * Kafka version 3.2.0
 */
KafkaVersion.V3_2_0 = KafkaVersion.of('3.2.0');
/**
 * Kafka version 3.3.1
 */
KafkaVersion.V3_3_1 = KafkaVersion.of('3.3.1');
/**
 * Kafka version 3.3.2
 */
KafkaVersion.V3_3_2 = KafkaVersion.of('3.3.2');
//# sourceMappingURL=data:application/json;base64,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