# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/salesforceConnection.json
#   timestamp: 2022-04-14T07:03:55+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class SalesforceType(Enum):
    Salesforce = 'Salesforce'


class SalesforceScheme(Enum):
    salesforce = 'salesforce'


class SalesforceConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SalesforceType] = Field(
        SalesforceType.Salesforce, description='Service Type'
    )
    scheme: Optional[SalesforceScheme] = Field(
        SalesforceScheme.salesforce, description='SQLAlchemy driver scheme options.'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Redshift. This user should have privileges to read all the metadata in Redshift.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Redshift.'
    )
    securityToken: Optional[str] = Field(None, description='Salesforce Security Token.')
    hostPort: Optional[str] = Field(None, description='Host and port of the Redshift.')
    sobjectName: Optional[str] = Field(None, description='Salesforce Object Name.')
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
