# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/dashboard/tableauConnection.json
#   timestamp: 2022-04-14T07:03:55+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class TableauType(Enum):
    Tableau = 'Tableau'


class TableauConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[TableauType] = Field(TableauType.Tableau, description='Service Type')
    hostPort: Optional[str] = Field(None, description='Tableau Server')
    username: Optional[str] = Field(None, description='username for the Tableau')
    password: Optional[SecretStr] = Field(None, description='password for the Tableau')
    apiVersion: Optional[str] = Field(None, description='Tableau API version')
    siteName: Optional[str] = Field(None, description='Tableau Site Name')
    personalAccessTokenName: Optional[str] = Field(
        None, description='Personal Access Token Name'
    )
    personalAccessTokenSecret: Optional[str] = Field(
        None, description='Personal Access Token Secret'
    )
    env: Optional[str] = Field(None, description='Tableau Environment Name')
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
