# generated by datamodel-codegen:
#   filename:  schema/api/data/createDashboard.json
#   timestamp: 2022-04-14T10:43:15+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, constr

from ...type import entityReference, tagLabel


class CreateDashboardRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: constr(min_length=1, max_length=128) = Field(
        ..., description='Name that identifies this dashboard.'
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this Dashboard. It could be title or label from the source services',
    )
    description: Optional[str] = Field(
        None,
        description='Description of the database instance. What it has and how to use it.',
    )
    dashboardUrl: Optional[AnyUrl] = Field(None, description='Dashboard URL')
    charts: Optional[List[entityReference.EntityReference]] = Field(
        None, description='All the charts included in this Dashboard.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this dashboard'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this dashboard'
    )
    service: entityReference.EntityReference = Field(
        ...,
        description='Link to the dashboard service where this dashboard is hosted in',
    )
