# Generated by Django 3.2.5 on 2021-09-08 13:52

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import odk.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='XForm',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('xls_file', models.FileField(help_text='XLSForm with 3 tabs: survey, choices, settings', null=True, upload_to=odk.models.xform_path, verbose_name='Excel file')),
                ('xml_file', models.FileField(help_text="XLSForm traduit par <a href='https://getodk.org/xlsform/' target='_blank'>https://getodk.org/xlsform/</a>", upload_to=odk.models.xform_path, verbose_name='XML file')),
                ('xml_content', models.TextField(verbose_name='Contenu du formulaire XML')),
                ('form_id', models.SlugField(editable=False, help_text='Retrieved from XLSForm (settings tab)', max_length=200)),
                ('version', models.CharField(editable=False, help_text='Retrieved from XLSForm (settings tab)', max_length=200)),
                ('title', models.CharField(editable=False, help_text='Retrieved from XLSForm (settings tab)', max_length=250, verbose_name='Title')),
                ('short_desc', models.CharField(blank=True, max_length=250, verbose_name='Short description')),
                ('created_on', models.DateTimeField(auto_now_add=True, verbose_name='Created on')),
                ('modified_on', models.DateTimeField(auto_now=True, verbose_name='Modified on')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='xform_created_by', to=settings.AUTH_USER_MODEL, verbose_name='Created by')),
                ('modified_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='xform_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='Modified by')),
            ],
            options={
                'verbose_name': 'Available form',
                'verbose_name_plural': 'Available form',
                'ordering': ('xml_file',),
                'unique_together': {('form_id', 'version')},
            },
        ),
        migrations.CreateModel(
            name='XFormSubmit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('form_id', models.SlugField(editable=False, help_text='Retrieved from XML form (settings tab du fichier Excel)', max_length=200)),
                ('version', models.CharField(editable=False, help_text='Retrieved from XML form (settings tab du fichier Excel)', max_length=200)),
                ('instanceid', models.UUIDField(unique=True)),
                ('deviceid', models.CharField(blank=True, max_length=255, null=True)),
                ('survey_date', models.DateField(blank=True, null=True, verbose_name='Encoding date')),
                ('picture_files', models.JSONField(blank=True, null=True, verbose_name='Picture file names')),
                ('xml_file', models.FileField(blank=True, help_text='XML file sended through ODK Collect Mobile App', upload_to='', verbose_name='Submitted form')),
                ('xml_content', models.TextField(help_text='XML content sended through ODK Collect Mobile App', verbose_name='Content of XML file submitted')),
                ('submitted_by', models.CharField(blank=True, max_length=255, null=True, verbose_name='Submitted by')),
                ('submitted_on', models.DateTimeField(verbose_name='Submitted on')),
                ('modified_by', models.CharField(blank=True, max_length=255, null=True, verbose_name='Modified by')),
                ('modified_on', models.DateTimeField(auto_now=True, verbose_name='Modified on')),
                ('xform', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='template_form', to='odk.xform', verbose_name='Template form')),
            ],
            options={
                'verbose_name': 'Submitted form',
                'verbose_name_plural': 'Submitted form',
                'ordering': ('submitted_on',),
            },
        ),
    ]
