# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ModelModel(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'model_id': 'RimeUUID',
        'project_ids': 'list[str]',
        'creator_id': 'str',
        'creation_time': 'datetime',
        'external_id': 'str',
        'user_metadata': 'RegistryMetadata',
        'model_info': 'ModelModelInfo'
    }

    attribute_map = {
        'name': 'name',
        'model_id': 'modelId',
        'project_ids': 'projectIds',
        'creator_id': 'creatorId',
        'creation_time': 'creationTime',
        'external_id': 'externalId',
        'user_metadata': 'userMetadata',
        'model_info': 'modelInfo'
    }

    def __init__(self, name=None, model_id=None, project_ids=None, creator_id=None, creation_time=None, external_id=None, user_metadata=None, model_info=None):  # noqa: E501
        """ModelModel - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._model_id = None
        self._project_ids = None
        self._creator_id = None
        self._creation_time = None
        self._external_id = None
        self._user_metadata = None
        self._model_info = None
        self.discriminator = None
        if name is not None:
            self.name = name
        if model_id is not None:
            self.model_id = model_id
        if project_ids is not None:
            self.project_ids = project_ids
        if creator_id is not None:
            self.creator_id = creator_id
        if creation_time is not None:
            self.creation_time = creation_time
        if external_id is not None:
            self.external_id = external_id
        if user_metadata is not None:
            self.user_metadata = user_metadata
        if model_info is not None:
            self.model_info = model_info

    @property
    def name(self):
        """Gets the name of this ModelModel.  # noqa: E501

        Name and model_id are both enforced to be unique. Name is user specified. Model_id is internally generated.  # noqa: E501

        :return: The name of this ModelModel.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ModelModel.

        Name and model_id are both enforced to be unique. Name is user specified. Model_id is internally generated.  # noqa: E501

        :param name: The name of this ModelModel.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def model_id(self):
        """Gets the model_id of this ModelModel.  # noqa: E501


        :return: The model_id of this ModelModel.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """Sets the model_id of this ModelModel.


        :param model_id: The model_id of this ModelModel.  # noqa: E501
        :type: RimeUUID
        """

        self._model_id = model_id

    @property
    def project_ids(self):
        """Gets the project_ids of this ModelModel.  # noqa: E501

        For now, a model will only have one project_id associated with it. We make this an array to allow model's to be shared in the future.  # noqa: E501

        :return: The project_ids of this ModelModel.  # noqa: E501
        :rtype: list[str]
        """
        return self._project_ids

    @project_ids.setter
    def project_ids(self, project_ids):
        """Sets the project_ids of this ModelModel.

        For now, a model will only have one project_id associated with it. We make this an array to allow model's to be shared in the future.  # noqa: E501

        :param project_ids: The project_ids of this ModelModel.  # noqa: E501
        :type: list[str]
        """

        self._project_ids = project_ids

    @property
    def creator_id(self):
        """Gets the creator_id of this ModelModel.  # noqa: E501

        creator and created_time of the model will be automatically populated.  # noqa: E501

        :return: The creator_id of this ModelModel.  # noqa: E501
        :rtype: str
        """
        return self._creator_id

    @creator_id.setter
    def creator_id(self, creator_id):
        """Sets the creator_id of this ModelModel.

        creator and created_time of the model will be automatically populated.  # noqa: E501

        :param creator_id: The creator_id of this ModelModel.  # noqa: E501
        :type: str
        """

        self._creator_id = creator_id

    @property
    def creation_time(self):
        """Gets the creation_time of this ModelModel.  # noqa: E501


        :return: The creation_time of this ModelModel.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this ModelModel.


        :param creation_time: The creation_time of this ModelModel.  # noqa: E501
        :type: datetime
        """

        self._creation_time = creation_time

    @property
    def external_id(self):
        """Gets the external_id of this ModelModel.  # noqa: E501

        external_id is an optional way for a user to identify the model  with their own model ids.  # noqa: E501

        :return: The external_id of this ModelModel.  # noqa: E501
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """Sets the external_id of this ModelModel.

        external_id is an optional way for a user to identify the model  with their own model ids.  # noqa: E501

        :param external_id: The external_id of this ModelModel.  # noqa: E501
        :type: str
        """

        self._external_id = external_id

    @property
    def user_metadata(self):
        """Gets the user_metadata of this ModelModel.  # noqa: E501


        :return: The user_metadata of this ModelModel.  # noqa: E501
        :rtype: RegistryMetadata
        """
        return self._user_metadata

    @user_metadata.setter
    def user_metadata(self, user_metadata):
        """Sets the user_metadata of this ModelModel.


        :param user_metadata: The user_metadata of this ModelModel.  # noqa: E501
        :type: RegistryMetadata
        """

        self._user_metadata = user_metadata

    @property
    def model_info(self):
        """Gets the model_info of this ModelModel.  # noqa: E501


        :return: The model_info of this ModelModel.  # noqa: E501
        :rtype: ModelModelInfo
        """
        return self._model_info

    @model_info.setter
    def model_info(self, model_info):
        """Sets the model_info of this ModelModel.


        :param model_info: The model_info of this ModelModel.  # noqa: E501
        :type: ModelModelInfo
        """

        self._model_info = model_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ModelModel, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ModelModel):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
