# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class ProjectManagerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def project_manager_create_project(self, body, **kwargs):  # noqa: E501
        """CreateProject  # noqa: E501

        Creates a project with a specified name and description.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_manager_create_project(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateProjectRequest body: (required)
        :return: RimeCreateProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_manager_create_project_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.project_manager_create_project_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def project_manager_create_project_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateProject  # noqa: E501

        Creates a project with a specified name and description.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_manager_create_project_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateProjectRequest body: (required)
        :return: RimeCreateProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_manager_create_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_manager_create_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_manager_delete_project(self, project_id, **kwargs):  # noqa: E501
        """DeleteProject  # noqa: E501

        Deletes a project with specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_manager_delete_project(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :return: RimeDeleteProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_manager_delete_project_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_manager_delete_project_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def project_manager_delete_project_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """DeleteProject  # noqa: E501

        Deletes a project with specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_manager_delete_project_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :return: RimeDeleteProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_manager_delete_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_manager_delete_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_manager_get_project(self, project_id, **kwargs):  # noqa: E501
        """GetProject  # noqa: E501

        Returns the project that matches the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_manager_get_project(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: Unique ID of a project. (required)
        :return: RimeGetProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_manager_get_project_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_manager_get_project_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def project_manager_get_project_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """GetProject  # noqa: E501

        Returns the project that matches the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_manager_get_project_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: Unique ID of a project. (required)
        :return: RimeGetProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_manager_get_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_manager_get_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_manager_list_projects(self, **kwargs):  # noqa: E501
        """ListProjects  # noqa: E501

        Returns a paginated list of projects.  [Python pagination example](#tag/JobReader/operation/JobReader_ListJobs)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_manager_list_projects(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id: Specifies which workspace projects to list.
        :param str page_token: Use to retrieve a page of the list returned by a ListProjects query  beyond the first page. The ListProjects query returns a pageToken when there is more than one  page of results.
        :param str page_size: Specifies the maximum number of projects on a given page. Each call to  ListProjects returns a single page.
        :return: RimeListProjectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_manager_list_projects_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.project_manager_list_projects_with_http_info(**kwargs)  # noqa: E501
            return data

    def project_manager_list_projects_with_http_info(self, **kwargs):  # noqa: E501
        """ListProjects  # noqa: E501

        Returns a paginated list of projects.  [Python pagination example](#tag/JobReader/operation/JobReader_ListJobs)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_manager_list_projects_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id: Specifies which workspace projects to list.
        :param str page_token: Use to retrieve a page of the list returned by a ListProjects query  beyond the first page. The ListProjects query returns a pageToken when there is more than one  page of results.
        :param str page_size: Specifies the maximum number of projects on a given page. Each call to  ListProjects returns a single page.
        :return: RimeListProjectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_manager_list_projects" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'workspace_id' in params:
            query_params.append(('workspaceId', params['workspace_id']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListProjectsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_manager_move_test_runs(self, body, source_project_id, destination_project_id, **kwargs):  # noqa: E501
        """MoveTestRuns  # noqa: E501

        Moves test runs from one project to another project in the same workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_manager_move_test_runs(body, source_project_id, destination_project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SourceProjectIdDestinationProjectIdBody body: (required)
        :param str source_project_id: The unique ID of an existing project that is the source of the test runs. (required)
        :param str destination_project_id: The unique ID of an existing project that is the destination of the test runs. (required)
        :return: RimeMoveTestRunsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_manager_move_test_runs_with_http_info(body, source_project_id, destination_project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_manager_move_test_runs_with_http_info(body, source_project_id, destination_project_id, **kwargs)  # noqa: E501
            return data

    def project_manager_move_test_runs_with_http_info(self, body, source_project_id, destination_project_id, **kwargs):  # noqa: E501
        """MoveTestRuns  # noqa: E501

        Moves test runs from one project to another project in the same workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_manager_move_test_runs_with_http_info(body, source_project_id, destination_project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SourceProjectIdDestinationProjectIdBody body: (required)
        :param str source_project_id: The unique ID of an existing project that is the source of the test runs. (required)
        :param str destination_project_id: The unique ID of an existing project that is the destination of the test runs. (required)
        :return: RimeMoveTestRunsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'source_project_id', 'destination_project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_manager_move_test_runs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_manager_move_test_runs`")  # noqa: E501
        # verify the required parameter 'source_project_id' is set
        if ('source_project_id' not in params or
                params['source_project_id'] is None):
            raise ValueError("Missing the required parameter `source_project_id` when calling `project_manager_move_test_runs`")  # noqa: E501
        # verify the required parameter 'destination_project_id' is set
        if ('destination_project_id' not in params or
                params['destination_project_id'] is None):
            raise ValueError("Missing the required parameter `destination_project_id` when calling `project_manager_move_test_runs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'source_project_id' in params:
            path_params['sourceProjectId'] = params['source_project_id']  # noqa: E501
        if 'destination_project_id' in params:
            path_params['destinationProjectId'] = params['destination_project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/move-test-runs/{sourceProjectId}/{destinationProjectId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeMoveTestRunsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_manager_update_project(self, body, project_id, **kwargs):  # noqa: E501
        """UpdateProject  # noqa: E501

        Updates project name and description.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_manager_update_project(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectsProjectIdBody body: (required)
        :param str project_id: (required)
        :return: RimeUpdateProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_manager_update_project_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_manager_update_project_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def project_manager_update_project_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """UpdateProject  # noqa: E501

        Updates project name and description.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_manager_update_project_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectsProjectIdBody body: (required)
        :param str project_id: (required)
        :return: RimeUpdateProjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_manager_update_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_manager_update_project`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_manager_update_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project.id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{project.id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateProjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
