# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class FileScanningApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def file_scanning_list_file_scan_results(self, **kwargs):  # noqa: E501
        """ListFileScanResults  # noqa: E501

        Returns a paginated list of all file scan results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_scanning_list_file_scan_results(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: Defines the maximum number of results on a given page. API call pagination navigates through the entire set of results in groups of the specified page size.
        :param str page_token: Specifies a page of the list returned by a ListFileScan query beyond the first page.
        :return: RimeListFileScanResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.file_scanning_list_file_scan_results_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.file_scanning_list_file_scan_results_with_http_info(**kwargs)  # noqa: E501
            return data

    def file_scanning_list_file_scan_results_with_http_info(self, **kwargs):  # noqa: E501
        """ListFileScanResults  # noqa: E501

        Returns a paginated list of all file scan results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_scanning_list_file_scan_results_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: Defines the maximum number of results on a given page. API call pagination navigates through the entire set of results in groups of the specified page size.
        :param str page_token: Specifies a page of the list returned by a ListFileScan query beyond the first page.
        :return: RimeListFileScanResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method file_scanning_list_file_scan_results" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/file-scans', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListFileScanResultsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def file_scanning_start_file_scan(self, body, **kwargs):  # noqa: E501
        """StartFileScan  # noqa: E501

        Starts a file scanning job for the specified file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_scanning_start_file_scan(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeStartFileScanRequest body: (required)
        :return: RimeStartFileScanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.file_scanning_start_file_scan_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.file_scanning_start_file_scan_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def file_scanning_start_file_scan_with_http_info(self, body, **kwargs):  # noqa: E501
        """StartFileScan  # noqa: E501

        Starts a file scanning job for the specified file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_scanning_start_file_scan_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeStartFileScanRequest body: (required)
        :return: RimeStartFileScanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method file_scanning_start_file_scan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `file_scanning_start_file_scan`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/file-scans', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeStartFileScanResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
