# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://docs.intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.28.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from intrinio_sdk.models.security_summary import SecuritySummary  # noqa: F401,E501


class ZacksLongTermGrowthRate(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'mean': 'float',
        'median': 'float',
        'count': 'int',
        'high': 'float',
        'low': 'float',
        'std_dev': 'str',
        'revisions_upward': 'int',
        'revisions_downward': 'int',
        'mean_7_days_ago': 'str',
        'mean_30_days_ago': 'str',
        'mean_60_days_ago': 'str',
        'mean_90_days_ago': 'str',
        'revisions_upward_last_7_days': 'str',
        'revisions_downward_last_7_days': 'str',
        'revisions_upward_last_30_days': 'str',
        'revisions_downward_last_30_days': 'str',
        'revisions_upward_last_60_days': 'str',
        'revisions_downward_last_60_days': 'str',
        'revisions_upward_last_90_days': 'str',
        'revisions_downward_last_90_days': 'str',
        'revisions_upward_last_120_days': 'str',
        'revisions_downward_last_120_days': 'str',
        'revisions_upward_last_150_days': 'str',
        'revisions_downward_last_150_days': 'str',
        'security': 'SecuritySummary'
    }

    attribute_map = {
        'mean': 'mean',
        'median': 'median',
        'count': 'count',
        'high': 'high',
        'low': 'low',
        'std_dev': 'std_dev',
        'revisions_upward': 'revisions_upward',
        'revisions_downward': 'revisions_downward',
        'mean_7_days_ago': 'mean_7_days_ago',
        'mean_30_days_ago': 'mean_30_days_ago',
        'mean_60_days_ago': 'mean_60_days_ago',
        'mean_90_days_ago': 'mean_90_days_ago',
        'revisions_upward_last_7_days': 'revisions_upward_last_7_days',
        'revisions_downward_last_7_days': 'revisions_downward_last_7_days',
        'revisions_upward_last_30_days': 'revisions_upward_last_30_days',
        'revisions_downward_last_30_days': 'revisions_downward_last_30_days',
        'revisions_upward_last_60_days': 'revisions_upward_last_60_days',
        'revisions_downward_last_60_days': 'revisions_downward_last_60_days',
        'revisions_upward_last_90_days': 'revisions_upward_last_90_days',
        'revisions_downward_last_90_days': 'revisions_downward_last_90_days',
        'revisions_upward_last_120_days': 'revisions_upward_last_120_days',
        'revisions_downward_last_120_days': 'revisions_downward_last_120_days',
        'revisions_upward_last_150_days': 'revisions_upward_last_150_days',
        'revisions_downward_last_150_days': 'revisions_downward_last_150_days',
        'security': 'security'
    }

    def __init__(self, mean=None, median=None, count=None, high=None, low=None, std_dev=None, revisions_upward=None, revisions_downward=None, mean_7_days_ago=None, mean_30_days_ago=None, mean_60_days_ago=None, mean_90_days_ago=None, revisions_upward_last_7_days=None, revisions_downward_last_7_days=None, revisions_upward_last_30_days=None, revisions_downward_last_30_days=None, revisions_upward_last_60_days=None, revisions_downward_last_60_days=None, revisions_upward_last_90_days=None, revisions_downward_last_90_days=None, revisions_upward_last_120_days=None, revisions_downward_last_120_days=None, revisions_upward_last_150_days=None, revisions_downward_last_150_days=None, security=None):  # noqa: E501
        """ZacksLongTermGrowthRate - a model defined in Swagger"""  # noqa: E501

        self._mean = None
        self._median = None
        self._count = None
        self._high = None
        self._low = None
        self._std_dev = None
        self._revisions_upward = None
        self._revisions_downward = None
        self._mean_7_days_ago = None
        self._mean_30_days_ago = None
        self._mean_60_days_ago = None
        self._mean_90_days_ago = None
        self._revisions_upward_last_7_days = None
        self._revisions_downward_last_7_days = None
        self._revisions_upward_last_30_days = None
        self._revisions_downward_last_30_days = None
        self._revisions_upward_last_60_days = None
        self._revisions_downward_last_60_days = None
        self._revisions_upward_last_90_days = None
        self._revisions_downward_last_90_days = None
        self._revisions_upward_last_120_days = None
        self._revisions_downward_last_120_days = None
        self._revisions_upward_last_150_days = None
        self._revisions_downward_last_150_days = None
        self._security = None
        self.discriminator = None

        if mean is not None:
            self.mean = mean
        if median is not None:
            self.median = median
        if count is not None:
            self.count = count
        if high is not None:
            self.high = high
        if low is not None:
            self.low = low
        if std_dev is not None:
            self.std_dev = std_dev
        if revisions_upward is not None:
            self.revisions_upward = revisions_upward
        if revisions_downward is not None:
            self.revisions_downward = revisions_downward
        if mean_7_days_ago is not None:
            self.mean_7_days_ago = mean_7_days_ago
        if mean_30_days_ago is not None:
            self.mean_30_days_ago = mean_30_days_ago
        if mean_60_days_ago is not None:
            self.mean_60_days_ago = mean_60_days_ago
        if mean_90_days_ago is not None:
            self.mean_90_days_ago = mean_90_days_ago
        if revisions_upward_last_7_days is not None:
            self.revisions_upward_last_7_days = revisions_upward_last_7_days
        if revisions_downward_last_7_days is not None:
            self.revisions_downward_last_7_days = revisions_downward_last_7_days
        if revisions_upward_last_30_days is not None:
            self.revisions_upward_last_30_days = revisions_upward_last_30_days
        if revisions_downward_last_30_days is not None:
            self.revisions_downward_last_30_days = revisions_downward_last_30_days
        if revisions_upward_last_60_days is not None:
            self.revisions_upward_last_60_days = revisions_upward_last_60_days
        if revisions_downward_last_60_days is not None:
            self.revisions_downward_last_60_days = revisions_downward_last_60_days
        if revisions_upward_last_90_days is not None:
            self.revisions_upward_last_90_days = revisions_upward_last_90_days
        if revisions_downward_last_90_days is not None:
            self.revisions_downward_last_90_days = revisions_downward_last_90_days
        if revisions_upward_last_120_days is not None:
            self.revisions_upward_last_120_days = revisions_upward_last_120_days
        if revisions_downward_last_120_days is not None:
            self.revisions_downward_last_120_days = revisions_downward_last_120_days
        if revisions_upward_last_150_days is not None:
            self.revisions_upward_last_150_days = revisions_upward_last_150_days
        if revisions_downward_last_150_days is not None:
            self.revisions_downward_last_150_days = revisions_downward_last_150_days
        if security is not None:
            self.security = security

    @property
    def mean(self):
        """Gets the mean of this ZacksLongTermGrowthRate.  # noqa: E501

        The mean long term growth estimate  # noqa: E501

        :return: The mean of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._mean
        
    @property
    def mean_dict(self):
        """Gets the mean of this ZacksLongTermGrowthRate.  # noqa: E501

        The mean long term growth estimate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The mean of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.mean
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'mean': value }

        
        return result
        

    @mean.setter
    def mean(self, mean):
        """Sets the mean of this ZacksLongTermGrowthRate.

        The mean long term growth estimate  # noqa: E501

        :param mean: The mean of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: float
        """

        self._mean = mean

    @property
    def median(self):
        """Gets the median of this ZacksLongTermGrowthRate.  # noqa: E501

        The median long term growth estimate  # noqa: E501

        :return: The median of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._median
        
    @property
    def median_dict(self):
        """Gets the median of this ZacksLongTermGrowthRate.  # noqa: E501

        The median long term growth estimate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The median of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.median
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'median': value }

        
        return result
        

    @median.setter
    def median(self, median):
        """Sets the median of this ZacksLongTermGrowthRate.

        The median long term growth estimate  # noqa: E501

        :param median: The median of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: float
        """

        self._median = median

    @property
    def count(self):
        """Gets the count of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimates  # noqa: E501

        :return: The count of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: int
        """
        return self._count
        
    @property
    def count_dict(self):
        """Gets the count of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimates as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The count of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: int
        """

        result = None

        value = self.count
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'count': value }

        
        return result
        

    @count.setter
    def count(self, count):
        """Sets the count of this ZacksLongTermGrowthRate.

        The number of long term growth estimates  # noqa: E501

        :param count: The count of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: int
        """

        self._count = count

    @property
    def high(self):
        """Gets the high of this ZacksLongTermGrowthRate.  # noqa: E501

        The high long term growth estimate  # noqa: E501

        :return: The high of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._high
        
    @property
    def high_dict(self):
        """Gets the high of this ZacksLongTermGrowthRate.  # noqa: E501

        The high long term growth estimate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The high of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.high
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'high': value }

        
        return result
        

    @high.setter
    def high(self, high):
        """Sets the high of this ZacksLongTermGrowthRate.

        The high long term growth estimate  # noqa: E501

        :param high: The high of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: float
        """

        self._high = high

    @property
    def low(self):
        """Gets the low of this ZacksLongTermGrowthRate.  # noqa: E501

        The low long term growth estimate  # noqa: E501

        :return: The low of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: float
        """
        return self._low
        
    @property
    def low_dict(self):
        """Gets the low of this ZacksLongTermGrowthRate.  # noqa: E501

        The low long term growth estimate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The low of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.low
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'low': value }

        
        return result
        

    @low.setter
    def low(self, low):
        """Sets the low of this ZacksLongTermGrowthRate.

        The low long term growth estimate  # noqa: E501

        :param low: The low of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: float
        """

        self._low = low

    @property
    def std_dev(self):
        """Gets the std_dev of this ZacksLongTermGrowthRate.  # noqa: E501

        The standard deviation long term growth estimate  # noqa: E501

        :return: The std_dev of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._std_dev
        
    @property
    def std_dev_dict(self):
        """Gets the std_dev of this ZacksLongTermGrowthRate.  # noqa: E501

        The standard deviation long term growth estimate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The std_dev of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.std_dev
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'std_dev': value }

        
        return result
        

    @std_dev.setter
    def std_dev(self, std_dev):
        """Sets the std_dev of this ZacksLongTermGrowthRate.

        The standard deviation long term growth estimate  # noqa: E501

        :param std_dev: The std_dev of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._std_dev = std_dev

    @property
    def revisions_upward(self):
        """Gets the revisions_upward of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward  # noqa: E501

        :return: The revisions_upward of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: int
        """
        return self._revisions_upward
        
    @property
    def revisions_upward_dict(self):
        """Gets the revisions_upward of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_upward of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: int
        """

        result = None

        value = self.revisions_upward
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_upward': value }

        
        return result
        

    @revisions_upward.setter
    def revisions_upward(self, revisions_upward):
        """Sets the revisions_upward of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions upward  # noqa: E501

        :param revisions_upward: The revisions_upward of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: int
        """

        self._revisions_upward = revisions_upward

    @property
    def revisions_downward(self):
        """Gets the revisions_downward of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward  # noqa: E501

        :return: The revisions_downward of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: int
        """
        return self._revisions_downward
        
    @property
    def revisions_downward_dict(self):
        """Gets the revisions_downward of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_downward of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: int
        """

        result = None

        value = self.revisions_downward
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_downward': value }

        
        return result
        

    @revisions_downward.setter
    def revisions_downward(self, revisions_downward):
        """Sets the revisions_downward of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions downward  # noqa: E501

        :param revisions_downward: The revisions_downward of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: int
        """

        self._revisions_downward = revisions_downward

    @property
    def mean_7_days_ago(self):
        """Gets the mean_7_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501

        The mean long term growth estimate 7 days ago  # noqa: E501

        :return: The mean_7_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._mean_7_days_ago
        
    @property
    def mean_7_days_ago_dict(self):
        """Gets the mean_7_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501

        The mean long term growth estimate 7 days ago as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The mean_7_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.mean_7_days_ago
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'mean_7_days_ago': value }

        
        return result
        

    @mean_7_days_ago.setter
    def mean_7_days_ago(self, mean_7_days_ago):
        """Sets the mean_7_days_ago of this ZacksLongTermGrowthRate.

        The mean long term growth estimate 7 days ago  # noqa: E501

        :param mean_7_days_ago: The mean_7_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._mean_7_days_ago = mean_7_days_ago

    @property
    def mean_30_days_ago(self):
        """Gets the mean_30_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501

        The mean long term growth estimate 30 days ago  # noqa: E501

        :return: The mean_30_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._mean_30_days_ago
        
    @property
    def mean_30_days_ago_dict(self):
        """Gets the mean_30_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501

        The mean long term growth estimate 30 days ago as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The mean_30_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.mean_30_days_ago
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'mean_30_days_ago': value }

        
        return result
        

    @mean_30_days_ago.setter
    def mean_30_days_ago(self, mean_30_days_ago):
        """Sets the mean_30_days_ago of this ZacksLongTermGrowthRate.

        The mean long term growth estimate 30 days ago  # noqa: E501

        :param mean_30_days_ago: The mean_30_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._mean_30_days_ago = mean_30_days_ago

    @property
    def mean_60_days_ago(self):
        """Gets the mean_60_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501

        The mean long term growth estimate 60 days ago  # noqa: E501

        :return: The mean_60_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._mean_60_days_ago
        
    @property
    def mean_60_days_ago_dict(self):
        """Gets the mean_60_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501

        The mean long term growth estimate 60 days ago as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The mean_60_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.mean_60_days_ago
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'mean_60_days_ago': value }

        
        return result
        

    @mean_60_days_ago.setter
    def mean_60_days_ago(self, mean_60_days_ago):
        """Sets the mean_60_days_ago of this ZacksLongTermGrowthRate.

        The mean long term growth estimate 60 days ago  # noqa: E501

        :param mean_60_days_ago: The mean_60_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._mean_60_days_ago = mean_60_days_ago

    @property
    def mean_90_days_ago(self):
        """Gets the mean_90_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501

        The mean long term growth estimate 90 days ago  # noqa: E501

        :return: The mean_90_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._mean_90_days_ago
        
    @property
    def mean_90_days_ago_dict(self):
        """Gets the mean_90_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501

        The mean long term growth estimate 90 days ago as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The mean_90_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.mean_90_days_ago
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'mean_90_days_ago': value }

        
        return result
        

    @mean_90_days_ago.setter
    def mean_90_days_ago(self, mean_90_days_ago):
        """Sets the mean_90_days_ago of this ZacksLongTermGrowthRate.

        The mean long term growth estimate 90 days ago  # noqa: E501

        :param mean_90_days_ago: The mean_90_days_ago of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._mean_90_days_ago = mean_90_days_ago

    @property
    def revisions_upward_last_7_days(self):
        """Gets the revisions_upward_last_7_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward in the last 7 days  # noqa: E501

        :return: The revisions_upward_last_7_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._revisions_upward_last_7_days
        
    @property
    def revisions_upward_last_7_days_dict(self):
        """Gets the revisions_upward_last_7_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward in the last 7 days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_upward_last_7_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.revisions_upward_last_7_days
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_upward_last_7_days': value }

        
        return result
        

    @revisions_upward_last_7_days.setter
    def revisions_upward_last_7_days(self, revisions_upward_last_7_days):
        """Sets the revisions_upward_last_7_days of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions upward in the last 7 days  # noqa: E501

        :param revisions_upward_last_7_days: The revisions_upward_last_7_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._revisions_upward_last_7_days = revisions_upward_last_7_days

    @property
    def revisions_downward_last_7_days(self):
        """Gets the revisions_downward_last_7_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward in the last 7 days  # noqa: E501

        :return: The revisions_downward_last_7_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._revisions_downward_last_7_days
        
    @property
    def revisions_downward_last_7_days_dict(self):
        """Gets the revisions_downward_last_7_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward in the last 7 days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_downward_last_7_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.revisions_downward_last_7_days
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_downward_last_7_days': value }

        
        return result
        

    @revisions_downward_last_7_days.setter
    def revisions_downward_last_7_days(self, revisions_downward_last_7_days):
        """Sets the revisions_downward_last_7_days of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions downward in the last 7 days  # noqa: E501

        :param revisions_downward_last_7_days: The revisions_downward_last_7_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._revisions_downward_last_7_days = revisions_downward_last_7_days

    @property
    def revisions_upward_last_30_days(self):
        """Gets the revisions_upward_last_30_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward in the last 30 days  # noqa: E501

        :return: The revisions_upward_last_30_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._revisions_upward_last_30_days
        
    @property
    def revisions_upward_last_30_days_dict(self):
        """Gets the revisions_upward_last_30_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward in the last 30 days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_upward_last_30_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.revisions_upward_last_30_days
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_upward_last_30_days': value }

        
        return result
        

    @revisions_upward_last_30_days.setter
    def revisions_upward_last_30_days(self, revisions_upward_last_30_days):
        """Sets the revisions_upward_last_30_days of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions upward in the last 30 days  # noqa: E501

        :param revisions_upward_last_30_days: The revisions_upward_last_30_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._revisions_upward_last_30_days = revisions_upward_last_30_days

    @property
    def revisions_downward_last_30_days(self):
        """Gets the revisions_downward_last_30_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward in the last 30 days  # noqa: E501

        :return: The revisions_downward_last_30_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._revisions_downward_last_30_days
        
    @property
    def revisions_downward_last_30_days_dict(self):
        """Gets the revisions_downward_last_30_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward in the last 30 days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_downward_last_30_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.revisions_downward_last_30_days
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_downward_last_30_days': value }

        
        return result
        

    @revisions_downward_last_30_days.setter
    def revisions_downward_last_30_days(self, revisions_downward_last_30_days):
        """Sets the revisions_downward_last_30_days of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions downward in the last 30 days  # noqa: E501

        :param revisions_downward_last_30_days: The revisions_downward_last_30_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._revisions_downward_last_30_days = revisions_downward_last_30_days

    @property
    def revisions_upward_last_60_days(self):
        """Gets the revisions_upward_last_60_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward in the last 60 days  # noqa: E501

        :return: The revisions_upward_last_60_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._revisions_upward_last_60_days
        
    @property
    def revisions_upward_last_60_days_dict(self):
        """Gets the revisions_upward_last_60_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward in the last 60 days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_upward_last_60_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.revisions_upward_last_60_days
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_upward_last_60_days': value }

        
        return result
        

    @revisions_upward_last_60_days.setter
    def revisions_upward_last_60_days(self, revisions_upward_last_60_days):
        """Sets the revisions_upward_last_60_days of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions upward in the last 60 days  # noqa: E501

        :param revisions_upward_last_60_days: The revisions_upward_last_60_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._revisions_upward_last_60_days = revisions_upward_last_60_days

    @property
    def revisions_downward_last_60_days(self):
        """Gets the revisions_downward_last_60_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward in the last 60 days  # noqa: E501

        :return: The revisions_downward_last_60_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._revisions_downward_last_60_days
        
    @property
    def revisions_downward_last_60_days_dict(self):
        """Gets the revisions_downward_last_60_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward in the last 60 days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_downward_last_60_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.revisions_downward_last_60_days
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_downward_last_60_days': value }

        
        return result
        

    @revisions_downward_last_60_days.setter
    def revisions_downward_last_60_days(self, revisions_downward_last_60_days):
        """Sets the revisions_downward_last_60_days of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions downward in the last 60 days  # noqa: E501

        :param revisions_downward_last_60_days: The revisions_downward_last_60_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._revisions_downward_last_60_days = revisions_downward_last_60_days

    @property
    def revisions_upward_last_90_days(self):
        """Gets the revisions_upward_last_90_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward in the last 90 days  # noqa: E501

        :return: The revisions_upward_last_90_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._revisions_upward_last_90_days
        
    @property
    def revisions_upward_last_90_days_dict(self):
        """Gets the revisions_upward_last_90_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward in the last 90 days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_upward_last_90_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.revisions_upward_last_90_days
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_upward_last_90_days': value }

        
        return result
        

    @revisions_upward_last_90_days.setter
    def revisions_upward_last_90_days(self, revisions_upward_last_90_days):
        """Sets the revisions_upward_last_90_days of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions upward in the last 90 days  # noqa: E501

        :param revisions_upward_last_90_days: The revisions_upward_last_90_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._revisions_upward_last_90_days = revisions_upward_last_90_days

    @property
    def revisions_downward_last_90_days(self):
        """Gets the revisions_downward_last_90_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward in the last 90 days  # noqa: E501

        :return: The revisions_downward_last_90_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._revisions_downward_last_90_days
        
    @property
    def revisions_downward_last_90_days_dict(self):
        """Gets the revisions_downward_last_90_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward in the last 90 days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_downward_last_90_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.revisions_downward_last_90_days
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_downward_last_90_days': value }

        
        return result
        

    @revisions_downward_last_90_days.setter
    def revisions_downward_last_90_days(self, revisions_downward_last_90_days):
        """Sets the revisions_downward_last_90_days of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions downward in the last 90 days  # noqa: E501

        :param revisions_downward_last_90_days: The revisions_downward_last_90_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._revisions_downward_last_90_days = revisions_downward_last_90_days

    @property
    def revisions_upward_last_120_days(self):
        """Gets the revisions_upward_last_120_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward in the last 120 days  # noqa: E501

        :return: The revisions_upward_last_120_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._revisions_upward_last_120_days
        
    @property
    def revisions_upward_last_120_days_dict(self):
        """Gets the revisions_upward_last_120_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward in the last 120 days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_upward_last_120_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.revisions_upward_last_120_days
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_upward_last_120_days': value }

        
        return result
        

    @revisions_upward_last_120_days.setter
    def revisions_upward_last_120_days(self, revisions_upward_last_120_days):
        """Sets the revisions_upward_last_120_days of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions upward in the last 120 days  # noqa: E501

        :param revisions_upward_last_120_days: The revisions_upward_last_120_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._revisions_upward_last_120_days = revisions_upward_last_120_days

    @property
    def revisions_downward_last_120_days(self):
        """Gets the revisions_downward_last_120_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward in the last 120 days  # noqa: E501

        :return: The revisions_downward_last_120_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._revisions_downward_last_120_days
        
    @property
    def revisions_downward_last_120_days_dict(self):
        """Gets the revisions_downward_last_120_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward in the last 120 days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_downward_last_120_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.revisions_downward_last_120_days
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_downward_last_120_days': value }

        
        return result
        

    @revisions_downward_last_120_days.setter
    def revisions_downward_last_120_days(self, revisions_downward_last_120_days):
        """Sets the revisions_downward_last_120_days of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions downward in the last 120 days  # noqa: E501

        :param revisions_downward_last_120_days: The revisions_downward_last_120_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._revisions_downward_last_120_days = revisions_downward_last_120_days

    @property
    def revisions_upward_last_150_days(self):
        """Gets the revisions_upward_last_150_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward in the last 150 days  # noqa: E501

        :return: The revisions_upward_last_150_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._revisions_upward_last_150_days
        
    @property
    def revisions_upward_last_150_days_dict(self):
        """Gets the revisions_upward_last_150_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions upward in the last 150 days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_upward_last_150_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.revisions_upward_last_150_days
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_upward_last_150_days': value }

        
        return result
        

    @revisions_upward_last_150_days.setter
    def revisions_upward_last_150_days(self, revisions_upward_last_150_days):
        """Sets the revisions_upward_last_150_days of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions upward in the last 150 days  # noqa: E501

        :param revisions_upward_last_150_days: The revisions_upward_last_150_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._revisions_upward_last_150_days = revisions_upward_last_150_days

    @property
    def revisions_downward_last_150_days(self):
        """Gets the revisions_downward_last_150_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward in the last 150 days  # noqa: E501

        :return: The revisions_downward_last_150_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """
        return self._revisions_downward_last_150_days
        
    @property
    def revisions_downward_last_150_days_dict(self):
        """Gets the revisions_downward_last_150_days of this ZacksLongTermGrowthRate.  # noqa: E501

        The number of long term growth estimate revisions downward in the last 150 days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The revisions_downward_last_150_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.revisions_downward_last_150_days
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'revisions_downward_last_150_days': value }

        
        return result
        

    @revisions_downward_last_150_days.setter
    def revisions_downward_last_150_days(self, revisions_downward_last_150_days):
        """Sets the revisions_downward_last_150_days of this ZacksLongTermGrowthRate.

        The number of long term growth estimate revisions downward in the last 150 days  # noqa: E501

        :param revisions_downward_last_150_days: The revisions_downward_last_150_days of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: str
        """

        self._revisions_downward_last_150_days = revisions_downward_last_150_days

    @property
    def security(self):
        """Gets the security of this ZacksLongTermGrowthRate.  # noqa: E501

        The Security of the Zacks long term growth estimate  # noqa: E501

        :return: The security of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: SecuritySummary
        """
        return self._security
        
    @property
    def security_dict(self):
        """Gets the security of this ZacksLongTermGrowthRate.  # noqa: E501

        The Security of the Zacks long term growth estimate as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The security of this ZacksLongTermGrowthRate.  # noqa: E501
        :rtype: SecuritySummary
        """

        result = None

        value = self.security
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'security': value }

        
        return result
        

    @security.setter
    def security(self, security):
        """Sets the security of this ZacksLongTermGrowthRate.

        The Security of the Zacks long term growth estimate  # noqa: E501

        :param security: The security of this ZacksLongTermGrowthRate.  # noqa: E501
        :type: SecuritySummary
        """

        self._security = security

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ZacksLongTermGrowthRate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
