<h1 align="center">
    <img src="https://github.com/takeshi-iwanari/dear_ros_node_viewer/raw/main/00_docs/logo.png" alt="Dear RosNodeViewer logo"></a>
</h1>

https://user-images.githubusercontent.com/105265012/177068238-eaf4fed9-12c0-4c5b-ac7f-9597483c4c3c.mp4

[![Python application](https://github.com/takeshi-iwanari/dear_ros_node_viewer/actions/workflows/python-app.yml/badge.svg)](https://github.com/takeshi-iwanari/dear_ros_node_viewer/actions/workflows/python-app.yml)
[![PyPI Publish](https://github.com/takeshi-iwanari/dear_ros_node_viewer/actions/workflows/pypi-publish.yml/badge.svg)](https://pypi.org/project/dear-ros-node-viewer/)


# Dear RosNodeViewer
## About
- Visualize ROS2 node diagram
- Support the following sources:
    - *architecture.yaml* generated by [CARET](https://github.com/tier4/caret)
    - *rosgraph.dot* generated by rqt_graph
    - running ROS graph analysis


## Requirements
- Ubuntu 20.04 (Not tested in Windows / Mac)
    - graphviz is required
- optional: ROS 2 Galactic if you need runtime ROS graph analysis


## Get Started
```sh
# Install requirements
sudo apt install graphviz graphviz-dev

# Install Dear RosNodeViewer
pip install dear-ros-node-viewer

# Download sample graph
wget https://raw.githubusercontent.com/takeshi-iwanari/dear_ros_node_viewer/main/sample/architecture_autoware.yaml

# Run Dear RosNodeViewer
dear_ros_node_viewer architecture_autoware.yaml
```

- Quick operation guide:
    - Middle button drag: move graph area
    - Mouse scroll: zoom in/out (zoom function is tentative)


## How to Use
[See WiKi](https://github.com/takeshi-iwanari/dear_ros_node_viewer/wiki/01.-How-to-Use)


# Acknowledgements
- Dear RosNodeViewer utilizes [Dear PyGui](https://github.com/hoffstadt/DearPyGui)
    - *Dear RosNodeViewer* is named in honor of Dear PyGui
- Dear RosNodeViewer contains [Roboto font](https://fonts.google.com/specimen/Roboto)
    - licensed under the Apache License, Version 2.0.
