"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const events = require("@aws-cdk/aws-events");
const cdk = require("@aws-cdk/core");
const targets = require("../../lib");
const path = require("path");
const app = new cdk.App();
class EventStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const vpc = new ec2.Vpc(this, 'Vpc', { maxAzs: 1 });
        const cluster = new ecs.Cluster(this, 'EcsCluster', { vpc });
        cluster.addCapacity('DefaultAutoScalingGroup', {
            instanceType: new ec2.InstanceType('t2.micro'),
        });
        /// !show
        // Create a Task Definition for the container to start
        const taskDefinition = new ecs.Ec2TaskDefinition(this, 'TaskDef');
        taskDefinition.addContainer('TheContainer', {
            image: ecs.ContainerImage.fromAsset(path.resolve(__dirname, 'eventhandler-image')),
            memoryLimitMiB: 256,
            logging: new ecs.AwsLogDriver({ streamPrefix: 'EventDemo' }),
        });
        // An Rule that describes the event trigger (in this case a scheduled run)
        const rule = new events.Rule(this, 'Rule', {
            schedule: events.Schedule.rate(cdk.Duration.minutes(1)),
        });
        // Use EcsTask as the target of the Rule
        rule.addTarget(new targets.EcsTask({
            cluster,
            taskDefinition,
            taskCount: 1,
            containerOverrides: [{
                    containerName: 'TheContainer',
                    environment: [
                        { name: 'I_WAS_TRIGGERED', value: 'From CloudWatch Events' },
                    ],
                }],
        }));
        /// !hide
    }
}
new EventStack(app, 'aws-ecs-integ-ecs');
app.synth();
//# sourceMappingURL=data:application/json;base64,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