"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const batch = require("@aws-cdk/aws-batch");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const events = require("@aws-cdk/aws-events");
const cdk = require("@aws-cdk/core");
const targets = require("../../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'batch-events');
const queue = new batch.JobQueue(stack, 'MyQueue', {
    computeEnvironments: [
        {
            computeEnvironment: new batch.ComputeEnvironment(stack, 'ComputeEnvironment', {
                managed: false,
            }),
            order: 1,
        },
    ],
});
const job = new batch.JobDefinition(stack, 'MyJob', {
    container: {
        image: aws_ecs_1.ContainerImage.fromRegistry('test-repo'),
    },
});
const timer = new events.Rule(stack, 'Timer', {
    schedule: events.Schedule.rate(cdk.Duration.minutes(1)),
});
timer.addTarget(new targets.BatchJob(queue, job));
const timer2 = new events.Rule(stack, 'Timer2', {
    schedule: events.Schedule.rate(cdk.Duration.minutes(2)),
});
timer2.addTarget(new targets.BatchJob(queue, job));
app.synth();
//# sourceMappingURL=data:application/json;base64,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