"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events = require("@aws-cdk/aws-events");
const cdk = require("@aws-cdk/core");
const targets = require("../../lib");
const app = new cdk.App();
class AwsApi extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // Force new deployment of 'cool-service' and stop 'dev-instance' at midnight everyday
        const scheduleRule = new events.Rule(this, 'ScheduleRule', {
            schedule: events.Schedule.cron({
                hour: '0',
                minute: '0',
            }),
        });
        scheduleRule.addTarget(new targets.AwsApi({
            service: 'ECS',
            action: 'updateService',
            parameters: {
                service: 'cool-service',
                forceNewDeployment: true,
            },
        }));
        scheduleRule.addTarget(new targets.AwsApi({
            service: 'RDS',
            action: 'stopDBInstance',
            parameters: {
                DBInstanceIdentifier: 'dev-instance',
            },
        }));
        // Create snapshots when a DB instance restarts
        const patternRule = new events.Rule(this, 'PatternRule', {
            eventPattern: {
                detailType: ['RDS DB Instance Event'],
                detail: {
                    Message: ['DB instance restarted'],
                },
            },
        });
        patternRule.addTarget(new targets.AwsApi({
            service: 'RDS',
            action: 'createDBSnapshot',
            parameters: {
                DBInstanceIdentifier: events.EventField.fromPath('$.detail.SourceArn'),
            },
        }));
    }
}
new AwsApi(app, 'aws-cdk-aws-api-target-integ');
app.synth();
//# sourceMappingURL=data:application/json;base64,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