"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Use an AWS Batch Job / Queue as an event rule target.
 * @experimental
 */
class BatchJob {
    constructor(jobQueue, jobDefinition, props = {}) {
        this.jobQueue = jobQueue;
        this.jobDefinition = jobDefinition;
        this.props = props;
    }
    /**
     * Returns a RuleTarget that can be used to trigger queue this batch job as a
     * result from a CloudWatch event.
     */
    bind(rule, _id) {
        var _a;
        const batchParameters = {
            jobDefinition: this.jobDefinition.jobDefinitionArn,
            jobName: (_a = this.props.jobName) !== null && _a !== void 0 ? _a : rule.node.uniqueId,
            arrayProperties: this.props.size ? { size: this.props.size } : undefined,
            retryStrategy: this.props.attempts ? { attempts: this.props.attempts } : undefined,
        };
        return {
            id: '',
            arn: this.jobQueue.jobQueueArn,
            // When scoping resource-level access for job submission, you must provide both job queue and job definition resource types.
            // https://docs.aws.amazon.com/batch/latest/userguide/ExamplePolicies_BATCH.html#iam-example-restrict-job-def
            role: util_1.singletonEventRole(this.jobDefinition, [
                new iam.PolicyStatement({
                    actions: ['batch:SubmitJob'],
                    resources: [
                        this.jobDefinition.jobDefinitionArn,
                        this.jobQueue.jobQueueArn,
                    ],
                }),
            ]),
            input: this.props.event,
            targetResource: this.jobQueue,
            batchParameters,
        };
    }
}
exports.BatchJob = BatchJob;
//# sourceMappingURL=data:application/json;base64,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