import * as batch from '@aws-cdk/aws-batch';
import * as events from '@aws-cdk/aws-events';
/**
 * Customize the Batch Job Event Target
 * @experimental
 */
export interface BatchJobProps {
    /**
     * The event to send to the Lambda
     *
     * This will be the payload sent to the Lambda Function.
     *
     * @default the entire CloudWatch event
     */
    readonly event?: events.RuleTargetInput;
    /**
     * The size of the array, if this is an array batch job.
     *
     * Valid values are integers between 2 and 10,000.
     *
     * @default no arrayProperties are set
     */
    readonly size?: number;
    /**
     * The number of times to attempt to retry, if the job fails. Valid values are 1–10.
     *
     * @default no retryStrategy is set
     */
    readonly attempts?: number;
    /**
     * The name of the submitted job
     *
     * @default - Automatically generated
     */
    readonly jobName?: string;
}
/**
 * Use an AWS Batch Job / Queue as an event rule target.
 * @experimental
 */
export declare class BatchJob implements events.IRuleTarget {
    private readonly jobQueue;
    private readonly jobDefinition;
    private readonly props;
    constructor(jobQueue: batch.IJobQueue, jobDefinition: batch.IJobDefinition, props?: BatchJobProps);
    /**
     * Returns a RuleTarget that can be used to trigger queue this batch job as a
     * result from a CloudWatch event.
     */
    bind(rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
