"""empty message

Revision ID: 9d566d915a2c
Revises: 
Create Date: 2022-09-04 19:01:51.002043

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '9d566d915a2c'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('doi_identifiers',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('identifier', sa.String(), nullable=False),
    sa.Column('db_name', sa.String(), nullable=False),
    sa.Column('db_version', sa.String(), nullable=True),
    sa.Column('url', sa.String(), nullable=True),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_doi_identifiers_id'), 'doi_identifiers', ['id'], unique=False)
    op.create_table('ensembl_identifiers',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('identifier', sa.String(), nullable=False),
    sa.Column('db_name', sa.String(), nullable=False),
    sa.Column('db_version', sa.String(), nullable=True),
    sa.Column('url', sa.String(), nullable=True),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_ensembl_identifiers_id'), 'ensembl_identifiers', ['id'], unique=False)
    op.create_table('genome_identifiers',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('identifier', sa.String(), nullable=False),
    sa.Column('db_name', sa.String(), nullable=False),
    sa.Column('db_version', sa.String(), nullable=True),
    sa.Column('url', sa.String(), nullable=True),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_genome_identifiers_id'), 'genome_identifiers', ['id'], unique=False)
    op.create_table('keywords',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('text', sa.String(), nullable=False),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('text')
    )
    op.create_index(op.f('ix_keywords_id'), 'keywords', ['id'], unique=False)
    op.create_table('pubmed_identifiers',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('identifier', sa.String(), nullable=False),
    sa.Column('db_name', sa.String(), nullable=False),
    sa.Column('db_version', sa.String(), nullable=True),
    sa.Column('url', sa.String(), nullable=True),
    sa.Column('reference_html', sa.String(), nullable=True),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_pubmed_identifiers_id'), 'pubmed_identifiers', ['id'], unique=False)
    op.create_table('refseq_identifiers',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('identifier', sa.String(), nullable=False),
    sa.Column('db_name', sa.String(), nullable=False),
    sa.Column('db_version', sa.String(), nullable=True),
    sa.Column('url', sa.String(), nullable=True),
    sa.Column('reference_html', sa.String(), nullable=True),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_refseq_identifiers_id'), 'refseq_identifiers', ['id'], unique=False)
    op.create_table('roles',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_roles_name'), 'roles', ['name'], unique=False)
    op.create_table('sra_identifiers',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('identifier', sa.String(), nullable=False),
    sa.Column('db_name', sa.String(), nullable=False),
    sa.Column('db_version', sa.String(), nullable=True),
    sa.Column('url', sa.String(), nullable=True),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_sra_identifiers_id'), 'sra_identifiers', ['id'], unique=False)
    op.create_table('uniprot_identifiers',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('identifier', sa.String(), nullable=False),
    sa.Column('db_name', sa.String(), nullable=False),
    sa.Column('db_version', sa.String(), nullable=True),
    sa.Column('url', sa.String(), nullable=True),
    sa.Column('reference_html', sa.String(), nullable=True),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_uniprot_identifiers_id'), 'uniprot_identifiers', ['id'], unique=False)
    op.create_table('users',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('username', sa.String(), nullable=False),
    sa.Column('first_name', sa.String(), nullable=True),
    sa.Column('last_name', sa.String(), nullable=True),
    sa.Column('is_superuser', sa.Boolean(), nullable=False),
    sa.Column('is_staff', sa.Boolean(), nullable=False),
    sa.Column('is_active', sa.Boolean(), nullable=False),
    sa.Column('date_joined', sa.DateTime(), nullable=True),
    sa.Column('email', sa.String(), nullable=True),
    sa.Column('last_login', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_users_username'), 'users', ['username'], unique=False)
    op.create_table('wild_type_sequences',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('sequence_type', sa.String(), nullable=False),
    sa.Column('sequence', sa.String(), nullable=False),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_wild_type_sequences_id'), 'wild_type_sequences', ['id'], unique=False)
    op.create_table('access_keys',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('key_id', sa.String(), nullable=False),
    sa.Column('public_key', sa.String(), nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('expiration_date', sa.Date(), nullable=True),
    sa.Column('creation_time', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_access_keys_key_id'), 'access_keys', ['key_id'], unique=True)
    op.create_table('experiment_sets',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('urn', sa.String(length=64), nullable=True),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('method_text', sa.String(), nullable=False),
    sa.Column('abstract_text', sa.String(), nullable=False),
    sa.Column('short_description', sa.String(), nullable=False),
    sa.Column('extra_metadata', postgresql.JSONB(astext_type=sa.Text()), nullable=False),
    sa.Column('private', sa.Boolean(), nullable=False),
    sa.Column('approved', sa.Boolean(), nullable=False),
    sa.Column('published_date', sa.Date(), nullable=True),
    sa.Column('processing_state', sa.String(), nullable=True),
    sa.Column('num_experiments', sa.Integer(), nullable=False),
    sa.Column('created_by_id', sa.Integer(), nullable=True),
    sa.Column('modified_by_id', sa.Integer(), nullable=True),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ),
    sa.ForeignKeyConstraint(['modified_by_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_experiment_sets_id'), 'experiment_sets', ['id'], unique=False)
    op.create_table('reference_genomes',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('short_name', sa.String(), nullable=False),
    sa.Column('organism_name', sa.String(), nullable=False),
    sa.Column('genome_identifier_id', sa.Integer(), nullable=True),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.ForeignKeyConstraint(['genome_identifier_id'], ['genome_identifiers.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_reference_genomes_id'), 'reference_genomes', ['id'], unique=False)
    op.create_table('users_roles',
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('role_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['role_id'], ['roles.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('user_id', 'role_id')
    )
    op.create_table('experiment_set_doi_identifiers',
    sa.Column('experiment_set_id', sa.Integer(), nullable=False),
    sa.Column('doi_identifier_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['doi_identifier_id'], ['doi_identifiers.id'], ),
    sa.ForeignKeyConstraint(['experiment_set_id'], ['experiment_sets.id'], ),
    sa.PrimaryKeyConstraint('experiment_set_id', 'doi_identifier_id')
    )
    op.create_table('experiment_set_keywords',
    sa.Column('experiment_set_id', sa.Integer(), nullable=False),
    sa.Column('keyword_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['experiment_set_id'], ['experiment_sets.id'], ),
    sa.ForeignKeyConstraint(['keyword_id'], ['keywords.id'], ),
    sa.PrimaryKeyConstraint('experiment_set_id', 'keyword_id')
    )
    op.create_table('experiment_set_pubmed_identifiers',
    sa.Column('experiment_set_id', sa.Integer(), nullable=False),
    sa.Column('pubmed_identifier_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['experiment_set_id'], ['experiment_sets.id'], ),
    sa.ForeignKeyConstraint(['pubmed_identifier_id'], ['pubmed_identifiers.id'], ),
    sa.PrimaryKeyConstraint('experiment_set_id', 'pubmed_identifier_id')
    )
    op.create_table('experiment_set_sra_identifiers',
    sa.Column('experiment_set_id', sa.Integer(), nullable=False),
    sa.Column('sra_identifier_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['experiment_set_id'], ['experiment_sets.id'], ),
    sa.ForeignKeyConstraint(['sra_identifier_id'], ['sra_identifiers.id'], ),
    sa.PrimaryKeyConstraint('experiment_set_id', 'sra_identifier_id')
    )
    op.create_table('experiments',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('urn', sa.String(length=64), nullable=True),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('short_description', sa.String(), nullable=False),
    sa.Column('abstract_text', sa.String(), nullable=False),
    sa.Column('method_text', sa.String(), nullable=False),
    sa.Column('extra_metadata', postgresql.JSONB(astext_type=sa.Text()), nullable=False),
    sa.Column('private', sa.Boolean(), nullable=False),
    sa.Column('approved', sa.Boolean(), nullable=False),
    sa.Column('published_date', sa.Date(), nullable=True),
    sa.Column('processing_state', sa.String(), nullable=True),
    sa.Column('num_scoresets', sa.Integer(), nullable=False),
    sa.Column('experiment_set_id', sa.Integer(), nullable=True),
    sa.Column('created_by_id', sa.Integer(), nullable=True),
    sa.Column('modified_by_id', sa.Integer(), nullable=True),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ),
    sa.ForeignKeyConstraint(['experiment_set_id'], ['experiment_sets.id'], ),
    sa.ForeignKeyConstraint(['modified_by_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_experiments_id'), 'experiments', ['id'], unique=False)
    op.create_table('experiment_doi_identifiers',
    sa.Column('experiment_id', sa.Integer(), nullable=False),
    sa.Column('doi_identifier_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['doi_identifier_id'], ['doi_identifiers.id'], ),
    sa.ForeignKeyConstraint(['experiment_id'], ['experiments.id'], ),
    sa.PrimaryKeyConstraint('experiment_id', 'doi_identifier_id')
    )
    op.create_table('experiment_keywords',
    sa.Column('experiment_id', sa.Integer(), nullable=False),
    sa.Column('keyword_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['experiment_id'], ['experiments.id'], ),
    sa.ForeignKeyConstraint(['keyword_id'], ['keywords.id'], ),
    sa.PrimaryKeyConstraint('experiment_id', 'keyword_id')
    )
    op.create_table('experiment_pubmed_identifiers',
    sa.Column('experiment_id', sa.Integer(), nullable=False),
    sa.Column('pubmed_identifier_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['experiment_id'], ['experiments.id'], ),
    sa.ForeignKeyConstraint(['pubmed_identifier_id'], ['pubmed_identifiers.id'], ),
    sa.PrimaryKeyConstraint('experiment_id', 'pubmed_identifier_id')
    )
    op.create_table('experiment_sra_identifiers',
    sa.Column('experiment_id', sa.Integer(), nullable=False),
    sa.Column('sra_identifier_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['experiment_id'], ['experiments.id'], ),
    sa.ForeignKeyConstraint(['sra_identifier_id'], ['sra_identifiers.id'], ),
    sa.PrimaryKeyConstraint('experiment_id', 'sra_identifier_id')
    )
    op.create_table('scoresets',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('urn', sa.String(length=64), nullable=True),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('method_text', sa.String(), nullable=False),
    sa.Column('abstract_text', sa.String(), nullable=False),
    sa.Column('short_description', sa.String(), nullable=False),
    sa.Column('extra_metadata', postgresql.JSONB(astext_type=sa.Text()), nullable=False),
    sa.Column('dataset_columns', postgresql.JSONB(astext_type=sa.Text()), nullable=False),
    sa.Column('normalised', sa.Boolean(), nullable=False),
    sa.Column('private', sa.Boolean(), nullable=False),
    sa.Column('approved', sa.Boolean(), nullable=False),
    sa.Column('published_date', sa.Date(), nullable=True),
    sa.Column('processing_state', sa.Enum('incomplete', 'processing', 'failed', 'success', name='processingstate', native_enum=False, create_constraint=True, length=32), nullable=True),
    sa.Column('data_usage_policy', sa.String(), nullable=True),
    sa.Column('num_variants', sa.Integer(), nullable=False),
    sa.Column('experiment_id', sa.Integer(), nullable=False),
    sa.Column('licence_id', sa.Integer(), nullable=True),
    sa.Column('replaces_id', sa.Integer(), nullable=True),
    sa.Column('created_by_id', sa.Integer(), nullable=True),
    sa.Column('modified_by_id', sa.Integer(), nullable=True),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ),
    sa.ForeignKeyConstraint(['experiment_id'], ['experiments.id'], ),
    sa.ForeignKeyConstraint(['modified_by_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_scoresets_id'), 'scoresets', ['id'], unique=False)
    op.create_table('scoreset_doi_identifiers',
    sa.Column('scoreset_id', sa.Integer(), nullable=False),
    sa.Column('doi_identifier_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['doi_identifier_id'], ['doi_identifiers.id'], ),
    sa.ForeignKeyConstraint(['scoreset_id'], ['scoresets.id'], ),
    sa.PrimaryKeyConstraint('scoreset_id', 'doi_identifier_id')
    )
    op.create_table('scoreset_keywords',
    sa.Column('scoreset_id', sa.Integer(), nullable=False),
    sa.Column('keyword_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['keyword_id'], ['keywords.id'], ),
    sa.ForeignKeyConstraint(['scoreset_id'], ['scoresets.id'], ),
    sa.PrimaryKeyConstraint('scoreset_id', 'keyword_id')
    )
    op.create_table('scoreset_meta_analysis_sources',
    sa.Column('source_scoreset_id', sa.Integer(), nullable=False),
    sa.Column('meta_analysis_scoreset_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['meta_analysis_scoreset_id'], ['scoresets.id'], ),
    sa.ForeignKeyConstraint(['source_scoreset_id'], ['scoresets.id'], ),
    sa.PrimaryKeyConstraint('source_scoreset_id', 'meta_analysis_scoreset_id')
    )
    op.create_table('scoreset_pubmed_identifiers',
    sa.Column('scoreset_id', sa.Integer(), nullable=False),
    sa.Column('pubmed_identifier_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['pubmed_identifier_id'], ['pubmed_identifiers.id'], ),
    sa.ForeignKeyConstraint(['scoreset_id'], ['scoresets.id'], ),
    sa.PrimaryKeyConstraint('scoreset_id', 'pubmed_identifier_id')
    )
    op.create_table('scoreset_sra_identifiers',
    sa.Column('scoreset_id', sa.Integer(), nullable=False),
    sa.Column('sra_identifier_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['scoreset_id'], ['scoresets.id'], ),
    sa.ForeignKeyConstraint(['sra_identifier_id'], ['sra_identifiers.id'], ),
    sa.PrimaryKeyConstraint('scoreset_id', 'sra_identifier_id')
    )
    op.create_table('target_genes',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('category', sa.String(), nullable=False),
    sa.Column('scoreset_id', sa.Integer(), nullable=False),
    sa.Column('wt_sequence_id', sa.Integer(), nullable=False),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.ForeignKeyConstraint(['scoreset_id'], ['scoresets.id'], ),
    sa.ForeignKeyConstraint(['wt_sequence_id'], ['wild_type_sequences.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_target_genes_id'), 'target_genes', ['id'], unique=False)
    op.create_table('variants',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('urn', sa.String(length=64), nullable=True),
    sa.Column('data', postgresql.JSONB(astext_type=sa.Text()), nullable=False),
    sa.Column('scoreset_id', sa.Integer(), nullable=False),
    sa.Column('hgvs_nt', sa.String(), nullable=True),
    sa.Column('hgvs_pro', sa.String(), nullable=True),
    sa.Column('hgvs_splice', sa.String(), nullable=True),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.ForeignKeyConstraint(['scoreset_id'], ['scoresets.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_variants_id'), 'variants', ['id'], unique=False)
    op.create_table('ensembl_offsets',
    sa.Column('identifier_id', sa.Integer(), nullable=False),
    sa.Column('target_gene_id', sa.Integer(), nullable=False),
    sa.Column('offset', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['identifier_id'], ['ensembl_identifiers.id'], ),
    sa.ForeignKeyConstraint(['target_gene_id'], ['target_genes.id'], ),
    sa.PrimaryKeyConstraint('identifier_id', 'target_gene_id')
    )
    op.create_table('reference_maps',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('is_primary', sa.Boolean(), nullable=False),
    sa.Column('genome_id', sa.Integer(), nullable=False),
    sa.Column('target_id', sa.Integer(), nullable=False),
    sa.Column('creation_date', sa.Date(), nullable=False),
    sa.Column('modification_date', sa.Date(), nullable=False),
    sa.ForeignKeyConstraint(['genome_id'], ['reference_genomes.id'], ),
    sa.ForeignKeyConstraint(['target_id'], ['target_genes.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_reference_maps_id'), 'reference_maps', ['id'], unique=False)
    op.create_table('refseq_offsets',
    sa.Column('identifier_id', sa.Integer(), nullable=False),
    sa.Column('target_gene_id', sa.Integer(), nullable=False),
    sa.Column('offset', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['identifier_id'], ['refseq_identifiers.id'], ),
    sa.ForeignKeyConstraint(['target_gene_id'], ['target_genes.id'], ),
    sa.PrimaryKeyConstraint('identifier_id', 'target_gene_id')
    )
    op.create_table('uniprot_offsets',
    sa.Column('identifier_id', sa.Integer(), nullable=False),
    sa.Column('target_gene_id', sa.Integer(), nullable=False),
    sa.Column('offset', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['identifier_id'], ['uniprot_identifiers.id'], ),
    sa.ForeignKeyConstraint(['target_gene_id'], ['target_genes.id'], ),
    sa.PrimaryKeyConstraint('identifier_id', 'target_gene_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('uniprot_offsets')
    op.drop_table('refseq_offsets')
    op.drop_index(op.f('ix_reference_maps_id'), table_name='reference_maps')
    op.drop_table('reference_maps')
    op.drop_table('ensembl_offsets')
    op.drop_index(op.f('ix_variants_id'), table_name='variants')
    op.drop_table('variants')
    op.drop_index(op.f('ix_target_genes_id'), table_name='target_genes')
    op.drop_table('target_genes')
    op.drop_table('scoreset_sra_identifiers')
    op.drop_table('scoreset_pubmed_identifiers')
    op.drop_table('scoreset_meta_analysis_sources')
    op.drop_table('scoreset_keywords')
    op.drop_table('scoreset_doi_identifiers')
    op.drop_index(op.f('ix_scoresets_id'), table_name='scoresets')
    op.drop_table('scoresets')
    op.drop_table('experiment_sra_identifiers')
    op.drop_table('experiment_pubmed_identifiers')
    op.drop_table('experiment_keywords')
    op.drop_table('experiment_doi_identifiers')
    op.drop_index(op.f('ix_experiments_id'), table_name='experiments')
    op.drop_table('experiments')
    op.drop_table('experiment_set_sra_identifiers')
    op.drop_table('experiment_set_pubmed_identifiers')
    op.drop_table('experiment_set_keywords')
    op.drop_table('experiment_set_doi_identifiers')
    op.drop_table('users_roles')
    op.drop_index(op.f('ix_reference_genomes_id'), table_name='reference_genomes')
    op.drop_table('reference_genomes')
    op.drop_index(op.f('ix_experiment_sets_id'), table_name='experiment_sets')
    op.drop_table('experiment_sets')
    op.drop_index(op.f('ix_access_keys_key_id'), table_name='access_keys')
    op.drop_table('access_keys')
    op.drop_index(op.f('ix_wild_type_sequences_id'), table_name='wild_type_sequences')
    op.drop_table('wild_type_sequences')
    op.drop_index(op.f('ix_users_username'), table_name='users')
    op.drop_table('users')
    op.drop_index(op.f('ix_uniprot_identifiers_id'), table_name='uniprot_identifiers')
    op.drop_table('uniprot_identifiers')
    op.drop_index(op.f('ix_sra_identifiers_id'), table_name='sra_identifiers')
    op.drop_table('sra_identifiers')
    op.drop_index(op.f('ix_roles_name'), table_name='roles')
    op.drop_table('roles')
    op.drop_index(op.f('ix_refseq_identifiers_id'), table_name='refseq_identifiers')
    op.drop_table('refseq_identifiers')
    op.drop_index(op.f('ix_pubmed_identifiers_id'), table_name='pubmed_identifiers')
    op.drop_table('pubmed_identifiers')
    op.drop_index(op.f('ix_keywords_id'), table_name='keywords')
    op.drop_table('keywords')
    op.drop_index(op.f('ix_genome_identifiers_id'), table_name='genome_identifiers')
    op.drop_table('genome_identifiers')
    op.drop_index(op.f('ix_ensembl_identifiers_id'), table_name='ensembl_identifiers')
    op.drop_table('ensembl_identifiers')
    op.drop_index(op.f('ix_doi_identifiers_id'), table_name='doi_identifiers')
    op.drop_table('doi_identifiers')
    # ### end Alembic commands ###
