# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class AdditionalCapabilities(msrest.serialization.Model):
    """Enables or disables a capability on the virtual machine or virtual machine scale set.

    :param ultra_ssd_enabled: The flag that enables or disables a capability to have one or more
     managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with
     storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale
     set only if this property is enabled.
    :type ultra_ssd_enabled: bool
    """

    _attribute_map = {
        'ultra_ssd_enabled': {'key': 'ultraSSDEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AdditionalCapabilities, self).__init__(**kwargs)
        self.ultra_ssd_enabled = kwargs.get('ultra_ssd_enabled', None)


class AdditionalUnattendContent(msrest.serialization.Model):
    """Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
     value: "OobeSystem".
    :vartype pass_name: str
    :ivar component_name: The component name. Currently, the only allowable value is Microsoft-
     Windows-Shell-Setup. Default value: "Microsoft-Windows-Shell-Setup".
    :vartype component_name: str
    :param setting_name: Specifies the name of the setting to which the content applies. Possible
     values are: FirstLogonCommands and AutoLogon. Possible values include: "AutoLogon",
     "FirstLogonCommands".
    :type setting_name: str or ~azure.mgmt.compute.v2020_06_01.models.SettingNames
    :param content: Specifies the XML formatted content that is added to the unattend.xml file for
     the specified path and component. The XML must be less than 4KB and must include the root
     element for the setting or feature that is being inserted.
    :type content: str
    """

    _validation = {
        'pass_name': {'constant': True},
        'component_name': {'constant': True},
    }

    _attribute_map = {
        'pass_name': {'key': 'passName', 'type': 'str'},
        'component_name': {'key': 'componentName', 'type': 'str'},
        'setting_name': {'key': 'settingName', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
    }

    pass_name = "OobeSystem"
    component_name = "Microsoft-Windows-Shell-Setup"

    def __init__(
        self,
        **kwargs
    ):
        super(AdditionalUnattendContent, self).__init__(**kwargs)
        self.setting_name = kwargs.get('setting_name', None)
        self.content = kwargs.get('content', None)


class ApiEntityReference(msrest.serialization.Model):
    """The API entity reference.

    :param id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiEntityReference, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ApiError(msrest.serialization.Model):
    """Api error.

    :param details: The Api error details.
    :type details: list[~azure.mgmt.compute.v2020_06_01.models.ApiErrorBase]
    :param innererror: The Api inner error.
    :type innererror: ~azure.mgmt.compute.v2020_06_01.models.InnerError
    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'details': {'key': 'details', 'type': '[ApiErrorBase]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiError, self).__init__(**kwargs)
        self.details = kwargs.get('details', None)
        self.innererror = kwargs.get('innererror', None)
        self.code = kwargs.get('code', None)
        self.target = kwargs.get('target', None)
        self.message = kwargs.get('message', None)


class ApiErrorBase(msrest.serialization.Model):
    """Api error base.

    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiErrorBase, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.target = kwargs.get('target', None)
        self.message = kwargs.get('message', None)


class AutomaticOSUpgradePolicy(msrest.serialization.Model):
    """The configuration parameters used for performing automatic OS upgrade.

    :param enable_automatic_os_upgrade: Indicates whether OS upgrades should automatically be
     applied to scale set instances in a rolling fashion when a newer version of the OS image
     becomes available. Default value is false. :code:`<br>`:code:`<br>` If this is set to true for
     Windows based scale sets, `enableAutomaticUpdates
     <https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-
     dotnet>`_ is automatically set to false and cannot be set to true.
    :type enable_automatic_os_upgrade: bool
    :param disable_automatic_rollback: Whether OS image rollback feature should be disabled.
     Default value is false.
    :type disable_automatic_rollback: bool
    """

    _attribute_map = {
        'enable_automatic_os_upgrade': {'key': 'enableAutomaticOSUpgrade', 'type': 'bool'},
        'disable_automatic_rollback': {'key': 'disableAutomaticRollback', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutomaticOSUpgradePolicy, self).__init__(**kwargs)
        self.enable_automatic_os_upgrade = kwargs.get('enable_automatic_os_upgrade', None)
        self.disable_automatic_rollback = kwargs.get('disable_automatic_rollback', None)


class AutomaticOSUpgradeProperties(msrest.serialization.Model):
    """Describes automatic OS upgrade properties on the image.

    All required parameters must be populated in order to send to Azure.

    :param automatic_os_upgrade_supported: Required. Specifies whether automatic OS upgrade is
     supported on the image.
    :type automatic_os_upgrade_supported: bool
    """

    _validation = {
        'automatic_os_upgrade_supported': {'required': True},
    }

    _attribute_map = {
        'automatic_os_upgrade_supported': {'key': 'automaticOSUpgradeSupported', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutomaticOSUpgradeProperties, self).__init__(**kwargs)
        self.automatic_os_upgrade_supported = kwargs['automatic_os_upgrade_supported']


class AutomaticRepairsPolicy(msrest.serialization.Model):
    """Specifies the configuration parameters for automatic repairs on the virtual machine scale set.

    :param enabled: Specifies whether automatic repairs should be enabled on the virtual machine
     scale set. The default value is false.
    :type enabled: bool
    :param grace_period: The amount of time for which automatic repairs are suspended due to a
     state change on VM. The grace time starts after the state change has completed. This helps
     avoid premature or accidental repairs. The time duration should be specified in ISO 8601
     format. The minimum allowed grace period is 30 minutes (PT30M), which is also the default
     value. The maximum allowed grace period is 90 minutes (PT90M).
    :type grace_period: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'grace_period': {'key': 'gracePeriod', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutomaticRepairsPolicy, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.grace_period = kwargs.get('grace_period', None)


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class AvailabilitySet(Resource):
    """Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see `Manage the availability of virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_. :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned maintenance for virtual machines in Azure <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_ :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Sku of the availability set, only name is required to be set. See
     AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with
     managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is
     'Classic'.
    :type sku: ~azure.mgmt.compute.v2020_06_01.models.Sku
    :param platform_update_domain_count: Update Domain count.
    :type platform_update_domain_count: int
    :param platform_fault_domain_count: Fault Domain count.
    :type platform_fault_domain_count: int
    :param virtual_machines: A list of references to all virtual machines in the availability set.
    :type virtual_machines: list[~azure.mgmt.compute.v2020_06_01.models.SubResource]
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'statuses': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'platform_update_domain_count': {'key': 'properties.platformUpdateDomainCount', 'type': 'int'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResource]'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'statuses': {'key': 'properties.statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailabilitySet, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.platform_update_domain_count = kwargs.get('platform_update_domain_count', None)
        self.platform_fault_domain_count = kwargs.get('platform_fault_domain_count', None)
        self.virtual_machines = kwargs.get('virtual_machines', None)
        self.proximity_placement_group = kwargs.get('proximity_placement_group', None)
        self.statuses = None


class AvailabilitySetListResult(msrest.serialization.Model):
    """The List Availability Set operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of availability sets.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.AvailabilitySet]
    :param next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with this
     URI to fetch the next page of AvailabilitySets.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailabilitySet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailabilitySetListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class UpdateResource(msrest.serialization.Model):
    """The Update Resource model definition.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class AvailabilitySetUpdate(UpdateResource):
    """Specifies information about the availability set that the virtual machine should be assigned to. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Sku of the availability set.
    :type sku: ~azure.mgmt.compute.v2020_06_01.models.Sku
    :param platform_update_domain_count: Update Domain count.
    :type platform_update_domain_count: int
    :param platform_fault_domain_count: Fault Domain count.
    :type platform_fault_domain_count: int
    :param virtual_machines: A list of references to all virtual machines in the availability set.
    :type virtual_machines: list[~azure.mgmt.compute.v2020_06_01.models.SubResource]
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    """

    _validation = {
        'statuses': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'platform_update_domain_count': {'key': 'properties.platformUpdateDomainCount', 'type': 'int'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResource]'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'statuses': {'key': 'properties.statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailabilitySetUpdate, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.platform_update_domain_count = kwargs.get('platform_update_domain_count', None)
        self.platform_fault_domain_count = kwargs.get('platform_fault_domain_count', None)
        self.virtual_machines = kwargs.get('virtual_machines', None)
        self.proximity_placement_group = kwargs.get('proximity_placement_group', None)
        self.statuses = None


class AvailablePatchSummary(msrest.serialization.Model):
    """Describes the properties of an virtual machine instance view for available patch summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Failed", "Succeeded", or
     "CompletedWithWarnings.". Possible values include: "InProgress", "Failed", "Succeeded",
     "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.v2020_06_01.models.PatchOperationStatus
    :ivar assessment_activity_id: The activity ID of the operation that produced this result. It is
     used to correlate across CRP and extension logs.
    :vartype assessment_activity_id: str
    :ivar reboot_pending: The overall reboot status of the VM. It will be true when partially
     installed patches require a reboot to complete installation but the reboot has not yet
     occurred.
    :vartype reboot_pending: bool
    :ivar critical_and_security_patch_count: The number of critical or security patches that have
     been detected as available and not yet installed.
    :vartype critical_and_security_patch_count: int
    :ivar other_patch_count: The number of all available patches excluding critical and security.
    :vartype other_patch_count: int
    :ivar start_time: The UTC timestamp when the operation began.
    :vartype start_time: ~datetime.datetime
    :ivar last_modified_time: The UTC timestamp when the operation began.
    :vartype last_modified_time: ~datetime.datetime
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.v2020_06_01.models.ApiError
    """

    _validation = {
        'status': {'readonly': True},
        'assessment_activity_id': {'readonly': True},
        'reboot_pending': {'readonly': True},
        'critical_and_security_patch_count': {'readonly': True},
        'other_patch_count': {'readonly': True},
        'start_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'assessment_activity_id': {'key': 'assessmentActivityId', 'type': 'str'},
        'reboot_pending': {'key': 'rebootPending', 'type': 'bool'},
        'critical_and_security_patch_count': {'key': 'criticalAndSecurityPatchCount', 'type': 'int'},
        'other_patch_count': {'key': 'otherPatchCount', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'ApiError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailablePatchSummary, self).__init__(**kwargs)
        self.status = None
        self.assessment_activity_id = None
        self.reboot_pending = None
        self.critical_and_security_patch_count = None
        self.other_patch_count = None
        self.start_time = None
        self.last_modified_time = None
        self.error = None


class BillingProfile(msrest.serialization.Model):
    """Specifies the billing related details of a Azure Spot VM or VMSS. :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.

    :param max_price: Specifies the maximum price you are willing to pay for a Azure Spot VM/VMSS.
     This price is in US Dollars. :code:`<br>`:code:`<br>` This price will be compared with the
     current Azure Spot price for the VM size. Also, the prices are compared at the time of
     create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is
     greater than the current Azure Spot price. :code:`<br>`:code:`<br>` The maxPrice will also be
     used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the maxPrice
     after creation of VM/VMSS. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` - Any decimal value greater than zero. Example: 0.01538
     :code:`<br>`:code:`<br>` -1 – indicates default price to be up-to on-demand.
     :code:`<br>`:code:`<br>` You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS
     should not be evicted for price reasons. Also, the default max price is -1 if it is not
     provided by you. :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :type max_price: float
    """

    _attribute_map = {
        'max_price': {'key': 'maxPrice', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingProfile, self).__init__(**kwargs)
        self.max_price = kwargs.get('max_price', None)


class BootDiagnostics(msrest.serialization.Model):
    """Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a screenshot of the VM from the hypervisor.

    :param enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
    :type enabled: bool
    :param storage_uri: Uri of the storage account to use for placing the console output and
     screenshot. :code:`<br>`:code:`<br>`If storageUri is not specified while enabling boot
     diagnostics, managed storage will be used.
    :type storage_uri: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BootDiagnostics, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.storage_uri = kwargs.get('storage_uri', None)


class BootDiagnosticsInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine boot diagnostics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
     :code:`<br>`:code:`<br>`NOTE: This will **not** be set if boot diagnostics is currently enabled
     with managed storage.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The serial console log blob Uri.
     :code:`<br>`:code:`<br>`NOTE: This will **not** be set if boot diagnostics is currently enabled
     with managed storage.
    :vartype serial_console_log_blob_uri: str
    :ivar status: The boot diagnostics status information for the VM. :code:`<br>`:code:`<br>`
     NOTE: It will be set only if there are errors encountered in enabling boot diagnostics.
    :vartype status: ~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus
    """

    _validation = {
        'console_screenshot_blob_uri': {'readonly': True},
        'serial_console_log_blob_uri': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'console_screenshot_blob_uri': {'key': 'consoleScreenshotBlobUri', 'type': 'str'},
        'serial_console_log_blob_uri': {'key': 'serialConsoleLogBlobUri', 'type': 'str'},
        'status': {'key': 'status', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BootDiagnosticsInstanceView, self).__init__(**kwargs)
        self.console_screenshot_blob_uri = None
        self.serial_console_log_blob_uri = None
        self.status = None


class ComputeOperationListResult(msrest.serialization.Model):
    """The List Compute Operation operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of compute operations.
    :vartype value: list[~azure.mgmt.compute.v2020_06_01.models.ComputeOperationValue]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ComputeOperationValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeOperationListResult, self).__init__(**kwargs)
        self.value = None


class ComputeOperationValue(msrest.serialization.Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        'origin': {'readonly': True},
        'name': {'readonly': True},
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'operation': {'key': 'display.operation', 'type': 'str'},
        'resource': {'key': 'display.resource', 'type': 'str'},
        'description': {'key': 'display.description', 'type': 'str'},
        'provider': {'key': 'display.provider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeOperationValue, self).__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class DataDisk(msrest.serialization.Model):
    """Describes a data disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param lun: Required. Specifies the logical unit number of the data disk. This value is used to
     identify data disks within the VM and therefore must be unique for each data disk attached to a
     VM.
    :type lun: int
    :param name: The disk name.
    :type name: str
    :param vhd: The virtual hard disk.
    :type vhd: ~azure.mgmt.compute.v2020_06_01.models.VirtualHardDisk
    :param image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :type image: ~azure.mgmt.compute.v2020_06_01.models.VirtualHardDisk
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2020_06_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param create_option: Required. Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
     This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Possible values include: "FromImage", "Empty", "Attach".
    :type create_option: str or ~azure.mgmt.compute.v2020_06_01.models.DiskCreateOptionTypes
    :param disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param managed_disk: The managed disk parameters.
    :type managed_disk: ~azure.mgmt.compute.v2020_06_01.models.ManagedDiskParameters
    :param to_be_detached: Specifies whether the data disk is in process of detachment from the
     VirtualMachine/VirtualMachineScaleset.
    :type to_be_detached: bool
    :ivar disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk when
     StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be
     updated only via updates to the VirtualMachine Scale Set.
    :vartype disk_iops_read_write: long
    :ivar disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk when
     StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be
     updated only via updates to the VirtualMachine Scale Set.
    :vartype disk_m_bps_read_write: long
    """

    _validation = {
        'lun': {'required': True},
        'create_option': {'required': True},
        'disk_iops_read_write': {'readonly': True},
        'disk_m_bps_read_write': {'readonly': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'vhd': {'key': 'vhd', 'type': 'VirtualHardDisk'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'create_option': {'key': 'createOption', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'managed_disk': {'key': 'managedDisk', 'type': 'ManagedDiskParameters'},
        'to_be_detached': {'key': 'toBeDetached', 'type': 'bool'},
        'disk_iops_read_write': {'key': 'diskIOPSReadWrite', 'type': 'long'},
        'disk_m_bps_read_write': {'key': 'diskMBpsReadWrite', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataDisk, self).__init__(**kwargs)
        self.lun = kwargs['lun']
        self.name = kwargs.get('name', None)
        self.vhd = kwargs.get('vhd', None)
        self.image = kwargs.get('image', None)
        self.caching = kwargs.get('caching', None)
        self.write_accelerator_enabled = kwargs.get('write_accelerator_enabled', None)
        self.create_option = kwargs['create_option']
        self.disk_size_gb = kwargs.get('disk_size_gb', None)
        self.managed_disk = kwargs.get('managed_disk', None)
        self.to_be_detached = kwargs.get('to_be_detached', None)
        self.disk_iops_read_write = None
        self.disk_m_bps_read_write = None


class DataDiskImage(msrest.serialization.Model):
    """Contains the data disk images information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
    :vartype lun: int
    """

    _validation = {
        'lun': {'readonly': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataDiskImage, self).__init__(**kwargs)
        self.lun = None


class DedicatedHost(Resource):
    """Specifies information about the Dedicated host.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Required. SKU of the dedicated host for Hardware Generation and VM family. Only
     name is required to be set. List Microsoft.Compute SKUs for a list of possible values.
    :type sku: ~azure.mgmt.compute.v2020_06_01.models.Sku
    :param platform_fault_domain: Fault domain of the dedicated host within a dedicated host group.
    :type platform_fault_domain: int
    :param auto_replace_on_failure: Specifies whether the dedicated host should be replaced
     automatically in case of a failure. The value is defaulted to 'true' when not provided.
    :type auto_replace_on_failure: bool
    :ivar host_id: A unique id generated and assigned to the dedicated host by the platform.
     :code:`<br>`:code:`<br>` Does not change throughout the lifetime of the host.
    :vartype host_id: str
    :ivar virtual_machines: A list of references to all virtual machines in the Dedicated Host.
    :vartype virtual_machines: list[~azure.mgmt.compute.v2020_06_01.models.SubResourceReadOnly]
    :param license_type: Specifies the software license type that will be applied to the VMs
     deployed on the dedicated host. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **Windows_Server_Hybrid**
     :code:`<br>`:code:`<br>` **Windows_Server_Perpetual** :code:`<br>`:code:`<br>` Default:
     **None**. Possible values include: "None", "Windows_Server_Hybrid", "Windows_Server_Perpetual".
    :type license_type: str or ~azure.mgmt.compute.v2020_06_01.models.DedicatedHostLicenseTypes
    :ivar provisioning_time: The date when the host was first provisioned.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The dedicated host instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2020_06_01.models.DedicatedHostInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'platform_fault_domain': {'minimum': 0},
        'host_id': {'readonly': True},
        'virtual_machines': {'readonly': True},
        'provisioning_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'platform_fault_domain': {'key': 'properties.platformFaultDomain', 'type': 'int'},
        'auto_replace_on_failure': {'key': 'properties.autoReplaceOnFailure', 'type': 'bool'},
        'host_id': {'key': 'properties.hostId', 'type': 'str'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResourceReadOnly]'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'provisioning_time': {'key': 'properties.provisioningTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'DedicatedHostInstanceView'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedHost, self).__init__(**kwargs)
        self.sku = kwargs['sku']
        self.platform_fault_domain = kwargs.get('platform_fault_domain', None)
        self.auto_replace_on_failure = kwargs.get('auto_replace_on_failure', None)
        self.host_id = None
        self.virtual_machines = None
        self.license_type = kwargs.get('license_type', None)
        self.provisioning_time = None
        self.provisioning_state = None
        self.instance_view = None


class DedicatedHostAllocatableVM(msrest.serialization.Model):
    """Represents the dedicated host unutilized capacity in terms of a specific VM size.

    :param vm_size: VM size in terms of which the unutilized capacity is represented.
    :type vm_size: str
    :param count: Maximum number of VMs of size vmSize that can fit in the dedicated host's
     remaining capacity.
    :type count: float
    """

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'count': {'key': 'count', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedHostAllocatableVM, self).__init__(**kwargs)
        self.vm_size = kwargs.get('vm_size', None)
        self.count = kwargs.get('count', None)


class DedicatedHostAvailableCapacity(msrest.serialization.Model):
    """Dedicated host unutilized capacity.

    :param allocatable_v_ms: The unutilized capacity of the dedicated host represented in terms of
     each VM size that is allowed to be deployed to the dedicated host.
    :type allocatable_v_ms: list[~azure.mgmt.compute.v2020_06_01.models.DedicatedHostAllocatableVM]
    """

    _attribute_map = {
        'allocatable_v_ms': {'key': 'allocatableVMs', 'type': '[DedicatedHostAllocatableVM]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedHostAvailableCapacity, self).__init__(**kwargs)
        self.allocatable_v_ms = kwargs.get('allocatable_v_ms', None)


class DedicatedHostGroup(Resource):
    """Specifies information about the dedicated host group that the dedicated hosts should be assigned to. :code:`<br>`:code:`<br>` Currently, a dedicated host can only be added to a dedicated host group at creation time. An existing dedicated host cannot be added to another dedicated host group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param zones: Availability Zone to use for this host group. Only single zone is supported. The
     zone can be assigned only during creation. If not provided, the group supports all zones in the
     region. If provided, enforces each host in the group to be in the same zone.
    :type zones: list[str]
    :param platform_fault_domain_count: Number of fault domains that the host group can span.
    :type platform_fault_domain_count: int
    :ivar hosts: A list of references to all dedicated hosts in the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.v2020_06_01.models.SubResourceReadOnly]
    :ivar instance_view: The dedicated host group instance view, which has the list of instance
     view of the dedicated hosts under the dedicated host group.
    :vartype instance_view: ~azure.mgmt.compute.v2020_06_01.models.DedicatedHostGroupInstanceView
    :param support_automatic_placement: Specifies whether virtual machines or virtual machine scale
     sets can be placed automatically on the dedicated host group. Automatic placement means
     resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
     group. The value is defaulted to 'false' when not provided. :code:`<br>`:code:`<br>`Minimum
     api-version: 2020-06-01.
    :type support_automatic_placement: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'platform_fault_domain_count': {'minimum': 1},
        'hosts': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'hosts': {'key': 'properties.hosts', 'type': '[SubResourceReadOnly]'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'DedicatedHostGroupInstanceView'},
        'support_automatic_placement': {'key': 'properties.supportAutomaticPlacement', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedHostGroup, self).__init__(**kwargs)
        self.zones = kwargs.get('zones', None)
        self.platform_fault_domain_count = kwargs.get('platform_fault_domain_count', None)
        self.hosts = None
        self.instance_view = None
        self.support_automatic_placement = kwargs.get('support_automatic_placement', None)


class DedicatedHostGroupInstanceView(msrest.serialization.Model):
    """DedicatedHostGroupInstanceView.

    :param hosts: List of instance view of the dedicated hosts under the dedicated host group.
    :type hosts: list[~azure.mgmt.compute.v2020_06_01.models.DedicatedHostInstanceViewWithName]
    """

    _attribute_map = {
        'hosts': {'key': 'hosts', 'type': '[DedicatedHostInstanceViewWithName]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedHostGroupInstanceView, self).__init__(**kwargs)
        self.hosts = kwargs.get('hosts', None)


class DedicatedHostGroupListResult(msrest.serialization.Model):
    """The List Dedicated Host Group with resource group response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of dedicated host groups.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.DedicatedHostGroup]
    :param next_link: The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with
     this URI to fetch the next page of Dedicated Host Groups.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DedicatedHostGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedHostGroupListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class DedicatedHostGroupUpdate(UpdateResource):
    """Specifies information about the dedicated host group that the dedicated host should be assigned to. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param zones: Availability Zone to use for this host group. Only single zone is supported. The
     zone can be assigned only during creation. If not provided, the group supports all zones in the
     region. If provided, enforces each host in the group to be in the same zone.
    :type zones: list[str]
    :param platform_fault_domain_count: Number of fault domains that the host group can span.
    :type platform_fault_domain_count: int
    :ivar hosts: A list of references to all dedicated hosts in the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.v2020_06_01.models.SubResourceReadOnly]
    :ivar instance_view: The dedicated host group instance view, which has the list of instance
     view of the dedicated hosts under the dedicated host group.
    :vartype instance_view: ~azure.mgmt.compute.v2020_06_01.models.DedicatedHostGroupInstanceView
    :param support_automatic_placement: Specifies whether virtual machines or virtual machine scale
     sets can be placed automatically on the dedicated host group. Automatic placement means
     resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
     group. The value is defaulted to 'false' when not provided. :code:`<br>`:code:`<br>`Minimum
     api-version: 2020-06-01.
    :type support_automatic_placement: bool
    """

    _validation = {
        'platform_fault_domain_count': {'minimum': 1},
        'hosts': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'hosts': {'key': 'properties.hosts', 'type': '[SubResourceReadOnly]'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'DedicatedHostGroupInstanceView'},
        'support_automatic_placement': {'key': 'properties.supportAutomaticPlacement', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedHostGroupUpdate, self).__init__(**kwargs)
        self.zones = kwargs.get('zones', None)
        self.platform_fault_domain_count = kwargs.get('platform_fault_domain_count', None)
        self.hosts = None
        self.instance_view = None
        self.support_automatic_placement = kwargs.get('support_automatic_placement', None)


class DedicatedHostInstanceView(msrest.serialization.Model):
    """The instance view of a dedicated host.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asset_id: Specifies the unique id of the dedicated physical machine on which the
     dedicated host resides.
    :vartype asset_id: str
    :param available_capacity: Unutilized capacity of the dedicated host.
    :type available_capacity: ~azure.mgmt.compute.v2020_06_01.models.DedicatedHostAvailableCapacity
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    """

    _validation = {
        'asset_id': {'readonly': True},
    }

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'available_capacity': {'key': 'availableCapacity', 'type': 'DedicatedHostAvailableCapacity'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedHostInstanceView, self).__init__(**kwargs)
        self.asset_id = None
        self.available_capacity = kwargs.get('available_capacity', None)
        self.statuses = kwargs.get('statuses', None)


class DedicatedHostInstanceViewWithName(DedicatedHostInstanceView):
    """The instance view of a dedicated host that includes the name of the dedicated host. It is used for the response to the instance view of a dedicated host group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asset_id: Specifies the unique id of the dedicated physical machine on which the
     dedicated host resides.
    :vartype asset_id: str
    :param available_capacity: Unutilized capacity of the dedicated host.
    :type available_capacity: ~azure.mgmt.compute.v2020_06_01.models.DedicatedHostAvailableCapacity
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    :ivar name: The name of the dedicated host.
    :vartype name: str
    """

    _validation = {
        'asset_id': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'available_capacity': {'key': 'availableCapacity', 'type': 'DedicatedHostAvailableCapacity'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedHostInstanceViewWithName, self).__init__(**kwargs)
        self.name = None


class DedicatedHostListResult(msrest.serialization.Model):
    """The list dedicated host operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of dedicated hosts.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.DedicatedHost]
    :param next_link: The URI to fetch the next page of dedicated hosts. Call ListNext() with this
     URI to fetch the next page of dedicated hosts.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DedicatedHost]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedHostListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class DedicatedHostUpdate(UpdateResource):
    """Specifies information about the dedicated host. Only tags, autoReplaceOnFailure and licenseType may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param platform_fault_domain: Fault domain of the dedicated host within a dedicated host group.
    :type platform_fault_domain: int
    :param auto_replace_on_failure: Specifies whether the dedicated host should be replaced
     automatically in case of a failure. The value is defaulted to 'true' when not provided.
    :type auto_replace_on_failure: bool
    :ivar host_id: A unique id generated and assigned to the dedicated host by the platform.
     :code:`<br>`:code:`<br>` Does not change throughout the lifetime of the host.
    :vartype host_id: str
    :ivar virtual_machines: A list of references to all virtual machines in the Dedicated Host.
    :vartype virtual_machines: list[~azure.mgmt.compute.v2020_06_01.models.SubResourceReadOnly]
    :param license_type: Specifies the software license type that will be applied to the VMs
     deployed on the dedicated host. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **Windows_Server_Hybrid**
     :code:`<br>`:code:`<br>` **Windows_Server_Perpetual** :code:`<br>`:code:`<br>` Default:
     **None**. Possible values include: "None", "Windows_Server_Hybrid", "Windows_Server_Perpetual".
    :type license_type: str or ~azure.mgmt.compute.v2020_06_01.models.DedicatedHostLicenseTypes
    :ivar provisioning_time: The date when the host was first provisioned.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The dedicated host instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2020_06_01.models.DedicatedHostInstanceView
    """

    _validation = {
        'platform_fault_domain': {'minimum': 0},
        'host_id': {'readonly': True},
        'virtual_machines': {'readonly': True},
        'provisioning_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'platform_fault_domain': {'key': 'properties.platformFaultDomain', 'type': 'int'},
        'auto_replace_on_failure': {'key': 'properties.autoReplaceOnFailure', 'type': 'bool'},
        'host_id': {'key': 'properties.hostId', 'type': 'str'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResourceReadOnly]'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'provisioning_time': {'key': 'properties.provisioningTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'DedicatedHostInstanceView'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedHostUpdate, self).__init__(**kwargs)
        self.platform_fault_domain = kwargs.get('platform_fault_domain', None)
        self.auto_replace_on_failure = kwargs.get('auto_replace_on_failure', None)
        self.host_id = None
        self.virtual_machines = None
        self.license_type = kwargs.get('license_type', None)
        self.provisioning_time = None
        self.provisioning_state = None
        self.instance_view = None


class DiagnosticsProfile(msrest.serialization.Model):
    """Specifies the boot diagnostic settings state. :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.

    :param boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :type boot_diagnostics: ~azure.mgmt.compute.v2020_06_01.models.BootDiagnostics
    """

    _attribute_map = {
        'boot_diagnostics': {'key': 'bootDiagnostics', 'type': 'BootDiagnostics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticsProfile, self).__init__(**kwargs)
        self.boot_diagnostics = kwargs.get('boot_diagnostics', None)


class DiffDiskSettings(msrest.serialization.Model):
    """Describes the parameters of ephemeral disk settings that can be specified for operating system disk. :code:`<br>`:code:`<br>` NOTE: The ephemeral disk settings can only be specified for managed disk.

    :param option: Specifies the ephemeral disk settings for operating system disk. Possible values
     include: "Local".
    :type option: str or ~azure.mgmt.compute.v2020_06_01.models.DiffDiskOptions
    :param placement: Specifies the ephemeral disk placement for operating system
     disk.:code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **CacheDisk**
     :code:`<br>`:code:`<br>` **ResourceDisk** :code:`<br>`:code:`<br>` Default: **CacheDisk** if
     one is configured for the VM size otherwise **ResourceDisk** is used.:code:`<br>`:code:`<br>`
     Refer to VM size documentation for Windows VM at https://docs.microsoft.com/en-
     us/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/en-
     us/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk. Possible
     values include: "CacheDisk", "ResourceDisk".
    :type placement: str or ~azure.mgmt.compute.v2020_06_01.models.DiffDiskPlacement
    """

    _attribute_map = {
        'option': {'key': 'option', 'type': 'str'},
        'placement': {'key': 'placement', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiffDiskSettings, self).__init__(**kwargs)
        self.option = kwargs.get('option', None)
        self.placement = kwargs.get('placement', None)


class DisallowedConfiguration(msrest.serialization.Model):
    """Specifies the disallowed configuration for a virtual machine image.

    :param vm_disk_type: VM disk types which are disallowed. Possible values include: "None",
     "Unmanaged".
    :type vm_disk_type: str or ~azure.mgmt.compute.v2020_06_01.models.VmDiskTypes
    """

    _attribute_map = {
        'vm_disk_type': {'key': 'vmDiskType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DisallowedConfiguration, self).__init__(**kwargs)
        self.vm_disk_type = kwargs.get('vm_disk_type', None)


class SubResource(msrest.serialization.Model):
    """SubResource.

    :param id: Resource Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class DiskEncryptionSetParameters(SubResource):
    """Describes the parameter of customer managed disk encryption set resource id that can be specified for disk. :code:`<br>`:code:`<br>` NOTE: The disk encryption set resource id can only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.

    :param id: Resource Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiskEncryptionSetParameters, self).__init__(**kwargs)


class DiskEncryptionSettings(msrest.serialization.Model):
    """Describes a Encryption Settings for a Disk.

    :param disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
     Vault Secret.
    :type disk_encryption_key: ~azure.mgmt.compute.v2020_06_01.models.KeyVaultSecretReference
    :param key_encryption_key: Specifies the location of the key encryption key in Key Vault.
    :type key_encryption_key: ~azure.mgmt.compute.v2020_06_01.models.KeyVaultKeyReference
    :param enabled: Specifies whether disk encryption should be enabled on the virtual machine.
    :type enabled: bool
    """

    _attribute_map = {
        'disk_encryption_key': {'key': 'diskEncryptionKey', 'type': 'KeyVaultSecretReference'},
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyVaultKeyReference'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiskEncryptionSettings, self).__init__(**kwargs)
        self.disk_encryption_key = kwargs.get('disk_encryption_key', None)
        self.key_encryption_key = kwargs.get('key_encryption_key', None)
        self.enabled = kwargs.get('enabled', None)


class DiskInstanceView(msrest.serialization.Model):
    """The instance view of the disk.

    :param name: The disk name.
    :type name: str
    :param encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type encryption_settings: list[~azure.mgmt.compute.v2020_06_01.models.DiskEncryptionSettings]
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'encryption_settings': {'key': 'encryptionSettings', 'type': '[DiskEncryptionSettings]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiskInstanceView, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.encryption_settings = kwargs.get('encryption_settings', None)
        self.statuses = kwargs.get('statuses', None)


class HardwareProfile(msrest.serialization.Model):
    """Specifies the hardware settings for the virtual machine.

    :param vm_size: Specifies the size of the virtual machine. For more information about virtual
     machine sizes, see `Sizes for virtual machines <https://docs.microsoft.com/en-us/azure/virtual-
     machines/sizes>`_. :code:`<br>`:code:`<br>` The available VM sizes depend on region and
     availability set. For a list of available sizes use these APIs:  :code:`<br>`:code:`<br>` `List
     all available virtual machine sizes in an availability set
     <https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes>`_
     :code:`<br>`:code:`<br>` `List all available virtual machine sizes in a region
     <https://docs.microsoft.com/en-us/rest/api/compute/resourceskus/list>`_
     :code:`<br>`:code:`<br>` `List all available virtual machine sizes for resizing
     <https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes>`_.
     :code:`<br>`:code:`<br>` This list of sizes is no longer updated and the
     **VirtualMachineSizeTypes** string constants will be removed from the subsequent REST API
     specification. Use `List all available virtual machine sizes in a region
     <https://docs.microsoft.com/en-us/rest/api/compute/resourceskus/list>`_ to get the latest
     sizes. Possible values include: "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4",
     "Standard_A0", "Standard_A1", "Standard_A2", "Standard_A3", "Standard_A4", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A9", "Standard_A10", "Standard_A11",
     "Standard_A1_v2", "Standard_A2_v2", "Standard_A4_v2", "Standard_A8_v2", "Standard_A2m_v2",
     "Standard_A4m_v2", "Standard_A8m_v2", "Standard_B1s", "Standard_B1ms", "Standard_B2s",
     "Standard_B2ms", "Standard_B4ms", "Standard_B8ms", "Standard_D1", "Standard_D2", "Standard_D3",
     "Standard_D4", "Standard_D11", "Standard_D12", "Standard_D13", "Standard_D14",
     "Standard_D1_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2",
     "Standard_D2_v3", "Standard_D4_v3", "Standard_D8_v3", "Standard_D16_v3", "Standard_D32_v3",
     "Standard_D64_v3", "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3",
     "Standard_D32s_v3", "Standard_D64s_v3", "Standard_D11_v2", "Standard_D12_v2",
     "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2", "Standard_DS1", "Standard_DS2",
     "Standard_DS3", "Standard_DS4", "Standard_DS11", "Standard_DS12", "Standard_DS13",
     "Standard_DS14", "Standard_DS1_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2",
     "Standard_DS5_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2",
     "Standard_DS14_v2", "Standard_DS15_v2", "Standard_DS13-4_v2", "Standard_DS13-2_v2",
     "Standard_DS14-8_v2", "Standard_DS14-4_v2", "Standard_E2_v3", "Standard_E4_v3",
     "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3", "Standard_E64_v3", "Standard_E2s_v3",
     "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3", "Standard_E32s_v3",
     "Standard_E64s_v3", "Standard_E32-16_v3", "Standard_E32-8s_v3", "Standard_E64-32s_v3",
     "Standard_E64-16s_v3", "Standard_F1", "Standard_F2", "Standard_F4", "Standard_F8",
     "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
     "Standard_F16s", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2", "Standard_F16s_v2",
     "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2", "Standard_G1", "Standard_G2",
     "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3",
     "Standard_GS4", "Standard_GS5", "Standard_GS4-8", "Standard_GS4-4", "Standard_GS5-16",
     "Standard_GS5-8", "Standard_H8", "Standard_H16", "Standard_H8m", "Standard_H16m",
     "Standard_H16r", "Standard_H16mr", "Standard_L4s", "Standard_L8s", "Standard_L16s",
     "Standard_L32s", "Standard_M64s", "Standard_M64ms", "Standard_M128s", "Standard_M128ms",
     "Standard_M64-32ms", "Standard_M64-16ms", "Standard_M128-64ms", "Standard_M128-32ms",
     "Standard_NC6", "Standard_NC12", "Standard_NC24", "Standard_NC24r", "Standard_NC6s_v2",
     "Standard_NC12s_v2", "Standard_NC24s_v2", "Standard_NC24rs_v2", "Standard_NC6s_v3",
     "Standard_NC12s_v3", "Standard_NC24s_v3", "Standard_NC24rs_v3", "Standard_ND6s",
     "Standard_ND12s", "Standard_ND24s", "Standard_ND24rs", "Standard_NV6", "Standard_NV12",
     "Standard_NV24".
    :type vm_size: str or ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineSizeTypes
    """

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HardwareProfile, self).__init__(**kwargs)
        self.vm_size = kwargs.get('vm_size', None)


class Image(Resource):
    """The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param source_virtual_machine: The source virtual machine from which Image is created.
    :type source_virtual_machine: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2020_06_01.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :param hyper_v_generation: Gets the HyperVGenerationType of the VirtualMachine created from the
     image. Possible values include: "V1", "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2020_06_01.models.HyperVGenerationTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source_virtual_machine': {'key': 'properties.sourceVirtualMachine', 'type': 'SubResource'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'ImageStorageProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Image, self).__init__(**kwargs)
        self.source_virtual_machine = kwargs.get('source_virtual_machine', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.provisioning_state = None
        self.hyper_v_generation = kwargs.get('hyper_v_generation', None)


class ImageDisk(msrest.serialization.Model):
    """Describes a image disk.

    :param snapshot: The snapshot.
    :type snapshot: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param managed_disk: The managedDisk.
    :type managed_disk: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param blob_uri: The Virtual Hard Disk.
    :type blob_uri: str
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2020_06_01.models.CachingTypes
    :param disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values
     include: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2020_06_01.models.StorageAccountTypes
    :param disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :type disk_encryption_set: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    """

    _attribute_map = {
        'snapshot': {'key': 'snapshot', 'type': 'SubResource'},
        'managed_disk': {'key': 'managedDisk', 'type': 'SubResource'},
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'disk_encryption_set': {'key': 'diskEncryptionSet', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageDisk, self).__init__(**kwargs)
        self.snapshot = kwargs.get('snapshot', None)
        self.managed_disk = kwargs.get('managed_disk', None)
        self.blob_uri = kwargs.get('blob_uri', None)
        self.caching = kwargs.get('caching', None)
        self.disk_size_gb = kwargs.get('disk_size_gb', None)
        self.storage_account_type = kwargs.get('storage_account_type', None)
        self.disk_encryption_set = kwargs.get('disk_encryption_set', None)


class ImageDataDisk(ImageDisk):
    """Describes a data disk.

    All required parameters must be populated in order to send to Azure.

    :param snapshot: The snapshot.
    :type snapshot: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param managed_disk: The managedDisk.
    :type managed_disk: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param blob_uri: The Virtual Hard Disk.
    :type blob_uri: str
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2020_06_01.models.CachingTypes
    :param disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values
     include: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2020_06_01.models.StorageAccountTypes
    :param disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :type disk_encryption_set: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param lun: Required. Specifies the logical unit number of the data disk. This value is used to
     identify data disks within the VM and therefore must be unique for each data disk attached to a
     VM.
    :type lun: int
    """

    _validation = {
        'lun': {'required': True},
    }

    _attribute_map = {
        'snapshot': {'key': 'snapshot', 'type': 'SubResource'},
        'managed_disk': {'key': 'managedDisk', 'type': 'SubResource'},
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'disk_encryption_set': {'key': 'diskEncryptionSet', 'type': 'SubResource'},
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageDataDisk, self).__init__(**kwargs)
        self.lun = kwargs['lun']


class ImageListResult(msrest.serialization.Model):
    """The List Image operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of Images.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.Image]
    :param next_link: The uri to fetch the next page of Images. Call ListNext() with this to fetch
     the next page of Images.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Image]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class ImageOSDisk(ImageDisk):
    """Describes an Operating System disk.

    All required parameters must be populated in order to send to Azure.

    :param snapshot: The snapshot.
    :type snapshot: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param managed_disk: The managedDisk.
    :type managed_disk: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param blob_uri: The Virtual Hard Disk.
    :type blob_uri: str
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2020_06_01.models.CachingTypes
    :param disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values
     include: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2020_06_01.models.StorageAccountTypes
    :param disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :type disk_encryption_set: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param os_type: Required. This property allows you to specify the type of the OS that is
     included in the disk if creating a VM from a custom image. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible
     values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2020_06_01.models.OperatingSystemTypes
    :param os_state: Required. The OS State. Possible values include: "Generalized", "Specialized".
    :type os_state: str or ~azure.mgmt.compute.v2020_06_01.models.OperatingSystemStateTypes
    """

    _validation = {
        'os_type': {'required': True},
        'os_state': {'required': True},
    }

    _attribute_map = {
        'snapshot': {'key': 'snapshot', 'type': 'SubResource'},
        'managed_disk': {'key': 'managedDisk', 'type': 'SubResource'},
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'disk_encryption_set': {'key': 'diskEncryptionSet', 'type': 'SubResource'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'os_state': {'key': 'osState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageOSDisk, self).__init__(**kwargs)
        self.os_type = kwargs['os_type']
        self.os_state = kwargs['os_state']


class ImageReference(SubResource):
    """Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Id.
    :type id: str
    :param publisher: The image publisher.
    :type publisher: str
    :param offer: Specifies the offer of the platform image or marketplace image used to create the
     virtual machine.
    :type offer: str
    :param sku: The image SKU.
    :type sku: str
    :param version: Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and
     Build are decimal numbers. Specify 'latest' to use the latest version of an image available at
     deploy time. Even if you use 'latest', the VM image will not automatically update after deploy
     time even if a new version becomes available.
    :type version: str
    :ivar exact_version: Specifies in decimal numbers, the version of platform image or marketplace
     image used to create the virtual machine. This readonly field differs from 'version', only if
     the value specified in 'version' field is 'latest'.
    :vartype exact_version: str
    """

    _validation = {
        'exact_version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'exact_version': {'key': 'exactVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageReference, self).__init__(**kwargs)
        self.publisher = kwargs.get('publisher', None)
        self.offer = kwargs.get('offer', None)
        self.sku = kwargs.get('sku', None)
        self.version = kwargs.get('version', None)
        self.exact_version = None


class ImageStorageProfile(msrest.serialization.Model):
    """Describes a storage profile.

    :param os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-
     windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :type os_disk: ~azure.mgmt.compute.v2020_06_01.models.ImageOSDisk
    :param data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-
     windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :type data_disks: list[~azure.mgmt.compute.v2020_06_01.models.ImageDataDisk]
    :param zone_resilient: Specifies whether an image is zone resilient or not. Default is false.
     Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
    :type zone_resilient: bool
    """

    _attribute_map = {
        'os_disk': {'key': 'osDisk', 'type': 'ImageOSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[ImageDataDisk]'},
        'zone_resilient': {'key': 'zoneResilient', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageStorageProfile, self).__init__(**kwargs)
        self.os_disk = kwargs.get('os_disk', None)
        self.data_disks = kwargs.get('data_disks', None)
        self.zone_resilient = kwargs.get('zone_resilient', None)


class ImageUpdate(UpdateResource):
    """The source user image virtual hard disk. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param source_virtual_machine: The source virtual machine from which Image is created.
    :type source_virtual_machine: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2020_06_01.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :param hyper_v_generation: Gets the HyperVGenerationType of the VirtualMachine created from the
     image. Possible values include: "V1", "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2020_06_01.models.HyperVGenerationTypes
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'source_virtual_machine': {'key': 'properties.sourceVirtualMachine', 'type': 'SubResource'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'ImageStorageProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageUpdate, self).__init__(**kwargs)
        self.source_virtual_machine = kwargs.get('source_virtual_machine', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.provisioning_state = None
        self.hyper_v_generation = kwargs.get('hyper_v_generation', None)


class InnerError(msrest.serialization.Model):
    """Inner error details.

    :param exceptiontype: The exception type.
    :type exceptiontype: str
    :param errordetail: The internal error message or exception dump.
    :type errordetail: str
    """

    _attribute_map = {
        'exceptiontype': {'key': 'exceptiontype', 'type': 'str'},
        'errordetail': {'key': 'errordetail', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.exceptiontype = kwargs.get('exceptiontype', None)
        self.errordetail = kwargs.get('errordetail', None)


class InstanceViewStatus(msrest.serialization.Model):
    """Instance view status.

    :param code: The status code.
    :type code: str
    :param level: The level code. Possible values include: "Info", "Warning", "Error".
    :type level: str or ~azure.mgmt.compute.v2020_06_01.models.StatusLevelTypes
    :param display_status: The short localizable label for the status.
    :type display_status: str
    :param message: The detailed status message, including for alerts and error messages.
    :type message: str
    :param time: The time of the status.
    :type time: ~datetime.datetime
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstanceViewStatus, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.level = kwargs.get('level', None)
        self.display_status = kwargs.get('display_status', None)
        self.message = kwargs.get('message', None)
        self.time = kwargs.get('time', None)


class KeyVaultKeyReference(msrest.serialization.Model):
    """Describes a reference to Key Vault Key.

    All required parameters must be populated in order to send to Azure.

    :param key_url: Required. The URL referencing a key encryption key in Key Vault.
    :type key_url: str
    :param source_vault: Required. The relative URL of the Key Vault containing the key.
    :type source_vault: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    """

    _validation = {
        'key_url': {'required': True},
        'source_vault': {'required': True},
    }

    _attribute_map = {
        'key_url': {'key': 'keyUrl', 'type': 'str'},
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultKeyReference, self).__init__(**kwargs)
        self.key_url = kwargs['key_url']
        self.source_vault = kwargs['source_vault']


class KeyVaultSecretReference(msrest.serialization.Model):
    """Describes a reference to Key Vault Secret.

    All required parameters must be populated in order to send to Azure.

    :param secret_url: Required. The URL referencing a secret in a Key Vault.
    :type secret_url: str
    :param source_vault: Required. The relative URL of the Key Vault containing the secret.
    :type source_vault: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    """

    _validation = {
        'secret_url': {'required': True},
        'source_vault': {'required': True},
    }

    _attribute_map = {
        'secret_url': {'key': 'secretUrl', 'type': 'str'},
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultSecretReference, self).__init__(**kwargs)
        self.secret_url = kwargs['secret_url']
        self.source_vault = kwargs['source_vault']


class LastPatchInstallationSummary(msrest.serialization.Model):
    """Describes the properties of the last installed patch summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Failed", "Succeeded", or
     "CompletedWithWarnings.". Possible values include: "InProgress", "Failed", "Succeeded",
     "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.v2020_06_01.models.PatchOperationStatus
    :ivar installation_activity_id: The activity ID of the operation that produced this result. It
     is used to correlate across CRP and extension logs.
    :vartype installation_activity_id: str
    :ivar maintenance_window_exceeded: Describes whether the operation ran out of time before it
     completed all its intended actions.
    :vartype maintenance_window_exceeded: bool
    :ivar reboot_status: The reboot status of the machine after the patch operation. It will be in
     "NotNeeded" status if reboot is not needed after the patch operation. "Required" will be the
     status once the patch is applied and machine is required to reboot. "Started" will be the
     reboot status when the machine has started to reboot. "Failed" will be the status if the
     machine is failed to reboot. "Completed" will be the status once the machine is rebooted
     successfully. Possible values include: "NotNeeded", "Required", "Started", "Failed",
     "Completed".
    :vartype reboot_status: str or ~azure.mgmt.compute.v2020_06_01.models.RebootStatus
    :ivar not_selected_patch_count: The number of all available patches but not going to be
     installed because it didn't match a classification or inclusion list entry.
    :vartype not_selected_patch_count: int
    :ivar excluded_patch_count: The number of all available patches but excluded explicitly by a
     customer-specified exclusion list match.
    :vartype excluded_patch_count: int
    :ivar pending_patch_count: The number of all available patches expected to be installed over
     the course of the patch installation operation.
    :vartype pending_patch_count: int
    :ivar installed_patch_count: The count of patches that successfully installed.
    :vartype installed_patch_count: int
    :ivar failed_patch_count: The count of patches that failed installation.
    :vartype failed_patch_count: int
    :ivar start_time: The UTC timestamp when the operation began.
    :vartype start_time: ~datetime.datetime
    :ivar last_modified_time: The UTC timestamp when the operation began.
    :vartype last_modified_time: ~datetime.datetime
    :ivar started_by: The person or system account that started the operation.
    :vartype started_by: str
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.v2020_06_01.models.ApiError
    """

    _validation = {
        'status': {'readonly': True},
        'installation_activity_id': {'readonly': True},
        'maintenance_window_exceeded': {'readonly': True},
        'reboot_status': {'readonly': True},
        'not_selected_patch_count': {'readonly': True},
        'excluded_patch_count': {'readonly': True},
        'pending_patch_count': {'readonly': True},
        'installed_patch_count': {'readonly': True},
        'failed_patch_count': {'readonly': True},
        'start_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'started_by': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'installation_activity_id': {'key': 'installationActivityId', 'type': 'str'},
        'maintenance_window_exceeded': {'key': 'maintenanceWindowExceeded', 'type': 'bool'},
        'reboot_status': {'key': 'rebootStatus', 'type': 'str'},
        'not_selected_patch_count': {'key': 'notSelectedPatchCount', 'type': 'int'},
        'excluded_patch_count': {'key': 'excludedPatchCount', 'type': 'int'},
        'pending_patch_count': {'key': 'pendingPatchCount', 'type': 'int'},
        'installed_patch_count': {'key': 'installedPatchCount', 'type': 'int'},
        'failed_patch_count': {'key': 'failedPatchCount', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'started_by': {'key': 'startedBy', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ApiError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LastPatchInstallationSummary, self).__init__(**kwargs)
        self.status = None
        self.installation_activity_id = None
        self.maintenance_window_exceeded = None
        self.reboot_status = None
        self.not_selected_patch_count = None
        self.excluded_patch_count = None
        self.pending_patch_count = None
        self.installed_patch_count = None
        self.failed_patch_count = None
        self.start_time = None
        self.last_modified_time = None
        self.started_by = None
        self.error = None


class LinuxConfiguration(msrest.serialization.Model):
    """Specifies the Linux operating system settings on the virtual machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on Azure-Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_ :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for Non-Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.

    :param disable_password_authentication: Specifies whether password authentication should be
     disabled.
    :type disable_password_authentication: bool
    :param ssh: Specifies the ssh key configuration for a Linux OS.
    :type ssh: ~azure.mgmt.compute.v2020_06_01.models.SshConfiguration
    :param provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the request
     body, default behavior is to set it to true.  This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later.
    :type provision_vm_agent: bool
    """

    _attribute_map = {
        'disable_password_authentication': {'key': 'disablePasswordAuthentication', 'type': 'bool'},
        'ssh': {'key': 'ssh', 'type': 'SshConfiguration'},
        'provision_vm_agent': {'key': 'provisionVMAgent', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinuxConfiguration, self).__init__(**kwargs)
        self.disable_password_authentication = kwargs.get('disable_password_authentication', None)
        self.ssh = kwargs.get('ssh', None)
        self.provision_vm_agent = kwargs.get('provision_vm_agent', None)


class ListUsagesResult(msrest.serialization.Model):
    """The List Usages operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of compute resource usages.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.Usage]
    :param next_link: The URI to fetch the next page of compute resource usage information. Call
     ListNext() with this to fetch the next page of compute resource usage information.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListUsagesResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class LogAnalyticsInputBase(msrest.serialization.Model):
    """Api input base class for LogAnalytics Api.

    All required parameters must be populated in order to send to Azure.

    :param blob_container_sas_uri: Required. SAS Uri of the logging blob container to which
     LogAnalytics Api writes output logs to.
    :type blob_container_sas_uri: str
    :param from_time: Required. From time of the query.
    :type from_time: ~datetime.datetime
    :param to_time: Required. To time of the query.
    :type to_time: ~datetime.datetime
    :param group_by_throttle_policy: Group query result by Throttle Policy applied.
    :type group_by_throttle_policy: bool
    :param group_by_operation_name: Group query result by Operation Name.
    :type group_by_operation_name: bool
    :param group_by_resource_name: Group query result by Resource Name.
    :type group_by_resource_name: bool
    :param group_by_client_application_id: Group query result by Client Application ID.
    :type group_by_client_application_id: bool
    :param group_by_user_agent: Group query result by User Agent.
    :type group_by_user_agent: bool
    """

    _validation = {
        'blob_container_sas_uri': {'required': True},
        'from_time': {'required': True},
        'to_time': {'required': True},
    }

    _attribute_map = {
        'blob_container_sas_uri': {'key': 'blobContainerSasUri', 'type': 'str'},
        'from_time': {'key': 'fromTime', 'type': 'iso-8601'},
        'to_time': {'key': 'toTime', 'type': 'iso-8601'},
        'group_by_throttle_policy': {'key': 'groupByThrottlePolicy', 'type': 'bool'},
        'group_by_operation_name': {'key': 'groupByOperationName', 'type': 'bool'},
        'group_by_resource_name': {'key': 'groupByResourceName', 'type': 'bool'},
        'group_by_client_application_id': {'key': 'groupByClientApplicationId', 'type': 'bool'},
        'group_by_user_agent': {'key': 'groupByUserAgent', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogAnalyticsInputBase, self).__init__(**kwargs)
        self.blob_container_sas_uri = kwargs['blob_container_sas_uri']
        self.from_time = kwargs['from_time']
        self.to_time = kwargs['to_time']
        self.group_by_throttle_policy = kwargs.get('group_by_throttle_policy', None)
        self.group_by_operation_name = kwargs.get('group_by_operation_name', None)
        self.group_by_resource_name = kwargs.get('group_by_resource_name', None)
        self.group_by_client_application_id = kwargs.get('group_by_client_application_id', None)
        self.group_by_user_agent = kwargs.get('group_by_user_agent', None)


class LogAnalyticsOperationResult(msrest.serialization.Model):
    """LogAnalytics operation status response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: LogAnalyticsOutput.
    :vartype properties: ~azure.mgmt.compute.v2020_06_01.models.LogAnalyticsOutput
    """

    _validation = {
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'LogAnalyticsOutput'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogAnalyticsOperationResult, self).__init__(**kwargs)
        self.properties = None


class LogAnalyticsOutput(msrest.serialization.Model):
    """LogAnalytics output properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar output: Output file Uri path to blob container.
    :vartype output: str
    """

    _validation = {
        'output': {'readonly': True},
    }

    _attribute_map = {
        'output': {'key': 'output', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogAnalyticsOutput, self).__init__(**kwargs)
        self.output = None


class MaintenanceRedeployStatus(msrest.serialization.Model):
    """Maintenance Operation Status.

    :param is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform
     Maintenance.
    :type is_customer_initiated_maintenance_allowed: bool
    :param pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
    :type pre_maintenance_window_start_time: ~datetime.datetime
    :param pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
    :type pre_maintenance_window_end_time: ~datetime.datetime
    :param maintenance_window_start_time: Start Time for the Maintenance Window.
    :type maintenance_window_start_time: ~datetime.datetime
    :param maintenance_window_end_time: End Time for the Maintenance Window.
    :type maintenance_window_end_time: ~datetime.datetime
    :param last_operation_result_code: The Last Maintenance Operation Result Code. Possible values
     include: "None", "RetryLater", "MaintenanceAborted", "MaintenanceCompleted".
    :type last_operation_result_code: str or
     ~azure.mgmt.compute.v2020_06_01.models.MaintenanceOperationResultCodeTypes
    :param last_operation_message: Message returned for the last Maintenance Operation.
    :type last_operation_message: str
    """

    _attribute_map = {
        'is_customer_initiated_maintenance_allowed': {'key': 'isCustomerInitiatedMaintenanceAllowed', 'type': 'bool'},
        'pre_maintenance_window_start_time': {'key': 'preMaintenanceWindowStartTime', 'type': 'iso-8601'},
        'pre_maintenance_window_end_time': {'key': 'preMaintenanceWindowEndTime', 'type': 'iso-8601'},
        'maintenance_window_start_time': {'key': 'maintenanceWindowStartTime', 'type': 'iso-8601'},
        'maintenance_window_end_time': {'key': 'maintenanceWindowEndTime', 'type': 'iso-8601'},
        'last_operation_result_code': {'key': 'lastOperationResultCode', 'type': 'str'},
        'last_operation_message': {'key': 'lastOperationMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MaintenanceRedeployStatus, self).__init__(**kwargs)
        self.is_customer_initiated_maintenance_allowed = kwargs.get('is_customer_initiated_maintenance_allowed', None)
        self.pre_maintenance_window_start_time = kwargs.get('pre_maintenance_window_start_time', None)
        self.pre_maintenance_window_end_time = kwargs.get('pre_maintenance_window_end_time', None)
        self.maintenance_window_start_time = kwargs.get('maintenance_window_start_time', None)
        self.maintenance_window_end_time = kwargs.get('maintenance_window_end_time', None)
        self.last_operation_result_code = kwargs.get('last_operation_result_code', None)
        self.last_operation_message = kwargs.get('last_operation_message', None)


class ManagedDiskParameters(SubResource):
    """The parameters of a managed disk.

    :param id: Resource Id.
    :type id: str
    :param storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values
     include: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2020_06_01.models.StorageAccountTypes
    :param disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk.
    :type disk_encryption_set: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'disk_encryption_set': {'key': 'diskEncryptionSet', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedDiskParameters, self).__init__(**kwargs)
        self.storage_account_type = kwargs.get('storage_account_type', None)
        self.disk_encryption_set = kwargs.get('disk_encryption_set', None)


class NetworkInterfaceReference(SubResource):
    """Describes a network interface reference.

    :param id: Resource Id.
    :type id: str
    :param primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :type primary: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceReference, self).__init__(**kwargs)
        self.primary = kwargs.get('primary', None)


class NetworkProfile(msrest.serialization.Model):
    """Specifies the network interfaces of the virtual machine.

    :param network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the virtual machine.
    :type network_interfaces:
     list[~azure.mgmt.compute.v2020_06_01.models.NetworkInterfaceReference]
    """

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[NetworkInterfaceReference]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkProfile, self).__init__(**kwargs)
        self.network_interfaces = kwargs.get('network_interfaces', None)


class OrchestrationServiceStateInput(msrest.serialization.Model):
    """The input for OrchestrationServiceState.

    All required parameters must be populated in order to send to Azure.

    :param service_name: Required. The name of the service. Possible values include:
     "AutomaticRepairs", "DummyOrchestrationServiceName".
    :type service_name: str or ~azure.mgmt.compute.v2020_06_01.models.OrchestrationServiceNames
    :param action: Required. The action to be performed. Possible values include: "Resume",
     "Suspend".
    :type action: str or ~azure.mgmt.compute.v2020_06_01.models.OrchestrationServiceStateAction
    """

    _validation = {
        'service_name': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrchestrationServiceStateInput, self).__init__(**kwargs)
        self.service_name = kwargs['service_name']
        self.action = kwargs['action']


class OrchestrationServiceSummary(msrest.serialization.Model):
    """Summary for an orchestration service of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_name: The name of the service. Possible values include: "AutomaticRepairs",
     "DummyOrchestrationServiceName".
    :vartype service_name: str or ~azure.mgmt.compute.v2020_06_01.models.OrchestrationServiceNames
    :ivar service_state: The current state of the service. Possible values include: "NotRunning",
     "Running", "Suspended".
    :vartype service_state: str or ~azure.mgmt.compute.v2020_06_01.models.OrchestrationServiceState
    """

    _validation = {
        'service_name': {'readonly': True},
        'service_state': {'readonly': True},
    }

    _attribute_map = {
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'service_state': {'key': 'serviceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrchestrationServiceSummary, self).__init__(**kwargs)
        self.service_name = None
        self.service_state = None


class OSDisk(msrest.serialization.Model):
    """Specifies information about the operating system disk used by the virtual machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.

    All required parameters must be populated in order to send to Azure.

    :param os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible
     values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2020_06_01.models.OperatingSystemTypes
    :param encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type encryption_settings: ~azure.mgmt.compute.v2020_06_01.models.DiskEncryptionSettings
    :param name: The disk name.
    :type name: str
    :param vhd: The virtual hard disk.
    :type vhd: ~azure.mgmt.compute.v2020_06_01.models.VirtualHardDisk
    :param image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :type image: ~azure.mgmt.compute.v2020_06_01.models.VirtualHardDisk
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None** for Standard
     storage. **ReadOnly** for Premium storage. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2020_06_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param diff_disk_settings: Specifies the ephemeral Disk Settings for the operating system disk
     used by the virtual machine.
    :type diff_disk_settings: ~azure.mgmt.compute.v2020_06_01.models.DiffDiskSettings
    :param create_option: Required. Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
     This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Possible values include: "FromImage", "Empty", "Attach".
    :type create_option: str or ~azure.mgmt.compute.v2020_06_01.models.DiskCreateOptionTypes
    :param disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param managed_disk: The managed disk parameters.
    :type managed_disk: ~azure.mgmt.compute.v2020_06_01.models.ManagedDiskParameters
    """

    _validation = {
        'create_option': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'encryption_settings': {'key': 'encryptionSettings', 'type': 'DiskEncryptionSettings'},
        'name': {'key': 'name', 'type': 'str'},
        'vhd': {'key': 'vhd', 'type': 'VirtualHardDisk'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'diff_disk_settings': {'key': 'diffDiskSettings', 'type': 'DiffDiskSettings'},
        'create_option': {'key': 'createOption', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'managed_disk': {'key': 'managedDisk', 'type': 'ManagedDiskParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OSDisk, self).__init__(**kwargs)
        self.os_type = kwargs.get('os_type', None)
        self.encryption_settings = kwargs.get('encryption_settings', None)
        self.name = kwargs.get('name', None)
        self.vhd = kwargs.get('vhd', None)
        self.image = kwargs.get('image', None)
        self.caching = kwargs.get('caching', None)
        self.write_accelerator_enabled = kwargs.get('write_accelerator_enabled', None)
        self.diff_disk_settings = kwargs.get('diff_disk_settings', None)
        self.create_option = kwargs['create_option']
        self.disk_size_gb = kwargs.get('disk_size_gb', None)
        self.managed_disk = kwargs.get('managed_disk', None)


class OSDiskImage(msrest.serialization.Model):
    """Contains the os disk image information.

    All required parameters must be populated in order to send to Azure.

    :param operating_system: Required. The operating system of the osDiskImage. Possible values
     include: "Windows", "Linux".
    :type operating_system: str or ~azure.mgmt.compute.v2020_06_01.models.OperatingSystemTypes
    """

    _validation = {
        'operating_system': {'required': True},
    }

    _attribute_map = {
        'operating_system': {'key': 'operatingSystem', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OSDiskImage, self).__init__(**kwargs)
        self.operating_system = kwargs['operating_system']


class OSProfile(msrest.serialization.Model):
    """Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once VM is provisioned.

    :param computer_name: Specifies the host OS name of the virtual machine.
     :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
     :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
     restrictions see `Azure infrastructure services implementation guidelines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-
     subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-
     conventions>`_.
    :type computer_name: str
    :param admin_username: Specifies the name of the administrator account.
     :code:`<br>`:code:`<br>` This property cannot be updated after the VM is created.
     :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
     :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
     "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
     "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
     "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
     :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
     characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access to the Linux VM, see `Using
     root privileges on Linux virtual machines in Azure <https://docs.microsoft.com/azure/virtual-
     machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-
     machines%2flinux%2ftoc.json>`_\ :code:`<br>`:code:`<li>` For a list of built-in system users on
     Linux that should not be used in this field, see `Selecting User Names for Linux on Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-
     usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type admin_username: str
    :param admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-
     rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_ :code:`<br>`:code:`<br>` For
     resetting root password, see `Manage users, SSH, and check or repair disks on Azure Linux VMs
     using the VMAccess Extension <https://docs.microsoft.com/azure/virtual-machines/virtual-
     machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-
     machines%2flinux%2ftoc.json#reset-root-password>`_.
    :type admin_password: str
    :param custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` **Note: Do not pass any
     secrets or passwords in customData property** :code:`<br>`:code:`<br>` This property cannot be
     updated after the VM is created. :code:`<br>`:code:`<br>` customData is passed to the VM to be
     saved as a file, for more information see `Custom Data on Azure VMs
     <https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/>`_
     :code:`<br>`:code:`<br>` For using cloud-init for your Linux VM, see `Using cloud-init to
     customize a Linux VM during creation <https://docs.microsoft.com/azure/virtual-
     machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-
     machines%2flinux%2ftoc.json>`_.
    :type custom_data: str
    :param windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :type windows_configuration: ~azure.mgmt.compute.v2020_06_01.models.WindowsConfiguration
    :param linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-
     machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_
     :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for Non-
     Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-
     linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type linux_configuration: ~azure.mgmt.compute.v2020_06_01.models.LinuxConfiguration
    :param secrets: Specifies set of certificates that should be installed onto the virtual
     machine.
    :type secrets: list[~azure.mgmt.compute.v2020_06_01.models.VaultSecretGroup]
    :param allow_extension_operations: Specifies whether extension operations should be allowed on
     the virtual machine. :code:`<br>`:code:`<br>`This may only be set to False when no extensions
     are present on the virtual machine.
    :type allow_extension_operations: bool
    :param require_guest_provision_signal: Specifies whether the guest provision signal is required
     to infer provision success of the virtual machine.  **Note: This property is for private
     testing only, and all customers must not set the property to false.**.
    :type require_guest_provision_signal: bool
    """

    _attribute_map = {
        'computer_name': {'key': 'computerName', 'type': 'str'},
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
        'custom_data': {'key': 'customData', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'linux_configuration': {'key': 'linuxConfiguration', 'type': 'LinuxConfiguration'},
        'secrets': {'key': 'secrets', 'type': '[VaultSecretGroup]'},
        'allow_extension_operations': {'key': 'allowExtensionOperations', 'type': 'bool'},
        'require_guest_provision_signal': {'key': 'requireGuestProvisionSignal', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OSProfile, self).__init__(**kwargs)
        self.computer_name = kwargs.get('computer_name', None)
        self.admin_username = kwargs.get('admin_username', None)
        self.admin_password = kwargs.get('admin_password', None)
        self.custom_data = kwargs.get('custom_data', None)
        self.windows_configuration = kwargs.get('windows_configuration', None)
        self.linux_configuration = kwargs.get('linux_configuration', None)
        self.secrets = kwargs.get('secrets', None)
        self.allow_extension_operations = kwargs.get('allow_extension_operations', None)
        self.require_guest_provision_signal = kwargs.get('require_guest_provision_signal', None)


class PatchSettings(msrest.serialization.Model):
    """PatchSettings.

    :param patch_mode: Specifies the mode of in-guest patching to IaaS virtual machine.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
     the application of patches to a virtual machine. You do this by applying patches manually
     inside the VM. In this mode, automatic updates are disabled; the property
     WindowsConfiguration.enableAutomaticUpdates must be false:code:`<br />`:code:`<br />`
     **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property
     WindowsConfiguration.enableAutomaticUpdates must be true. :code:`<br />`:code:`<br />`
     **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The
     properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true.
     Possible values include: "Manual", "AutomaticByOS", "AutomaticByPlatform".
    :type patch_mode: str or ~azure.mgmt.compute.v2020_06_01.models.InGuestPatchMode
    """

    _attribute_map = {
        'patch_mode': {'key': 'patchMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PatchSettings, self).__init__(**kwargs)
        self.patch_mode = kwargs.get('patch_mode', None)


class Plan(msrest.serialization.Model):
    """Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.

    :param name: The plan ID.
    :type name: str
    :param publisher: The publisher ID.
    :type publisher: str
    :param product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element.
    :type product: str
    :param promotion_code: The promotion code.
    :type promotion_code: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Plan, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.publisher = kwargs.get('publisher', None)
        self.product = kwargs.get('product', None)
        self.promotion_code = kwargs.get('promotion_code', None)


class ProximityPlacementGroup(Resource):
    """Specifies information about the proximity placement group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param proximity_placement_group_type: Specifies the type of the proximity placement group.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Standard** : Co-locate
     resources within an Azure region or Availability Zone. :code:`<br>`:code:`<br>` **Ultra** : For
     future use. Possible values include: "Standard", "Ultra".
    :type proximity_placement_group_type: str or
     ~azure.mgmt.compute.v2020_06_01.models.ProximityPlacementGroupType
    :ivar virtual_machines: A list of references to all virtual machines in the proximity placement
     group.
    :vartype virtual_machines:
     list[~azure.mgmt.compute.v2020_06_01.models.SubResourceWithColocationStatus]
    :ivar virtual_machine_scale_sets: A list of references to all virtual machine scale sets in the
     proximity placement group.
    :vartype virtual_machine_scale_sets:
     list[~azure.mgmt.compute.v2020_06_01.models.SubResourceWithColocationStatus]
    :ivar availability_sets: A list of references to all availability sets in the proximity
     placement group.
    :vartype availability_sets:
     list[~azure.mgmt.compute.v2020_06_01.models.SubResourceWithColocationStatus]
    :param colocation_status: Describes colocation status of the Proximity Placement Group.
    :type colocation_status: ~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'virtual_machines': {'readonly': True},
        'virtual_machine_scale_sets': {'readonly': True},
        'availability_sets': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'proximity_placement_group_type': {'key': 'properties.proximityPlacementGroupType', 'type': 'str'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResourceWithColocationStatus]'},
        'virtual_machine_scale_sets': {'key': 'properties.virtualMachineScaleSets', 'type': '[SubResourceWithColocationStatus]'},
        'availability_sets': {'key': 'properties.availabilitySets', 'type': '[SubResourceWithColocationStatus]'},
        'colocation_status': {'key': 'properties.colocationStatus', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProximityPlacementGroup, self).__init__(**kwargs)
        self.proximity_placement_group_type = kwargs.get('proximity_placement_group_type', None)
        self.virtual_machines = None
        self.virtual_machine_scale_sets = None
        self.availability_sets = None
        self.colocation_status = kwargs.get('colocation_status', None)


class ProximityPlacementGroupListResult(msrest.serialization.Model):
    """The List Proximity Placement Group operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of proximity placement groups.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.ProximityPlacementGroup]
    :param next_link: The URI to fetch the next page of proximity placement groups.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProximityPlacementGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProximityPlacementGroupListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class ProximityPlacementGroupUpdate(UpdateResource):
    """Specifies information about the proximity placement group.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProximityPlacementGroupUpdate, self).__init__(**kwargs)


class PurchasePlan(msrest.serialization.Model):
    """Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.

    All required parameters must be populated in order to send to Azure.

    :param publisher: Required. The publisher ID.
    :type publisher: str
    :param name: Required. The plan ID.
    :type name: str
    :param product: Required. Specifies the product of the image from the marketplace. This is the
     same value as Offer under the imageReference element.
    :type product: str
    """

    _validation = {
        'publisher': {'required': True},
        'name': {'required': True},
        'product': {'required': True},
    }

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PurchasePlan, self).__init__(**kwargs)
        self.publisher = kwargs['publisher']
        self.name = kwargs['name']
        self.product = kwargs['product']


class RecoveryWalkResponse(msrest.serialization.Model):
    """Response after calling a manual recovery walk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar walk_performed: Whether the recovery walk was performed.
    :vartype walk_performed: bool
    :ivar next_platform_update_domain: The next update domain that needs to be walked. Null means
     walk spanning all update domains has been completed.
    :vartype next_platform_update_domain: int
    """

    _validation = {
        'walk_performed': {'readonly': True},
        'next_platform_update_domain': {'readonly': True},
    }

    _attribute_map = {
        'walk_performed': {'key': 'walkPerformed', 'type': 'bool'},
        'next_platform_update_domain': {'key': 'nextPlatformUpdateDomain', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryWalkResponse, self).__init__(**kwargs)
        self.walk_performed = None
        self.next_platform_update_domain = None


class RequestRateByIntervalInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getRequestRateByInterval Api.

    All required parameters must be populated in order to send to Azure.

    :param blob_container_sas_uri: Required. SAS Uri of the logging blob container to which
     LogAnalytics Api writes output logs to.
    :type blob_container_sas_uri: str
    :param from_time: Required. From time of the query.
    :type from_time: ~datetime.datetime
    :param to_time: Required. To time of the query.
    :type to_time: ~datetime.datetime
    :param group_by_throttle_policy: Group query result by Throttle Policy applied.
    :type group_by_throttle_policy: bool
    :param group_by_operation_name: Group query result by Operation Name.
    :type group_by_operation_name: bool
    :param group_by_resource_name: Group query result by Resource Name.
    :type group_by_resource_name: bool
    :param group_by_client_application_id: Group query result by Client Application ID.
    :type group_by_client_application_id: bool
    :param group_by_user_agent: Group query result by User Agent.
    :type group_by_user_agent: bool
    :param interval_length: Required. Interval value in minutes used to create LogAnalytics call
     rate logs. Possible values include: "ThreeMins", "FiveMins", "ThirtyMins", "SixtyMins".
    :type interval_length: str or ~azure.mgmt.compute.v2020_06_01.models.IntervalInMins
    """

    _validation = {
        'blob_container_sas_uri': {'required': True},
        'from_time': {'required': True},
        'to_time': {'required': True},
        'interval_length': {'required': True},
    }

    _attribute_map = {
        'blob_container_sas_uri': {'key': 'blobContainerSasUri', 'type': 'str'},
        'from_time': {'key': 'fromTime', 'type': 'iso-8601'},
        'to_time': {'key': 'toTime', 'type': 'iso-8601'},
        'group_by_throttle_policy': {'key': 'groupByThrottlePolicy', 'type': 'bool'},
        'group_by_operation_name': {'key': 'groupByOperationName', 'type': 'bool'},
        'group_by_resource_name': {'key': 'groupByResourceName', 'type': 'bool'},
        'group_by_client_application_id': {'key': 'groupByClientApplicationId', 'type': 'bool'},
        'group_by_user_agent': {'key': 'groupByUserAgent', 'type': 'bool'},
        'interval_length': {'key': 'intervalLength', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RequestRateByIntervalInput, self).__init__(**kwargs)
        self.interval_length = kwargs['interval_length']


class RetrieveBootDiagnosticsDataResult(msrest.serialization.Model):
    """The SAS URIs of the console screenshot and serial log blobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The serial console log blob URI.
    :vartype serial_console_log_blob_uri: str
    """

    _validation = {
        'console_screenshot_blob_uri': {'readonly': True},
        'serial_console_log_blob_uri': {'readonly': True},
    }

    _attribute_map = {
        'console_screenshot_blob_uri': {'key': 'consoleScreenshotBlobUri', 'type': 'str'},
        'serial_console_log_blob_uri': {'key': 'serialConsoleLogBlobUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RetrieveBootDiagnosticsDataResult, self).__init__(**kwargs)
        self.console_screenshot_blob_uri = None
        self.serial_console_log_blob_uri = None


class RollbackStatusInfo(msrest.serialization.Model):
    """Information about rollback on failed VM instances after a OS Upgrade operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successfully_rolledback_instance_count: The number of instances which have been
     successfully rolled back.
    :vartype successfully_rolledback_instance_count: int
    :ivar failed_rolledback_instance_count: The number of instances which failed to rollback.
    :vartype failed_rolledback_instance_count: int
    :ivar rollback_error: Error details if OS rollback failed.
    :vartype rollback_error: ~azure.mgmt.compute.v2020_06_01.models.ApiError
    """

    _validation = {
        'successfully_rolledback_instance_count': {'readonly': True},
        'failed_rolledback_instance_count': {'readonly': True},
        'rollback_error': {'readonly': True},
    }

    _attribute_map = {
        'successfully_rolledback_instance_count': {'key': 'successfullyRolledbackInstanceCount', 'type': 'int'},
        'failed_rolledback_instance_count': {'key': 'failedRolledbackInstanceCount', 'type': 'int'},
        'rollback_error': {'key': 'rollbackError', 'type': 'ApiError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RollbackStatusInfo, self).__init__(**kwargs)
        self.successfully_rolledback_instance_count = None
        self.failed_rolledback_instance_count = None
        self.rollback_error = None


class RollingUpgradePolicy(msrest.serialization.Model):
    """The configuration parameters used while performing a rolling upgrade.

    :param max_batch_instance_percent: The maximum percent of total virtual machine instances that
     will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
     unhealthy instances in previous or future batches can cause the percentage of instances in a
     batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
    :type max_batch_instance_percent: int
    :param max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
     instances in the scale set that can be simultaneously unhealthy, either as a result of being
     upgraded, or by being found in an unhealthy state by the virtual machine health checks before
     the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
     default value for this parameter is 20%.
    :type max_unhealthy_instance_percent: int
    :param max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
     machine instances that can be found to be in an unhealthy state. This check will happen after
     each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
     default value for this parameter is 20%.
    :type max_unhealthy_upgraded_instance_percent: int
    :param pause_time_between_batches: The wait time between completing the update for all virtual
     machines in one batch and starting the next batch. The time duration should be specified in ISO
     8601 format. The default value is 0 seconds (PT0S).
    :type pause_time_between_batches: str
    """

    _validation = {
        'max_batch_instance_percent': {'maximum': 100, 'minimum': 5},
        'max_unhealthy_instance_percent': {'maximum': 100, 'minimum': 5},
        'max_unhealthy_upgraded_instance_percent': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'max_batch_instance_percent': {'key': 'maxBatchInstancePercent', 'type': 'int'},
        'max_unhealthy_instance_percent': {'key': 'maxUnhealthyInstancePercent', 'type': 'int'},
        'max_unhealthy_upgraded_instance_percent': {'key': 'maxUnhealthyUpgradedInstancePercent', 'type': 'int'},
        'pause_time_between_batches': {'key': 'pauseTimeBetweenBatches', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RollingUpgradePolicy, self).__init__(**kwargs)
        self.max_batch_instance_percent = kwargs.get('max_batch_instance_percent', None)
        self.max_unhealthy_instance_percent = kwargs.get('max_unhealthy_instance_percent', None)
        self.max_unhealthy_upgraded_instance_percent = kwargs.get('max_unhealthy_upgraded_instance_percent', None)
        self.pause_time_between_batches = kwargs.get('pause_time_between_batches', None)


class RollingUpgradeProgressInfo(msrest.serialization.Model):
    """Information about the number of virtual machine instances in each upgrade state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successful_instance_count: The number of instances that have been successfully upgraded.
    :vartype successful_instance_count: int
    :ivar failed_instance_count: The number of instances that have failed to be upgraded
     successfully.
    :vartype failed_instance_count: int
    :ivar in_progress_instance_count: The number of instances that are currently being upgraded.
    :vartype in_progress_instance_count: int
    :ivar pending_instance_count: The number of instances that have not yet begun to be upgraded.
    :vartype pending_instance_count: int
    """

    _validation = {
        'successful_instance_count': {'readonly': True},
        'failed_instance_count': {'readonly': True},
        'in_progress_instance_count': {'readonly': True},
        'pending_instance_count': {'readonly': True},
    }

    _attribute_map = {
        'successful_instance_count': {'key': 'successfulInstanceCount', 'type': 'int'},
        'failed_instance_count': {'key': 'failedInstanceCount', 'type': 'int'},
        'in_progress_instance_count': {'key': 'inProgressInstanceCount', 'type': 'int'},
        'pending_instance_count': {'key': 'pendingInstanceCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RollingUpgradeProgressInfo, self).__init__(**kwargs)
        self.successful_instance_count = None
        self.failed_instance_count = None
        self.in_progress_instance_count = None
        self.pending_instance_count = None


class RollingUpgradeRunningStatus(msrest.serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Possible values include:
     "RollingForward", "Cancelled", "Completed", "Faulted".
    :vartype code: str or ~azure.mgmt.compute.v2020_06_01.models.RollingUpgradeStatusCode
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar last_action: The last action performed on the rolling upgrade. Possible values include:
     "Start", "Cancel".
    :vartype last_action: str or ~azure.mgmt.compute.v2020_06_01.models.RollingUpgradeActionType
    :ivar last_action_time: Last action time of the upgrade.
    :vartype last_action_time: ~datetime.datetime
    """

    _validation = {
        'code': {'readonly': True},
        'start_time': {'readonly': True},
        'last_action': {'readonly': True},
        'last_action_time': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_action': {'key': 'lastAction', 'type': 'str'},
        'last_action_time': {'key': 'lastActionTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RollingUpgradeRunningStatus, self).__init__(**kwargs)
        self.code = None
        self.start_time = None
        self.last_action = None
        self.last_action_time = None


class RollingUpgradeStatusInfo(Resource):
    """The status of the latest virtual machine scale set rolling upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar policy: The rolling upgrade policies applied for this upgrade.
    :vartype policy: ~azure.mgmt.compute.v2020_06_01.models.RollingUpgradePolicy
    :ivar running_status: Information about the current running state of the overall upgrade.
    :vartype running_status: ~azure.mgmt.compute.v2020_06_01.models.RollingUpgradeRunningStatus
    :ivar progress: Information about the number of virtual machine instances in each upgrade
     state.
    :vartype progress: ~azure.mgmt.compute.v2020_06_01.models.RollingUpgradeProgressInfo
    :ivar error: Error details for this upgrade, if there are any.
    :vartype error: ~azure.mgmt.compute.v2020_06_01.models.ApiError
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'policy': {'readonly': True},
        'running_status': {'readonly': True},
        'progress': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'policy': {'key': 'properties.policy', 'type': 'RollingUpgradePolicy'},
        'running_status': {'key': 'properties.runningStatus', 'type': 'RollingUpgradeRunningStatus'},
        'progress': {'key': 'properties.progress', 'type': 'RollingUpgradeProgressInfo'},
        'error': {'key': 'properties.error', 'type': 'ApiError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RollingUpgradeStatusInfo, self).__init__(**kwargs)
        self.policy = None
        self.running_status = None
        self.progress = None
        self.error = None


class RunCommandDocumentBase(msrest.serialization.Model):
    """Describes the properties of a Run Command metadata.

    All required parameters must be populated in order to send to Azure.

    :param schema: Required. The VM run command schema.
    :type schema: str
    :param id: Required. The VM run command id.
    :type id: str
    :param os_type: Required. The Operating System type. Possible values include: "Windows",
     "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2020_06_01.models.OperatingSystemTypes
    :param label: Required. The VM run command label.
    :type label: str
    :param description: Required. The VM run command description.
    :type description: str
    """

    _validation = {
        'schema': {'required': True},
        'id': {'required': True},
        'os_type': {'required': True},
        'label': {'required': True},
        'description': {'required': True},
    }

    _attribute_map = {
        'schema': {'key': '$schema', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunCommandDocumentBase, self).__init__(**kwargs)
        self.schema = kwargs['schema']
        self.id = kwargs['id']
        self.os_type = kwargs['os_type']
        self.label = kwargs['label']
        self.description = kwargs['description']


class RunCommandDocument(RunCommandDocumentBase):
    """Describes the properties of a Run Command.

    All required parameters must be populated in order to send to Azure.

    :param schema: Required. The VM run command schema.
    :type schema: str
    :param id: Required. The VM run command id.
    :type id: str
    :param os_type: Required. The Operating System type. Possible values include: "Windows",
     "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2020_06_01.models.OperatingSystemTypes
    :param label: Required. The VM run command label.
    :type label: str
    :param description: Required. The VM run command description.
    :type description: str
    :param script: Required. The script to be executed.
    :type script: list[str]
    :param parameters: The parameters used by the script.
    :type parameters: list[~azure.mgmt.compute.v2020_06_01.models.RunCommandParameterDefinition]
    """

    _validation = {
        'schema': {'required': True},
        'id': {'required': True},
        'os_type': {'required': True},
        'label': {'required': True},
        'description': {'required': True},
        'script': {'required': True},
    }

    _attribute_map = {
        'schema': {'key': '$schema', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'script': {'key': 'script', 'type': '[str]'},
        'parameters': {'key': 'parameters', 'type': '[RunCommandParameterDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunCommandDocument, self).__init__(**kwargs)
        self.script = kwargs['script']
        self.parameters = kwargs.get('parameters', None)


class RunCommandInput(msrest.serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :param command_id: Required. The run command id.
    :type command_id: str
    :param script: Optional. The script to be executed.  When this value is given, the given script
     will override the default script of the command.
    :type script: list[str]
    :param parameters: The run command parameters.
    :type parameters: list[~azure.mgmt.compute.v2020_06_01.models.RunCommandInputParameter]
    """

    _validation = {
        'command_id': {'required': True},
    }

    _attribute_map = {
        'command_id': {'key': 'commandId', 'type': 'str'},
        'script': {'key': 'script', 'type': '[str]'},
        'parameters': {'key': 'parameters', 'type': '[RunCommandInputParameter]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunCommandInput, self).__init__(**kwargs)
        self.command_id = kwargs['command_id']
        self.script = kwargs.get('script', None)
        self.parameters = kwargs.get('parameters', None)


class RunCommandInputParameter(msrest.serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The run command parameter name.
    :type name: str
    :param value: Required. The run command parameter value.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunCommandInputParameter, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.value = kwargs['value']


class RunCommandListResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machine run commands.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.RunCommandDocumentBase]
    :param next_link: The uri to fetch the next page of run commands. Call ListNext() with this to
     fetch the next page of run commands.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RunCommandDocumentBase]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunCommandListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class RunCommandParameterDefinition(msrest.serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The run command parameter name.
    :type name: str
    :param type: Required. The run command parameter type.
    :type type: str
    :param default_value: The run command parameter default value.
    :type default_value: str
    :param required: The run command parameter required.
    :type required: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
        'required': {'key': 'required', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunCommandParameterDefinition, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs['type']
        self.default_value = kwargs.get('default_value', None)
        self.required = kwargs.get('required', False)


class RunCommandResult(msrest.serialization.Model):
    """RunCommandResult.

    :param value: Run command operation response.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunCommandResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ScaleInPolicy(msrest.serialization.Model):
    """Describes a scale-in policy for a virtual machine scale set.

    :param rules: The rules to be followed when scaling-in a virtual machine scale set.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Default** When a
     virtual machine scale set is scaled in, the scale set will first be balanced across zones if it
     is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within
     each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not
     protected from scale-in. :code:`<br>`:code:`<br>` **OldestVM** When a virtual machine scale set
     is being scaled-in, the oldest virtual machines that are not protected from scale-in will be
     chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced
     across zones. Within each zone, the oldest virtual machines that are not protected will be
     chosen for removal. :code:`<br>`:code:`<br>` **NewestVM** When a virtual machine scale set is
     being scaled-in, the newest virtual machines that are not protected from scale-in will be
     chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced
     across zones. Within each zone, the newest virtual machines that are not protected will be
     chosen for removal. :code:`<br>`:code:`<br>`.
    :type rules: list[str or
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetScaleInRules]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScaleInPolicy, self).__init__(**kwargs)
        self.rules = kwargs.get('rules', None)


class ScheduledEventsProfile(msrest.serialization.Model):
    """ScheduledEventsProfile.

    :param terminate_notification_profile: Specifies Terminate Scheduled Event related
     configurations.
    :type terminate_notification_profile:
     ~azure.mgmt.compute.v2020_06_01.models.TerminateNotificationProfile
    """

    _attribute_map = {
        'terminate_notification_profile': {'key': 'terminateNotificationProfile', 'type': 'TerminateNotificationProfile'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScheduledEventsProfile, self).__init__(**kwargs)
        self.terminate_notification_profile = kwargs.get('terminate_notification_profile', None)


class SecurityProfile(msrest.serialization.Model):
    """Specifies the Security profile settings for the virtual machine or virtual machine scale set.

    :param encryption_at_host: This property can be used by user in the request to enable or
     disable the Host Encryption for the virtual machine or virtual machine scale set. This will
     enable the encryption for all the disks including Resource/Temp disk at host itself.
     :code:`<br>`:code:`<br>` Default: The Encryption at host will be disabled unless this property
     is set to true for the resource.
    :type encryption_at_host: bool
    """

    _attribute_map = {
        'encryption_at_host': {'key': 'encryptionAtHost', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityProfile, self).__init__(**kwargs)
        self.encryption_at_host = kwargs.get('encryption_at_host', None)


class Sku(msrest.serialization.Model):
    """Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.

    :param name: The sku name.
    :type name: str
    :param tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br />`
     Possible Values::code:`<br />`:code:`<br />` **Standard**\ :code:`<br />`:code:`<br />`
     **Basic**.
    :type tier: str
    :param capacity: Specifies the number of virtual machines in the scale set.
    :type capacity: long
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)


class SshConfiguration(msrest.serialization.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :param public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :type public_keys: list[~azure.mgmt.compute.v2020_06_01.models.SshPublicKey]
    """

    _attribute_map = {
        'public_keys': {'key': 'publicKeys', 'type': '[SshPublicKey]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SshConfiguration, self).__init__(**kwargs)
        self.public_keys = kwargs.get('public_keys', None)


class SshPublicKey(msrest.serialization.Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.

    :param path: Specifies the full path on the created VM where ssh public key is stored. If the
     file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :type path: str
    :param key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
     ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in Azure
     <https://docs.microsoft.com/en-us/azure/virtual-machines/linux/mac-create-ssh-
     keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type key_data: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'key_data': {'key': 'keyData', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SshPublicKey, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)
        self.key_data = kwargs.get('key_data', None)


class SshPublicKeyGenerateKeyPairResult(msrest.serialization.Model):
    """Response from generation of an SSH key pair.

    All required parameters must be populated in order to send to Azure.

    :param private_key: Required. Private key portion of the key pair used to authenticate to a
     virtual machine through ssh. The private key is returned in RFC3447 format and should be
     treated as a secret.
    :type private_key: str
    :param public_key: Required. Public key portion of the key pair used to authenticate to a
     virtual machine through ssh. The public key is in ssh-rsa format.
    :type public_key: str
    :param id: Required. The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{SshPublicKeyName}.
    :type id: str
    """

    _validation = {
        'private_key': {'required': True},
        'public_key': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        'private_key': {'key': 'privateKey', 'type': 'str'},
        'public_key': {'key': 'publicKey', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SshPublicKeyGenerateKeyPairResult, self).__init__(**kwargs)
        self.private_key = kwargs['private_key']
        self.public_key = kwargs['public_key']
        self.id = kwargs['id']


class SshPublicKeyResource(Resource):
    """Specifies information about the SSH public key.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param public_key: SSH public key used to authenticate to a virtual machine through ssh. If
     this property is not initially provided when the resource is created, the publicKey property
     will be populated when generateKeyPair is called. If the public key is provided upon resource
     creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
    :type public_key: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'public_key': {'key': 'properties.publicKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SshPublicKeyResource, self).__init__(**kwargs)
        self.public_key = kwargs.get('public_key', None)


class SshPublicKeysGroupListResult(msrest.serialization.Model):
    """The list SSH public keys operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of SSH public keys.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.SshPublicKeyResource]
    :param next_link: The URI to fetch the next page of SSH public keys. Call ListNext() with this
     URI to fetch the next page of SSH public keys.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SshPublicKeyResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SshPublicKeysGroupListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class SshPublicKeyUpdateResource(UpdateResource):
    """Specifies information about the SSH public key.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param public_key: SSH public key used to authenticate to a virtual machine through ssh. If
     this property is not initially provided when the resource is created, the publicKey property
     will be populated when generateKeyPair is called. If the public key is provided upon resource
     creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
    :type public_key: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'public_key': {'key': 'properties.publicKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SshPublicKeyUpdateResource, self).__init__(**kwargs)
        self.public_key = kwargs.get('public_key', None)


class StorageProfile(msrest.serialization.Model):
    """Specifies the storage settings for the virtual machine disks.

    :param image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :type image_reference: ~azure.mgmt.compute.v2020_06_01.models.ImageReference
    :param os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-
     windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :type os_disk: ~azure.mgmt.compute.v2020_06_01.models.OSDisk
    :param data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-
     windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :type data_disks: list[~azure.mgmt.compute.v2020_06_01.models.DataDisk]
    """

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'os_disk': {'key': 'osDisk', 'type': 'OSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[DataDisk]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageProfile, self).__init__(**kwargs)
        self.image_reference = kwargs.get('image_reference', None)
        self.os_disk = kwargs.get('os_disk', None)
        self.data_disks = kwargs.get('data_disks', None)


class SubResourceReadOnly(msrest.serialization.Model):
    """SubResourceReadOnly.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResourceReadOnly, self).__init__(**kwargs)
        self.id = None


class SubResourceWithColocationStatus(SubResource):
    """SubResourceWithColocationStatus.

    :param id: Resource Id.
    :type id: str
    :param colocation_status: Describes colocation status of a resource in the Proximity Placement
     Group.
    :type colocation_status: ~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'colocation_status': {'key': 'colocationStatus', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResourceWithColocationStatus, self).__init__(**kwargs)
        self.colocation_status = kwargs.get('colocation_status', None)


class TerminateNotificationProfile(msrest.serialization.Model):
    """TerminateNotificationProfile.

    :param not_before_timeout: Configurable length of time a Virtual Machine being deleted will
     have to potentially approve the Terminate Scheduled Event before the event is auto approved
     (timed out). The configuration must be specified in ISO 8601 format, the default value is 5
     minutes (PT5M).
    :type not_before_timeout: str
    :param enable: Specifies whether the Terminate Scheduled event is enabled or disabled.
    :type enable: bool
    """

    _attribute_map = {
        'not_before_timeout': {'key': 'notBeforeTimeout', 'type': 'str'},
        'enable': {'key': 'enable', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TerminateNotificationProfile, self).__init__(**kwargs)
        self.not_before_timeout = kwargs.get('not_before_timeout', None)
        self.enable = kwargs.get('enable', None)


class ThrottledRequestsInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getThrottledRequests Api.

    All required parameters must be populated in order to send to Azure.

    :param blob_container_sas_uri: Required. SAS Uri of the logging blob container to which
     LogAnalytics Api writes output logs to.
    :type blob_container_sas_uri: str
    :param from_time: Required. From time of the query.
    :type from_time: ~datetime.datetime
    :param to_time: Required. To time of the query.
    :type to_time: ~datetime.datetime
    :param group_by_throttle_policy: Group query result by Throttle Policy applied.
    :type group_by_throttle_policy: bool
    :param group_by_operation_name: Group query result by Operation Name.
    :type group_by_operation_name: bool
    :param group_by_resource_name: Group query result by Resource Name.
    :type group_by_resource_name: bool
    :param group_by_client_application_id: Group query result by Client Application ID.
    :type group_by_client_application_id: bool
    :param group_by_user_agent: Group query result by User Agent.
    :type group_by_user_agent: bool
    """

    _validation = {
        'blob_container_sas_uri': {'required': True},
        'from_time': {'required': True},
        'to_time': {'required': True},
    }

    _attribute_map = {
        'blob_container_sas_uri': {'key': 'blobContainerSasUri', 'type': 'str'},
        'from_time': {'key': 'fromTime', 'type': 'iso-8601'},
        'to_time': {'key': 'toTime', 'type': 'iso-8601'},
        'group_by_throttle_policy': {'key': 'groupByThrottlePolicy', 'type': 'bool'},
        'group_by_operation_name': {'key': 'groupByOperationName', 'type': 'bool'},
        'group_by_resource_name': {'key': 'groupByResourceName', 'type': 'bool'},
        'group_by_client_application_id': {'key': 'groupByClientApplicationId', 'type': 'bool'},
        'group_by_user_agent': {'key': 'groupByUserAgent', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ThrottledRequestsInput, self).__init__(**kwargs)


class UpgradeOperationHistoricalStatusInfo(msrest.serialization.Model):
    """Virtual Machine Scale Set OS Upgrade History operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Information about the properties of the upgrade operation.
    :vartype properties:
     ~azure.mgmt.compute.v2020_06_01.models.UpgradeOperationHistoricalStatusInfoProperties
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    """

    _validation = {
        'properties': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UpgradeOperationHistoricalStatusInfoProperties'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradeOperationHistoricalStatusInfo, self).__init__(**kwargs)
        self.properties = None
        self.type = None
        self.location = None


class UpgradeOperationHistoricalStatusInfoProperties(msrest.serialization.Model):
    """Describes each OS upgrade on the Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar running_status: Information about the overall status of the upgrade operation.
    :vartype running_status: ~azure.mgmt.compute.v2020_06_01.models.UpgradeOperationHistoryStatus
    :ivar progress: Counts of the VMs in each state.
    :vartype progress: ~azure.mgmt.compute.v2020_06_01.models.RollingUpgradeProgressInfo
    :ivar error: Error Details for this upgrade if there are any.
    :vartype error: ~azure.mgmt.compute.v2020_06_01.models.ApiError
    :ivar started_by: Invoker of the Upgrade Operation. Possible values include: "Unknown", "User",
     "Platform".
    :vartype started_by: str or ~azure.mgmt.compute.v2020_06_01.models.UpgradeOperationInvoker
    :ivar target_image_reference: Image Reference details.
    :vartype target_image_reference: ~azure.mgmt.compute.v2020_06_01.models.ImageReference
    :ivar rollback_info: Information about OS rollback if performed.
    :vartype rollback_info: ~azure.mgmt.compute.v2020_06_01.models.RollbackStatusInfo
    """

    _validation = {
        'running_status': {'readonly': True},
        'progress': {'readonly': True},
        'error': {'readonly': True},
        'started_by': {'readonly': True},
        'target_image_reference': {'readonly': True},
        'rollback_info': {'readonly': True},
    }

    _attribute_map = {
        'running_status': {'key': 'runningStatus', 'type': 'UpgradeOperationHistoryStatus'},
        'progress': {'key': 'progress', 'type': 'RollingUpgradeProgressInfo'},
        'error': {'key': 'error', 'type': 'ApiError'},
        'started_by': {'key': 'startedBy', 'type': 'str'},
        'target_image_reference': {'key': 'targetImageReference', 'type': 'ImageReference'},
        'rollback_info': {'key': 'rollbackInfo', 'type': 'RollbackStatusInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradeOperationHistoricalStatusInfoProperties, self).__init__(**kwargs)
        self.running_status = None
        self.progress = None
        self.error = None
        self.started_by = None
        self.target_image_reference = None
        self.rollback_info = None


class UpgradeOperationHistoryStatus(msrest.serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Possible values include:
     "RollingForward", "Cancelled", "Completed", "Faulted".
    :vartype code: str or ~azure.mgmt.compute.v2020_06_01.models.UpgradeState
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the upgrade.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        'code': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradeOperationHistoryStatus, self).__init__(**kwargs)
        self.code = None
        self.start_time = None
        self.end_time = None


class UpgradePolicy(msrest.serialization.Model):
    """Describes an upgrade policy - automatic, manual, or rolling.

    :param mode: Specifies the mode of an upgrade to virtual machines in the scale set.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
     the application of updates to virtual machines in the scale set. You do this by using the
     manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual machines in the
     scale set are  automatically updated at the same time. Possible values include: "Automatic",
     "Manual", "Rolling".
    :type mode: str or ~azure.mgmt.compute.v2020_06_01.models.UpgradeMode
    :param rolling_upgrade_policy: The configuration parameters used while performing a rolling
     upgrade.
    :type rolling_upgrade_policy: ~azure.mgmt.compute.v2020_06_01.models.RollingUpgradePolicy
    :param automatic_os_upgrade_policy: Configuration parameters used for performing automatic OS
     Upgrade.
    :type automatic_os_upgrade_policy:
     ~azure.mgmt.compute.v2020_06_01.models.AutomaticOSUpgradePolicy
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'rolling_upgrade_policy': {'key': 'rollingUpgradePolicy', 'type': 'RollingUpgradePolicy'},
        'automatic_os_upgrade_policy': {'key': 'automaticOSUpgradePolicy', 'type': 'AutomaticOSUpgradePolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradePolicy, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.rolling_upgrade_policy = kwargs.get('rolling_upgrade_policy', None)
        self.automatic_os_upgrade_policy = kwargs.get('automatic_os_upgrade_policy', None)


class Usage(msrest.serialization.Model):
    """Describes Compute Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar unit: Required. An enum describing the unit of usage measurement. Default value: "Count".
    :vartype unit: str
    :param current_value: Required. The current usage of the resource.
    :type current_value: int
    :param limit: Required. The maximum permitted usage of the resource.
    :type limit: long
    :param name: Required. The name of the type of usage.
    :type name: ~azure.mgmt.compute.v2020_06_01.models.UsageName
    """

    _validation = {
        'unit': {'required': True, 'constant': True},
        'current_value': {'required': True},
        'limit': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    unit = "Count"

    def __init__(
        self,
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.current_value = kwargs['current_value']
        self.limit = kwargs['limit']
        self.name = kwargs['name']


class UsageName(msrest.serialization.Model):
    """The Usage Names.

    :param value: The name of the resource.
    :type value: str
    :param localized_value: The localized name of the resource.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageName, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class UserAssignedIdentitiesValue(msrest.serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VaultCertificate(msrest.serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.

    :param certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`  "data":":code:`<Base64-encoded-
     certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`  "password":":code:`<pfx-file-
     password>`":code:`<br>`}.
    :type certificate_url: str
    :param certificate_store: For Windows VMs, specifies the certificate store on the Virtual
     Machine to which the certificate should be added. The specified certificate store is implicitly
     in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate file is
     placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt
     for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of
     these files are .pem formatted.
    :type certificate_store: str
    """

    _attribute_map = {
        'certificate_url': {'key': 'certificateUrl', 'type': 'str'},
        'certificate_store': {'key': 'certificateStore', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VaultCertificate, self).__init__(**kwargs)
        self.certificate_url = kwargs.get('certificate_url', None)
        self.certificate_store = kwargs.get('certificate_store', None)


class VaultSecretGroup(msrest.serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :param source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :type source_vault: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :type vault_certificates: list[~azure.mgmt.compute.v2020_06_01.models.VaultCertificate]
    """

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
        'vault_certificates': {'key': 'vaultCertificates', 'type': '[VaultCertificate]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VaultSecretGroup, self).__init__(**kwargs)
        self.source_vault = kwargs.get('source_vault', None)
        self.vault_certificates = kwargs.get('vault_certificates', None)


class VirtualHardDisk(msrest.serialization.Model):
    """Describes the uri of a disk.

    :param uri: Specifies the virtual hard disk's uri.
    :type uri: str
    """

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualHardDisk, self).__init__(**kwargs)
        self.uri = kwargs.get('uri', None)


class VirtualMachine(Resource):
    """Describes a Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :type plan: ~azure.mgmt.compute.v2020_06_01.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineExtension]
    :param identity: The identity of the virtual machine, if configured.
    :type identity: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineIdentity
    :param zones: The virtual machine zones.
    :type zones: list[str]
    :param hardware_profile: Specifies the hardware settings for the virtual machine.
    :type hardware_profile: ~azure.mgmt.compute.v2020_06_01.models.HardwareProfile
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2020_06_01.models.StorageProfile
    :param additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine.
    :type additional_capabilities: ~azure.mgmt.compute.v2020_06_01.models.AdditionalCapabilities
    :param os_profile: Specifies the operating system settings used while creating the virtual
     machine. Some of the settings cannot be changed once VM is provisioned.
    :type os_profile: ~azure.mgmt.compute.v2020_06_01.models.OSProfile
    :param network_profile: Specifies the network interfaces of the virtual machine.
    :type network_profile: ~azure.mgmt.compute.v2020_06_01.models.NetworkProfile
    :param security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :type security_profile: ~azure.mgmt.compute.v2020_06_01.models.SecurityProfile
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :type diagnostics_profile: ~azure.mgmt.compute.v2020_06_01.models.DiagnosticsProfile
    :param availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Manage the availability of virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-
     availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_. :code:`<br>`:code:`<br>`
     For more information on Azure planned maintenance, see `Planned maintenance for virtual
     machines in Azure <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-
     planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. The availability set to which the VM is being added should be under the same resource
     group as the availability set resource. An existing VM cannot be added to an availability set.
     :code:`<br>`:code:`<br>`This property cannot exist along with a non-null
     properties.virtualMachineScaleSet reference.
    :type availability_set: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param virtual_machine_scale_set: Specifies information about the virtual machine scale set
     that the virtual machine should be assigned to. Virtual machines specified in the same virtual
     machine scale set are allocated to different nodes to maximize availability. Currently, a VM
     can only be added to virtual machine scale set at creation time. An existing VM cannot be added
     to a virtual machine scale set. :code:`<br>`:code:`<br>`This property cannot exist along with a
     non-null properties.availabilitySet reference. :code:`<br>`:code:`<br>`Minimum api‐version:
     2019‐03‐01.
    :type virtual_machine_scale_set: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param priority: Specifies the priority for the virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01. Possible values include: "Regular",
     "Low", "Spot".
    :type priority: str or ~azure.mgmt.compute.v2020_06_01.models.VirtualMachinePriorityTypes
    :param eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
     :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
     and the minimum api-version is 2017-10-30-preview. Possible values include: "Deallocate",
     "Delete".
    :type eviction_policy: str or
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineEvictionPolicyTypes
    :param billing_profile: Specifies the billing related details of a Azure Spot virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :type billing_profile: ~azure.mgmt.compute.v2020_06_01.models.BillingProfile
    :param host: Specifies information about the dedicated host that the virtual machine resides
     in. :code:`<br>`:code:`<br>`Minimum api-version: 2018-10-01.
    :type host: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param host_group: Specifies information about the dedicated host group that the virtual
     machine resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
     :code:`<br>`:code:`<br>`NOTE: User cannot specify both host and hostGroup properties.
    :type host_group: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineInstanceView
    :param license_type: Specifies that the image or disk that is being used was licensed on-
     premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    :param extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
     api-version: 2020-06-01.
    :type extensions_time_budget: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'resources': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
        'vm_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'resources': {'key': 'resources', 'type': '[VirtualMachineExtension]'},
        'identity': {'key': 'identity', 'type': 'VirtualMachineIdentity'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'additional_capabilities': {'key': 'properties.additionalCapabilities', 'type': 'AdditionalCapabilities'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'security_profile': {'key': 'properties.securityProfile', 'type': 'SecurityProfile'},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'availability_set': {'key': 'properties.availabilitySet', 'type': 'SubResource'},
        'virtual_machine_scale_set': {'key': 'properties.virtualMachineScaleSet', 'type': 'SubResource'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'priority': {'key': 'properties.priority', 'type': 'str'},
        'eviction_policy': {'key': 'properties.evictionPolicy', 'type': 'str'},
        'billing_profile': {'key': 'properties.billingProfile', 'type': 'BillingProfile'},
        'host': {'key': 'properties.host', 'type': 'SubResource'},
        'host_group': {'key': 'properties.hostGroup', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineInstanceView'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
        'extensions_time_budget': {'key': 'properties.extensionsTimeBudget', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachine, self).__init__(**kwargs)
        self.plan = kwargs.get('plan', None)
        self.resources = None
        self.identity = kwargs.get('identity', None)
        self.zones = kwargs.get('zones', None)
        self.hardware_profile = kwargs.get('hardware_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.additional_capabilities = kwargs.get('additional_capabilities', None)
        self.os_profile = kwargs.get('os_profile', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.security_profile = kwargs.get('security_profile', None)
        self.diagnostics_profile = kwargs.get('diagnostics_profile', None)
        self.availability_set = kwargs.get('availability_set', None)
        self.virtual_machine_scale_set = kwargs.get('virtual_machine_scale_set', None)
        self.proximity_placement_group = kwargs.get('proximity_placement_group', None)
        self.priority = kwargs.get('priority', None)
        self.eviction_policy = kwargs.get('eviction_policy', None)
        self.billing_profile = kwargs.get('billing_profile', None)
        self.host = kwargs.get('host', None)
        self.host_group = kwargs.get('host_group', None)
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = kwargs.get('license_type', None)
        self.vm_id = None
        self.extensions_time_budget = kwargs.get('extensions_time_budget', None)


class VirtualMachineAgentInstanceView(msrest.serialization.Model):
    """The instance view of the VM Agent running on the virtual machine.

    :param vm_agent_version: The VM Agent full version.
    :type vm_agent_version: str
    :param extension_handlers: The virtual machine extension handler instance view.
    :type extension_handlers:
     list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineExtensionHandlerInstanceView]
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'vm_agent_version': {'key': 'vmAgentVersion', 'type': 'str'},
        'extension_handlers': {'key': 'extensionHandlers', 'type': '[VirtualMachineExtensionHandlerInstanceView]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineAgentInstanceView, self).__init__(**kwargs)
        self.vm_agent_version = kwargs.get('vm_agent_version', None)
        self.extension_handlers = kwargs.get('extension_handlers', None)
        self.statuses = kwargs.get('statuses', None)


class VirtualMachineAssessPatchesResult(msrest.serialization.Model):
    """Describes the properties of an AssessPatches result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Failed", "Succeeded", or
     "CompletedWithWarnings.". Possible values include: "InProgress", "Failed", "Succeeded",
     "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.v2020_06_01.models.PatchOperationStatus
    :ivar assessment_activity_id: The activity ID of the operation that produced this result. It is
     used to correlate across CRP and extension logs.
    :vartype assessment_activity_id: str
    :ivar reboot_pending: The overall reboot status of the VM. It will be true when partially
     installed patches require a reboot to complete installation but the reboot has not yet
     occurred.
    :vartype reboot_pending: bool
    :ivar critical_and_security_patch_count: The number of critical or security patches that have
     been detected as available and not yet installed.
    :vartype critical_and_security_patch_count: int
    :ivar other_patch_count: The number of all available patches excluding critical and security.
    :vartype other_patch_count: int
    :ivar start_date_time: The UTC timestamp when the operation began.
    :vartype start_date_time: ~datetime.datetime
    :ivar patches: The list of patches that have been detected as available for installation.
    :vartype patches:
     list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineSoftwarePatchProperties]
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.v2020_06_01.models.ApiError
    """

    _validation = {
        'status': {'readonly': True},
        'assessment_activity_id': {'readonly': True},
        'reboot_pending': {'readonly': True},
        'critical_and_security_patch_count': {'readonly': True},
        'other_patch_count': {'readonly': True},
        'start_date_time': {'readonly': True},
        'patches': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'assessment_activity_id': {'key': 'assessmentActivityId', 'type': 'str'},
        'reboot_pending': {'key': 'rebootPending', 'type': 'bool'},
        'critical_and_security_patch_count': {'key': 'criticalAndSecurityPatchCount', 'type': 'int'},
        'other_patch_count': {'key': 'otherPatchCount', 'type': 'int'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'patches': {'key': 'patches', 'type': '[VirtualMachineSoftwarePatchProperties]'},
        'error': {'key': 'error', 'type': 'ApiError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineAssessPatchesResult, self).__init__(**kwargs)
        self.status = None
        self.assessment_activity_id = None
        self.reboot_pending = None
        self.critical_and_security_patch_count = None
        self.other_patch_count = None
        self.start_date_time = None
        self.patches = None
        self.error = None


class VirtualMachineCaptureParameters(msrest.serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :param vhd_prefix: Required. The captured virtual hard disk's name prefix.
    :type vhd_prefix: str
    :param destination_container_name: Required. The destination container name.
    :type destination_container_name: str
    :param overwrite_vhds: Required. Specifies whether to overwrite the destination virtual hard
     disk, in case of conflict.
    :type overwrite_vhds: bool
    """

    _validation = {
        'vhd_prefix': {'required': True},
        'destination_container_name': {'required': True},
        'overwrite_vhds': {'required': True},
    }

    _attribute_map = {
        'vhd_prefix': {'key': 'vhdPrefix', 'type': 'str'},
        'destination_container_name': {'key': 'destinationContainerName', 'type': 'str'},
        'overwrite_vhds': {'key': 'overwriteVhds', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineCaptureParameters, self).__init__(**kwargs)
        self.vhd_prefix = kwargs['vhd_prefix']
        self.destination_container_name = kwargs['destination_container_name']
        self.overwrite_vhds = kwargs['overwrite_vhds']


class VirtualMachineCaptureResult(SubResource):
    """Output of virtual machine capture operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Id.
    :type id: str
    :ivar schema: the schema of the captured virtual machine.
    :vartype schema: str
    :ivar content_version: the version of the content.
    :vartype content_version: str
    :ivar parameters: parameters of the captured virtual machine.
    :vartype parameters: object
    :ivar resources: a list of resource items of the captured virtual machine.
    :vartype resources: list[object]
    """

    _validation = {
        'schema': {'readonly': True},
        'content_version': {'readonly': True},
        'parameters': {'readonly': True},
        'resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'schema': {'key': '$schema', 'type': 'str'},
        'content_version': {'key': 'contentVersion', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'resources': {'key': 'resources', 'type': '[object]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineCaptureResult, self).__init__(**kwargs)
        self.schema = None
        self.content_version = None
        self.parameters = None
        self.resources = None


class VirtualMachineExtension(Resource):
    """Describes a Virtual Machine Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type_properties_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :type enable_automatic_upgrade: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param instance_view: The virtual machine extension instance view.
    :type instance_view: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineExtensionInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineExtensionInstanceView'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineExtension, self).__init__(**kwargs)
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.enable_automatic_upgrade = kwargs.get('enable_automatic_upgrade', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)
        self.provisioning_state = None
        self.instance_view = kwargs.get('instance_view', None)


class VirtualMachineExtensionHandlerInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine extension handler.

    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param status: The extension handler status.
    :type status: ~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'status': {'key': 'status', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineExtensionHandlerInstanceView, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.status = kwargs.get('status', None)


class VirtualMachineExtensionImage(Resource):
    """Describes a Virtual Machine Extension Image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param operating_system: The operating system this extension supports.
    :type operating_system: str
    :param compute_role: The type of role (IaaS or PaaS) this extension supports.
    :type compute_role: str
    :param handler_schema: The schema defined by publisher, where extension consumers should
     provide settings in a matching schema.
    :type handler_schema: str
    :param vm_scale_set_enabled: Whether the extension can be used on xRP VMScaleSets. By default
     existing extensions are usable on scalesets, but there might be cases where a publisher wants
     to explicitly indicate the extension is only enabled for CRP VMs but not VMSS.
    :type vm_scale_set_enabled: bool
    :param supports_multiple_extensions: Whether the handler can support multiple extensions.
    :type supports_multiple_extensions: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'operating_system': {'key': 'properties.operatingSystem', 'type': 'str'},
        'compute_role': {'key': 'properties.computeRole', 'type': 'str'},
        'handler_schema': {'key': 'properties.handlerSchema', 'type': 'str'},
        'vm_scale_set_enabled': {'key': 'properties.vmScaleSetEnabled', 'type': 'bool'},
        'supports_multiple_extensions': {'key': 'properties.supportsMultipleExtensions', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineExtensionImage, self).__init__(**kwargs)
        self.operating_system = kwargs.get('operating_system', None)
        self.compute_role = kwargs.get('compute_role', None)
        self.handler_schema = kwargs.get('handler_schema', None)
        self.vm_scale_set_enabled = kwargs.get('vm_scale_set_enabled', None)
        self.supports_multiple_extensions = kwargs.get('supports_multiple_extensions', None)


class VirtualMachineExtensionInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine extension.

    :param name: The virtual machine extension name.
    :type name: str
    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param substatuses: The resource status information.
    :type substatuses: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'substatuses': {'key': 'substatuses', 'type': '[InstanceViewStatus]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineExtensionInstanceView, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.substatuses = kwargs.get('substatuses', None)
        self.statuses = kwargs.get('statuses', None)


class VirtualMachineExtensionsListResult(msrest.serialization.Model):
    """The List Extension operation response.

    :param value: The list of extensions.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineExtension]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineExtension]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineExtensionsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class VirtualMachineExtensionUpdate(UpdateResource):
    """Describes a Virtual Machine Extension.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :type enable_automatic_upgrade: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: object
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineExtensionUpdate, self).__init__(**kwargs)
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.enable_automatic_upgrade = kwargs.get('enable_automatic_upgrade', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)


class VirtualMachineHealthStatus(msrest.serialization.Model):
    """The health status of the VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The health status information for the VM.
    :vartype status: ~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus
    """

    _validation = {
        'status': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineHealthStatus, self).__init__(**kwargs)
        self.status = None


class VirtualMachineIdentity(msrest.serialization.Model):
    """Identity for the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the virtual machine. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of user assigned
     identities. The type 'None' will remove any identities from the virtual machine. Possible
     values include: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type type: str or ~azure.mgmt.compute.v2020_06_01.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated with the Virtual
     Machine. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.compute.v2020_06_01.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentitiesValue}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class VirtualMachineImageResource(SubResource):
    """Virtual machine image resource information.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The name of the resource.
    :type name: str
    :param location: Required. The supported Azure location of the resource.
    :type location: str
    :param tags: A set of tags. Specifies the tags that are assigned to the virtual machine. For
     more information about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :type tags: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineImageResource, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class VirtualMachineImage(VirtualMachineImageResource):
    """Describes a Virtual Machine Image.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The name of the resource.
    :type name: str
    :param location: Required. The supported Azure location of the resource.
    :type location: str
    :param tags: A set of tags. Specifies the tags that are assigned to the virtual machine. For
     more information about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :type tags: dict[str, str]
    :param plan: Used for establishing the purchase context of any 3rd Party artifact through
     MarketPlace.
    :type plan: ~azure.mgmt.compute.v2020_06_01.models.PurchasePlan
    :param os_disk_image: Contains the os disk image information.
    :type os_disk_image: ~azure.mgmt.compute.v2020_06_01.models.OSDiskImage
    :param data_disk_images:
    :type data_disk_images: list[~azure.mgmt.compute.v2020_06_01.models.DataDiskImage]
    :param automatic_os_upgrade_properties: Describes automatic OS upgrade properties on the image.
    :type automatic_os_upgrade_properties:
     ~azure.mgmt.compute.v2020_06_01.models.AutomaticOSUpgradeProperties
    :param hyper_v_generation: Specifies the HyperVGeneration Type. Possible values include: "V1",
     "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2020_06_01.models.HyperVGenerationTypes
    :param disallowed: Specifies disallowed configuration for the VirtualMachine created from the
     image.
    :type disallowed: ~azure.mgmt.compute.v2020_06_01.models.DisallowedConfiguration
    """

    _validation = {
        'name': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'properties.plan', 'type': 'PurchasePlan'},
        'os_disk_image': {'key': 'properties.osDiskImage', 'type': 'OSDiskImage'},
        'data_disk_images': {'key': 'properties.dataDiskImages', 'type': '[DataDiskImage]'},
        'automatic_os_upgrade_properties': {'key': 'properties.automaticOSUpgradeProperties', 'type': 'AutomaticOSUpgradeProperties'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'disallowed': {'key': 'properties.disallowed', 'type': 'DisallowedConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineImage, self).__init__(**kwargs)
        self.plan = kwargs.get('plan', None)
        self.os_disk_image = kwargs.get('os_disk_image', None)
        self.data_disk_images = kwargs.get('data_disk_images', None)
        self.automatic_os_upgrade_properties = kwargs.get('automatic_os_upgrade_properties', None)
        self.hyper_v_generation = kwargs.get('hyper_v_generation', None)
        self.disallowed = kwargs.get('disallowed', None)


class VirtualMachineInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param platform_update_domain: Specifies the update domain of the virtual machine.
    :type platform_update_domain: int
    :param platform_fault_domain: Specifies the fault domain of the virtual machine.
    :type platform_fault_domain: int
    :param computer_name: The computer name assigned to the virtual machine.
    :type computer_name: str
    :param os_name: The Operating System running on the virtual machine.
    :type os_name: str
    :param os_version: The version of Operating System running on the virtual machine.
    :type os_version: str
    :param hyper_v_generation: Specifies the HyperVGeneration Type associated with a resource.
     Possible values include: "V1", "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2020_06_01.models.HyperVGenerationType
    :param rdp_thumb_print: The Remote desktop certificate thumbprint.
    :type rdp_thumb_print: str
    :param vm_agent: The VM Agent running on the virtual machine.
    :type vm_agent: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineAgentInstanceView
    :param maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
    :type maintenance_redeploy_status:
     ~azure.mgmt.compute.v2020_06_01.models.MaintenanceRedeployStatus
    :param disks: The virtual machine disk information.
    :type disks: list[~azure.mgmt.compute.v2020_06_01.models.DiskInstanceView]
    :param extensions: The extensions information.
    :type extensions:
     list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineExtensionInstanceView]
    :ivar vm_health: The health status for the VM.
    :vartype vm_health: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineHealthStatus
    :param boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :type boot_diagnostics: ~azure.mgmt.compute.v2020_06_01.models.BootDiagnosticsInstanceView
    :ivar assigned_host: Resource id of the dedicated host, on which the virtual machine is
     allocated through automatic placement, when the virtual machine is associated with a dedicated
     host group that has automatic placement enabled. :code:`<br>`:code:`<br>`Minimum api-version:
     2020-06-01.
    :vartype assigned_host: str
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    :param patch_status: The status of virtual machine patch operations.
    :type patch_status: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachinePatchStatus
    """

    _validation = {
        'vm_health': {'readonly': True},
        'assigned_host': {'readonly': True},
    }

    _attribute_map = {
        'platform_update_domain': {'key': 'platformUpdateDomain', 'type': 'int'},
        'platform_fault_domain': {'key': 'platformFaultDomain', 'type': 'int'},
        'computer_name': {'key': 'computerName', 'type': 'str'},
        'os_name': {'key': 'osName', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
        'hyper_v_generation': {'key': 'hyperVGeneration', 'type': 'str'},
        'rdp_thumb_print': {'key': 'rdpThumbPrint', 'type': 'str'},
        'vm_agent': {'key': 'vmAgent', 'type': 'VirtualMachineAgentInstanceView'},
        'maintenance_redeploy_status': {'key': 'maintenanceRedeployStatus', 'type': 'MaintenanceRedeployStatus'},
        'disks': {'key': 'disks', 'type': '[DiskInstanceView]'},
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineExtensionInstanceView]'},
        'vm_health': {'key': 'vmHealth', 'type': 'VirtualMachineHealthStatus'},
        'boot_diagnostics': {'key': 'bootDiagnostics', 'type': 'BootDiagnosticsInstanceView'},
        'assigned_host': {'key': 'assignedHost', 'type': 'str'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
        'patch_status': {'key': 'patchStatus', 'type': 'VirtualMachinePatchStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineInstanceView, self).__init__(**kwargs)
        self.platform_update_domain = kwargs.get('platform_update_domain', None)
        self.platform_fault_domain = kwargs.get('platform_fault_domain', None)
        self.computer_name = kwargs.get('computer_name', None)
        self.os_name = kwargs.get('os_name', None)
        self.os_version = kwargs.get('os_version', None)
        self.hyper_v_generation = kwargs.get('hyper_v_generation', None)
        self.rdp_thumb_print = kwargs.get('rdp_thumb_print', None)
        self.vm_agent = kwargs.get('vm_agent', None)
        self.maintenance_redeploy_status = kwargs.get('maintenance_redeploy_status', None)
        self.disks = kwargs.get('disks', None)
        self.extensions = kwargs.get('extensions', None)
        self.vm_health = None
        self.boot_diagnostics = kwargs.get('boot_diagnostics', None)
        self.assigned_host = None
        self.statuses = kwargs.get('statuses', None)
        self.patch_status = kwargs.get('patch_status', None)


class VirtualMachineListResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machines.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachine]
    :param next_link: The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch
     the next page of Virtual Machines.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachine]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class VirtualMachinePatchStatus(msrest.serialization.Model):
    """The status of virtual machine patch operations.

    :param available_patch_summary: The available patch summary of the latest assessment operation
     for the virtual machine.
    :type available_patch_summary: ~azure.mgmt.compute.v2020_06_01.models.AvailablePatchSummary
    :param last_patch_installation_summary: The installation summary of the latest installation
     operation for the virtual machine.
    :type last_patch_installation_summary:
     ~azure.mgmt.compute.v2020_06_01.models.LastPatchInstallationSummary
    """

    _attribute_map = {
        'available_patch_summary': {'key': 'availablePatchSummary', 'type': 'AvailablePatchSummary'},
        'last_patch_installation_summary': {'key': 'lastPatchInstallationSummary', 'type': 'LastPatchInstallationSummary'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachinePatchStatus, self).__init__(**kwargs)
        self.available_patch_summary = kwargs.get('available_patch_summary', None)
        self.last_patch_installation_summary = kwargs.get('last_patch_installation_summary', None)


class VirtualMachineReimageParameters(msrest.serialization.Model):
    """Parameters for Reimaging Virtual Machine. NOTE: Virtual Machine OS disk will always be reimaged.

    :param temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This temp
     disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
    :type temp_disk: bool
    """

    _attribute_map = {
        'temp_disk': {'key': 'tempDisk', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineReimageParameters, self).__init__(**kwargs)
        self.temp_disk = kwargs.get('temp_disk', None)


class VirtualMachineRunCommand(Resource):
    """Describes a Virtual Machine run command.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param source: The source of the run command script.
    :type source: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineRunCommandScriptSource
    :param parameters: The parameters used by the script.
    :type parameters: list[~azure.mgmt.compute.v2020_06_01.models.RunCommandInputParameter]
    :param protected_parameters: The parameters used by the script.
    :type protected_parameters:
     list[~azure.mgmt.compute.v2020_06_01.models.RunCommandInputParameter]
    :param async_execution: Optional. If set to true, provisioning will complete as soon as the
     script starts and will not wait for script to complete.
    :type async_execution: bool
    :param run_as_user: Specifies the user account on the VM when executing the run command.
    :type run_as_user: str
    :param run_as_password: Specifies the user account password on the VM when executing the run
     command.
    :type run_as_password: str
    :param timeout_in_seconds: The timeout in seconds to execute the run command.
    :type timeout_in_seconds: int
    :param output_blob_uri: Specifies the Azure storage blob where script output stream will be
     uploaded.
    :type output_blob_uri: str
    :param error_blob_uri: Specifies the Azure storage blob where script error stream will be
     uploaded.
    :type error_blob_uri: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine run command instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineRunCommandInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'VirtualMachineRunCommandScriptSource'},
        'parameters': {'key': 'properties.parameters', 'type': '[RunCommandInputParameter]'},
        'protected_parameters': {'key': 'properties.protectedParameters', 'type': '[RunCommandInputParameter]'},
        'async_execution': {'key': 'properties.asyncExecution', 'type': 'bool'},
        'run_as_user': {'key': 'properties.runAsUser', 'type': 'str'},
        'run_as_password': {'key': 'properties.runAsPassword', 'type': 'str'},
        'timeout_in_seconds': {'key': 'properties.timeoutInSeconds', 'type': 'int'},
        'output_blob_uri': {'key': 'properties.outputBlobUri', 'type': 'str'},
        'error_blob_uri': {'key': 'properties.errorBlobUri', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineRunCommandInstanceView'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineRunCommand, self).__init__(**kwargs)
        self.source = kwargs.get('source', None)
        self.parameters = kwargs.get('parameters', None)
        self.protected_parameters = kwargs.get('protected_parameters', None)
        self.async_execution = kwargs.get('async_execution', False)
        self.run_as_user = kwargs.get('run_as_user', None)
        self.run_as_password = kwargs.get('run_as_password', None)
        self.timeout_in_seconds = kwargs.get('timeout_in_seconds', None)
        self.output_blob_uri = kwargs.get('output_blob_uri', None)
        self.error_blob_uri = kwargs.get('error_blob_uri', None)
        self.provisioning_state = None
        self.instance_view = None


class VirtualMachineRunCommandInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine run command.

    :param execution_state: Script execution status. Possible values include: "Unknown", "Pending",
     "Running", "Failed", "Succeeded", "TimedOut", "Canceled".
    :type execution_state: str or ~azure.mgmt.compute.v2020_06_01.models.ExecutionState
    :param execution_message: Communicate script configuration errors or execution messages.
    :type execution_message: str
    :param exit_code: Exit code returned from script execution.
    :type exit_code: int
    :param output: Script output stream.
    :type output: str
    :param error: Script error stream.
    :type error: str
    :param start_time: Script start time.
    :type start_time: ~datetime.datetime
    :param end_time: Script end time.
    :type end_time: ~datetime.datetime
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'execution_state': {'key': 'executionState', 'type': 'str'},
        'execution_message': {'key': 'executionMessage', 'type': 'str'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'output': {'key': 'output', 'type': 'str'},
        'error': {'key': 'error', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineRunCommandInstanceView, self).__init__(**kwargs)
        self.execution_state = kwargs.get('execution_state', None)
        self.execution_message = kwargs.get('execution_message', None)
        self.exit_code = kwargs.get('exit_code', None)
        self.output = kwargs.get('output', None)
        self.error = kwargs.get('error', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.statuses = kwargs.get('statuses', None)


class VirtualMachineRunCommandScriptSource(msrest.serialization.Model):
    """Describes the script sources for run command.

    :param script: Specifies the script content to be executed on the VM.
    :type script: str
    :param script_uri: Specifies the script download location.
    :type script_uri: str
    :param command_id: Specifies a commandId of predefined built-in script.
    :type command_id: str
    """

    _attribute_map = {
        'script': {'key': 'script', 'type': 'str'},
        'script_uri': {'key': 'scriptUri', 'type': 'str'},
        'command_id': {'key': 'commandId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineRunCommandScriptSource, self).__init__(**kwargs)
        self.script = kwargs.get('script', None)
        self.script_uri = kwargs.get('script_uri', None)
        self.command_id = kwargs.get('command_id', None)


class VirtualMachineRunCommandsListResult(msrest.serialization.Model):
    """The List run command operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of run commands.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineRunCommand]
    :param next_link: The uri to fetch the next page of run commands.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineRunCommand]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineRunCommandsListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class VirtualMachineRunCommandUpdate(UpdateResource):
    """Describes a Virtual Machine run command.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param source: The source of the run command script.
    :type source: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineRunCommandScriptSource
    :param parameters: The parameters used by the script.
    :type parameters: list[~azure.mgmt.compute.v2020_06_01.models.RunCommandInputParameter]
    :param protected_parameters: The parameters used by the script.
    :type protected_parameters:
     list[~azure.mgmt.compute.v2020_06_01.models.RunCommandInputParameter]
    :param async_execution: Optional. If set to true, provisioning will complete as soon as the
     script starts and will not wait for script to complete.
    :type async_execution: bool
    :param run_as_user: Specifies the user account on the VM when executing the run command.
    :type run_as_user: str
    :param run_as_password: Specifies the user account password on the VM when executing the run
     command.
    :type run_as_password: str
    :param timeout_in_seconds: The timeout in seconds to execute the run command.
    :type timeout_in_seconds: int
    :param output_blob_uri: Specifies the Azure storage blob where script output stream will be
     uploaded.
    :type output_blob_uri: str
    :param error_blob_uri: Specifies the Azure storage blob where script error stream will be
     uploaded.
    :type error_blob_uri: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine run command instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineRunCommandInstanceView
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'VirtualMachineRunCommandScriptSource'},
        'parameters': {'key': 'properties.parameters', 'type': '[RunCommandInputParameter]'},
        'protected_parameters': {'key': 'properties.protectedParameters', 'type': '[RunCommandInputParameter]'},
        'async_execution': {'key': 'properties.asyncExecution', 'type': 'bool'},
        'run_as_user': {'key': 'properties.runAsUser', 'type': 'str'},
        'run_as_password': {'key': 'properties.runAsPassword', 'type': 'str'},
        'timeout_in_seconds': {'key': 'properties.timeoutInSeconds', 'type': 'int'},
        'output_blob_uri': {'key': 'properties.outputBlobUri', 'type': 'str'},
        'error_blob_uri': {'key': 'properties.errorBlobUri', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineRunCommandInstanceView'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineRunCommandUpdate, self).__init__(**kwargs)
        self.source = kwargs.get('source', None)
        self.parameters = kwargs.get('parameters', None)
        self.protected_parameters = kwargs.get('protected_parameters', None)
        self.async_execution = kwargs.get('async_execution', False)
        self.run_as_user = kwargs.get('run_as_user', None)
        self.run_as_password = kwargs.get('run_as_password', None)
        self.timeout_in_seconds = kwargs.get('timeout_in_seconds', None)
        self.output_blob_uri = kwargs.get('output_blob_uri', None)
        self.error_blob_uri = kwargs.get('error_blob_uri', None)
        self.provisioning_state = None
        self.instance_view = None


class VirtualMachineScaleSet(Resource):
    """Describes a Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The virtual machine scale set sku.
    :type sku: ~azure.mgmt.compute.v2020_06_01.models.Sku
    :param plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :type plan: ~azure.mgmt.compute.v2020_06_01.models.Plan
    :param identity: The identity of the virtual machine scale set, if configured.
    :type identity: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetIdentity
    :param zones: The virtual machine scale set zones. NOTE: Availability zones can only be set
     when you create the scale set.
    :type zones: list[str]
    :param upgrade_policy: The upgrade policy.
    :type upgrade_policy: ~azure.mgmt.compute.v2020_06_01.models.UpgradePolicy
    :param automatic_repairs_policy: Policy for automatic repairs.
    :type automatic_repairs_policy: ~azure.mgmt.compute.v2020_06_01.models.AutomaticRepairsPolicy
    :param virtual_machine_profile: The virtual machine profile.
    :type virtual_machine_profile:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetVMProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param overprovision: Specifies whether the Virtual Machine Scale Set should be
     overprovisioned.
    :type overprovision: bool
    :param do_not_run_extensions_on_overprovisioned_v_ms: When Overprovision is enabled, extensions
     are launched only on the requested number of VMs which are finally kept. This property will
     hence ensure that the extensions do not run on the extra overprovisioned VMs.
    :type do_not_run_extensions_on_overprovisioned_v_ms: bool
    :ivar unique_id: Specifies the ID which uniquely identifies a Virtual Machine Scale Set.
    :vartype unique_id: str
    :param single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to
     false. However, if singlePlacementGroup is false, it may not be modified to true.
    :type single_placement_group: bool
    :param zone_balance: Whether to force strictly even Virtual Machine distribution cross x-zones
     in case there is zone outage.
    :type zone_balance: bool
    :param platform_fault_domain_count: Fault Domain count for each placement group.
    :type platform_fault_domain_count: int
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-
     version: 2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param host_group: Specifies information about the dedicated host group that the virtual
     machine scale set resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
    :type host_group: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param additional_capabilities: Specifies additional capabilities enabled or disabled on the
     Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines
     have the capability to support attaching managed data disks with UltraSSD_LRS storage account
     type.
    :type additional_capabilities: ~azure.mgmt.compute.v2020_06_01.models.AdditionalCapabilities
    :param scale_in_policy: Specifies the scale-in policy that decides which virtual machines are
     chosen for removal when a Virtual Machine Scale Set is scaled-in.
    :type scale_in_policy: ~azure.mgmt.compute.v2020_06_01.models.ScaleInPolicy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'unique_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'identity': {'key': 'identity', 'type': 'VirtualMachineScaleSetIdentity'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'upgrade_policy': {'key': 'properties.upgradePolicy', 'type': 'UpgradePolicy'},
        'automatic_repairs_policy': {'key': 'properties.automaticRepairsPolicy', 'type': 'AutomaticRepairsPolicy'},
        'virtual_machine_profile': {'key': 'properties.virtualMachineProfile', 'type': 'VirtualMachineScaleSetVMProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'overprovision': {'key': 'properties.overprovision', 'type': 'bool'},
        'do_not_run_extensions_on_overprovisioned_v_ms': {'key': 'properties.doNotRunExtensionsOnOverprovisionedVMs', 'type': 'bool'},
        'unique_id': {'key': 'properties.uniqueId', 'type': 'str'},
        'single_placement_group': {'key': 'properties.singlePlacementGroup', 'type': 'bool'},
        'zone_balance': {'key': 'properties.zoneBalance', 'type': 'bool'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'host_group': {'key': 'properties.hostGroup', 'type': 'SubResource'},
        'additional_capabilities': {'key': 'properties.additionalCapabilities', 'type': 'AdditionalCapabilities'},
        'scale_in_policy': {'key': 'properties.scaleInPolicy', 'type': 'ScaleInPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSet, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.plan = kwargs.get('plan', None)
        self.identity = kwargs.get('identity', None)
        self.zones = kwargs.get('zones', None)
        self.upgrade_policy = kwargs.get('upgrade_policy', None)
        self.automatic_repairs_policy = kwargs.get('automatic_repairs_policy', None)
        self.virtual_machine_profile = kwargs.get('virtual_machine_profile', None)
        self.provisioning_state = None
        self.overprovision = kwargs.get('overprovision', None)
        self.do_not_run_extensions_on_overprovisioned_v_ms = kwargs.get('do_not_run_extensions_on_overprovisioned_v_ms', None)
        self.unique_id = None
        self.single_placement_group = kwargs.get('single_placement_group', None)
        self.zone_balance = kwargs.get('zone_balance', None)
        self.platform_fault_domain_count = kwargs.get('platform_fault_domain_count', None)
        self.proximity_placement_group = kwargs.get('proximity_placement_group', None)
        self.host_group = kwargs.get('host_group', None)
        self.additional_capabilities = kwargs.get('additional_capabilities', None)
        self.scale_in_policy = kwargs.get('scale_in_policy', None)


class VirtualMachineScaleSetDataDisk(msrest.serialization.Model):
    """Describes a virtual machine scale set data disk.

    All required parameters must be populated in order to send to Azure.

    :param name: The disk name.
    :type name: str
    :param lun: Required. Specifies the logical unit number of the data disk. This value is used to
     identify data disks within the VM and therefore must be unique for each data disk attached to a
     VM.
    :type lun: int
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2020_06_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param create_option: Required. The create option. Possible values include: "FromImage",
     "Empty", "Attach".
    :type create_option: str or ~azure.mgmt.compute.v2020_06_01.models.DiskCreateOptionTypes
    :param disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param managed_disk: The managed disk parameters.
    :type managed_disk:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetManagedDiskParameters
    :param disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk. Should be used
     only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be
     assigned based on diskSizeGB.
    :type disk_iops_read_write: long
    :param disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk.
     Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value
     would be assigned based on diskSizeGB.
    :type disk_m_bps_read_write: long
    """

    _validation = {
        'lun': {'required': True},
        'create_option': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'lun': {'key': 'lun', 'type': 'int'},
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'create_option': {'key': 'createOption', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'managed_disk': {'key': 'managedDisk', 'type': 'VirtualMachineScaleSetManagedDiskParameters'},
        'disk_iops_read_write': {'key': 'diskIOPSReadWrite', 'type': 'long'},
        'disk_m_bps_read_write': {'key': 'diskMBpsReadWrite', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetDataDisk, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.lun = kwargs['lun']
        self.caching = kwargs.get('caching', None)
        self.write_accelerator_enabled = kwargs.get('write_accelerator_enabled', None)
        self.create_option = kwargs['create_option']
        self.disk_size_gb = kwargs.get('disk_size_gb', None)
        self.managed_disk = kwargs.get('managed_disk', None)
        self.disk_iops_read_write = kwargs.get('disk_iops_read_write', None)
        self.disk_m_bps_read_write = kwargs.get('disk_m_bps_read_write', None)


class VirtualMachineScaleSetExtension(SubResourceReadOnly):
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: The name of the extension.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type_properties_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :type enable_automatic_upgrade: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :type provision_after_extensions: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'provision_after_extensions': {'key': 'properties.provisionAfterExtensions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetExtension, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.enable_automatic_upgrade = kwargs.get('enable_automatic_upgrade', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)
        self.provisioning_state = None
        self.provision_after_extensions = kwargs.get('provision_after_extensions', None)


class VirtualMachineScaleSetExtensionListResult(msrest.serialization.Model):
    """The List VM scale set extension operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of VM scale set extensions.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetExtension]
    :param next_link: The uri to fetch the next page of VM scale set extensions. Call ListNext()
     with this to fetch the next page of VM scale set extensions.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSetExtension]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetExtensionListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class VirtualMachineScaleSetExtensionProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set extension profile.

    :param extensions: The virtual machine scale set child extension resources.
    :type extensions: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetExtension]
    :param extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
     api-version: 2020-06-01.
    :type extensions_time_budget: str
    """

    _attribute_map = {
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineScaleSetExtension]'},
        'extensions_time_budget': {'key': 'extensionsTimeBudget', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetExtensionProfile, self).__init__(**kwargs)
        self.extensions = kwargs.get('extensions', None)
        self.extensions_time_budget = kwargs.get('extensions_time_budget', None)


class VirtualMachineScaleSetExtensionUpdate(SubResourceReadOnly):
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type_properties_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :type enable_automatic_upgrade: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :type provision_after_extensions: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'provision_after_extensions': {'key': 'properties.provisionAfterExtensions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetExtensionUpdate, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.enable_automatic_upgrade = kwargs.get('enable_automatic_upgrade', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)
        self.provisioning_state = None
        self.provision_after_extensions = kwargs.get('provision_after_extensions', None)


class VirtualMachineScaleSetIdentity(msrest.serialization.Model):
    """Identity for the virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine scale set identity. This property will
     only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine scale set. This property
     will only be provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the virtual machine scale set. The type
     'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user
     assigned identities. The type 'None' will remove any identities from the virtual machine scale
     set. Possible values include: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned",
     "None".
    :type type: str or ~azure.mgmt.compute.v2020_06_01.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated with the virtual
     machine scale set. The user identity dictionary key references will be ARM resource ids in the
     form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue(msrest.serialization.Model):
    """VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VirtualMachineScaleSetInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar virtual_machine: The instance view status summary for the virtual machine scale set.
    :vartype virtual_machine:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetInstanceViewStatusesSummary
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetVMExtensionsSummary]
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    :ivar orchestration_services: The orchestration services information.
    :vartype orchestration_services:
     list[~azure.mgmt.compute.v2020_06_01.models.OrchestrationServiceSummary]
    """

    _validation = {
        'virtual_machine': {'readonly': True},
        'extensions': {'readonly': True},
        'orchestration_services': {'readonly': True},
    }

    _attribute_map = {
        'virtual_machine': {'key': 'virtualMachine', 'type': 'VirtualMachineScaleSetInstanceViewStatusesSummary'},
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineScaleSetVMExtensionsSummary]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
        'orchestration_services': {'key': 'orchestrationServices', 'type': '[OrchestrationServiceSummary]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetInstanceView, self).__init__(**kwargs)
        self.virtual_machine = None
        self.extensions = None
        self.statuses = kwargs.get('statuses', None)
        self.orchestration_services = None


class VirtualMachineScaleSetInstanceViewStatusesSummary(msrest.serialization.Model):
    """Instance view statuses summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        'statuses_summary': {'readonly': True},
    }

    _attribute_map = {
        'statuses_summary': {'key': 'statusesSummary', 'type': '[VirtualMachineStatusCodeCount]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetInstanceViewStatusesSummary, self).__init__(**kwargs)
        self.statuses_summary = None


class VirtualMachineScaleSetIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The IP configuration name.
    :type name: str
    :param subnet: Specifies the identifier of the subnet.
    :type subnet: ~azure.mgmt.compute.v2020_06_01.models.ApiEntityReference
    :param primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :type primary: bool
    :param public_ip_address_configuration: The publicIPAddressConfiguration.
    :type public_ip_address_configuration:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetPublicIPAddressConfiguration
    :param private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Possible values include: "IPv4", "IPv6".
    :type private_ip_address_version: str or ~azure.mgmt.compute.v2020_06_01.models.IPVersion
    :param application_gateway_backend_address_pools: Specifies an array of references to backend
     address pools of application gateways. A scale set can reference backend address pools of
     multiple application gateways. Multiple scale sets cannot use the same application gateway.
    :type application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2020_06_01.models.SubResource]
    :param application_security_groups: Specifies an array of references to application security
     group.
    :type application_security_groups: list[~azure.mgmt.compute.v2020_06_01.models.SubResource]
    :param load_balancer_backend_address_pools: Specifies an array of references to backend address
     pools of load balancers. A scale set can reference backend address pools of one public and one
     internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2020_06_01.models.SubResource]
    :param load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools
     of the load balancers. A scale set can reference inbound nat pools of one public and one
     internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
    :type load_balancer_inbound_nat_pools: list[~azure.mgmt.compute.v2020_06_01.models.SubResource]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'ApiEntityReference'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address_configuration': {'key': 'properties.publicIPAddressConfiguration', 'type': 'VirtualMachineScaleSetPublicIPAddressConfiguration'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'application_gateway_backend_address_pools': {'key': 'properties.applicationGatewayBackendAddressPools', 'type': '[SubResource]'},
        'application_security_groups': {'key': 'properties.applicationSecurityGroups', 'type': '[SubResource]'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[SubResource]'},
        'load_balancer_inbound_nat_pools': {'key': 'properties.loadBalancerInboundNatPools', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.subnet = kwargs.get('subnet', None)
        self.primary = kwargs.get('primary', None)
        self.public_ip_address_configuration = kwargs.get('public_ip_address_configuration', None)
        self.private_ip_address_version = kwargs.get('private_ip_address_version', None)
        self.application_gateway_backend_address_pools = kwargs.get('application_gateway_backend_address_pools', None)
        self.application_security_groups = kwargs.get('application_security_groups', None)
        self.load_balancer_backend_address_pools = kwargs.get('load_balancer_backend_address_pools', None)
        self.load_balancer_inbound_nat_pools = kwargs.get('load_balancer_inbound_nat_pools', None)


class VirtualMachineScaleSetIpTag(msrest.serialization.Model):
    """Contains the IP tag associated with the public IP address.

    :param ip_tag_type: IP tag type. Example: FirstPartyUsage.
    :type ip_tag_type: str
    :param tag: IP tag associated with the public IP. Example: SQL, Storage etc.
    :type tag: str
    """

    _attribute_map = {
        'ip_tag_type': {'key': 'ipTagType', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetIpTag, self).__init__(**kwargs)
        self.ip_tag_type = kwargs.get('ip_tag_type', None)
        self.tag = kwargs.get('tag', None)


class VirtualMachineScaleSetListOSUpgradeHistory(msrest.serialization.Model):
    """List of Virtual Machine Scale Set OS Upgrade History operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of OS upgrades performed on the virtual machine scale set.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.UpgradeOperationHistoricalStatusInfo]
    :param next_link: The uri to fetch the next page of OS Upgrade History. Call ListNext() with
     this to fetch the next page of history of upgrades.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UpgradeOperationHistoricalStatusInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetListOSUpgradeHistory, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class VirtualMachineScaleSetListResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machine scale sets.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSet]
    :param next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of VMSS.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class VirtualMachineScaleSetListSkusResult(msrest.serialization.Model):
    """The Virtual Machine Scale Set List Skus operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of skus available for the virtual machine scale set.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetSku]
    :param next_link: The uri to fetch the next page of Virtual Machine Scale Set Skus. Call
     ListNext() with this to fetch the next page of VMSS Skus.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSetSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetListSkusResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class VirtualMachineScaleSetListWithLinkResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machine scale sets.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSet]
    :param next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of Virtual Machine Scale Sets.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetListWithLinkResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class VirtualMachineScaleSetManagedDiskParameters(msrest.serialization.Model):
    """Describes the parameters of a ScaleSet managed disk.

    :param storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values
     include: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2020_06_01.models.StorageAccountTypes
    :param disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk.
    :type disk_encryption_set: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    """

    _attribute_map = {
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'disk_encryption_set': {'key': 'diskEncryptionSet', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetManagedDiskParameters, self).__init__(**kwargs)
        self.storage_account_type = kwargs.get('storage_account_type', None)
        self.disk_encryption_set = kwargs.get('disk_encryption_set', None)


class VirtualMachineScaleSetNetworkConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's network configurations.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The network configuration name.
    :type name: str
    :param primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :type primary: bool
    :param enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :type enable_accelerated_networking: bool
    :param enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
    :type enable_fpga: bool
    :param network_security_group: The network security group.
    :type network_security_group: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param dns_settings: The dns settings to be applied on the network interfaces.
    :type dns_settings:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :param ip_configurations: Specifies the IP configurations of the network interface.
    :type ip_configurations:
     list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetIPConfiguration]
    :param enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :type enable_ip_forwarding: bool
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'enable_accelerated_networking': {'key': 'properties.enableAcceleratedNetworking', 'type': 'bool'},
        'enable_fpga': {'key': 'properties.enableFpga', 'type': 'bool'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'SubResource'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineScaleSetNetworkConfigurationDnsSettings'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualMachineScaleSetIPConfiguration]'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetNetworkConfiguration, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.primary = kwargs.get('primary', None)
        self.enable_accelerated_networking = kwargs.get('enable_accelerated_networking', None)
        self.enable_fpga = kwargs.get('enable_fpga', None)
        self.network_security_group = kwargs.get('network_security_group', None)
        self.dns_settings = kwargs.get('dns_settings', None)
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.enable_ip_forwarding = kwargs.get('enable_ip_forwarding', None)


class VirtualMachineScaleSetNetworkConfigurationDnsSettings(msrest.serialization.Model):
    """Describes a virtual machines scale sets network configuration's DNS settings.

    :param dns_servers: List of DNS servers IP addresses.
    :type dns_servers: list[str]
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetNetworkConfigurationDnsSettings, self).__init__(**kwargs)
        self.dns_servers = kwargs.get('dns_servers', None)


class VirtualMachineScaleSetNetworkProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set network profile.

    :param health_probe: A reference to a load balancer probe used to determine the health of an
     instance in the virtual machine scale set. The reference will be in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
    :type health_probe: ~azure.mgmt.compute.v2020_06_01.models.ApiEntityReference
    :param network_interface_configurations: The list of network configurations.
    :type network_interface_configurations:
     list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetNetworkConfiguration]
    """

    _attribute_map = {
        'health_probe': {'key': 'healthProbe', 'type': 'ApiEntityReference'},
        'network_interface_configurations': {'key': 'networkInterfaceConfigurations', 'type': '[VirtualMachineScaleSetNetworkConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetNetworkProfile, self).__init__(**kwargs)
        self.health_probe = kwargs.get('health_probe', None)
        self.network_interface_configurations = kwargs.get('network_interface_configurations', None)


class VirtualMachineScaleSetOSDisk(msrest.serialization.Model):
    """Describes a virtual machine scale set operating system disk.

    All required parameters must be populated in order to send to Azure.

    :param name: The disk name.
    :type name: str
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2020_06_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param create_option: Required. Specifies how the virtual machines in the scale set should be
     created.:code:`<br>`:code:`<br>` The only allowed value is: **FromImage** \u2013 This value is
     used when you are using an image to create the virtual machine. If you are using a platform
     image, you also use the imageReference element described above. If you are using a marketplace
     image, you  also use the plan element previously described. Possible values include:
     "FromImage", "Empty", "Attach".
    :type create_option: str or ~azure.mgmt.compute.v2020_06_01.models.DiskCreateOptionTypes
    :param diff_disk_settings: Specifies the ephemeral disk Settings for the operating system disk
     used by the virtual machine scale set.
    :type diff_disk_settings: ~azure.mgmt.compute.v2020_06_01.models.DiffDiskSettings
    :param disk_size_gb: Specifies the size of the operating system disk in gigabytes. This element
     can be used to overwrite the size of the disk in a virtual machine image.
     :code:`<br>`:code:`<br>` This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible
     values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2020_06_01.models.OperatingSystemTypes
    :param image: Specifies information about the unmanaged user image to base the scale set on.
    :type image: ~azure.mgmt.compute.v2020_06_01.models.VirtualHardDisk
    :param vhd_containers: Specifies the container urls that are used to store operating system
     disks for the scale set.
    :type vhd_containers: list[str]
    :param managed_disk: The managed disk parameters.
    :type managed_disk:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _validation = {
        'create_option': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'create_option': {'key': 'createOption', 'type': 'str'},
        'diff_disk_settings': {'key': 'diffDiskSettings', 'type': 'DiffDiskSettings'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'vhd_containers': {'key': 'vhdContainers', 'type': '[str]'},
        'managed_disk': {'key': 'managedDisk', 'type': 'VirtualMachineScaleSetManagedDiskParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetOSDisk, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.caching = kwargs.get('caching', None)
        self.write_accelerator_enabled = kwargs.get('write_accelerator_enabled', None)
        self.create_option = kwargs['create_option']
        self.diff_disk_settings = kwargs.get('diff_disk_settings', None)
        self.disk_size_gb = kwargs.get('disk_size_gb', None)
        self.os_type = kwargs.get('os_type', None)
        self.image = kwargs.get('image', None)
        self.vhd_containers = kwargs.get('vhd_containers', None)
        self.managed_disk = kwargs.get('managed_disk', None)


class VirtualMachineScaleSetOSProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :param computer_name_prefix: Specifies the computer name prefix for all of the virtual machines
     in the scale set. Computer name prefixes must be 1 to 15 characters long.
    :type computer_name_prefix: str
    :param admin_username: Specifies the name of the administrator account.
     :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
     :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
     "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
     "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
     "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
     :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
     characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access to the Linux VM, see `Using
     root privileges on Linux virtual machines in Azure <https://docs.microsoft.com/azure/virtual-
     machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-
     machines%2flinux%2ftoc.json>`_\ :code:`<br>`:code:`<li>` For a list of built-in system users on
     Linux that should not be used in this field, see `Selecting User Names for Linux on Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-
     usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type admin_username: str
    :param admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-
     rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_ :code:`<br>`:code:`<br>` For
     resetting root password, see `Manage users, SSH, and check or repair disks on Azure Linux VMs
     using the VMAccess Extension <https://docs.microsoft.com/azure/virtual-machines/virtual-
     machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-
     machines%2flinux%2ftoc.json#reset-root-password>`_.
    :type admin_password: str
    :param custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
     your VM, see `Using cloud-init to customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-
     init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type custom_data: str
    :param windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :type windows_configuration: ~azure.mgmt.compute.v2020_06_01.models.WindowsConfiguration
    :param linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-
     machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_
     :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for Non-
     Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-
     linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type linux_configuration: ~azure.mgmt.compute.v2020_06_01.models.LinuxConfiguration
    :param secrets: Specifies set of certificates that should be installed onto the virtual
     machines in the scale set.
    :type secrets: list[~azure.mgmt.compute.v2020_06_01.models.VaultSecretGroup]
    """

    _attribute_map = {
        'computer_name_prefix': {'key': 'computerNamePrefix', 'type': 'str'},
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
        'custom_data': {'key': 'customData', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'linux_configuration': {'key': 'linuxConfiguration', 'type': 'LinuxConfiguration'},
        'secrets': {'key': 'secrets', 'type': '[VaultSecretGroup]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetOSProfile, self).__init__(**kwargs)
        self.computer_name_prefix = kwargs.get('computer_name_prefix', None)
        self.admin_username = kwargs.get('admin_username', None)
        self.admin_password = kwargs.get('admin_password', None)
        self.custom_data = kwargs.get('custom_data', None)
        self.windows_configuration = kwargs.get('windows_configuration', None)
        self.linux_configuration = kwargs.get('linux_configuration', None)
        self.secrets = kwargs.get('secrets', None)


class VirtualMachineScaleSetPublicIPAddressConfiguration(msrest.serialization.Model):
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The publicIP address configuration name.
    :type name: str
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :param dns_settings: The dns settings to be applied on the publicIP addresses .
    :type dns_settings:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    :param ip_tags: The list of IP tags associated with the public IP address.
    :type ip_tags: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetIpTag]
    :param public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
    :type public_ip_prefix: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values
     are: 'IPv4' and 'IPv6'. Possible values include: "IPv4", "IPv6".
    :type public_ip_address_version: str or ~azure.mgmt.compute.v2020_06_01.models.IPVersion
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings'},
        'ip_tags': {'key': 'properties.ipTags', 'type': '[VirtualMachineScaleSetIpTag]'},
        'public_ip_prefix': {'key': 'properties.publicIPPrefix', 'type': 'SubResource'},
        'public_ip_address_version': {'key': 'properties.publicIPAddressVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetPublicIPAddressConfiguration, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.dns_settings = kwargs.get('dns_settings', None)
        self.ip_tags = kwargs.get('ip_tags', None)
        self.public_ip_prefix = kwargs.get('public_ip_prefix', None)
        self.public_ip_address_version = kwargs.get('public_ip_address_version', None)


class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings(msrest.serialization.Model):
    """Describes a virtual machines scale sets network configuration's DNS settings.

    All required parameters must be populated in order to send to Azure.

    :param domain_name_label: Required. The Domain name label.The concatenation of the domain name
     label and vm index will be the domain name labels of the PublicIPAddress resources that will be
     created.
    :type domain_name_label: str
    """

    _validation = {
        'domain_name_label': {'required': True},
    }

    _attribute_map = {
        'domain_name_label': {'key': 'domainNameLabel', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings, self).__init__(**kwargs)
        self.domain_name_label = kwargs['domain_name_label']


class VirtualMachineScaleSetReimageParameters(VirtualMachineReimageParameters):
    """Describes a Virtual Machine Scale Set VM Reimage Parameters.

    :param temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This temp
     disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
    :type temp_disk: bool
    :param instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
     scale set instance ids will result in the operation being performed on all virtual machines in
     the virtual machine scale set.
    :type instance_ids: list[str]
    """

    _attribute_map = {
        'temp_disk': {'key': 'tempDisk', 'type': 'bool'},
        'instance_ids': {'key': 'instanceIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetReimageParameters, self).__init__(**kwargs)
        self.instance_ids = kwargs.get('instance_ids', None)


class VirtualMachineScaleSetSku(msrest.serialization.Model):
    """Describes an available virtual machine scale set sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the sku applies to.
    :vartype resource_type: str
    :ivar sku: The Sku.
    :vartype sku: ~azure.mgmt.compute.v2020_06_01.models.Sku
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetSkuCapacity
    """

    _validation = {
        'resource_type': {'readonly': True},
        'sku': {'readonly': True},
        'capacity': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'capacity': {'key': 'capacity', 'type': 'VirtualMachineScaleSetSkuCapacity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetSku, self).__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None


class VirtualMachineScaleSetSkuCapacity(msrest.serialization.Model):
    """Describes scaling information of a sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: long
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: long
    :ivar default_capacity: The default capacity.
    :vartype default_capacity: long
    :ivar scale_type: The scale type applicable to the sku. Possible values include: "Automatic",
     "None".
    :vartype scale_type: str or
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetSkuScaleType
    """

    _validation = {
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'default_capacity': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'long'},
        'maximum': {'key': 'maximum', 'type': 'long'},
        'default_capacity': {'key': 'defaultCapacity', 'type': 'long'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetSkuCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default_capacity = None
        self.scale_type = None


class VirtualMachineScaleSetStorageProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :param image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :type image_reference: ~azure.mgmt.compute.v2020_06_01.models.ImageReference
    :param os_disk: Specifies information about the operating system disk used by the virtual
     machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
     `About disks and VHDs for Azure virtual machines <https://docs.microsoft.com/azure/virtual-
     machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-
     machines%2fwindows%2ftoc.json>`_.
    :type os_disk: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetOSDisk
    :param data_disks: Specifies the parameters that are used to add data disks to the virtual
     machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
     `About disks and VHDs for Azure virtual machines <https://docs.microsoft.com/azure/virtual-
     machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-
     machines%2fwindows%2ftoc.json>`_.
    :type data_disks: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetDataDisk]
    """

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'os_disk': {'key': 'osDisk', 'type': 'VirtualMachineScaleSetOSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[VirtualMachineScaleSetDataDisk]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetStorageProfile, self).__init__(**kwargs)
        self.image_reference = kwargs.get('image_reference', None)
        self.os_disk = kwargs.get('os_disk', None)
        self.data_disks = kwargs.get('data_disks', None)


class VirtualMachineScaleSetUpdate(UpdateResource):
    """Describes a Virtual Machine Scale Set.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The virtual machine scale set sku.
    :type sku: ~azure.mgmt.compute.v2020_06_01.models.Sku
    :param plan: The purchase plan when deploying a virtual machine scale set from VM Marketplace
     images.
    :type plan: ~azure.mgmt.compute.v2020_06_01.models.Plan
    :param identity: The identity of the virtual machine scale set, if configured.
    :type identity: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetIdentity
    :param upgrade_policy: The upgrade policy.
    :type upgrade_policy: ~azure.mgmt.compute.v2020_06_01.models.UpgradePolicy
    :param automatic_repairs_policy: Policy for automatic repairs.
    :type automatic_repairs_policy: ~azure.mgmt.compute.v2020_06_01.models.AutomaticRepairsPolicy
    :param virtual_machine_profile: The virtual machine profile.
    :type virtual_machine_profile:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetUpdateVMProfile
    :param overprovision: Specifies whether the Virtual Machine Scale Set should be
     overprovisioned.
    :type overprovision: bool
    :param do_not_run_extensions_on_overprovisioned_v_ms: When Overprovision is enabled, extensions
     are launched only on the requested number of VMs which are finally kept. This property will
     hence ensure that the extensions do not run on the extra overprovisioned VMs.
    :type do_not_run_extensions_on_overprovisioned_v_ms: bool
    :param single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to
     false. However, if singlePlacementGroup is false, it may not be modified to true.
    :type single_placement_group: bool
    :param additional_capabilities: Specifies additional capabilities enabled or disabled on the
     Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines
     have the capability to support attaching managed data disks with UltraSSD_LRS storage account
     type.
    :type additional_capabilities: ~azure.mgmt.compute.v2020_06_01.models.AdditionalCapabilities
    :param scale_in_policy: Specifies the scale-in policy that decides which virtual machines are
     chosen for removal when a Virtual Machine Scale Set is scaled-in.
    :type scale_in_policy: ~azure.mgmt.compute.v2020_06_01.models.ScaleInPolicy
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-
     version: 2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'identity': {'key': 'identity', 'type': 'VirtualMachineScaleSetIdentity'},
        'upgrade_policy': {'key': 'properties.upgradePolicy', 'type': 'UpgradePolicy'},
        'automatic_repairs_policy': {'key': 'properties.automaticRepairsPolicy', 'type': 'AutomaticRepairsPolicy'},
        'virtual_machine_profile': {'key': 'properties.virtualMachineProfile', 'type': 'VirtualMachineScaleSetUpdateVMProfile'},
        'overprovision': {'key': 'properties.overprovision', 'type': 'bool'},
        'do_not_run_extensions_on_overprovisioned_v_ms': {'key': 'properties.doNotRunExtensionsOnOverprovisionedVMs', 'type': 'bool'},
        'single_placement_group': {'key': 'properties.singlePlacementGroup', 'type': 'bool'},
        'additional_capabilities': {'key': 'properties.additionalCapabilities', 'type': 'AdditionalCapabilities'},
        'scale_in_policy': {'key': 'properties.scaleInPolicy', 'type': 'ScaleInPolicy'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdate, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.plan = kwargs.get('plan', None)
        self.identity = kwargs.get('identity', None)
        self.upgrade_policy = kwargs.get('upgrade_policy', None)
        self.automatic_repairs_policy = kwargs.get('automatic_repairs_policy', None)
        self.virtual_machine_profile = kwargs.get('virtual_machine_profile', None)
        self.overprovision = kwargs.get('overprovision', None)
        self.do_not_run_extensions_on_overprovisioned_v_ms = kwargs.get('do_not_run_extensions_on_overprovisioned_v_ms', None)
        self.single_placement_group = kwargs.get('single_placement_group', None)
        self.additional_capabilities = kwargs.get('additional_capabilities', None)
        self.scale_in_policy = kwargs.get('scale_in_policy', None)
        self.proximity_placement_group = kwargs.get('proximity_placement_group', None)


class VirtualMachineScaleSetUpdateIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration. NOTE: The subnet of a scale set may be modified as long as the original subnet and the new subnet are in the same virtual network.

    :param id: Resource Id.
    :type id: str
    :param name: The IP configuration name.
    :type name: str
    :param subnet: The subnet.
    :type subnet: ~azure.mgmt.compute.v2020_06_01.models.ApiEntityReference
    :param primary: Specifies the primary IP Configuration in case the network interface has more
     than one IP Configuration.
    :type primary: bool
    :param public_ip_address_configuration: The publicIPAddressConfiguration.
    :type public_ip_address_configuration:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration
    :param private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Possible values include: "IPv4", "IPv6".
    :type private_ip_address_version: str or ~azure.mgmt.compute.v2020_06_01.models.IPVersion
    :param application_gateway_backend_address_pools: The application gateway backend address
     pools.
    :type application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2020_06_01.models.SubResource]
    :param application_security_groups: Specifies an array of references to application security
     group.
    :type application_security_groups: list[~azure.mgmt.compute.v2020_06_01.models.SubResource]
    :param load_balancer_backend_address_pools: The load balancer backend address pools.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2020_06_01.models.SubResource]
    :param load_balancer_inbound_nat_pools: The load balancer inbound nat pools.
    :type load_balancer_inbound_nat_pools: list[~azure.mgmt.compute.v2020_06_01.models.SubResource]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'ApiEntityReference'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address_configuration': {'key': 'properties.publicIPAddressConfiguration', 'type': 'VirtualMachineScaleSetUpdatePublicIPAddressConfiguration'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'application_gateway_backend_address_pools': {'key': 'properties.applicationGatewayBackendAddressPools', 'type': '[SubResource]'},
        'application_security_groups': {'key': 'properties.applicationSecurityGroups', 'type': '[SubResource]'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[SubResource]'},
        'load_balancer_inbound_nat_pools': {'key': 'properties.loadBalancerInboundNatPools', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.subnet = kwargs.get('subnet', None)
        self.primary = kwargs.get('primary', None)
        self.public_ip_address_configuration = kwargs.get('public_ip_address_configuration', None)
        self.private_ip_address_version = kwargs.get('private_ip_address_version', None)
        self.application_gateway_backend_address_pools = kwargs.get('application_gateway_backend_address_pools', None)
        self.application_security_groups = kwargs.get('application_security_groups', None)
        self.load_balancer_backend_address_pools = kwargs.get('load_balancer_backend_address_pools', None)
        self.load_balancer_inbound_nat_pools = kwargs.get('load_balancer_inbound_nat_pools', None)


class VirtualMachineScaleSetUpdateNetworkConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's network configurations.

    :param id: Resource Id.
    :type id: str
    :param name: The network configuration name.
    :type name: str
    :param primary: Whether this is a primary NIC on a virtual machine.
    :type primary: bool
    :param enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :type enable_accelerated_networking: bool
    :param enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
    :type enable_fpga: bool
    :param network_security_group: The network security group.
    :type network_security_group: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param dns_settings: The dns settings to be applied on the network interfaces.
    :type dns_settings:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :param ip_configurations: The virtual machine scale set IP Configuration.
    :type ip_configurations:
     list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetUpdateIPConfiguration]
    :param enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :type enable_ip_forwarding: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'enable_accelerated_networking': {'key': 'properties.enableAcceleratedNetworking', 'type': 'bool'},
        'enable_fpga': {'key': 'properties.enableFpga', 'type': 'bool'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'SubResource'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineScaleSetNetworkConfigurationDnsSettings'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualMachineScaleSetUpdateIPConfiguration]'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateNetworkConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.primary = kwargs.get('primary', None)
        self.enable_accelerated_networking = kwargs.get('enable_accelerated_networking', None)
        self.enable_fpga = kwargs.get('enable_fpga', None)
        self.network_security_group = kwargs.get('network_security_group', None)
        self.dns_settings = kwargs.get('dns_settings', None)
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.enable_ip_forwarding = kwargs.get('enable_ip_forwarding', None)


class VirtualMachineScaleSetUpdateNetworkProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set network profile.

    :param health_probe: A reference to a load balancer probe used to determine the health of an
     instance in the virtual machine scale set. The reference will be in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
    :type health_probe: ~azure.mgmt.compute.v2020_06_01.models.ApiEntityReference
    :param network_interface_configurations: The list of network configurations.
    :type network_interface_configurations:
     list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetUpdateNetworkConfiguration]
    """

    _attribute_map = {
        'health_probe': {'key': 'healthProbe', 'type': 'ApiEntityReference'},
        'network_interface_configurations': {'key': 'networkInterfaceConfigurations', 'type': '[VirtualMachineScaleSetUpdateNetworkConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateNetworkProfile, self).__init__(**kwargs)
        self.health_probe = kwargs.get('health_probe', None)
        self.network_interface_configurations = kwargs.get('network_interface_configurations', None)


class VirtualMachineScaleSetUpdateOSDisk(msrest.serialization.Model):
    """Describes virtual machine scale set operating system disk Update Object. This should be used for Updating VMSS OS Disk.

    :param caching: The caching type. Possible values include: "None", "ReadOnly", "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2020_06_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param disk_size_gb: Specifies the size of the operating system disk in gigabytes. This element
     can be used to overwrite the size of the disk in a virtual machine image.
     :code:`<br>`:code:`<br>` This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param image: The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied before
     using it to attach to the Virtual Machine. If SourceImage is provided, the destination
     VirtualHardDisk should not exist.
    :type image: ~azure.mgmt.compute.v2020_06_01.models.VirtualHardDisk
    :param vhd_containers: The list of virtual hard disk container uris.
    :type vhd_containers: list[str]
    :param managed_disk: The managed disk parameters.
    :type managed_disk:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _attribute_map = {
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'vhd_containers': {'key': 'vhdContainers', 'type': '[str]'},
        'managed_disk': {'key': 'managedDisk', 'type': 'VirtualMachineScaleSetManagedDiskParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateOSDisk, self).__init__(**kwargs)
        self.caching = kwargs.get('caching', None)
        self.write_accelerator_enabled = kwargs.get('write_accelerator_enabled', None)
        self.disk_size_gb = kwargs.get('disk_size_gb', None)
        self.image = kwargs.get('image', None)
        self.vhd_containers = kwargs.get('vhd_containers', None)
        self.managed_disk = kwargs.get('managed_disk', None)


class VirtualMachineScaleSetUpdateOSProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :param custom_data: A base-64 encoded string of custom data.
    :type custom_data: str
    :param windows_configuration: The Windows Configuration of the OS profile.
    :type windows_configuration: ~azure.mgmt.compute.v2020_06_01.models.WindowsConfiguration
    :param linux_configuration: The Linux Configuration of the OS profile.
    :type linux_configuration: ~azure.mgmt.compute.v2020_06_01.models.LinuxConfiguration
    :param secrets: The List of certificates for addition to the VM.
    :type secrets: list[~azure.mgmt.compute.v2020_06_01.models.VaultSecretGroup]
    """

    _attribute_map = {
        'custom_data': {'key': 'customData', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'linux_configuration': {'key': 'linuxConfiguration', 'type': 'LinuxConfiguration'},
        'secrets': {'key': 'secrets', 'type': '[VaultSecretGroup]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateOSProfile, self).__init__(**kwargs)
        self.custom_data = kwargs.get('custom_data', None)
        self.windows_configuration = kwargs.get('windows_configuration', None)
        self.linux_configuration = kwargs.get('linux_configuration', None)
        self.secrets = kwargs.get('secrets', None)


class VirtualMachineScaleSetUpdatePublicIPAddressConfiguration(msrest.serialization.Model):
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.

    :param name: The publicIP address configuration name.
    :type name: str
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :param dns_settings: The dns settings to be applied on the publicIP addresses .
    :type dns_settings:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdatePublicIPAddressConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.dns_settings = kwargs.get('dns_settings', None)


class VirtualMachineScaleSetUpdateStorageProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :param image_reference: The image reference.
    :type image_reference: ~azure.mgmt.compute.v2020_06_01.models.ImageReference
    :param os_disk: The OS disk.
    :type os_disk: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetUpdateOSDisk
    :param data_disks: The data disks.
    :type data_disks: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetDataDisk]
    """

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'os_disk': {'key': 'osDisk', 'type': 'VirtualMachineScaleSetUpdateOSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[VirtualMachineScaleSetDataDisk]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateStorageProfile, self).__init__(**kwargs)
        self.image_reference = kwargs.get('image_reference', None)
        self.os_disk = kwargs.get('os_disk', None)
        self.data_disks = kwargs.get('data_disks', None)


class VirtualMachineScaleSetUpdateVMProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set virtual machine profile.

    :param os_profile: The virtual machine scale set OS profile.
    :type os_profile: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetUpdateOSProfile
    :param storage_profile: The virtual machine scale set storage profile.
    :type storage_profile:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetUpdateStorageProfile
    :param network_profile: The virtual machine scale set network profile.
    :type network_profile:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetUpdateNetworkProfile
    :param security_profile: The virtual machine scale set Security profile.
    :type security_profile: ~azure.mgmt.compute.v2020_06_01.models.SecurityProfile
    :param diagnostics_profile: The virtual machine scale set diagnostics profile.
    :type diagnostics_profile: ~azure.mgmt.compute.v2020_06_01.models.DiagnosticsProfile
    :param extension_profile: The virtual machine scale set extension profile.
    :type extension_profile:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetExtensionProfile
    :param license_type: The license type, which is for bring your own license scenario.
    :type license_type: str
    :param billing_profile: Specifies the billing related details of a Azure Spot VMSS.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :type billing_profile: ~azure.mgmt.compute.v2020_06_01.models.BillingProfile
    :param scheduled_events_profile: Specifies Scheduled Event related configurations.
    :type scheduled_events_profile: ~azure.mgmt.compute.v2020_06_01.models.ScheduledEventsProfile
    """

    _attribute_map = {
        'os_profile': {'key': 'osProfile', 'type': 'VirtualMachineScaleSetUpdateOSProfile'},
        'storage_profile': {'key': 'storageProfile', 'type': 'VirtualMachineScaleSetUpdateStorageProfile'},
        'network_profile': {'key': 'networkProfile', 'type': 'VirtualMachineScaleSetUpdateNetworkProfile'},
        'security_profile': {'key': 'securityProfile', 'type': 'SecurityProfile'},
        'diagnostics_profile': {'key': 'diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'extension_profile': {'key': 'extensionProfile', 'type': 'VirtualMachineScaleSetExtensionProfile'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'billing_profile': {'key': 'billingProfile', 'type': 'BillingProfile'},
        'scheduled_events_profile': {'key': 'scheduledEventsProfile', 'type': 'ScheduledEventsProfile'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateVMProfile, self).__init__(**kwargs)
        self.os_profile = kwargs.get('os_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.security_profile = kwargs.get('security_profile', None)
        self.diagnostics_profile = kwargs.get('diagnostics_profile', None)
        self.extension_profile = kwargs.get('extension_profile', None)
        self.license_type = kwargs.get('license_type', None)
        self.billing_profile = kwargs.get('billing_profile', None)
        self.scheduled_events_profile = kwargs.get('scheduled_events_profile', None)


class VirtualMachineScaleSetVM(Resource):
    """Describes a virtual machine scale set virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar instance_id: The virtual machine instance ID.
    :vartype instance_id: str
    :ivar sku: The virtual machine SKU.
    :vartype sku: ~azure.mgmt.compute.v2020_06_01.models.Sku
    :param plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :type plan: ~azure.mgmt.compute.v2020_06_01.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineExtension]
    :ivar zones: The virtual machine zones.
    :vartype zones: list[str]
    :ivar latest_model_applied: Specifies whether the latest model has been applied to the virtual
     machine.
    :vartype latest_model_applied: bool
    :ivar vm_id: Azure VM unique ID.
    :vartype vm_id: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetVMInstanceView
    :param hardware_profile: Specifies the hardware settings for the virtual machine.
    :type hardware_profile: ~azure.mgmt.compute.v2020_06_01.models.HardwareProfile
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2020_06_01.models.StorageProfile
    :param additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine in the scale set. For instance: whether the virtual machine has the capability
     to support attaching managed data disks with UltraSSD_LRS storage account type.
    :type additional_capabilities: ~azure.mgmt.compute.v2020_06_01.models.AdditionalCapabilities
    :param os_profile: Specifies the operating system settings for the virtual machine.
    :type os_profile: ~azure.mgmt.compute.v2020_06_01.models.OSProfile
    :param security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :type security_profile: ~azure.mgmt.compute.v2020_06_01.models.SecurityProfile
    :param network_profile: Specifies the network interfaces of the virtual machine.
    :type network_profile: ~azure.mgmt.compute.v2020_06_01.models.NetworkProfile
    :param network_profile_configuration: Specifies the network profile configuration of the
     virtual machine.
    :type network_profile_configuration:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetVMNetworkProfileConfiguration
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :type diagnostics_profile: ~azure.mgmt.compute.v2020_06_01.models.DiagnosticsProfile
    :param availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Manage the availability of virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-
     availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_. :code:`<br>`:code:`<br>`
     For more information on Azure planned maintenance, see `Planned maintenance for virtual
     machines in Azure <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-
     planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :type availability_set: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param license_type: Specifies that the image or disk that is being used was licensed on-
     premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type license_type: str
    :ivar model_definition_applied: Specifies whether the model applied to the virtual machine is
     the model of the virtual machine scale set or the customized model for the virtual machine.
    :vartype model_definition_applied: str
    :param protection_policy: Specifies the protection policy of the virtual machine.
    :type protection_policy:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetVMProtectionPolicy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'instance_id': {'readonly': True},
        'sku': {'readonly': True},
        'resources': {'readonly': True},
        'zones': {'readonly': True},
        'latest_model_applied': {'readonly': True},
        'vm_id': {'readonly': True},
        'instance_view': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'model_definition_applied': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'instance_id': {'key': 'instanceId', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'resources': {'key': 'resources', 'type': '[VirtualMachineExtension]'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'latest_model_applied': {'key': 'properties.latestModelApplied', 'type': 'bool'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineScaleSetVMInstanceView'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'additional_capabilities': {'key': 'properties.additionalCapabilities', 'type': 'AdditionalCapabilities'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'security_profile': {'key': 'properties.securityProfile', 'type': 'SecurityProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'network_profile_configuration': {'key': 'properties.networkProfileConfiguration', 'type': 'VirtualMachineScaleSetVMNetworkProfileConfiguration'},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'availability_set': {'key': 'properties.availabilitySet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'model_definition_applied': {'key': 'properties.modelDefinitionApplied', 'type': 'str'},
        'protection_policy': {'key': 'properties.protectionPolicy', 'type': 'VirtualMachineScaleSetVMProtectionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVM, self).__init__(**kwargs)
        self.instance_id = None
        self.sku = None
        self.plan = kwargs.get('plan', None)
        self.resources = None
        self.zones = None
        self.latest_model_applied = None
        self.vm_id = None
        self.instance_view = None
        self.hardware_profile = kwargs.get('hardware_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.additional_capabilities = kwargs.get('additional_capabilities', None)
        self.os_profile = kwargs.get('os_profile', None)
        self.security_profile = kwargs.get('security_profile', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.network_profile_configuration = kwargs.get('network_profile_configuration', None)
        self.diagnostics_profile = kwargs.get('diagnostics_profile', None)
        self.availability_set = kwargs.get('availability_set', None)
        self.provisioning_state = None
        self.license_type = kwargs.get('license_type', None)
        self.model_definition_applied = None
        self.protection_policy = kwargs.get('protection_policy', None)


class VirtualMachineScaleSetVMExtension(SubResourceReadOnly):
    """Describes a VMSS VM Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type_properties_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :type enable_automatic_upgrade: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param instance_view: The virtual machine extension instance view.
    :type instance_view: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineExtensionInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineExtensionInstanceView'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMExtension, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.enable_automatic_upgrade = kwargs.get('enable_automatic_upgrade', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)
        self.provisioning_state = None
        self.instance_view = kwargs.get('instance_view', None)


class VirtualMachineScaleSetVMExtensionsListResult(msrest.serialization.Model):
    """The List VMSS VM Extension operation response.

    :param value: The list of VMSS VM extensions.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetVMExtension]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSetVMExtension]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMExtensionsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class VirtualMachineScaleSetVMExtensionsSummary(msrest.serialization.Model):
    """Extensions summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The extension name.
    :vartype name: str
    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        'name': {'readonly': True},
        'statuses_summary': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'statuses_summary': {'key': 'statusesSummary', 'type': '[VirtualMachineStatusCodeCount]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMExtensionsSummary, self).__init__(**kwargs)
        self.name = None
        self.statuses_summary = None


class VirtualMachineScaleSetVMExtensionUpdate(SubResourceReadOnly):
    """Describes a VMSS VM Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type_properties_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :type enable_automatic_upgrade: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: object
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMExtensionUpdate, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.enable_automatic_upgrade = kwargs.get('enable_automatic_upgrade', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)


class VirtualMachineScaleSetVMInstanceIDs(msrest.serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    :param instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
     scale set instance ids will result in the operation being performed on all virtual machines in
     the virtual machine scale set.
    :type instance_ids: list[str]
    """

    _attribute_map = {
        'instance_ids': {'key': 'instanceIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMInstanceIDs, self).__init__(**kwargs)
        self.instance_ids = kwargs.get('instance_ids', None)


class VirtualMachineScaleSetVMInstanceRequiredIDs(msrest.serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    All required parameters must be populated in order to send to Azure.

    :param instance_ids: Required. The virtual machine scale set instance ids.
    :type instance_ids: list[str]
    """

    _validation = {
        'instance_ids': {'required': True},
    }

    _attribute_map = {
        'instance_ids': {'key': 'instanceIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMInstanceRequiredIDs, self).__init__(**kwargs)
        self.instance_ids = kwargs['instance_ids']


class VirtualMachineScaleSetVMInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine scale set VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param platform_update_domain: The Update Domain count.
    :type platform_update_domain: int
    :param platform_fault_domain: The Fault Domain count.
    :type platform_fault_domain: int
    :param rdp_thumb_print: The Remote desktop certificate thumbprint.
    :type rdp_thumb_print: str
    :param vm_agent: The VM Agent running on the virtual machine.
    :type vm_agent: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineAgentInstanceView
    :param maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
    :type maintenance_redeploy_status:
     ~azure.mgmt.compute.v2020_06_01.models.MaintenanceRedeployStatus
    :param disks: The disks information.
    :type disks: list[~azure.mgmt.compute.v2020_06_01.models.DiskInstanceView]
    :param extensions: The extensions information.
    :type extensions:
     list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineExtensionInstanceView]
    :ivar vm_health: The health status for the VM.
    :vartype vm_health: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineHealthStatus
    :param boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :type boot_diagnostics: ~azure.mgmt.compute.v2020_06_01.models.BootDiagnosticsInstanceView
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2020_06_01.models.InstanceViewStatus]
    :ivar assigned_host: Resource id of the dedicated host, on which the virtual machine is
     allocated through automatic placement, when the virtual machine is associated with a dedicated
     host group that has automatic placement enabled. :code:`<br>`:code:`<br>`Minimum api-version:
     2020-06-01.
    :vartype assigned_host: str
    :param placement_group_id: The placement group in which the VM is running. If the VM is
     deallocated it will not have a placementGroupId.
    :type placement_group_id: str
    """

    _validation = {
        'vm_health': {'readonly': True},
        'assigned_host': {'readonly': True},
    }

    _attribute_map = {
        'platform_update_domain': {'key': 'platformUpdateDomain', 'type': 'int'},
        'platform_fault_domain': {'key': 'platformFaultDomain', 'type': 'int'},
        'rdp_thumb_print': {'key': 'rdpThumbPrint', 'type': 'str'},
        'vm_agent': {'key': 'vmAgent', 'type': 'VirtualMachineAgentInstanceView'},
        'maintenance_redeploy_status': {'key': 'maintenanceRedeployStatus', 'type': 'MaintenanceRedeployStatus'},
        'disks': {'key': 'disks', 'type': '[DiskInstanceView]'},
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineExtensionInstanceView]'},
        'vm_health': {'key': 'vmHealth', 'type': 'VirtualMachineHealthStatus'},
        'boot_diagnostics': {'key': 'bootDiagnostics', 'type': 'BootDiagnosticsInstanceView'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
        'assigned_host': {'key': 'assignedHost', 'type': 'str'},
        'placement_group_id': {'key': 'placementGroupId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMInstanceView, self).__init__(**kwargs)
        self.platform_update_domain = kwargs.get('platform_update_domain', None)
        self.platform_fault_domain = kwargs.get('platform_fault_domain', None)
        self.rdp_thumb_print = kwargs.get('rdp_thumb_print', None)
        self.vm_agent = kwargs.get('vm_agent', None)
        self.maintenance_redeploy_status = kwargs.get('maintenance_redeploy_status', None)
        self.disks = kwargs.get('disks', None)
        self.extensions = kwargs.get('extensions', None)
        self.vm_health = None
        self.boot_diagnostics = kwargs.get('boot_diagnostics', None)
        self.statuses = kwargs.get('statuses', None)
        self.assigned_host = None
        self.placement_group_id = kwargs.get('placement_group_id', None)


class VirtualMachineScaleSetVMListResult(msrest.serialization.Model):
    """The List Virtual Machine Scale Set VMs operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machine scale sets VMs.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetVM]
    :param next_link: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call
     ListNext() with this to fetch the next page of VMSS VMs.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSetVM]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class VirtualMachineScaleSetVMNetworkProfileConfiguration(msrest.serialization.Model):
    """Describes a virtual machine scale set VM network profile.

    :param network_interface_configurations: The list of network configurations.
    :type network_interface_configurations:
     list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetNetworkConfiguration]
    """

    _attribute_map = {
        'network_interface_configurations': {'key': 'networkInterfaceConfigurations', 'type': '[VirtualMachineScaleSetNetworkConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMNetworkProfileConfiguration, self).__init__(**kwargs)
        self.network_interface_configurations = kwargs.get('network_interface_configurations', None)


class VirtualMachineScaleSetVMProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set virtual machine profile.

    :param os_profile: Specifies the operating system settings for the virtual machines in the
     scale set.
    :type os_profile: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetOSProfile
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetStorageProfile
    :param network_profile: Specifies properties of the network interfaces of the virtual machines
     in the scale set.
    :type network_profile:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetNetworkProfile
    :param security_profile: Specifies the Security related profile settings for the virtual
     machines in the scale set.
    :type security_profile: ~azure.mgmt.compute.v2020_06_01.models.SecurityProfile
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :type diagnostics_profile: ~azure.mgmt.compute.v2020_06_01.models.DiagnosticsProfile
    :param extension_profile: Specifies a collection of settings for extensions installed on
     virtual machines in the scale set.
    :type extension_profile:
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineScaleSetExtensionProfile
    :param license_type: Specifies that the image or disk that is being used was licensed on-
     premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type license_type: str
    :param priority: Specifies the priority for the virtual machines in the scale set.
     :code:`<br>`:code:`<br>`Minimum api-version: 2017-10-30-preview. Possible values include:
     "Regular", "Low", "Spot".
    :type priority: str or ~azure.mgmt.compute.v2020_06_01.models.VirtualMachinePriorityTypes
    :param eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
     :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
     and the minimum api-version is 2017-10-30-preview. Possible values include: "Deallocate",
     "Delete".
    :type eviction_policy: str or
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineEvictionPolicyTypes
    :param billing_profile: Specifies the billing related details of a Azure Spot VMSS.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :type billing_profile: ~azure.mgmt.compute.v2020_06_01.models.BillingProfile
    :param scheduled_events_profile: Specifies Scheduled Event related configurations.
    :type scheduled_events_profile: ~azure.mgmt.compute.v2020_06_01.models.ScheduledEventsProfile
    """

    _attribute_map = {
        'os_profile': {'key': 'osProfile', 'type': 'VirtualMachineScaleSetOSProfile'},
        'storage_profile': {'key': 'storageProfile', 'type': 'VirtualMachineScaleSetStorageProfile'},
        'network_profile': {'key': 'networkProfile', 'type': 'VirtualMachineScaleSetNetworkProfile'},
        'security_profile': {'key': 'securityProfile', 'type': 'SecurityProfile'},
        'diagnostics_profile': {'key': 'diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'extension_profile': {'key': 'extensionProfile', 'type': 'VirtualMachineScaleSetExtensionProfile'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'str'},
        'eviction_policy': {'key': 'evictionPolicy', 'type': 'str'},
        'billing_profile': {'key': 'billingProfile', 'type': 'BillingProfile'},
        'scheduled_events_profile': {'key': 'scheduledEventsProfile', 'type': 'ScheduledEventsProfile'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMProfile, self).__init__(**kwargs)
        self.os_profile = kwargs.get('os_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.security_profile = kwargs.get('security_profile', None)
        self.diagnostics_profile = kwargs.get('diagnostics_profile', None)
        self.extension_profile = kwargs.get('extension_profile', None)
        self.license_type = kwargs.get('license_type', None)
        self.priority = kwargs.get('priority', None)
        self.eviction_policy = kwargs.get('eviction_policy', None)
        self.billing_profile = kwargs.get('billing_profile', None)
        self.scheduled_events_profile = kwargs.get('scheduled_events_profile', None)


class VirtualMachineScaleSetVMProtectionPolicy(msrest.serialization.Model):
    """The protection policy of a virtual machine scale set VM.

    :param protect_from_scale_in: Indicates that the virtual machine scale set VM shouldn't be
     considered for deletion during a scale-in operation.
    :type protect_from_scale_in: bool
    :param protect_from_scale_set_actions: Indicates that model updates or actions (including
     scale-in) initiated on the virtual machine scale set should not be applied to the virtual
     machine scale set VM.
    :type protect_from_scale_set_actions: bool
    """

    _attribute_map = {
        'protect_from_scale_in': {'key': 'protectFromScaleIn', 'type': 'bool'},
        'protect_from_scale_set_actions': {'key': 'protectFromScaleSetActions', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMProtectionPolicy, self).__init__(**kwargs)
        self.protect_from_scale_in = kwargs.get('protect_from_scale_in', None)
        self.protect_from_scale_set_actions = kwargs.get('protect_from_scale_set_actions', None)


class VirtualMachineScaleSetVMReimageParameters(VirtualMachineReimageParameters):
    """Describes a Virtual Machine Scale Set VM Reimage Parameters.

    :param temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This temp
     disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
    :type temp_disk: bool
    """

    _attribute_map = {
        'temp_disk': {'key': 'tempDisk', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMReimageParameters, self).__init__(**kwargs)


class VirtualMachineSize(msrest.serialization.Model):
    """Describes the properties of a VM size.

    :param name: The name of the virtual machine size.
    :type name: str
    :param number_of_cores: The number of cores supported by the virtual machine size.
    :type number_of_cores: int
    :param os_disk_size_in_mb: The OS disk size, in MB, allowed by the virtual machine size.
    :type os_disk_size_in_mb: int
    :param resource_disk_size_in_mb: The resource disk size, in MB, allowed by the virtual machine
     size.
    :type resource_disk_size_in_mb: int
    :param memory_in_mb: The amount of memory, in MB, supported by the virtual machine size.
    :type memory_in_mb: int
    :param max_data_disk_count: The maximum number of data disks that can be attached to the
     virtual machine size.
    :type max_data_disk_count: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'number_of_cores': {'key': 'numberOfCores', 'type': 'int'},
        'os_disk_size_in_mb': {'key': 'osDiskSizeInMB', 'type': 'int'},
        'resource_disk_size_in_mb': {'key': 'resourceDiskSizeInMB', 'type': 'int'},
        'memory_in_mb': {'key': 'memoryInMB', 'type': 'int'},
        'max_data_disk_count': {'key': 'maxDataDiskCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineSize, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.number_of_cores = kwargs.get('number_of_cores', None)
        self.os_disk_size_in_mb = kwargs.get('os_disk_size_in_mb', None)
        self.resource_disk_size_in_mb = kwargs.get('resource_disk_size_in_mb', None)
        self.memory_in_mb = kwargs.get('memory_in_mb', None)
        self.max_data_disk_count = kwargs.get('max_data_disk_count', None)


class VirtualMachineSizeListResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    :param value: The list of virtual machine sizes.
    :type value: list[~azure.mgmt.compute.v2020_06_01.models.VirtualMachineSize]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineSize]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineSizeListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class VirtualMachineSoftwarePatchProperties(msrest.serialization.Model):
    """Describes the properties of a Virtual Machine software patch.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar patch_id: A unique identifier for the patch.
    :vartype patch_id: str
    :ivar name: The friendly name of the patch.
    :vartype name: str
    :ivar version: The version number of the patch. This property applies only to Linux patches.
    :vartype version: str
    :ivar kbid: The KBID of the patch. Only applies to Windows patches.
    :vartype kbid: str
    :ivar classifications: The classification(s) of the patch as provided by the patch publisher.
    :vartype classifications: list[str]
    :ivar reboot_behavior: Describes the reboot requirements of the patch. Possible values include:
     "NeverReboots", "AlwaysRequiresReboot", "CanRequestReboot".
    :vartype reboot_behavior: str or
     ~azure.mgmt.compute.v2020_06_01.models.SoftwareUpdateRebootBehavior
    :ivar activity_id: The activity ID of the operation that produced this result. It is used to
     correlate across CRP and extension logs.
    :vartype activity_id: str
    :ivar published_date: The UTC timestamp when the repository published this patch.
    :vartype published_date: ~datetime.datetime
    :ivar last_modified_date_time: The UTC timestamp of the last update to this patch record.
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar assessment_state: Describes the outcome of an install operation for a given patch.
     Possible values include: "Installed", "Failed", "Excluded", "NotSelected", "Pending",
     "Available".
    :vartype assessment_state: str or ~azure.mgmt.compute.v2020_06_01.models.PatchAssessmentState
    """

    _validation = {
        'patch_id': {'readonly': True},
        'name': {'readonly': True},
        'version': {'readonly': True},
        'kbid': {'readonly': True},
        'classifications': {'readonly': True},
        'reboot_behavior': {'readonly': True},
        'activity_id': {'readonly': True},
        'published_date': {'readonly': True},
        'last_modified_date_time': {'readonly': True},
        'assessment_state': {'readonly': True},
    }

    _attribute_map = {
        'patch_id': {'key': 'patchId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'kbid': {'key': 'kbid', 'type': 'str'},
        'classifications': {'key': 'classifications', 'type': '[str]'},
        'reboot_behavior': {'key': 'rebootBehavior', 'type': 'str'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'published_date': {'key': 'publishedDate', 'type': 'iso-8601'},
        'last_modified_date_time': {'key': 'lastModifiedDateTime', 'type': 'iso-8601'},
        'assessment_state': {'key': 'assessmentState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineSoftwarePatchProperties, self).__init__(**kwargs)
        self.patch_id = None
        self.name = None
        self.version = None
        self.kbid = None
        self.classifications = None
        self.reboot_behavior = None
        self.activity_id = None
        self.published_date = None
        self.last_modified_date_time = None
        self.assessment_state = None


class VirtualMachineStatusCodeCount(msrest.serialization.Model):
    """The status code and count of the virtual machine scale set instance view status summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The instance view status code.
    :vartype code: str
    :ivar count: The number of instances having a particular status code.
    :vartype count: int
    """

    _validation = {
        'code': {'readonly': True},
        'count': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineStatusCodeCount, self).__init__(**kwargs)
        self.code = None
        self.count = None


class VirtualMachineUpdate(UpdateResource):
    """Describes a Virtual Machine Update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :type plan: ~azure.mgmt.compute.v2020_06_01.models.Plan
    :param identity: The identity of the virtual machine, if configured.
    :type identity: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineIdentity
    :param zones: The virtual machine zones.
    :type zones: list[str]
    :param hardware_profile: Specifies the hardware settings for the virtual machine.
    :type hardware_profile: ~azure.mgmt.compute.v2020_06_01.models.HardwareProfile
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2020_06_01.models.StorageProfile
    :param additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine.
    :type additional_capabilities: ~azure.mgmt.compute.v2020_06_01.models.AdditionalCapabilities
    :param os_profile: Specifies the operating system settings used while creating the virtual
     machine. Some of the settings cannot be changed once VM is provisioned.
    :type os_profile: ~azure.mgmt.compute.v2020_06_01.models.OSProfile
    :param network_profile: Specifies the network interfaces of the virtual machine.
    :type network_profile: ~azure.mgmt.compute.v2020_06_01.models.NetworkProfile
    :param security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :type security_profile: ~azure.mgmt.compute.v2020_06_01.models.SecurityProfile
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :type diagnostics_profile: ~azure.mgmt.compute.v2020_06_01.models.DiagnosticsProfile
    :param availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Manage the availability of virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-
     availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_. :code:`<br>`:code:`<br>`
     For more information on Azure planned maintenance, see `Planned maintenance for virtual
     machines in Azure <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-
     planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. The availability set to which the VM is being added should be under the same resource
     group as the availability set resource. An existing VM cannot be added to an availability set.
     :code:`<br>`:code:`<br>`This property cannot exist along with a non-null
     properties.virtualMachineScaleSet reference.
    :type availability_set: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param virtual_machine_scale_set: Specifies information about the virtual machine scale set
     that the virtual machine should be assigned to. Virtual machines specified in the same virtual
     machine scale set are allocated to different nodes to maximize availability. Currently, a VM
     can only be added to virtual machine scale set at creation time. An existing VM cannot be added
     to a virtual machine scale set. :code:`<br>`:code:`<br>`This property cannot exist along with a
     non-null properties.availabilitySet reference. :code:`<br>`:code:`<br>`Minimum api‐version:
     2019‐03‐01.
    :type virtual_machine_scale_set: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param priority: Specifies the priority for the virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01. Possible values include: "Regular",
     "Low", "Spot".
    :type priority: str or ~azure.mgmt.compute.v2020_06_01.models.VirtualMachinePriorityTypes
    :param eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
     :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
     and the minimum api-version is 2017-10-30-preview. Possible values include: "Deallocate",
     "Delete".
    :type eviction_policy: str or
     ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineEvictionPolicyTypes
    :param billing_profile: Specifies the billing related details of a Azure Spot virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :type billing_profile: ~azure.mgmt.compute.v2020_06_01.models.BillingProfile
    :param host: Specifies information about the dedicated host that the virtual machine resides
     in. :code:`<br>`:code:`<br>`Minimum api-version: 2018-10-01.
    :type host: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :param host_group: Specifies information about the dedicated host group that the virtual
     machine resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
     :code:`<br>`:code:`<br>`NOTE: User cannot specify both host and hostGroup properties.
    :type host_group: ~azure.mgmt.compute.v2020_06_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2020_06_01.models.VirtualMachineInstanceView
    :param license_type: Specifies that the image or disk that is being used was licensed on-
     premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    :param extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
     api-version: 2020-06-01.
    :type extensions_time_budget: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
        'vm_id': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'identity': {'key': 'identity', 'type': 'VirtualMachineIdentity'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'additional_capabilities': {'key': 'properties.additionalCapabilities', 'type': 'AdditionalCapabilities'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'security_profile': {'key': 'properties.securityProfile', 'type': 'SecurityProfile'},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'availability_set': {'key': 'properties.availabilitySet', 'type': 'SubResource'},
        'virtual_machine_scale_set': {'key': 'properties.virtualMachineScaleSet', 'type': 'SubResource'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'priority': {'key': 'properties.priority', 'type': 'str'},
        'eviction_policy': {'key': 'properties.evictionPolicy', 'type': 'str'},
        'billing_profile': {'key': 'properties.billingProfile', 'type': 'BillingProfile'},
        'host': {'key': 'properties.host', 'type': 'SubResource'},
        'host_group': {'key': 'properties.hostGroup', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineInstanceView'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
        'extensions_time_budget': {'key': 'properties.extensionsTimeBudget', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineUpdate, self).__init__(**kwargs)
        self.plan = kwargs.get('plan', None)
        self.identity = kwargs.get('identity', None)
        self.zones = kwargs.get('zones', None)
        self.hardware_profile = kwargs.get('hardware_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.additional_capabilities = kwargs.get('additional_capabilities', None)
        self.os_profile = kwargs.get('os_profile', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.security_profile = kwargs.get('security_profile', None)
        self.diagnostics_profile = kwargs.get('diagnostics_profile', None)
        self.availability_set = kwargs.get('availability_set', None)
        self.virtual_machine_scale_set = kwargs.get('virtual_machine_scale_set', None)
        self.proximity_placement_group = kwargs.get('proximity_placement_group', None)
        self.priority = kwargs.get('priority', None)
        self.eviction_policy = kwargs.get('eviction_policy', None)
        self.billing_profile = kwargs.get('billing_profile', None)
        self.host = kwargs.get('host', None)
        self.host_group = kwargs.get('host_group', None)
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = kwargs.get('license_type', None)
        self.vm_id = None
        self.extensions_time_budget = kwargs.get('extensions_time_budget', None)


class VMScaleSetConvertToSinglePlacementGroupInput(msrest.serialization.Model):
    """VMScaleSetConvertToSinglePlacementGroupInput.

    :param active_placement_group_id: Id of the placement group in which you want future virtual
     machine instances to be placed. To query placement group Id, please use Virtual Machine Scale
     Set VMs - Get API. If not provided, the platform will choose one with maximum number of virtual
     machine instances.
    :type active_placement_group_id: str
    """

    _attribute_map = {
        'active_placement_group_id': {'key': 'activePlacementGroupId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VMScaleSetConvertToSinglePlacementGroupInput, self).__init__(**kwargs)
        self.active_placement_group_id = kwargs.get('active_placement_group_id', None)


class WindowsConfiguration(msrest.serialization.Model):
    """Specifies Windows operating system settings on the virtual machine.

    :param provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the request
     body, default behavior is to set it to true.  This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later.
    :type provision_vm_agent: bool
    :param enable_automatic_updates: Indicates whether Automatic Updates is enabled for the Windows
     virtual machine. Default value is true. :code:`<br>`:code:`<br>` For virtual machine scale
     sets, this property can be updated and updates will take effect on OS reprovisioning.
    :type enable_automatic_updates: bool
    :param time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time".
     :code:`<br>`:code:`<br>` Possible values can be `TimeZoneInfo.Id
     <https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id>`_
     value from time zones returned by `TimeZoneInfo.GetSystemTimeZones
     <https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.getsystemtimezones>`_.
    :type time_zone: str
    :param additional_unattend_content: Specifies additional base-64 encoded XML formatted
     information that can be included in the Unattend.xml file, which is used by Windows Setup.
    :type additional_unattend_content:
     list[~azure.mgmt.compute.v2020_06_01.models.AdditionalUnattendContent]
    :param patch_settings: Specifies settings related to in-guest patching (KBs).
    :type patch_settings: ~azure.mgmt.compute.v2020_06_01.models.PatchSettings
    :param win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
     PowerShell.
    :type win_rm: ~azure.mgmt.compute.v2020_06_01.models.WinRMConfiguration
    """

    _attribute_map = {
        'provision_vm_agent': {'key': 'provisionVMAgent', 'type': 'bool'},
        'enable_automatic_updates': {'key': 'enableAutomaticUpdates', 'type': 'bool'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'additional_unattend_content': {'key': 'additionalUnattendContent', 'type': '[AdditionalUnattendContent]'},
        'patch_settings': {'key': 'patchSettings', 'type': 'PatchSettings'},
        'win_rm': {'key': 'winRM', 'type': 'WinRMConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WindowsConfiguration, self).__init__(**kwargs)
        self.provision_vm_agent = kwargs.get('provision_vm_agent', None)
        self.enable_automatic_updates = kwargs.get('enable_automatic_updates', None)
        self.time_zone = kwargs.get('time_zone', None)
        self.additional_unattend_content = kwargs.get('additional_unattend_content', None)
        self.patch_settings = kwargs.get('patch_settings', None)
        self.win_rm = kwargs.get('win_rm', None)


class WinRMConfiguration(msrest.serialization.Model):
    """Describes Windows Remote Management configuration of the VM.

    :param listeners: The list of Windows Remote Management listeners.
    :type listeners: list[~azure.mgmt.compute.v2020_06_01.models.WinRMListener]
    """

    _attribute_map = {
        'listeners': {'key': 'listeners', 'type': '[WinRMListener]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WinRMConfiguration, self).__init__(**kwargs)
        self.listeners = kwargs.get('listeners', None)


class WinRMListener(msrest.serialization.Model):
    """Describes Protocol and thumbprint of Windows Remote Management listener.

    :param protocol: Specifies the protocol of WinRM listener. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`\ **http** :code:`<br>`:code:`<br>` **https**. Possible values include:
     "Http", "Https".
    :type protocol: str or ~azure.mgmt.compute.v2020_06_01.models.ProtocolTypes
    :param certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`  "data":":code:`<Base64-encoded-
     certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`  "password":":code:`<pfx-file-
     password>`":code:`<br>`}.
    :type certificate_url: str
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'certificate_url': {'key': 'certificateUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WinRMListener, self).__init__(**kwargs)
        self.protocol = kwargs.get('protocol', None)
        self.certificate_url = kwargs.get('certificate_url', None)
