/*
 * SPDX-FileCopyrightText: 2006-2021 Istituto Italiano di Tecnologia (IIT)
 * SPDX-License-Identifier: BSD-3-Clause
 */

// Autogenerated by Thrift Compiler (0.14.1-yarped)
//
// This is an automatically generated file.
// It could get re-generated if the ALLOW_IDL_GENERATION flag is on.

#include <return_getAllTransforms.h>

// Default constructor
return_getAllTransforms::return_getAllTransforms() :
        WirePortable(),
        retvalue(0),
        transforms_list()
{
}

// Constructor with field values
return_getAllTransforms::return_getAllTransforms(const bool retvalue,
                                                 const std::vector<yarp::math::FrameTransform>& transforms_list) :
        WirePortable(),
        retvalue(retvalue),
        transforms_list(transforms_list)
{
}

// Read structure on a Wire
bool return_getAllTransforms::read(yarp::os::idl::WireReader& reader)
{
    if (!read_retvalue(reader)) {
        return false;
    }
    if (!read_transforms_list(reader)) {
        return false;
    }
    return !reader.isError();
}

// Read structure on a Connection
bool return_getAllTransforms::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader(2)) {
        return false;
    }
    return read(reader);
}

// Write structure on a Wire
bool return_getAllTransforms::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!write_retvalue(writer)) {
        return false;
    }
    if (!write_transforms_list(writer)) {
        return false;
    }
    return !writer.isError();
}

// Write structure on a Connection
bool return_getAllTransforms::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    return write(writer);
}

// Convert to a printable string
std::string return_getAllTransforms::toString() const
{
    yarp::os::Bottle b;
    b.read(*this);
    return b.toString();
}

// Editor: default constructor
return_getAllTransforms::Editor::Editor()
{
    group = 0;
    obj_owned = true;
    obj = new return_getAllTransforms;
    dirty_flags(false);
    yarp().setOwner(*this);
}

// Editor: constructor with base class
return_getAllTransforms::Editor::Editor(return_getAllTransforms& obj)
{
    group = 0;
    obj_owned = false;
    edit(obj, false);
    yarp().setOwner(*this);
}

// Editor: destructor
return_getAllTransforms::Editor::~Editor()
{
    if (obj_owned) {
        delete obj;
    }
}

// Editor: edit
bool return_getAllTransforms::Editor::edit(return_getAllTransforms& obj, bool dirty)
{
    if (obj_owned) {
        delete this->obj;
    }
    this->obj = &obj;
    obj_owned = false;
    dirty_flags(dirty);
    return true;
}

// Editor: validity check
bool return_getAllTransforms::Editor::isValid() const
{
    return obj != nullptr;
}

// Editor: state
return_getAllTransforms& return_getAllTransforms::Editor::state()
{
    return *obj;
}

// Editor: grouping begin
void return_getAllTransforms::Editor::start_editing()
{
    group++;
}

// Editor: grouping end
void return_getAllTransforms::Editor::stop_editing()
{
    group--;
    if (group == 0 && is_dirty) {
        communicate();
    }
}
// Editor: retvalue setter
void return_getAllTransforms::Editor::set_retvalue(const bool retvalue)
{
    will_set_retvalue();
    obj->retvalue = retvalue;
    mark_dirty_retvalue();
    communicate();
    did_set_retvalue();
}

// Editor: retvalue getter
bool return_getAllTransforms::Editor::get_retvalue() const
{
    return obj->retvalue;
}

// Editor: retvalue will_set
bool return_getAllTransforms::Editor::will_set_retvalue()
{
    return true;
}

// Editor: retvalue did_set
bool return_getAllTransforms::Editor::did_set_retvalue()
{
    return true;
}

// Editor: transforms_list setter
void return_getAllTransforms::Editor::set_transforms_list(const std::vector<yarp::math::FrameTransform>& transforms_list)
{
    will_set_transforms_list();
    obj->transforms_list = transforms_list;
    mark_dirty_transforms_list();
    communicate();
    did_set_transforms_list();
}

// Editor: transforms_list setter (list)
void return_getAllTransforms::Editor::set_transforms_list(size_t index, const yarp::math::FrameTransform& elem)
{
    will_set_transforms_list();
    obj->transforms_list[index] = elem;
    mark_dirty_transforms_list();
    communicate();
    did_set_transforms_list();
}

// Editor: transforms_list getter
const std::vector<yarp::math::FrameTransform>& return_getAllTransforms::Editor::get_transforms_list() const
{
    return obj->transforms_list;
}

// Editor: transforms_list will_set
bool return_getAllTransforms::Editor::will_set_transforms_list()
{
    return true;
}

// Editor: transforms_list did_set
bool return_getAllTransforms::Editor::did_set_transforms_list()
{
    return true;
}

// Editor: clean
void return_getAllTransforms::Editor::clean()
{
    dirty_flags(false);
}

// Editor: read
bool return_getAllTransforms::Editor::read(yarp::os::ConnectionReader& connection)
{
    if (!isValid()) {
        return false;
    }
    yarp::os::idl::WireReader reader(connection);
    reader.expectAccept();
    if (!reader.readListHeader()) {
        return false;
    }
    int len = reader.getLength();
    if (len == 0) {
        yarp::os::idl::WireWriter writer(reader);
        if (writer.isNull()) {
            return true;
        }
        if (!writer.writeListHeader(1)) {
            return false;
        }
        writer.writeString("send: 'help' or 'patch (param1 val1) (param2 val2)'");
        return true;
    }
    std::string tag;
    if (!reader.readString(tag)) {
        return false;
    }
    if (tag == "help") {
        yarp::os::idl::WireWriter writer(reader);
        if (writer.isNull()) {
            return true;
        }
        if (!writer.writeListHeader(2)) {
            return false;
        }
        if (!writer.writeTag("many", 1, 0)) {
            return false;
        }
        if (reader.getLength() > 0) {
            std::string field;
            if (!reader.readString(field)) {
                return false;
            }
            if (field == "retvalue") {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeString("bool retvalue")) {
                    return false;
                }
            }
            if (field == "transforms_list") {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeString("std::vector<yarp::math::FrameTransform> transforms_list")) {
                    return false;
                }
            }
        }
        if (!writer.writeListHeader(3)) {
            return false;
        }
        writer.writeString("*** Available fields:");
        writer.writeString("retvalue");
        writer.writeString("transforms_list");
        return true;
    }
    bool nested = true;
    bool have_act = false;
    if (tag != "patch") {
        if (((len - 1) % 2) != 0) {
            return false;
        }
        len = 1 + ((len - 1) / 2);
        nested = false;
        have_act = true;
    }
    for (int i = 1; i < len; ++i) {
        if (nested && !reader.readListHeader(3)) {
            return false;
        }
        std::string act;
        std::string key;
        if (have_act) {
            act = tag;
        } else if (!reader.readString(act)) {
            return false;
        }
        if (!reader.readString(key)) {
            return false;
        }
        if (key == "retvalue") {
            will_set_retvalue();
            if (!obj->nested_read_retvalue(reader)) {
                return false;
            }
            did_set_retvalue();
        } else if (key == "transforms_list") {
            will_set_transforms_list();
            if (!obj->nested_read_transforms_list(reader)) {
                return false;
            }
            did_set_transforms_list();
        } else {
            // would be useful to have a fallback here
        }
    }
    reader.accept();
    yarp::os::idl::WireWriter writer(reader);
    if (writer.isNull()) {
        return true;
    }
    writer.writeListHeader(1);
    writer.writeVocab32('o', 'k');
    return true;
}

// Editor: write
bool return_getAllTransforms::Editor::write(yarp::os::ConnectionWriter& connection) const
{
    if (!isValid()) {
        return false;
    }
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(dirty_count + 1)) {
        return false;
    }
    if (!writer.writeString("patch")) {
        return false;
    }
    if (is_dirty_retvalue) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("retvalue")) {
            return false;
        }
        if (!obj->nested_write_retvalue(writer)) {
            return false;
        }
    }
    if (is_dirty_transforms_list) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("transforms_list")) {
            return false;
        }
        if (!obj->nested_write_transforms_list(writer)) {
            return false;
        }
    }
    return !writer.isError();
}

// Editor: send if possible
void return_getAllTransforms::Editor::communicate()
{
    if (group != 0) {
        return;
    }
    if (yarp().canWrite()) {
        yarp().write(*this);
        clean();
    }
}

// Editor: mark dirty overall
void return_getAllTransforms::Editor::mark_dirty()
{
    is_dirty = true;
}

// Editor: retvalue mark_dirty
void return_getAllTransforms::Editor::mark_dirty_retvalue()
{
    if (is_dirty_retvalue) {
        return;
    }
    dirty_count++;
    is_dirty_retvalue = true;
    mark_dirty();
}

// Editor: transforms_list mark_dirty
void return_getAllTransforms::Editor::mark_dirty_transforms_list()
{
    if (is_dirty_transforms_list) {
        return;
    }
    dirty_count++;
    is_dirty_transforms_list = true;
    mark_dirty();
}

// Editor: dirty_flags
void return_getAllTransforms::Editor::dirty_flags(bool flag)
{
    is_dirty = flag;
    is_dirty_retvalue = flag;
    is_dirty_transforms_list = flag;
    dirty_count = flag ? 2 : 0;
}

// read retvalue field
bool return_getAllTransforms::read_retvalue(yarp::os::idl::WireReader& reader)
{
    if (!reader.readBool(retvalue)) {
        reader.fail();
        return false;
    }
    return true;
}

// write retvalue field
bool return_getAllTransforms::write_retvalue(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeBool(retvalue)) {
        return false;
    }
    return true;
}

// read (nested) retvalue field
bool return_getAllTransforms::nested_read_retvalue(yarp::os::idl::WireReader& reader)
{
    if (!reader.readBool(retvalue)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) retvalue field
bool return_getAllTransforms::nested_write_retvalue(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeBool(retvalue)) {
        return false;
    }
    return true;
}

// read transforms_list field
bool return_getAllTransforms::read_transforms_list(yarp::os::idl::WireReader& reader)
{
    transforms_list.clear();
    uint32_t _size0;
    yarp::os::idl::WireState _etype3;
    reader.readListBegin(_etype3, _size0);
    transforms_list.resize(_size0);
    for (size_t _i4 = 0; _i4 < _size0; ++_i4) {
        if (!reader.readNested(transforms_list[_i4])) {
            reader.fail();
            return false;
        }
    }
    reader.readListEnd();
    return true;
}

// write transforms_list field
bool return_getAllTransforms::write_transforms_list(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeListBegin(BOTTLE_TAG_LIST, static_cast<uint32_t>(transforms_list.size()))) {
        return false;
    }
    for (const auto& _item5 : transforms_list) {
        if (!writer.writeNested(_item5)) {
            return false;
        }
    }
    if (!writer.writeListEnd()) {
        return false;
    }
    return true;
}

// read (nested) transforms_list field
bool return_getAllTransforms::nested_read_transforms_list(yarp::os::idl::WireReader& reader)
{
    transforms_list.clear();
    uint32_t _size6;
    yarp::os::idl::WireState _etype9;
    reader.readListBegin(_etype9, _size6);
    transforms_list.resize(_size6);
    for (size_t _i10 = 0; _i10 < _size6; ++_i10) {
        if (!reader.readNested(transforms_list[_i10])) {
            reader.fail();
            return false;
        }
    }
    reader.readListEnd();
    return true;
}

// write (nested) transforms_list field
bool return_getAllTransforms::nested_write_transforms_list(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeListBegin(BOTTLE_TAG_LIST, static_cast<uint32_t>(transforms_list.size()))) {
        return false;
    }
    for (const auto& _item11 : transforms_list) {
        if (!writer.writeNested(_item11)) {
            return false;
        }
    }
    if (!writer.writeListEnd()) {
        return false;
    }
    return true;
}
