# Generated by Django 2.2.6 on 2019-10-03 22:43

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('epic', '0008_auto_20180203_0553'),
    ]

    operations = [
        migrations.CreateModel(
            name='Stock_Cache_Entry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ts', models.DateTimeField(help_text='Date and time when this transaction was created.', verbose_name='Creation Time')),
            ],
            options={
                'ordering': ['-ts'],
            },
        ),
        migrations.CreateModel(
            name='Stock_Cache_Item',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('qty', models.IntegerField(help_text='The quantity of this part.')),
            ],
        ),
        migrations.AlterModelOptions(
            name='part',
            options={'ordering': ['id']},
        ),
        migrations.AlterField(
            model_name='vendor',
            name='name',
            field=models.CharField(max_length=31, unique=True, verbose_name='Vendor Name'),
        ),
        migrations.AlterIndexTogether(
            name='line_item',
            index_together={('txtn',), ('txtn', 'part')},
        ),
        migrations.AddIndex(
            model_name='delta',
            index=models.Index(fields=['txtn'], name='epic_delta_txtn_id_2ad9e1_idx'),
        ),
        migrations.AddIndex(
            model_name='delta',
            index=models.Index(fields=['warehouse'], name='epic_delta_warehou_9b26a4_idx'),
        ),
        migrations.AddIndex(
            model_name='vendor',
            index=models.Index(fields=['name'], name='epic_vendor_name_952e9d_idx'),
        ),
        migrations.AddField(
            model_name='stock_cache_item',
            name='part',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='epic.Part', verbose_name='Part #'),
        ),
        migrations.AddField(
            model_name='stock_cache_item',
            name='stock_cache_entry',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='epic.Stock_Cache_Entry'),
        ),
        migrations.AddField(
            model_name='stock_cache_item',
            name='warehouse',
            field=models.ForeignKey(help_text='The warehouse stocking this part.', on_delete=django.db.models.deletion.CASCADE, to='epic.Warehouse', verbose_name='Warehouse'),
        ),
        migrations.AddIndex(
            model_name='stock_cache_entry',
            index=models.Index(fields=['ts'], name='epic_stock__ts_25efd9_idx'),
        ),
        migrations.AddIndex(
            model_name='stock_cache_item',
            index=models.Index(fields=['stock_cache_entry'], name='epic_stock__stock_c_4ffb48_idx'),
        ),
    ]
