# Tasks

The primary goal of the safe-autonomy-sims repository is to provide reinforcement learning tasks of scaling complexity that are relevant to aerospace operations. These tasks can serve as benchmarks for researcher's novel techniques in the fields of reinforcement learning and robotics. These tasks seek to replicate real world aerospace maneuvers with a high likelihood of successful autonomization. The current implemented tasks are relatively low fidelity simulations, but higher fidelity tasks will be added in time. The following list contains all currently available tasks:

- [CWH](CWH/index.md)
    - [Docking](CWH/docking.md)
    - [Translational Inspection](CWH/translational_inspection.md)
    - [Weighted Translational Inspection](CWH/weighted_translational_inspection.md)
    - [Weighted Six DoF Inspection](CWH/weighted_six_dof_inspection.md)
    - [Multiagent Docking](CWH/multiagent_docking.md)
    - [Multiagent Translational Inspection](CWH/multiagent_translational_inspection.md)
    - [Multiagent Weighted Translational Inspection](CWH/multiagent_weighted_translational_inspection.md)
    - [Multiagent Weighted Six DoF Inspection](CWH/multiagent_weighted_six_dof_inspection.md)
