import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::RDS::DBCluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 * @external
 */
export interface CfnDBClusterProps {
    /**
     * `AWS::RDS::DBCluster.Engine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engine
     * @external
     */
    readonly engine: string;
    /**
     * `AWS::RDS::DBCluster.AssociatedRoles`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-associatedroles
     * @external
     */
    readonly associatedRoles?: Array<CfnDBCluster.DBClusterRoleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.AvailabilityZones`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-availabilityzones
     * @external
     */
    readonly availabilityZones?: string[];
    /**
     * `AWS::RDS::DBCluster.BacktrackWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backtrackwindow
     * @external
     */
    readonly backtrackWindow?: number;
    /**
     * `AWS::RDS::DBCluster.BackupRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backuprententionperiod
     * @external
     */
    readonly backupRetentionPeriod?: number;
    /**
     * `AWS::RDS::DBCluster.DatabaseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-databasename
     * @external
     */
    readonly databaseName?: string;
    /**
     * `AWS::RDS::DBCluster.DBClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusteridentifier
     * @external
     */
    readonly dbClusterIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.DBClusterParameterGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusterparametergroupname
     * @external
     */
    readonly dbClusterParameterGroupName?: string;
    /**
     * `AWS::RDS::DBCluster.DBSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbsubnetgroupname
     * @external
     */
    readonly dbSubnetGroupName?: string;
    /**
     * `AWS::RDS::DBCluster.DeletionProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-deletionprotection
     * @external
     */
    readonly deletionProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.EnableCloudwatchLogsExports`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablecloudwatchlogsexports
     * @external
     */
    readonly enableCloudwatchLogsExports?: string[];
    /**
     * `AWS::RDS::DBCluster.EnableHttpEndpoint`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablehttpendpoint
     * @external
     */
    readonly enableHttpEndpoint?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enableiamdatabaseauthentication
     * @external
     */
    readonly enableIamDatabaseAuthentication?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.EngineMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enginemode
     * @external
     */
    readonly engineMode?: string;
    /**
     * `AWS::RDS::DBCluster.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engineversion
     * @external
     */
    readonly engineVersion?: string;
    /**
     * `AWS::RDS::DBCluster.GlobalClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-globalclusteridentifier
     * @external
     */
    readonly globalClusterIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::RDS::DBCluster.MasterUsername`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masterusername
     * @external
     */
    readonly masterUsername?: string;
    /**
     * `AWS::RDS::DBCluster.MasterUserPassword`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masteruserpassword
     * @external
     */
    readonly masterUserPassword?: string;
    /**
     * `AWS::RDS::DBCluster.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-port
     * @external
     */
    readonly port?: number;
    /**
     * `AWS::RDS::DBCluster.PreferredBackupWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredbackupwindow
     * @external
     */
    readonly preferredBackupWindow?: string;
    /**
     * `AWS::RDS::DBCluster.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredmaintenancewindow
     * @external
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::RDS::DBCluster.ReplicationSourceIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-replicationsourceidentifier
     * @external
     */
    readonly replicationSourceIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.RestoreType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-restoretype
     * @external
     */
    readonly restoreType?: string;
    /**
     * `AWS::RDS::DBCluster.ScalingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-scalingconfiguration
     * @external
     */
    readonly scalingConfiguration?: CfnDBCluster.ScalingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.SnapshotIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-snapshotidentifier
     * @external
     */
    readonly snapshotIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.SourceDBClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourcedbclusteridentifier
     * @external
     */
    readonly sourceDbClusterIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.SourceRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourceregion
     * @external
     */
    readonly sourceRegion?: string;
    /**
     * `AWS::RDS::DBCluster.StorageEncrypted`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-storageencrypted
     * @external
     */
    readonly storageEncrypted?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::RDS::DBCluster.UseLatestRestorableTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-uselatestrestorabletime
     * @external
     */
    readonly useLatestRestorableTime?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.VpcSecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-vpcsecuritygroupids
     * @external
     */
    readonly vpcSecurityGroupIds?: string[];
}
/**
 * A CloudFormation `AWS::RDS::DBCluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 * @external
 * @cloudformationResource AWS::RDS::DBCluster
 */
export declare class CfnDBCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBCluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBCluster;
    /**
     * @external
     * @cloudformationAttribute Endpoint.Address
     */
    readonly attrEndpointAddress: string;
    /**
     * @external
     * @cloudformationAttribute Endpoint.Port
     */
    readonly attrEndpointPort: string;
    /**
     * @external
     * @cloudformationAttribute ReadEndpoint.Address
     */
    readonly attrReadEndpointAddress: string;
    /**
     * `AWS::RDS::DBCluster.Engine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engine
     * @external
     */
    engine: string;
    /**
     * `AWS::RDS::DBCluster.AssociatedRoles`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-associatedroles
     * @external
     */
    associatedRoles: Array<CfnDBCluster.DBClusterRoleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.AvailabilityZones`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-availabilityzones
     * @external
     */
    availabilityZones: string[] | undefined;
    /**
     * `AWS::RDS::DBCluster.BacktrackWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backtrackwindow
     * @external
     */
    backtrackWindow: number | undefined;
    /**
     * `AWS::RDS::DBCluster.BackupRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backuprententionperiod
     * @external
     */
    backupRetentionPeriod: number | undefined;
    /**
     * `AWS::RDS::DBCluster.DatabaseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-databasename
     * @external
     */
    databaseName: string | undefined;
    /**
     * `AWS::RDS::DBCluster.DBClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusteridentifier
     * @external
     */
    dbClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.DBClusterParameterGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusterparametergroupname
     * @external
     */
    dbClusterParameterGroupName: string | undefined;
    /**
     * `AWS::RDS::DBCluster.DBSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbsubnetgroupname
     * @external
     */
    dbSubnetGroupName: string | undefined;
    /**
     * `AWS::RDS::DBCluster.DeletionProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-deletionprotection
     * @external
     */
    deletionProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.EnableCloudwatchLogsExports`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablecloudwatchlogsexports
     * @external
     */
    enableCloudwatchLogsExports: string[] | undefined;
    /**
     * `AWS::RDS::DBCluster.EnableHttpEndpoint`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablehttpendpoint
     * @external
     */
    enableHttpEndpoint: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enableiamdatabaseauthentication
     * @external
     */
    enableIamDatabaseAuthentication: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.EngineMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enginemode
     * @external
     */
    engineMode: string | undefined;
    /**
     * `AWS::RDS::DBCluster.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engineversion
     * @external
     */
    engineVersion: string | undefined;
    /**
     * `AWS::RDS::DBCluster.GlobalClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-globalclusteridentifier
     * @external
     */
    globalClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::RDS::DBCluster.MasterUsername`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masterusername
     * @external
     */
    masterUsername: string | undefined;
    /**
     * `AWS::RDS::DBCluster.MasterUserPassword`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masteruserpassword
     * @external
     */
    masterUserPassword: string | undefined;
    /**
     * `AWS::RDS::DBCluster.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-port
     * @external
     */
    port: number | undefined;
    /**
     * `AWS::RDS::DBCluster.PreferredBackupWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredbackupwindow
     * @external
     */
    preferredBackupWindow: string | undefined;
    /**
     * `AWS::RDS::DBCluster.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredmaintenancewindow
     * @external
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::RDS::DBCluster.ReplicationSourceIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-replicationsourceidentifier
     * @external
     */
    replicationSourceIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.RestoreType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-restoretype
     * @external
     */
    restoreType: string | undefined;
    /**
     * `AWS::RDS::DBCluster.ScalingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-scalingconfiguration
     * @external
     */
    scalingConfiguration: CfnDBCluster.ScalingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.SnapshotIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-snapshotidentifier
     * @external
     */
    snapshotIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.SourceDBClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourcedbclusteridentifier
     * @external
     */
    sourceDbClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.SourceRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourceregion
     * @external
     */
    sourceRegion: string | undefined;
    /**
     * `AWS::RDS::DBCluster.StorageEncrypted`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-storageencrypted
     * @external
     */
    storageEncrypted: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::RDS::DBCluster.UseLatestRestorableTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-uselatestrestorabletime
     * @external
     */
    useLatestRestorableTime: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.VpcSecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-vpcsecuritygroupids
     * @external
     */
    vpcSecurityGroupIds: string[] | undefined;
    /**
     * Create a new `AWS::RDS::DBCluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBClusterProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::DBCluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 * @external
 * @cloudformationResource AWS::RDS::DBCluster
 */
export declare namespace CfnDBCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-dbclusterrole.html
     * @external
     */
    interface DBClusterRoleProperty {
        /**
         * `CfnDBCluster.DBClusterRoleProperty.FeatureName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-dbclusterrole.html#cfn-rds-dbcluster-dbclusterrole-featurename
         * @external
         */
        readonly featureName?: string;
        /**
         * `CfnDBCluster.DBClusterRoleProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-dbclusterrole.html#cfn-rds-dbcluster-dbclusterrole-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::RDS::DBCluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 * @external
 * @cloudformationResource AWS::RDS::DBCluster
 */
export declare namespace CfnDBCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html
     * @external
     */
    interface ScalingConfigurationProperty {
        /**
         * `CfnDBCluster.ScalingConfigurationProperty.AutoPause`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html#cfn-rds-dbcluster-scalingconfiguration-autopause
         * @external
         */
        readonly autoPause?: boolean | cdk.IResolvable;
        /**
         * `CfnDBCluster.ScalingConfigurationProperty.MaxCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html#cfn-rds-dbcluster-scalingconfiguration-maxcapacity
         * @external
         */
        readonly maxCapacity?: number;
        /**
         * `CfnDBCluster.ScalingConfigurationProperty.MinCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html#cfn-rds-dbcluster-scalingconfiguration-mincapacity
         * @external
         */
        readonly minCapacity?: number;
        /**
         * `CfnDBCluster.ScalingConfigurationProperty.SecondsUntilAutoPause`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html#cfn-rds-dbcluster-scalingconfiguration-secondsuntilautopause
         * @external
         */
        readonly secondsUntilAutoPause?: number;
    }
}
/**
 * Properties for defining a `AWS::RDS::DBClusterParameterGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html
 * @external
 */
export interface CfnDBClusterParameterGroupProps {
    /**
     * `AWS::RDS::DBClusterParameterGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-description
     * @external
     */
    readonly description: string;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Family`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-family
     * @external
     */
    readonly family: string;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-parameters
     * @external
     */
    readonly parameters: any | cdk.IResolvable;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::DBClusterParameterGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html
 * @external
 * @cloudformationResource AWS::RDS::DBClusterParameterGroup
 */
export declare class CfnDBClusterParameterGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBClusterParameterGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBClusterParameterGroup;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-description
     * @external
     */
    description: string;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Family`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-family
     * @external
     */
    family: string;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-parameters
     * @external
     */
    parameters: any | cdk.IResolvable;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::DBClusterParameterGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBClusterParameterGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::DBInstance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html
 * @external
 */
export interface CfnDBInstanceProps {
    /**
     * `AWS::RDS::DBInstance.DBInstanceClass`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbinstanceclass
     * @external
     */
    readonly dbInstanceClass: string;
    /**
     * `AWS::RDS::DBInstance.AllocatedStorage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-allocatedstorage
     * @external
     */
    readonly allocatedStorage?: string;
    /**
     * `AWS::RDS::DBInstance.AllowMajorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-allowmajorversionupgrade
     * @external
     */
    readonly allowMajorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.AssociatedRoles`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-associatedroles
     * @external
     */
    readonly associatedRoles?: Array<CfnDBInstance.DBInstanceRoleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.AutoMinorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-autominorversionupgrade
     * @external
     */
    readonly autoMinorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-availabilityzone
     * @external
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::RDS::DBInstance.BackupRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-backupretentionperiod
     * @external
     */
    readonly backupRetentionPeriod?: number;
    /**
     * `AWS::RDS::DBInstance.CACertificateIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-cacertificateidentifier
     * @external
     */
    readonly caCertificateIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.CharacterSetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-charactersetname
     * @external
     */
    readonly characterSetName?: string;
    /**
     * `AWS::RDS::DBInstance.CopyTagsToSnapshot`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-copytagstosnapshot
     * @external
     */
    readonly copyTagsToSnapshot?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.DBClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbclusteridentifier
     * @external
     */
    readonly dbClusterIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.DBInstanceIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbinstanceidentifier
     * @external
     */
    readonly dbInstanceIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.DBName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbname
     * @external
     */
    readonly dbName?: string;
    /**
     * `AWS::RDS::DBInstance.DBParameterGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbparametergroupname
     * @external
     */
    readonly dbParameterGroupName?: string;
    /**
     * `AWS::RDS::DBInstance.DBSecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups
     * @external
     */
    readonly dbSecurityGroups?: string[];
    /**
     * `AWS::RDS::DBInstance.DBSnapshotIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsnapshotidentifier
     * @external
     */
    readonly dbSnapshotIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.DBSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsubnetgroupname
     * @external
     */
    readonly dbSubnetGroupName?: string;
    /**
     * `AWS::RDS::DBInstance.DeleteAutomatedBackups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-deleteautomatedbackups
     * @external
     */
    readonly deleteAutomatedBackups?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.DeletionProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-deletionprotection
     * @external
     */
    readonly deletionProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.Domain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-domain
     * @external
     */
    readonly domain?: string;
    /**
     * `AWS::RDS::DBInstance.DomainIAMRoleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-domainiamrolename
     * @external
     */
    readonly domainIamRoleName?: string;
    /**
     * `AWS::RDS::DBInstance.EnableCloudwatchLogsExports`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enablecloudwatchlogsexports
     * @external
     */
    readonly enableCloudwatchLogsExports?: string[];
    /**
     * `AWS::RDS::DBInstance.EnableIAMDatabaseAuthentication`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableiamdatabaseauthentication
     * @external
     */
    readonly enableIamDatabaseAuthentication?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.EnablePerformanceInsights`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights
     * @external
     */
    readonly enablePerformanceInsights?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.Engine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-engine
     * @external
     */
    readonly engine?: string;
    /**
     * `AWS::RDS::DBInstance.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-engineversion
     * @external
     */
    readonly engineVersion?: string;
    /**
     * `AWS::RDS::DBInstance.Iops`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-iops
     * @external
     */
    readonly iops?: number;
    /**
     * `AWS::RDS::DBInstance.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::RDS::DBInstance.LicenseModel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-licensemodel
     * @external
     */
    readonly licenseModel?: string;
    /**
     * `AWS::RDS::DBInstance.MasterUsername`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-masterusername
     * @external
     */
    readonly masterUsername?: string;
    /**
     * `AWS::RDS::DBInstance.MasterUserPassword`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-masteruserpassword
     * @external
     */
    readonly masterUserPassword?: string;
    /**
     * `AWS::RDS::DBInstance.MaxAllocatedStorage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-maxallocatedstorage
     * @external
     */
    readonly maxAllocatedStorage?: number;
    /**
     * `AWS::RDS::DBInstance.MonitoringInterval`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-monitoringinterval
     * @external
     */
    readonly monitoringInterval?: number;
    /**
     * `AWS::RDS::DBInstance.MonitoringRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-monitoringrolearn
     * @external
     */
    readonly monitoringRoleArn?: string;
    /**
     * `AWS::RDS::DBInstance.MultiAZ`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-multiaz
     * @external
     */
    readonly multiAz?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.OptionGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-optiongroupname
     * @external
     */
    readonly optionGroupName?: string;
    /**
     * `AWS::RDS::DBInstance.PerformanceInsightsKMSKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-performanceinsightskmskeyid
     * @external
     */
    readonly performanceInsightsKmsKeyId?: string;
    /**
     * `AWS::RDS::DBInstance.PerformanceInsightsRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-performanceinsightsretentionperiod
     * @external
     */
    readonly performanceInsightsRetentionPeriod?: number;
    /**
     * `AWS::RDS::DBInstance.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port
     * @external
     */
    readonly port?: string;
    /**
     * `AWS::RDS::DBInstance.PreferredBackupWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-preferredbackupwindow
     * @external
     */
    readonly preferredBackupWindow?: string;
    /**
     * `AWS::RDS::DBInstance.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-preferredmaintenancewindow
     * @external
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::RDS::DBInstance.ProcessorFeatures`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-processorfeatures
     * @external
     */
    readonly processorFeatures?: Array<CfnDBInstance.ProcessorFeatureProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.PromotionTier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-promotiontier
     * @external
     */
    readonly promotionTier?: number;
    /**
     * `AWS::RDS::DBInstance.PubliclyAccessible`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-publiclyaccessible
     * @external
     */
    readonly publiclyAccessible?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.SourceDBInstanceIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-sourcedbinstanceidentifier
     * @external
     */
    readonly sourceDbInstanceIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.SourceRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-sourceregion
     * @external
     */
    readonly sourceRegion?: string;
    /**
     * `AWS::RDS::DBInstance.StorageEncrypted`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-storageencrypted
     * @external
     */
    readonly storageEncrypted?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.StorageType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-storagetype
     * @external
     */
    readonly storageType?: string;
    /**
     * `AWS::RDS::DBInstance.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::RDS::DBInstance.Timezone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-timezone
     * @external
     */
    readonly timezone?: string;
    /**
     * `AWS::RDS::DBInstance.UseDefaultProcessorFeatures`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-usedefaultprocessorfeatures
     * @external
     */
    readonly useDefaultProcessorFeatures?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.VPCSecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-vpcsecuritygroups
     * @external
     */
    readonly vpcSecurityGroups?: string[];
}
/**
 * A CloudFormation `AWS::RDS::DBInstance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html
 * @external
 * @cloudformationResource AWS::RDS::DBInstance
 */
export declare class CfnDBInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBInstance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBInstance;
    /**
     * @external
     * @cloudformationAttribute Endpoint.Address
     */
    readonly attrEndpointAddress: string;
    /**
     * @external
     * @cloudformationAttribute Endpoint.Port
     */
    readonly attrEndpointPort: string;
    /**
     * `AWS::RDS::DBInstance.DBInstanceClass`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbinstanceclass
     * @external
     */
    dbInstanceClass: string;
    /**
     * `AWS::RDS::DBInstance.AllocatedStorage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-allocatedstorage
     * @external
     */
    allocatedStorage: string | undefined;
    /**
     * `AWS::RDS::DBInstance.AllowMajorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-allowmajorversionupgrade
     * @external
     */
    allowMajorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.AssociatedRoles`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-associatedroles
     * @external
     */
    associatedRoles: Array<CfnDBInstance.DBInstanceRoleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.AutoMinorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-autominorversionupgrade
     * @external
     */
    autoMinorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-availabilityzone
     * @external
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::RDS::DBInstance.BackupRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-backupretentionperiod
     * @external
     */
    backupRetentionPeriod: number | undefined;
    /**
     * `AWS::RDS::DBInstance.CACertificateIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-cacertificateidentifier
     * @external
     */
    caCertificateIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.CharacterSetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-charactersetname
     * @external
     */
    characterSetName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.CopyTagsToSnapshot`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-copytagstosnapshot
     * @external
     */
    copyTagsToSnapshot: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.DBClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbclusteridentifier
     * @external
     */
    dbClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBInstanceIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbinstanceidentifier
     * @external
     */
    dbInstanceIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbname
     * @external
     */
    dbName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBParameterGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbparametergroupname
     * @external
     */
    dbParameterGroupName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBSecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups
     * @external
     */
    dbSecurityGroups: string[] | undefined;
    /**
     * `AWS::RDS::DBInstance.DBSnapshotIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsnapshotidentifier
     * @external
     */
    dbSnapshotIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsubnetgroupname
     * @external
     */
    dbSubnetGroupName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DeleteAutomatedBackups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-deleteautomatedbackups
     * @external
     */
    deleteAutomatedBackups: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.DeletionProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-deletionprotection
     * @external
     */
    deletionProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.Domain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-domain
     * @external
     */
    domain: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DomainIAMRoleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-domainiamrolename
     * @external
     */
    domainIamRoleName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.EnableCloudwatchLogsExports`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enablecloudwatchlogsexports
     * @external
     */
    enableCloudwatchLogsExports: string[] | undefined;
    /**
     * `AWS::RDS::DBInstance.EnableIAMDatabaseAuthentication`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableiamdatabaseauthentication
     * @external
     */
    enableIamDatabaseAuthentication: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.EnablePerformanceInsights`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights
     * @external
     */
    enablePerformanceInsights: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.Engine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-engine
     * @external
     */
    engine: string | undefined;
    /**
     * `AWS::RDS::DBInstance.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-engineversion
     * @external
     */
    engineVersion: string | undefined;
    /**
     * `AWS::RDS::DBInstance.Iops`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-iops
     * @external
     */
    iops: number | undefined;
    /**
     * `AWS::RDS::DBInstance.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::RDS::DBInstance.LicenseModel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-licensemodel
     * @external
     */
    licenseModel: string | undefined;
    /**
     * `AWS::RDS::DBInstance.MasterUsername`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-masterusername
     * @external
     */
    masterUsername: string | undefined;
    /**
     * `AWS::RDS::DBInstance.MasterUserPassword`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-masteruserpassword
     * @external
     */
    masterUserPassword: string | undefined;
    /**
     * `AWS::RDS::DBInstance.MaxAllocatedStorage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-maxallocatedstorage
     * @external
     */
    maxAllocatedStorage: number | undefined;
    /**
     * `AWS::RDS::DBInstance.MonitoringInterval`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-monitoringinterval
     * @external
     */
    monitoringInterval: number | undefined;
    /**
     * `AWS::RDS::DBInstance.MonitoringRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-monitoringrolearn
     * @external
     */
    monitoringRoleArn: string | undefined;
    /**
     * `AWS::RDS::DBInstance.MultiAZ`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-multiaz
     * @external
     */
    multiAz: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.OptionGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-optiongroupname
     * @external
     */
    optionGroupName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.PerformanceInsightsKMSKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-performanceinsightskmskeyid
     * @external
     */
    performanceInsightsKmsKeyId: string | undefined;
    /**
     * `AWS::RDS::DBInstance.PerformanceInsightsRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-performanceinsightsretentionperiod
     * @external
     */
    performanceInsightsRetentionPeriod: number | undefined;
    /**
     * `AWS::RDS::DBInstance.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port
     * @external
     */
    port: string | undefined;
    /**
     * `AWS::RDS::DBInstance.PreferredBackupWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-preferredbackupwindow
     * @external
     */
    preferredBackupWindow: string | undefined;
    /**
     * `AWS::RDS::DBInstance.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-preferredmaintenancewindow
     * @external
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::RDS::DBInstance.ProcessorFeatures`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-processorfeatures
     * @external
     */
    processorFeatures: Array<CfnDBInstance.ProcessorFeatureProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.PromotionTier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-promotiontier
     * @external
     */
    promotionTier: number | undefined;
    /**
     * `AWS::RDS::DBInstance.PubliclyAccessible`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-publiclyaccessible
     * @external
     */
    publiclyAccessible: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.SourceDBInstanceIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-sourcedbinstanceidentifier
     * @external
     */
    sourceDbInstanceIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.SourceRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-sourceregion
     * @external
     */
    sourceRegion: string | undefined;
    /**
     * `AWS::RDS::DBInstance.StorageEncrypted`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-storageencrypted
     * @external
     */
    storageEncrypted: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.StorageType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-storagetype
     * @external
     */
    storageType: string | undefined;
    /**
     * `AWS::RDS::DBInstance.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::RDS::DBInstance.Timezone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-timezone
     * @external
     */
    timezone: string | undefined;
    /**
     * `AWS::RDS::DBInstance.UseDefaultProcessorFeatures`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-usedefaultprocessorfeatures
     * @external
     */
    useDefaultProcessorFeatures: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.VPCSecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-vpcsecuritygroups
     * @external
     */
    vpcSecurityGroups: string[] | undefined;
    /**
     * Create a new `AWS::RDS::DBInstance`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBInstanceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::DBInstance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html
 * @external
 * @cloudformationResource AWS::RDS::DBInstance
 */
export declare namespace CfnDBInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html
     * @external
     */
    interface DBInstanceRoleProperty {
        /**
         * `CfnDBInstance.DBInstanceRoleProperty.FeatureName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html#cfn-rds-dbinstance-dbinstancerole-featurename
         * @external
         */
        readonly featureName: string;
        /**
         * `CfnDBInstance.DBInstanceRoleProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html#cfn-rds-dbinstance-dbinstancerole-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::RDS::DBInstance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html
 * @external
 * @cloudformationResource AWS::RDS::DBInstance
 */
export declare namespace CfnDBInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html
     * @external
     */
    interface ProcessorFeatureProperty {
        /**
         * `CfnDBInstance.ProcessorFeatureProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html#cfn-rds-dbinstance-processorfeature-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnDBInstance.ProcessorFeatureProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html#cfn-rds-dbinstance-processorfeature-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::RDS::DBParameterGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html
 * @external
 */
export interface CfnDBParameterGroupProps {
    /**
     * `AWS::RDS::DBParameterGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-description
     * @external
     */
    readonly description: string;
    /**
     * `AWS::RDS::DBParameterGroup.Family`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-family
     * @external
     */
    readonly family: string;
    /**
     * `AWS::RDS::DBParameterGroup.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-parameters
     * @external
     */
    readonly parameters?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::RDS::DBParameterGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::DBParameterGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html
 * @external
 * @cloudformationResource AWS::RDS::DBParameterGroup
 */
export declare class CfnDBParameterGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBParameterGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBParameterGroup;
    /**
     * `AWS::RDS::DBParameterGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-description
     * @external
     */
    description: string;
    /**
     * `AWS::RDS::DBParameterGroup.Family`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-family
     * @external
     */
    family: string;
    /**
     * `AWS::RDS::DBParameterGroup.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-parameters
     * @external
     */
    parameters: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBParameterGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::DBParameterGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBParameterGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::DBProxy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html
 * @external
 */
export interface CfnDBProxyProps {
    /**
     * `AWS::RDS::DBProxy.Auth`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-auth
     * @external
     */
    readonly auth: Array<CfnDBProxy.AuthFormatProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBProxy.DBProxyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-dbproxyname
     * @external
     */
    readonly dbProxyName: string;
    /**
     * `AWS::RDS::DBProxy.EngineFamily`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-enginefamily
     * @external
     */
    readonly engineFamily: string;
    /**
     * `AWS::RDS::DBProxy.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::RDS::DBProxy.VpcSubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-vpcsubnetids
     * @external
     */
    readonly vpcSubnetIds: string[];
    /**
     * `AWS::RDS::DBProxy.DebugLogging`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-debuglogging
     * @external
     */
    readonly debugLogging?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBProxy.IdleClientTimeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-idleclienttimeout
     * @external
     */
    readonly idleClientTimeout?: number;
    /**
     * `AWS::RDS::DBProxy.RequireTLS`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-requiretls
     * @external
     */
    readonly requireTls?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBProxy.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-tags
     * @external
     */
    readonly tags?: CfnDBProxy.TagFormatProperty[];
    /**
     * `AWS::RDS::DBProxy.VpcSecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-vpcsecuritygroupids
     * @external
     */
    readonly vpcSecurityGroupIds?: string[];
}
/**
 * A CloudFormation `AWS::RDS::DBProxy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html
 * @external
 * @cloudformationResource AWS::RDS::DBProxy
 */
export declare class CfnDBProxy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBProxy;
    /**
     * @external
     * @cloudformationAttribute DBProxyArn
     */
    readonly attrDbProxyArn: string;
    /**
     * @external
     * @cloudformationAttribute Endpoint
     */
    readonly attrEndpoint: string;
    /**
     * `AWS::RDS::DBProxy.Auth`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-auth
     * @external
     */
    auth: Array<CfnDBProxy.AuthFormatProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBProxy.DBProxyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-dbproxyname
     * @external
     */
    dbProxyName: string;
    /**
     * `AWS::RDS::DBProxy.EngineFamily`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-enginefamily
     * @external
     */
    engineFamily: string;
    /**
     * `AWS::RDS::DBProxy.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::RDS::DBProxy.VpcSubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-vpcsubnetids
     * @external
     */
    vpcSubnetIds: string[];
    /**
     * `AWS::RDS::DBProxy.DebugLogging`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-debuglogging
     * @external
     */
    debugLogging: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBProxy.IdleClientTimeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-idleclienttimeout
     * @external
     */
    idleClientTimeout: number | undefined;
    /**
     * `AWS::RDS::DBProxy.RequireTLS`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-requiretls
     * @external
     */
    requireTls: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBProxy.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-tags
     * @external
     */
    tags: CfnDBProxy.TagFormatProperty[] | undefined;
    /**
     * `AWS::RDS::DBProxy.VpcSecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-vpcsecuritygroupids
     * @external
     */
    vpcSecurityGroupIds: string[] | undefined;
    /**
     * Create a new `AWS::RDS::DBProxy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBProxyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::DBProxy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html
 * @external
 * @cloudformationResource AWS::RDS::DBProxy
 */
export declare namespace CfnDBProxy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-authformat.html
     * @external
     */
    interface AuthFormatProperty {
        /**
         * `CfnDBProxy.AuthFormatProperty.AuthScheme`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-authformat.html#cfn-rds-dbproxy-authformat-authscheme
         * @external
         */
        readonly authScheme?: string;
        /**
         * `CfnDBProxy.AuthFormatProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-authformat.html#cfn-rds-dbproxy-authformat-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnDBProxy.AuthFormatProperty.IAMAuth`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-authformat.html#cfn-rds-dbproxy-authformat-iamauth
         * @external
         */
        readonly iamAuth?: string;
        /**
         * `CfnDBProxy.AuthFormatProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-authformat.html#cfn-rds-dbproxy-authformat-secretarn
         * @external
         */
        readonly secretArn?: string;
        /**
         * `CfnDBProxy.AuthFormatProperty.UserName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-authformat.html#cfn-rds-dbproxy-authformat-username
         * @external
         */
        readonly userName?: string;
    }
}
/**
 * A CloudFormation `AWS::RDS::DBProxy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html
 * @external
 * @cloudformationResource AWS::RDS::DBProxy
 */
export declare namespace CfnDBProxy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-tagformat.html
     * @external
     */
    interface TagFormatProperty {
        /**
         * `CfnDBProxy.TagFormatProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-tagformat.html#cfn-rds-dbproxy-tagformat-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnDBProxy.TagFormatProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-tagformat.html#cfn-rds-dbproxy-tagformat-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::RDS::DBProxyTargetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html
 * @external
 */
export interface CfnDBProxyTargetGroupProps {
    /**
     * `AWS::RDS::DBProxyTargetGroup.DBProxyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbproxyname
     * @external
     */
    readonly dbProxyName: string;
    /**
     * `AWS::RDS::DBProxyTargetGroup.TargetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-targetgroupname
     * @external
     */
    readonly targetGroupName: string;
    /**
     * `AWS::RDS::DBProxyTargetGroup.ConnectionPoolConfigurationInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfo
     * @external
     */
    readonly connectionPoolConfigurationInfo?: CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty | cdk.IResolvable;
    /**
     * `AWS::RDS::DBProxyTargetGroup.DBClusterIdentifiers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbclusteridentifiers
     * @external
     */
    readonly dbClusterIdentifiers?: string[];
    /**
     * `AWS::RDS::DBProxyTargetGroup.DBInstanceIdentifiers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbinstanceidentifiers
     * @external
     */
    readonly dbInstanceIdentifiers?: string[];
}
/**
 * A CloudFormation `AWS::RDS::DBProxyTargetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html
 * @external
 * @cloudformationResource AWS::RDS::DBProxyTargetGroup
 */
export declare class CfnDBProxyTargetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxyTargetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBProxyTargetGroup;
    /**
     * @external
     * @cloudformationAttribute TargetGroupArn
     */
    readonly attrTargetGroupArn: string;
    /**
     * `AWS::RDS::DBProxyTargetGroup.DBProxyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbproxyname
     * @external
     */
    dbProxyName: string;
    /**
     * `AWS::RDS::DBProxyTargetGroup.TargetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-targetgroupname
     * @external
     */
    targetGroupName: string;
    /**
     * `AWS::RDS::DBProxyTargetGroup.ConnectionPoolConfigurationInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfo
     * @external
     */
    connectionPoolConfigurationInfo: CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBProxyTargetGroup.DBClusterIdentifiers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbclusteridentifiers
     * @external
     */
    dbClusterIdentifiers: string[] | undefined;
    /**
     * `AWS::RDS::DBProxyTargetGroup.DBInstanceIdentifiers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbinstanceidentifiers
     * @external
     */
    dbInstanceIdentifiers: string[] | undefined;
    /**
     * Create a new `AWS::RDS::DBProxyTargetGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBProxyTargetGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::DBProxyTargetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html
 * @external
 * @cloudformationResource AWS::RDS::DBProxyTargetGroup
 */
export declare namespace CfnDBProxyTargetGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html
     * @external
     */
    interface ConnectionPoolConfigurationInfoFormatProperty {
        /**
         * `CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty.ConnectionBorrowTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-connectionborrowtimeout
         * @external
         */
        readonly connectionBorrowTimeout?: number;
        /**
         * `CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty.InitQuery`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-initquery
         * @external
         */
        readonly initQuery?: string;
        /**
         * `CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty.MaxConnectionsPercent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-maxconnectionspercent
         * @external
         */
        readonly maxConnectionsPercent?: number;
        /**
         * `CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty.MaxIdleConnectionsPercent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-maxidleconnectionspercent
         * @external
         */
        readonly maxIdleConnectionsPercent?: number;
        /**
         * `CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty.SessionPinningFilters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-sessionpinningfilters
         * @external
         */
        readonly sessionPinningFilters?: string[];
    }
}
/**
 * Properties for defining a `AWS::RDS::DBSecurityGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html
 * @external
 */
export interface CfnDBSecurityGroupProps {
    /**
     * `AWS::RDS::DBSecurityGroup.DBSecurityGroupIngress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-dbsecuritygroupingress
     * @external
     */
    readonly dbSecurityGroupIngress: Array<CfnDBSecurityGroup.IngressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBSecurityGroup.GroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-groupdescription
     * @external
     */
    readonly groupDescription: string;
    /**
     * `AWS::RDS::DBSecurityGroup.EC2VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-ec2vpcid
     * @external
     */
    readonly ec2VpcId?: string;
    /**
     * `AWS::RDS::DBSecurityGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html
 * @external
 * @cloudformationResource AWS::RDS::DBSecurityGroup
 */
export declare class CfnDBSecurityGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSecurityGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBSecurityGroup;
    /**
     * `AWS::RDS::DBSecurityGroup.DBSecurityGroupIngress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-dbsecuritygroupingress
     * @external
     */
    dbSecurityGroupIngress: Array<CfnDBSecurityGroup.IngressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBSecurityGroup.GroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-groupdescription
     * @external
     */
    groupDescription: string;
    /**
     * `AWS::RDS::DBSecurityGroup.EC2VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-ec2vpcid
     * @external
     */
    ec2VpcId: string | undefined;
    /**
     * `AWS::RDS::DBSecurityGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::DBSecurityGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBSecurityGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html
 * @external
 * @cloudformationResource AWS::RDS::DBSecurityGroup
 */
export declare namespace CfnDBSecurityGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html
     * @external
     */
    interface IngressProperty {
        /**
         * `CfnDBSecurityGroup.IngressProperty.CIDRIP`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html#cfn-rds-securitygroup-cidrip
         * @external
         */
        readonly cidrip?: string;
        /**
         * `CfnDBSecurityGroup.IngressProperty.EC2SecurityGroupId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html#cfn-rds-securitygroup-ec2securitygroupid
         * @external
         */
        readonly ec2SecurityGroupId?: string;
        /**
         * `CfnDBSecurityGroup.IngressProperty.EC2SecurityGroupName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html#cfn-rds-securitygroup-ec2securitygroupname
         * @external
         */
        readonly ec2SecurityGroupName?: string;
        /**
         * `CfnDBSecurityGroup.IngressProperty.EC2SecurityGroupOwnerId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html#cfn-rds-securitygroup-ec2securitygroupownerid
         * @external
         */
        readonly ec2SecurityGroupOwnerId?: string;
    }
}
/**
 * Properties for defining a `AWS::RDS::DBSecurityGroupIngress`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html
 * @external
 */
export interface CfnDBSecurityGroupIngressProps {
    /**
     * `AWS::RDS::DBSecurityGroupIngress.DBSecurityGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-dbsecuritygroupname
     * @external
     */
    readonly dbSecurityGroupName: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.CIDRIP`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-cidrip
     * @external
     */
    readonly cidrip?: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupid
     * @external
     */
    readonly ec2SecurityGroupId?: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupname
     * @external
     */
    readonly ec2SecurityGroupName?: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupOwnerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupownerid
     * @external
     */
    readonly ec2SecurityGroupOwnerId?: string;
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroupIngress`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html
 * @external
 * @cloudformationResource AWS::RDS::DBSecurityGroupIngress
 */
export declare class CfnDBSecurityGroupIngress extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSecurityGroupIngress";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBSecurityGroupIngress;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.DBSecurityGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-dbsecuritygroupname
     * @external
     */
    dbSecurityGroupName: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.CIDRIP`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-cidrip
     * @external
     */
    cidrip: string | undefined;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupid
     * @external
     */
    ec2SecurityGroupId: string | undefined;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupname
     * @external
     */
    ec2SecurityGroupName: string | undefined;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupOwnerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupownerid
     * @external
     */
    ec2SecurityGroupOwnerId: string | undefined;
    /**
     * Create a new `AWS::RDS::DBSecurityGroupIngress`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBSecurityGroupIngressProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::DBSubnetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html
 * @external
 */
export interface CfnDBSubnetGroupProps {
    /**
     * `AWS::RDS::DBSubnetGroup.DBSubnetGroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-dbsubnetgroupdescription
     * @external
     */
    readonly dbSubnetGroupDescription: string;
    /**
     * `AWS::RDS::DBSubnetGroup.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-subnetids
     * @external
     */
    readonly subnetIds: string[];
    /**
     * `AWS::RDS::DBSubnetGroup.DBSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-dbsubnetgroupname
     * @external
     */
    readonly dbSubnetGroupName?: string;
    /**
     * `AWS::RDS::DBSubnetGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::DBSubnetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html
 * @external
 * @cloudformationResource AWS::RDS::DBSubnetGroup
 */
export declare class CfnDBSubnetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSubnetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBSubnetGroup;
    /**
     * `AWS::RDS::DBSubnetGroup.DBSubnetGroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-dbsubnetgroupdescription
     * @external
     */
    dbSubnetGroupDescription: string;
    /**
     * `AWS::RDS::DBSubnetGroup.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-subnetids
     * @external
     */
    subnetIds: string[];
    /**
     * `AWS::RDS::DBSubnetGroup.DBSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-dbsubnetgroupname
     * @external
     */
    dbSubnetGroupName: string | undefined;
    /**
     * `AWS::RDS::DBSubnetGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::DBSubnetGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBSubnetGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::EventSubscription`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html
 * @external
 */
export interface CfnEventSubscriptionProps {
    /**
     * `AWS::RDS::EventSubscription.SnsTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-snstopicarn
     * @external
     */
    readonly snsTopicArn: string;
    /**
     * `AWS::RDS::EventSubscription.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::EventSubscription.EventCategories`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-eventcategories
     * @external
     */
    readonly eventCategories?: string[];
    /**
     * `AWS::RDS::EventSubscription.SourceIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-sourceids
     * @external
     */
    readonly sourceIds?: string[];
    /**
     * `AWS::RDS::EventSubscription.SourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-sourcetype
     * @external
     */
    readonly sourceType?: string;
}
/**
 * A CloudFormation `AWS::RDS::EventSubscription`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html
 * @external
 * @cloudformationResource AWS::RDS::EventSubscription
 */
export declare class CfnEventSubscription extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::EventSubscription";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEventSubscription;
    /**
     * `AWS::RDS::EventSubscription.SnsTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-snstopicarn
     * @external
     */
    snsTopicArn: string;
    /**
     * `AWS::RDS::EventSubscription.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::EventSubscription.EventCategories`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-eventcategories
     * @external
     */
    eventCategories: string[] | undefined;
    /**
     * `AWS::RDS::EventSubscription.SourceIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-sourceids
     * @external
     */
    sourceIds: string[] | undefined;
    /**
     * `AWS::RDS::EventSubscription.SourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-sourcetype
     * @external
     */
    sourceType: string | undefined;
    /**
     * Create a new `AWS::RDS::EventSubscription`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventSubscriptionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::GlobalCluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html
 * @external
 */
export interface CfnGlobalClusterProps {
    /**
     * `AWS::RDS::GlobalCluster.DeletionProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-deletionprotection
     * @external
     */
    readonly deletionProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::GlobalCluster.Engine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-engine
     * @external
     */
    readonly engine?: string;
    /**
     * `AWS::RDS::GlobalCluster.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-engineversion
     * @external
     */
    readonly engineVersion?: string;
    /**
     * `AWS::RDS::GlobalCluster.GlobalClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-globalclusteridentifier
     * @external
     */
    readonly globalClusterIdentifier?: string;
    /**
     * `AWS::RDS::GlobalCluster.SourceDBClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-sourcedbclusteridentifier
     * @external
     */
    readonly sourceDbClusterIdentifier?: string;
    /**
     * `AWS::RDS::GlobalCluster.StorageEncrypted`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-storageencrypted
     * @external
     */
    readonly storageEncrypted?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::RDS::GlobalCluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html
 * @external
 * @cloudformationResource AWS::RDS::GlobalCluster
 */
export declare class CfnGlobalCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::GlobalCluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGlobalCluster;
    /**
     * `AWS::RDS::GlobalCluster.DeletionProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-deletionprotection
     * @external
     */
    deletionProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::GlobalCluster.Engine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-engine
     * @external
     */
    engine: string | undefined;
    /**
     * `AWS::RDS::GlobalCluster.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-engineversion
     * @external
     */
    engineVersion: string | undefined;
    /**
     * `AWS::RDS::GlobalCluster.GlobalClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-globalclusteridentifier
     * @external
     */
    globalClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::GlobalCluster.SourceDBClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-sourcedbclusteridentifier
     * @external
     */
    sourceDbClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::GlobalCluster.StorageEncrypted`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-storageencrypted
     * @external
     */
    storageEncrypted: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::RDS::GlobalCluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnGlobalClusterProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::OptionGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 * @external
 */
export interface CfnOptionGroupProps {
    /**
     * `AWS::RDS::OptionGroup.EngineName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-enginename
     * @external
     */
    readonly engineName: string;
    /**
     * `AWS::RDS::OptionGroup.MajorEngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-majorengineversion
     * @external
     */
    readonly majorEngineVersion: string;
    /**
     * `AWS::RDS::OptionGroup.OptionConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optionconfigurations
     * @external
     */
    readonly optionConfigurations: Array<CfnOptionGroup.OptionConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::OptionGroup.OptionGroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optiongroupdescription
     * @external
     */
    readonly optionGroupDescription: string;
    /**
     * `AWS::RDS::OptionGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::OptionGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 * @external
 * @cloudformationResource AWS::RDS::OptionGroup
 */
export declare class CfnOptionGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::OptionGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnOptionGroup;
    /**
     * `AWS::RDS::OptionGroup.EngineName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-enginename
     * @external
     */
    engineName: string;
    /**
     * `AWS::RDS::OptionGroup.MajorEngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-majorengineversion
     * @external
     */
    majorEngineVersion: string;
    /**
     * `AWS::RDS::OptionGroup.OptionConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optionconfigurations
     * @external
     */
    optionConfigurations: Array<CfnOptionGroup.OptionConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::OptionGroup.OptionGroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optiongroupdescription
     * @external
     */
    optionGroupDescription: string;
    /**
     * `AWS::RDS::OptionGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::OptionGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnOptionGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::OptionGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 * @external
 * @cloudformationResource AWS::RDS::OptionGroup
 */
export declare namespace CfnOptionGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html
     * @external
     */
    interface OptionConfigurationProperty {
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.DBSecurityGroupMemberships`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-dbsecuritygroupmemberships
         * @external
         */
        readonly dbSecurityGroupMemberships?: string[];
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.OptionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-optionname
         * @external
         */
        readonly optionName: string;
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.OptionSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-optionsettings
         * @external
         */
        readonly optionSettings?: Array<CfnOptionGroup.OptionSettingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.OptionVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfiguration-optionversion
         * @external
         */
        readonly optionVersion?: string;
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-port
         * @external
         */
        readonly port?: number;
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.VpcSecurityGroupMemberships`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-vpcsecuritygroupmemberships
         * @external
         */
        readonly vpcSecurityGroupMemberships?: string[];
    }
}
/**
 * A CloudFormation `AWS::RDS::OptionGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 * @external
 * @cloudformationResource AWS::RDS::OptionGroup
 */
export declare namespace CfnOptionGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations-optionsettings.html
     * @external
     */
    interface OptionSettingProperty {
        /**
         * `CfnOptionGroup.OptionSettingProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations-optionsettings.html#cfn-rds-optiongroup-optionconfigurations-optionsettings-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnOptionGroup.OptionSettingProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations-optionsettings.html#cfn-rds-optiongroup-optionconfigurations-optionsettings-value
         * @external
         */
        readonly value?: string;
    }
}
