/*
 * Decompiled with CFR 0.152.
 */
package xgboost.sklearn;

import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import org.jpmml.xgboost.ByteOrderUtil;
import org.jpmml.xgboost.HasXGBoostOptions;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.ObjFunction;
import sklearn.Estimator;
import xgboost.sklearn.Booster;
import xgboost.sklearn.HasBooster;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static <E extends Estimator & HasXGBoostOptions> int getNumberOfFeatures(E estimator) {
        Learner learner = BoosterUtil.getLearner(estimator);
        return learner.num_feature();
    }

    public static <E extends Estimator & HasXGBoostOptions> ObjFunction getObjFunction(E estimator) {
        Learner learner = BoosterUtil.getLearner(estimator);
        return learner.obj();
    }

    public static <E extends Estimator & HasXGBoostOptions> MiningModel encodeBooster(E estimator, Schema schema) {
        Learner learner = BoosterUtil.getLearner(estimator);
        Integer bestNTreeLimit = (Integer)estimator.getOptionalScalar("best_ntree_limit");
        Boolean compact = (Boolean)estimator.getOption("compact", Boolean.TRUE);
        Boolean numeric = (Boolean)estimator.getOption("numeric", Boolean.TRUE);
        Boolean prune = (Boolean)estimator.getOption("prune", Boolean.TRUE);
        Integer ntreeLimit = (Integer)estimator.getOption("ntree_limit", bestNTreeLimit);
        LinkedHashMap<String, Comparable<Boolean>> options = new LinkedHashMap<String, Comparable<Boolean>>();
        options.put("compact", compact);
        options.put("numeric", numeric);
        options.put("prune", prune);
        options.put("ntree_limit", ntreeLimit);
        Schema xgbSchema = learner.toXGBoostSchema(numeric.booleanValue(), schema);
        MiningModel miningModel = learner.encodeMiningModel(options, xgbSchema);
        return miningModel;
    }

    private static <E extends Estimator & HasXGBoostOptions> Learner getLearner(E estimator) {
        Booster booster = ((HasBooster)estimator).getBooster();
        String byteOrder = (String)estimator.getOption("byte_order", ByteOrder.nativeOrder().toString());
        String charset = (String)estimator.getOption("charset", null);
        return booster.getLearner(ByteOrderUtil.forValue((String)byteOrder), charset);
    }
}

