/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.StringFeature;
import org.jpmml.sklearn.SkLearnEncoder;

public class TransformerUtil {
    private TransformerUtil() {
    }

    public static Feature createFeature(Field<?> field, SkLearnEncoder encoder) {
        OpType opType = field.getOpType();
        DataType dataType = field.getDataType();
        switch (dataType) {
            case STRING: {
                return new StringFeature((PMMLEncoder)encoder, field);
            }
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                switch (opType) {
                    case CONTINUOUS: {
                        return new ContinuousFeature((PMMLEncoder)encoder, field);
                    }
                }
                return new ObjectFeature((PMMLEncoder)encoder, field){

                    public ContinuousFeature toContinuousFeature() {
                        PMMLEncoder encoder = this.getEncoder();
                        DerivedField derivedField = (DerivedField)encoder.toContinuous(this.getName());
                        return new ContinuousFeature(encoder, (Field)derivedField);
                    }
                };
            }
        }
        return new ObjectFeature((PMMLEncoder)encoder, field);
    }
}

