/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import category_encoders.BaseNFeature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InvalidValueDecorator;
import org.jpmml.converter.MissingValueFeature;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.preprocessing.BaseEncoder;
import sklearn.preprocessing.EncoderUtil;

public class MultiOneHotEncoder
extends BaseEncoder {
    public MultiOneHotEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<List<?>> categories = this.getCategories();
        Object drop = this.getDrop();
        List<Integer> dropIdx = drop != null ? this.getDropIdx() : null;
        String handleUnknown = this.getHandleUnknown();
        ClassDictUtil.checkSize((Collection[])new Collection[]{categories, features});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Integer index;
            CategoricalFeature categoricalFeature;
            InvalidValueTreatmentMethod invalidValueTreatmentMethod;
            Feature feature = features.get(i);
            ArrayList<Double> featureCategories = new ArrayList<Double>((Collection)categories.get(i));
            switch (handleUnknown) {
                case "error": {
                    invalidValueTreatmentMethod = InvalidValueTreatmentMethod.RETURN_INVALID;
                    break;
                }
                case "ignore": {
                    invalidValueTreatmentMethod = InvalidValueTreatmentMethod.AS_IS;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            EncoderUtil.addDecorator(feature, (Decorator)new InvalidValueDecorator(invalidValueTreatmentMethod, null));
            if (feature instanceof BaseNFeature) {
                BaseNFeature baseFeature = (BaseNFeature)feature;
                ContinuousFeature continuousFeature = baseFeature.toContinuousFeature();
                encoder.toCategorical(continuousFeature.getName(), null);
                feature = continuousFeature;
            } else if (feature instanceof CategoricalFeature) {
                categoricalFeature = (CategoricalFeature)feature;
                if (MultiOneHotEncoder.hasNaNCategory(featureCategories)) {
                    ClassDictUtil.checkSize((Collection[])new Collection[]{MultiOneHotEncoder.dropNaNCategory(featureCategories), categoricalFeature.getValues()});
                    featureCategories = new ArrayList(categoricalFeature.getValues());
                    featureCategories.add(Double.NaN);
                } else {
                    ClassDictUtil.checkSize((Collection[])new Collection[]{featureCategories, categoricalFeature.getValues()});
                    featureCategories = new ArrayList(categoricalFeature.getValues());
                }
            } else if (feature instanceof ObjectFeature) {
                categoricalFeature = (ObjectFeature)feature;
            } else if (feature instanceof WildcardFeature) {
                WildcardFeature wildcardFeature = (WildcardFeature)feature;
                feature = MultiOneHotEncoder.hasNaNCategory(featureCategories) ? wildcardFeature.toCategoricalFeature(MultiOneHotEncoder.dropNaNCategory(featureCategories)) : wildcardFeature.toCategoricalFeature(featureCategories);
                CategoricalFeature categoricalFeature2 = (CategoricalFeature)feature;
                DataType dataType = TypeUtil.getDataType((Collection)categoricalFeature2.getValues(), (DataType)DataType.STRING);
                DataField dataField = (DataField)categoricalFeature2.getField();
                if (!dataField.getDataType().equals((Object)dataType)) {
                    dataField.setDataType(dataType);
                }
            } else {
                throw new IllegalArgumentException();
            }
            if (dropIdx != null && (index = dropIdx.get(i)) != null) {
                int intIndex = dropIdx.get(i);
                featureCategories.remove(intIndex);
            }
            for (int j = 0; j < featureCategories.size(); ++j) {
                Object featureCategory = featureCategories.get(j);
                if (ValueUtil.isNaN(featureCategory)) {
                    result.add((Feature)new MissingValueFeature((PMMLEncoder)encoder, feature));
                    continue;
                }
                result.add((Feature)new BinaryFeature((PMMLEncoder)encoder, feature, featureCategory));
            }
        }
        return result;
    }

    public Object getDrop() {
        return this.getOptionalObject("drop");
    }

    public List<Integer> getDropIdx() {
        List dropIdx = this.getNumberArray("drop_idx_");
        if (dropIdx == null) {
            return null;
        }
        return Lists.transform((List)dropIdx, number -> number != null ? ValueUtil.asInteger((Number)number) : null);
    }

    private static boolean hasNaNCategory(List<?> categories) {
        if (!categories.isEmpty()) {
            Object lastCategory = categories.get(categories.size() - 1);
            return ValueUtil.isNaN(lastCategory);
        }
        return false;
    }

    private static <E> List<E> dropNaNCategory(List<E> categories) {
        if (MultiOneHotEncoder.hasNaNCategory(categories)) {
            return categories.subList(0, categories.size() - 1);
        }
        return categories;
    }
}

