/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import category_encoders.CategoryEncoder;
import category_encoders.MapEncoder;
import category_encoders.MapFeature;
import category_encoders.OrdinalEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import pandas.core.Series;
import pandas.core.SeriesUtil;
import sklearn.preprocessing.EncoderUtil;

public abstract class OrdinalMapEncoder
extends MapEncoder {
    public OrdinalMapEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<?> cols = this.getCols();
        Boolean dropInvariant = this.getDropInvariant();
        String handleMissing = this.getHandleMissing();
        String handleUnknown = this.getHandleUnknown();
        Map<Object, Series> mapping = this.getMapping();
        OrdinalEncoder ordinalEncoder = this.getOrdinalEncoder();
        if (dropInvariant.booleanValue()) {
            throw new IllegalArgumentException();
        }
        Object missingCategory = null;
        switch (handleMissing) {
            case "error": {
                break;
            }
            case "value": {
                missingCategory = CategoryEncoder.CATEGORY_NAN;
                break;
            }
            default: {
                throw new IllegalArgumentException(handleMissing);
            }
        }
        switch (handleUnknown) {
            case "error": {
                break;
            }
            default: {
                throw new IllegalArgumentException(handleUnknown);
            }
        }
        List<OrdinalEncoder.Mapping> ordinalMappings = ordinalEncoder.getMapping();
        ClassDictUtil.checkSize((Collection[])new Collection[]{features, cols, ordinalMappings});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Object col = cols.get(i);
            OrdinalEncoder.Mapping ordinalMapping = ordinalMappings.get(i);
            Map<?, Integer> ordinalCategoryMappings = ordinalMapping.getCategoryMapping();
            switch (handleMissing) {
                case "error": {
                    ordinalCategoryMappings.remove(CategoryEncoder.CATEGORY_NAN);
                    break;
                }
            }
            Series series = mapping.get(col);
            Map valueMappings = SeriesUtil.toMap((Series)series, key -> ValueUtil.asInteger((Number)((Number)key)), ValueUtil::asDouble);
            Map categoryValues = OrdinalMapEncoder.mapEncodeValues(ordinalCategoryMappings, valueMappings);
            ArrayList categories = new ArrayList();
            categories.addAll(categoryValues.keySet());
            encoder.toCategorical(feature.getName(), EncoderUtil.filterCategories(categories));
            MapFeature mapFeature = new MapFeature((PMMLEncoder)encoder, feature, categoryValues, missingCategory){

                @Override
                public FieldName getDerivedName() {
                    return OrdinalMapEncoder.this.createFieldName(OrdinalMapEncoder.this.functionName(), this.getName());
                }
            };
            result.add((Feature)mapFeature);
        }
        return result;
    }

    public OrdinalEncoder getOrdinalEncoder() {
        return (OrdinalEncoder)this.get("ordinal_encoder", OrdinalEncoder.class);
    }

    public static <K, V> Map<K, V> mapEncodeValues(Map<K, Integer> categoryMappings, Map<Integer, V> valueMappings) {
        LinkedHashMap result = new LinkedHashMap();
        Set<Map.Entry<K, Integer>> entries = categoryMappings.entrySet();
        for (Map.Entry entry : entries) {
            Object category = entry.getKey();
            V value = valueMappings.get(entry.getValue());
            if (value == null) {
                throw new IllegalArgumentException();
            }
            result.put(category, value);
        }
        return result;
    }
}

